/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.model.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.internal.model.StylesheetBuilder;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.internal.model.tests.AbstractModelTest;

public class TestStylesheetModel
extends AbstractModelTest {
    private StylesheetModel model = null;

    protected void tearDown() throws Exception {
        super.tearDown();
        StylesheetBuilder builder = StylesheetBuilder.getInstance();
        builder.release();
        this.model = null;
    }

    public void testStyleSheetModel() {
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("globalVariablesTest.xsl"));
        TestStylesheetModel.assertNotNull((String)"Failed to load stylesheet 'globalVariablesTest.xsl'.", (Object)this.model);
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("style1.xsl"));
        TestStylesheetModel.assertNotNull((String)"Failed to load stylesheet 'style1.xsl'.", (Object)this.model);
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("XSLT20Test.xsl"));
        TestStylesheetModel.assertNotNull((String)"Failed to load stylesheet 'XSLT20Test.xsl'.", (Object)this.model);
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("circularref.xsl"));
        TestStylesheetModel.assertNotNull((String)"Failed to load stylesheet 'circularref.xsl'.", (Object)this.model);
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("modeTest.xsl"));
        TestStylesheetModel.assertNotNull((String)"Failed to load stylesheet 'modeTest.xsl'.", (Object)this.model);
    }

    public void testFindAvailableTemplateModes() {
        ArrayList<String> modes = new ArrayList<String>();
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("modeTest.xsl"));
        List templates = this.model.getTemplates();
        TestStylesheetModel.assertTrue((String)"No templates returned.", (templates.size() > 0 ? 1 : 0) != 0);
        for (Template template : templates) {
            XSLAttribute attribute = template.getAttribute("mode");
            if (attribute == null || modes.indexOf(attribute.getValue()) != -1) continue;
            modes.add(attribute.getValue());
        }
        TestStylesheetModel.assertEquals((String)"Wrong number of mode templates returned.", (int)3, (int)modes.size());
    }

    public void testCircularReference() {
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("circularref.xsl"));
        TestStylesheetModel.assertTrue((String)"Undettected circular reference", (boolean)this.model.hasCircularReference());
    }

    public void testNoCircularReference() {
        this.model = XSLCore.getInstance().getStylesheet(this.getFile("modeTest.xsl"));
        TestStylesheetModel.assertFalse((String)"Undettected circular reference", (boolean)this.model.hasCircularReference());
    }
}

