/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.PublisherDelegate;

public class Publisher {
    private IConfigurationElement element;
    private PublisherDelegate delegate;
    private boolean modifyModules = false;

    public Publisher(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.contains(this.getTypeIds(), id);
    }

    public PublisherDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                long time = System.currentTimeMillis();
                this.delegate = (PublisherDelegate)this.element.createExecutableExtension("class");
                Trace.trace(10, "PublishTask.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate" + this.toString(), t);
            }
        }
        return this.delegate;
    }

    private boolean changeSchedulingRule(ISchedulingRule originalRule, ISchedulingRule newRule) {
        boolean changeRule = false;
        if (originalRule == null && newRule == null) {
            changeRule = false;
        } else if (originalRule == null && newRule != null) {
            changeRule = true;
        } else if (originalRule != null && newRule == null) {
            changeRule = true;
        } else if (originalRule != null && newRule != null) {
            changeRule = !originalRule.equals(newRule);
        }
        return changeRule;
    }

    private void rebuildModuleCache() {
        Server server = (Server)this.getDelegate().getTaskModel().getObject("server");
        if (server != null) {
            List moduleList;
            if (server.isWorkingCopy()) {
                IServerWorkingCopy workingCopy = (IServerWorkingCopy)((Object)server);
                server = (Server)workingCopy.getOriginal();
            }
            if ((moduleList = (List)this.getDelegate().getTaskModel().getObject("modules")) != null) {
                for (IModule[] module : moduleList) {
                    if (module == null) continue;
                    Trace.trace(5, "rebuilding cache for module: " + module[module.length - 1]);
                    server.getServerPublishInfo().rebuildCache(module);
                }
            }
        }
    }

    public IStatus execute(int kind, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        Trace.trace(5, "Task.init " + this);
        ISchedulingRule delegatePublisherRule = null;
        ISchedulingRule originalPublisherRule = Job.getJobManager().currentRule();
        Status resultStatus = null;
        boolean changeSchedulingRules = false;
        try {
            try {
                delegatePublisherRule = this.getDelegate().getRule();
                changeSchedulingRules = this.changeSchedulingRule(originalPublisherRule, delegatePublisherRule);
                Trace.trace(5, "Change the scheduling rule to execute delegate: " + changeSchedulingRules);
                if (changeSchedulingRules) {
                    Trace.trace(5, "Ending the current scheduling rule " + originalPublisherRule);
                    Job.getJobManager().endRule(originalPublisherRule);
                    Trace.trace(5, "Beginning the new scheduling rule: " + delegatePublisherRule);
                    Job.getJobManager().beginRule(delegatePublisherRule, monitor);
                }
                resultStatus = this.getDelegate().execute(kind, monitor, info);
                this.modifyModules = this.getDelegate().isModifyModules();
                Trace.trace(5, "The publisher delegate stated that it modified modules: " + this.modifyModules);
                if (this.modifyModules) {
                    this.rebuildModuleCache();
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error calling delegate " + this.toString(), e);
                resultStatus = new Status(4, "org.eclipse.wst.server.core", "Error in delegate", (Throwable)e);
                if (changeSchedulingRules) {
                    Trace.trace(5, "Reseting the scheduling rules... ending: " + delegatePublisherRule);
                    Job.getJobManager().endRule(delegatePublisherRule);
                    Trace.trace(5, "Reseting the scheduling rules... beginning: " + originalPublisherRule);
                    Job.getJobManager().beginRule(originalPublisherRule, monitor);
                }
            }
        }
        finally {
            if (changeSchedulingRules) {
                Trace.trace(5, "Reseting the scheduling rules... ending: " + delegatePublisherRule);
                Job.getJobManager().endRule(delegatePublisherRule);
                Trace.trace(5, "Reseting the scheduling rules... beginning: " + originalPublisherRule);
                Job.getJobManager().beginRule(originalPublisherRule, monitor);
            }
        }
        return resultStatus;
    }

    public void setTaskModel(TaskModel taskModel) {
        try {
            this.getDelegate().setTaskModel(taskModel);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
        }
    }

    public boolean isModifyModules() {
        return this.modifyModules;
    }

    public String toString() {
        return "Publisher[" + this.getId() + "]";
    }
}

