/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTConverterAST3Test
extends ConverterTestSetup {
    static /* synthetic */ Class class$0;

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public ASTConverterAST3Test(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterAST3Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTConverterAST3Test.buildModelTestSuite(clazz);
    }

    public void test0001() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0001", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        JavaScriptUnit unit = this.ast.newJavaScriptUnit();
        FunctionDeclaration methodDeclaration = this.ast.newFunctionDeclaration();
        methodDeclaration.setConstructor(false);
        methodDeclaration.setName(this.ast.newSimpleName("main"));
        SingleVariableDeclaration variableDeclaration = this.ast.newSingleVariableDeclaration();
        variableDeclaration.setName(this.ast.newSimpleName("args"));
        methodDeclaration.parameters().add(variableDeclaration);
        Block block = this.ast.newBlock();
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        methodInvocation.setName(this.ast.newSimpleName("print"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" world");
        infixExpression.setRightOperand((Expression)literal);
        methodInvocation.arguments().add(infixExpression);
        ExpressionStatement expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        block.statements().add(expressionStatement);
        methodDeclaration.setBody(block);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)result.subtreeMatch(new ASTMatcher(), (Object)unit));
        String expected = "function main(args) {\n\tprint(\"Hello\" + \" world\");\n}";
        this.checkSourceRange(result, expected, source);
    }

    public void test0002() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0002", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Object")));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new Object()", source);
    }

    public void test0003() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0003", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("Object"));
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)name));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Object()", source);
    }

    public void test0004() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0004", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("Exception"));
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)name));
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("ERROR");
        classInstanceCreation.arguments().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Exception(\"ERROR\")", source);
    }

    public void test0005() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0005", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("Object"));
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)name));
        AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
        classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Object() {}", source);
        ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)expression;
        Type type = classInstanceCreation2.getType();
        this.checkSourceRange((ASTNode)type, "java.lang.Object", source);
    }

    public void test0006() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0006", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("Runnable"));
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)name));
        FunctionDeclaration methodDeclaration = this.ast.newFunctionDeclaration();
        methodDeclaration.setBody(this.ast.newBlock());
        methodDeclaration.setConstructor(false);
        methodDeclaration.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        methodDeclaration.setName(this.ast.newSimpleName("run"));
        methodDeclaration.setReturnType2((Type)this.ast.newPrimitiveType(PrimitiveType.VOID));
        AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
        anonymousClassDeclaration.bodyDeclarations().add(methodDeclaration);
        classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new java.lang.Runnable() { public void run() {}}", source);
    }

    public void test0007() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0007", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        ASTNode expression = (ASTNode)((FunctionInvocation)expressionStatement.getExpression()).arguments().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("D")));
        ClassInstanceCreation classInstanceCreationExpression = this.ast.newClassInstanceCreation();
        classInstanceCreationExpression.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Test")));
        classInstanceCreation.setExpression((Expression)classInstanceCreationExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)classInstanceCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new Test().new D()", source);
    }

    public void test0008() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0008", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        arrayCreation.setType(this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 1));
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("1"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("2"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("3"));
        arrayInitializer.expressions().add(this.ast.newNumberLiteral("4"));
        arrayCreation.setInitializer(arrayInitializer);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)arrayCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new int[] {1, 2, 3, 4}", source);
    }

    public void test0009() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0009", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        arrayCreation.setType(this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 2));
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        ArrayInitializer innerArrayInitializer = this.ast.newArrayInitializer();
        innerArrayInitializer.expressions().add(this.ast.newNumberLiteral("1"));
        arrayInitializer.expressions().add(innerArrayInitializer);
        innerArrayInitializer = this.ast.newArrayInitializer();
        innerArrayInitializer.expressions().add(this.ast.newNumberLiteral("2"));
        arrayInitializer.expressions().add(innerArrayInitializer);
        arrayCreation.setInitializer(arrayInitializer);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)arrayCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new int[][] {{1}, {2}}", source);
    }

    public void test0010() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0010", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        arrayCreation.setType(this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 1));
        arrayCreation.dimensions().add(this.ast.newNumberLiteral("3"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)arrayCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new int[3]", source);
    }

    public void test0011() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0011", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        arrayCreation.setType(this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 2));
        arrayCreation.dimensions().add(this.ast.newNumberLiteral("3"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)arrayCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new int[3][]", source);
    }

    public void test0012() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0012", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        arrayCreation.setType(this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 2));
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        ArrayInitializer innerArrayInitializer = this.ast.newArrayInitializer();
        arrayInitializer.expressions().add(innerArrayInitializer);
        innerArrayInitializer = this.ast.newArrayInitializer();
        arrayInitializer.expressions().add(innerArrayInitializer);
        arrayCreation.setInitializer(arrayInitializer);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)arrayCreation.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "new int[][] {{}, {}}", source);
    }

    public void test0013() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0013", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0014() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0014", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i = 0;", source);
    }

    public void test0015() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0015", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("1"));
        assignment.setOperator(Assignment.Operator.ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i = 1;", source);
    }

    public void test0016() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0016", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i += 2;", source);
    }

    public void test0017() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0017", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i -= 2;", source);
    }

    public void test0018() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0018", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i *= 2;", source);
    }

    public void test0019() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0019", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i /= 2;", source);
    }

    public void test0020() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0020", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i &= 2;", source);
    }

    public void test0021() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0021", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i |= 2;", source);
    }

    public void test0022() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0022", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i ^= 2;", source);
    }

    public void test0023() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0023", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i %= 2;", source);
    }

    public void test0024() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0024", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i <<= 2;", source);
    }

    public void test0025() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0025", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i >>= 2;", source);
    }

    public void test0026() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0026", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        Assignment assignment = this.ast.newAssignment();
        assignment.setLeftHandSide((Expression)this.ast.newSimpleName("i"));
        assignment.setRightHandSide((Expression)this.ast.newNumberLiteral("2"));
        assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)assignment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i >>>= 2;", source);
    }

    public void test0027() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0027", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)prefixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "--i;", source);
    }

    public void test0028() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0028", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)prefixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "++i;", source);
    }

    public void test0029() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0029", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)postfixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i--;", source);
    }

    public void test0030() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0030", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)postfixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "i++;", source);
    }

    public void test0038() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0038", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("c"));
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        typeLiteral.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        variableDeclarationFragment.setInitializer((Expression)typeLiteral);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Class")));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)((VariableDeclarationFragment)((VariableDeclarationStatement)node).fragments().get(0)).getInitializer(), "int.class", source);
    }

    public void test0039() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0039", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("c"));
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        typeLiteral.setType((Type)this.ast.newPrimitiveType(PrimitiveType.VOID));
        variableDeclarationFragment.setInitializer((Expression)typeLiteral);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Class")));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)((VariableDeclarationFragment)((VariableDeclarationStatement)node).fragments().get(0)).getInitializer(), "void.class", source);
    }

    public void test0040() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0040", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("c"));
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        typeLiteral.setType((Type)this.ast.newPrimitiveType(PrimitiveType.DOUBLE));
        variableDeclarationFragment.setInitializer((Expression)typeLiteral);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Class")));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)((VariableDeclarationFragment)((VariableDeclarationStatement)node).fragments().get(0)).getInitializer(), "double.class", source);
    }

    public void test0041() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0041", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("c"));
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        typeLiteral.setType((Type)this.ast.newPrimitiveType(PrimitiveType.LONG));
        variableDeclarationFragment.setInitializer((Expression)typeLiteral);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Class")));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)((VariableDeclarationFragment)((VariableDeclarationStatement)node).fragments().get(0)).getInitializer(), "long.class", source);
    }

    public void test0042() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0042", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        BooleanLiteral literal = this.ast.newBooleanLiteral(false);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "false", source);
    }

    public void test0043() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0043", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        BooleanLiteral literal = this.ast.newBooleanLiteral(true);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "true", source);
    }

    public void test0044() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0044", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NullLiteral literal = this.ast.newNullLiteral();
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "null", source);
    }

    public void test0045() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0045", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        CharacterLiteral literal = this.ast.newCharacterLiteral();
        literal.setEscapedValue("'c'");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "'c'", source);
    }

    public void test0046() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0046", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("1.00001");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "1.00001", source);
    }

    public void test0047() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0047", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("1.00001f");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "1.00001f", source);
    }

    public void test0048() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0048", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("30000");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "30000", source);
    }

    public void test0049() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0049", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("-2147483648");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-2147483648", source);
    }

    public void test0050() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0050", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("2147483648L");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "2147483648L", source);
    }

    public void test0051() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0051", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("2147483648L");
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)literal);
        prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)prefixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-2147483648L", source);
    }

    public void test0052() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0052", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        NumberLiteral literal = this.ast.newNumberLiteral("-9223372036854775808L");
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)literal.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "-9223372036854775808L", source);
    }

    public void test0053() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0053", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\"", source);
    }

    public void test0054() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0054", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b3 = b && b2;", source);
    }

    public void test0055() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0055", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b3 = b || b2;", source);
    }

    public void test0056() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0056", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b3"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b2"));
        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b3 = b == b2;", source);
    }

    public void test0057() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0057", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i + j;", source);
    }

    public void test0058() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0058", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i - j;", source);
    }

    public void test0059() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0059", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.TIMES);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i * j;", source);
    }

    public void test0060() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0060", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i / j;", source);
    }

    public void test0061() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0061", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i % j;", source);
    }

    public void test0062() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0062", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.XOR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i ^ j;", source);
    }

    public void test0063() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0063", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.AND);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i & j;", source);
    }

    public void test0064() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0064", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("j"));
        infixExpression.setOperator(InfixExpression.Operator.OR);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = i | j;", source);
    }

    public void test0065() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0065", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b2 = b < b1;", source);
    }

    public void test0066() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0066", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b2 = b <= b1;", source);
    }

    public void test0067() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0067", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.GREATER);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b2 = b > b1;", source);
    }

    public void test0068() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0068", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b2 = b >= b1;", source);
    }

    public void test0069() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0069", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b2"));
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("b"));
        infixExpression.setRightOperand((Expression)this.ast.newSimpleName("b1"));
        infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
        variableDeclarationFragment.setInitializer((Expression)infixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b2 = b != b1;", source);
    }

    public void test0070() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0070", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b"));
        InstanceofExpression instanceOfExpression = this.ast.newInstanceofExpression();
        instanceOfExpression.setLeftOperand((Expression)this.ast.newSimpleName("o"));
        SimpleType simpleType = this.ast.newSimpleType((Name)this.ast.newSimpleName("Integer"));
        instanceOfExpression.setRightOperand((Type)simpleType);
        variableDeclarationFragment.setInitializer((Expression)instanceOfExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b = o instanceof Integer;", source);
    }

    public void test0071() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0071", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b"));
        InstanceofExpression instanceOfExpression = this.ast.newInstanceofExpression();
        instanceOfExpression.setLeftOperand((Expression)this.ast.newSimpleName("o"));
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("Integer"));
        SimpleType type = this.ast.newSimpleType((Name)name);
        instanceOfExpression.setRightOperand((Type)type);
        variableDeclarationFragment.setInitializer((Expression)instanceOfExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b = o instanceof java.lang.Integer;", source);
    }

    public void test0072() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0072", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b1"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("b"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b1 = !b;", source);
    }

    public void test0073() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0073", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("n"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int n = ~i;", source);
    }

    public void test0074() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0074", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
        prefixExpression.setOperand((Expression)this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i = +2;", source);
    }

    public void test0075() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0075", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
        prefixExpression.setOperand((Expression)this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)prefixExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i = -2;", source);
    }

    public void test0076() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0076", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("b"));
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        InfixExpression condition = this.ast.newInfixExpression();
        condition.setLeftOperand((Expression)this.ast.newSimpleName("args"));
        condition.setRightOperand((Expression)this.ast.newNullLiteral());
        condition.setOperator(InfixExpression.Operator.NOT_EQUALS);
        conditionalExpression.setExpression((Expression)condition);
        conditionalExpression.setThenExpression((Expression)this.ast.newBooleanLiteral(true));
        conditionalExpression.setElseExpression((Expression)this.ast.newBooleanLiteral(false));
        variableDeclarationFragment.setInitializer((Expression)conditionalExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.BOOLEAN));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "boolean b = args != null ? true : false;", source);
    }

    public void test0077() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0077", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        conditionalExpression.setExpression((Expression)this.ast.newBooleanLiteral(true));
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newSimpleName("args"), this.ast.newSimpleName("length"));
        conditionalExpression.setThenExpression((Expression)name);
        conditionalExpression.setElseExpression((Expression)this.ast.newNumberLiteral("0"));
        variableDeclarationFragment.setInitializer((Expression)conditionalExpression);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i = true ? args.length: 0;", source);
    }

    public void test0078() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0078", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        SuperMethodInvocation superMethodInvocation = this.ast.newSuperMethodInvocation();
        superMethodInvocation.setName(this.ast.newSimpleName("bar"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)superMethodInvocation);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "super.bar();", source);
    }

    public void test0079() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0079", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        SuperMethodInvocation superMethodInvocation = this.ast.newSuperMethodInvocation();
        superMethodInvocation.setName(this.ast.newSimpleName("bar"));
        superMethodInvocation.arguments().add(this.ast.newNumberLiteral("4"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)superMethodInvocation);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "super.bar(4);", source);
    }

    public void test0080() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0080", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        methodInvocation.setName(this.ast.newSimpleName("bar"));
        methodInvocation.arguments().add(this.ast.newNumberLiteral("4"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)methodInvocation);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "bar(4);", source);
    }

    public void test0081() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0081", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        methodInvocation.setName(this.ast.newSimpleName("bar"));
        methodInvocation.setExpression((Expression)this.ast.newThisExpression());
        methodInvocation.arguments().add(this.ast.newNumberLiteral("4"));
        ExpressionStatement statement = this.ast.newExpressionStatement((Expression)methodInvocation);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "this.bar(4);", source);
    }

    public void test0082() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0082", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (;;);", source);
    }

    public void test0083() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0083", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (int i = 0; i < 10; i++) {}", source);
    }

    public void test0084() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0084", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (int i = 0; i < 10; i++);", source);
    }

    public void test0085() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0085", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (int i = 0;; i++);", source);
    }

    public void test0086() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0086", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (; i < 10; i++);", source);
    }

    public void test0087() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0087", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (;;i++);", source);
    }

    public void test0088() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0088", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("i"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0089() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0089", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("s"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newQualifiedName((Name)this.ast.newSimpleName("java"), this.ast.newSimpleName("lang")), this.ast.newSimpleName("String"));
        statement.setType((Type)this.ast.newSimpleType((Name)name));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "java.lang.String s;", source);
    }

    public void test0090() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0090", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        ArrayInitializer initializer = this.ast.newArrayInitializer();
        initializer.expressions().add(this.ast.newNumberLiteral("1"));
        initializer.expressions().add(this.ast.newNumberLiteral("2"));
        variableDeclarationFragment.setInitializer((Expression)initializer);
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        statement.setType((Type)this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 1));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int[] tab = {1, 2};", source);
    }

    public void test0091() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0091", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        FunctionDeclaration method = (FunctionDeclaration)((TypeDeclaration)((JavaScriptUnit)result).types().get(0)).bodyDeclarations().get(0);
        SingleVariableDeclaration node = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        SingleVariableDeclaration variableDeclaration = this.ast.newSingleVariableDeclaration();
        variableDeclaration.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("String")));
        variableDeclaration.setName(this.ast.newSimpleName("s"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)variableDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)node, "String s", source);
    }

    public void test0092() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0092", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        FunctionDeclaration method = (FunctionDeclaration)((TypeDeclaration)((JavaScriptUnit)result).types().get(0)).bodyDeclarations().get(0);
        SingleVariableDeclaration node = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        SingleVariableDeclaration variableDeclaration = this.ast.newSingleVariableDeclaration();
        variableDeclaration.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        variableDeclaration.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("String")));
        variableDeclaration.setName(this.ast.newSimpleName("s"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)variableDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange((ASTNode)node, "final String s", source);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)0, (int)node.getExtraDimensions());
    }

    public void test0093() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0093", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)node;
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break;", source);
    }

    public void test0094() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0094", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)node;
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue;", source);
    }

    public void test0095() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0095", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue label;", source);
    }

    public void test0096() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0096", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break label;", source);
    }

    public void test0097() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0097", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        SwitchStatement switchStatement = this.ast.newSwitchStatement();
        switchStatement.setExpression((Expression)this.ast.newSimpleName("i"));
        SwitchCase _case = this.ast.newSwitchCase();
        _case.setExpression((Expression)this.ast.newNumberLiteral("1"));
        switchStatement.statements().add(_case);
        switchStatement.statements().add(this.ast.newBreakStatement());
        _case = this.ast.newSwitchCase();
        _case.setExpression((Expression)this.ast.newNumberLiteral("2"));
        switchStatement.statements().add(_case);
        FunctionInvocation methodInvocation = this.ast.newFunctionInvocation();
        QualifiedName name = this.ast.newQualifiedName((Name)this.ast.newSimpleName("System"), this.ast.newSimpleName("out"));
        methodInvocation.setExpression((Expression)name);
        methodInvocation.setName(this.ast.newSimpleName("println"));
        methodInvocation.arguments().add(this.ast.newNumberLiteral("2"));
        ExpressionStatement expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        switchStatement.statements().add(expressionStatement);
        switchStatement.statements().add(this.ast.newBreakStatement());
        _case = this.ast.newSwitchCase();
        _case.setExpression(null);
        switchStatement.statements().add(_case);
        methodInvocation = this.ast.newFunctionInvocation();
        name = this.ast.newQualifiedName((Name)this.ast.newSimpleName("System"), this.ast.newSimpleName("out"));
        methodInvocation.setExpression((Expression)name);
        methodInvocation.setName(this.ast.newSimpleName("println"));
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("default");
        methodInvocation.arguments().add(literal);
        expressionStatement = this.ast.newExpressionStatement((Expression)methodInvocation);
        switchStatement.statements().add(expressionStatement);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)switchStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "switch(i) {\n\t\t\tcase 1: \n              break;\n\t\t\tcase 2:\n\t\t\t\tSystem.out.println(2);\n              break;\n          default:\n\t\t\t\tSystem.out.println(\"default\");\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
        SwitchStatement switchStatement2 = (SwitchStatement)node;
        List statements = switchStatement2.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)7, (int)statements.size());
        Statement stmt = (Statement)statements.get(5);
        ASTConverterAST3Test.assertTrue((String)"Not a case statement", (boolean)(stmt instanceof SwitchCase));
        SwitchCase switchCase = (SwitchCase)stmt;
        ASTConverterAST3Test.assertTrue((String)"Not the default case", (boolean)switchCase.isDefault());
    }

    public void test0098() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0098", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)emptyStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, ";", source);
    }

    public void test0099() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0099", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        DoStatement doStatement = this.ast.newDoStatement();
        Block block = this.ast.newBlock();
        block.statements().add(this.ast.newEmptyStatement());
        doStatement.setBody((Statement)block);
        doStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)doStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "do {;\n\t\t} while(true);";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0100() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0100", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)whileStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "while(true);", source);
    }

    public void test0101() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0101", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)whileStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "while(true) {}", source);
    }

    public void test0102() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0102", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\"", source);
    }

    public void test0103() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0103", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\" + \"!\"", source);
    }

    public void test0104() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0104", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral literal = this.ast.newStringLiteral();
        literal.setLiteralValue("Hello");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue(" World");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newStringLiteral();
        literal.setLiteralValue("!");
        infixExpression.extendedOperands().add(literal);
        NumberLiteral numberLiteral = this.ast.newNumberLiteral();
        numberLiteral.setToken("4");
        infixExpression.extendedOperands().add(numberLiteral);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"Hello\" + \" World\" + \"!\" + 4", source);
    }

    public void test0105() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0105", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 + 5 + 6 + 4", source);
    }

    public void test0106() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0106", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        InfixExpression infixExpression2 = this.ast.newInfixExpression();
        infixExpression2.setOperator(InfixExpression.Operator.PLUS);
        infixExpression2.setLeftOperand((Expression)infixExpression);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression2.setRightOperand((Expression)literal);
        InfixExpression infixExpression3 = this.ast.newInfixExpression();
        infixExpression3.setOperator(InfixExpression.Operator.PLUS);
        infixExpression3.setLeftOperand((Expression)infixExpression2);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression3.setRightOperand((Expression)literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression3.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 - 5 + 6 + 4", source);
    }

    public void test0107() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0107", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.setLeftOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "4 - 5 - 6 - 4", source);
    }

    public void test0108() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0108", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        StringLiteral stringLiteral = this.ast.newStringLiteral();
        stringLiteral.setLiteralValue("4");
        infixExpression.setLeftOperand((Expression)stringLiteral);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression.extendedOperands().add(literal);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression.extendedOperands().add(literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"4\" + 5 + 6 + 4", source);
    }

    public void test0109() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0109", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.MINUS);
        StringLiteral stringLiteral = this.ast.newStringLiteral();
        stringLiteral.setLiteralValue("4");
        infixExpression.setLeftOperand((Expression)stringLiteral);
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("5");
        infixExpression.setRightOperand((Expression)literal);
        InfixExpression infixExpression2 = this.ast.newInfixExpression();
        infixExpression2.setOperator(InfixExpression.Operator.PLUS);
        infixExpression2.setLeftOperand((Expression)infixExpression);
        literal = this.ast.newNumberLiteral();
        literal.setToken("6");
        infixExpression2.setRightOperand((Expression)literal);
        InfixExpression infixExpression3 = this.ast.newInfixExpression();
        infixExpression3.setOperator(InfixExpression.Operator.PLUS);
        infixExpression3.setLeftOperand((Expression)infixExpression2);
        literal = this.ast.newNumberLiteral();
        literal.setToken("4");
        infixExpression3.setRightOperand((Expression)literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)infixExpression3.subtreeMatch(new ASTMatcher(), (Object)expression));
        this.checkSourceRange(expression, "\"4\" - 5 + 6 + 4", source);
    }

    public void test0110() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0110", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)returnStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "return 2;", source);
    }

    public void test0111() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0111", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)returnStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "return 2\\u003B", source);
    }

    public void test0113() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0113", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setBody(this.ast.newBlock());
        tryStatement.setFinally(this.ast.newBlock());
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        exceptionVariable.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Exception")));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t} catch(Exception e) {\n\t\t} finally {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0114() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0114", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setBody(this.ast.newBlock());
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        exceptionVariable.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Exception")));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t} catch(Exception e) {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0115() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0115", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        TryStatement tryStatement = this.ast.newTryStatement();
        Block block = this.ast.newBlock();
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        block.statements().add(returnStatement);
        tryStatement.setBody(block);
        CatchClause catchBlock = this.ast.newCatchClause();
        catchBlock.setBody(this.ast.newBlock());
        SingleVariableDeclaration exceptionVariable = this.ast.newSingleVariableDeclaration();
        exceptionVariable.setName(this.ast.newSimpleName("e"));
        exceptionVariable.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("Exception")));
        catchBlock.setException(exceptionVariable);
        tryStatement.catchClauses().add(catchBlock);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)tryStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "try {\n\t\t\treturn 2;\n\t\t} catch(Exception e) {\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0116() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0116", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e   \\u003B", source);
    }

    public void test0117() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0117", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e /* comment in the middle of a throw */  \\u003B", source);
    }

    public void test0118() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0118", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setExpression((Expression)this.ast.newSimpleName("e"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)throwStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "throw e /* comment in the middle of a throw */  \\u003B", source);
    }

    public void test0119() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0119", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "if (true)\\u003B", source);
    }

    public void test0120() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0120", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newEmptyStatement());
        ifStatement.setElseStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true)\\u003B\n\t\telse ;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0121() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0121", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ifStatement.setThenStatement((Statement)this.ast.newBlock());
        ifStatement.setElseStatement((Statement)this.ast.newEmptyStatement());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true) {}\n\t\telse ;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0122() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0122", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setThenStatement((Statement)returnStatement);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "if (true) return 2\\u003B", source);
    }

    public void test0123() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0123", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("2");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setThenStatement((Statement)returnStatement);
        returnStatement = this.ast.newReturnStatement();
        literal = this.ast.newNumberLiteral();
        literal.setToken("3");
        returnStatement.setExpression((Expression)literal);
        ifStatement.setElseStatement((Statement)returnStatement);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)ifStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "if (true) return 2;\n\t\telse return 3;";
        this.checkSourceRange(node, expectedSource, source);
    }

    public void test0124() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0124", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("x"));
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("10");
        fragment.setInitializer((Expression)literal);
        fragment.setExtraDimensions(0);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("z"));
        fragment.setInitializer((Expression)this.ast.newNullLiteral());
        fragment.setExtraDimensions(1);
        statement.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        fragment.setExtraDimensions(0);
        statement.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("j"));
        fragment.setExtraDimensions(2);
        statement.fragments().add(fragment);
        statement.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        VariableDeclarationFragment[] fragments = ((VariableDeclarationStatement)node).fragments().toArray(new VariableDeclarationFragment[4]);
        ASTConverterAST3Test.assertTrue((String)"fragments.length != 4", (fragments.length == 4 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)fragments[0], "x= 10", source);
        this.checkSourceRange((ASTNode)fragments[1], "z[] = null", source);
        this.checkSourceRange((ASTNode)fragments[2], "i", source);
        this.checkSourceRange((ASTNode)fragments[3], "j[][]", source);
        this.checkSourceRange(node, "int x= 10, z[] = null, i, j[][];", source);
    }

    public void test0125() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0125", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("x"));
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("10");
        fragment.setInitializer((Expression)literal);
        fragment.setExtraDimensions(0);
        VariableDeclarationStatement statement = this.ast.newVariableDeclarationStatement(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("z"));
        fragment.setInitializer((Expression)this.ast.newNullLiteral());
        fragment.setExtraDimensions(1);
        statement.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        fragment.setExtraDimensions(0);
        statement.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("j"));
        fragment.setExtraDimensions(2);
        statement.fragments().add(fragment);
        statement.setType((Type)this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 1));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)statement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int[] x= 10, z[] = null, i, j[][];", source);
        VariableDeclarationFragment[] fragments = ((VariableDeclarationStatement)node).fragments().toArray(new VariableDeclarationFragment[4]);
        ASTConverterAST3Test.assertTrue((String)"fragments.length != 4", (fragments.length == 4 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)fragments[0], "x= 10", source);
        this.checkSourceRange((ASTNode)fragments[1], "z[] = null", source);
        this.checkSourceRange((ASTNode)fragments[2], "i", source);
        this.checkSourceRange((ASTNode)fragments[3], "j[][]", source);
    }

    public void test0126() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0126", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNullLiteral());
        variableDeclarationFragment.setExtraDimensions(1);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newArrayType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("String")), 1));
        forStatement.initializers().add(variableDeclarationExpression);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
        forStatement.updaters().add(prefixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (String[] tab[] = null;; ++i) {}", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).updaters().get(0), "++i", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).initializers().get(0), "String[] tab[] = null", source);
    }

    public void test0127() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0127", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNullLiteral());
        variableDeclarationFragment.setExtraDimensions(1);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("String")));
        forStatement.initializers().add(variableDeclarationExpression);
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
        forStatement.updaters().add(prefixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (String tab[] = null;; ++i) {}", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).updaters().get(0), "++i", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).initializers().get(0), "String tab[] = null", source);
    }

    public void test0128() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0128", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.ast.newSimpleName("tab"));
        variableDeclarationFragment.setInitializer((Expression)this.ast.newNullLiteral());
        variableDeclarationFragment.setExtraDimensions(1);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        variableDeclarationExpression.setType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("String")));
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (String tab[] = null;; i++/**/) {}", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).updaters().get(0), "i++", source);
        this.checkSourceRange((ASTNode)((ForStatement)node).initializers().get(0), "String tab[] = null", source);
    }

    public void test0129() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0129", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        VariableDeclarationFragment frag = (VariableDeclarationFragment)((FieldDeclaration)node).fragments().get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a declaration", (boolean)frag.getName().isDeclaration());
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        fragment.setExtraDimensions(0);
        FieldDeclaration fieldDeclaration = this.ast.newFieldDeclaration(fragment);
        fieldDeclaration.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)fieldDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0130() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0130", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("x"));
        NumberLiteral literal = this.ast.newNumberLiteral();
        literal.setToken("10");
        fragment.setInitializer((Expression)literal);
        fragment.setExtraDimensions(0);
        FieldDeclaration fieldDeclaration = this.ast.newFieldDeclaration(fragment);
        fieldDeclaration.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        fieldDeclaration.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("y"));
        fragment.setExtraDimensions(1);
        fragment.setInitializer((Expression)this.ast.newNullLiteral());
        fieldDeclaration.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("i"));
        fragment.setExtraDimensions(0);
        fieldDeclaration.fragments().add(fragment);
        fragment = this.ast.newVariableDeclarationFragment();
        fragment.setName(this.ast.newSimpleName("j"));
        fragment.setExtraDimensions(2);
        fieldDeclaration.fragments().add(fragment);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)fieldDeclaration.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "public int x= 10, y[] = null, i, j[][];", source);
        VariableDeclarationFragment[] fragments = ((FieldDeclaration)node).fragments().toArray(new VariableDeclarationFragment[4]);
        ASTConverterAST3Test.assertTrue((String)"fragments.length != 4", (fragments.length == 4 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)fragments[0], "x= 10", source);
        this.checkSourceRange((ASTNode)fragments[1], "y[] = null", source);
        this.checkSourceRange((ASTNode)fragments[2], "i", source);
        this.checkSourceRange((ASTNode)fragments[3], "j[][]", source);
    }

    public void test0131() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0131", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        ASTConverterAST3Test.assertTrue((String)"Not a declaration", (boolean)((FunctionDeclaration)node).getName().isDeclaration());
        List parameters = ((FunctionDeclaration)node).parameters();
        ASTConverterAST3Test.assertTrue((String)"Parameters.length != 1", (parameters.size() == 1 ? 1 : 0) != 0);
        SingleVariableDeclaration arg = (SingleVariableDeclaration)((FunctionDeclaration)node).parameters().get(0);
        SingleVariableDeclaration singleVariableDeclaration = this.ast.newSingleVariableDeclaration();
        singleVariableDeclaration.modifiers().add(this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        singleVariableDeclaration.setName(this.ast.newSimpleName("i"));
        singleVariableDeclaration.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)singleVariableDeclaration.subtreeMatch(new ASTMatcher(), (Object)arg));
        this.checkSourceRange(node, "void foo(final int i) {}", source);
        this.checkSourceRange((ASTNode)arg, "final int i", source);
    }

    public void test0132() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0132", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  void foo(final int i) {}", source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0133() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0133", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "void foo(final int i) {}", source);
    }

    public void test0134() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0134", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "void foo(final int i) {}", source);
    }

    public void test0135() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0135", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  int i;", source);
    }

    public void test0136() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0136", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        JSdoc actualJavadoc = ((FieldDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0137() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0137", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        JSdoc actualJavadoc = ((FieldDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0138() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0138", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        String expectedContents = "public class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
    }

    public void test0139() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0139", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        String expectedContents = "public class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
    }

    public void test0140() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0140", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        String expectedContents = "/** JavaDoc Comment*/\npublic class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0141() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0141", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        String expectedContents = "/** JavaDoc Comment*/\n  class B {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0142() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0142", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "class B {}", source);
    }

    public void test0143() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0143", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "public static class B {}", source);
    }

    public void test0144() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0144", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "public static class B {}", source);
    }

    public void test0145() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0145", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        this.checkSourceRange(node, "{}", source);
    }

    public void test0146() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0146", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        this.checkSourceRange(node, "static {}", source);
    }

    public void test0147() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0147", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNotNull((String)"Javadoc comment should no be null", (Object)actualJavadoc);
        String expectedContents = "/** JavaDoc Comment*/\n  static {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0148() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0148", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNotNull((String)"Javadoc comment should not be null", (Object)actualJavadoc);
        String expectedContents = "/** JavaDoc Comment*/\n  {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0149() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0149", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNull((String)"Javadoc comment should be null", (Object)actualJavadoc);
        this.checkSourceRange(node, "{}", source);
    }

    public void test0150() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0150", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed((ASTNode)unit) ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The package declaration is not malformed", (boolean)this.isMalformed((ASTNode)unit.getPackage()));
        List imports = unit.imports();
        ASTConverterAST3Test.assertTrue((String)"The imports list size is not one", (imports.size() == 1 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The first import is malformed", (!this.isMalformed((ASTNode)imports.get(0)) ? 1 : 0) != 0);
    }

    public void test0151() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0151", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
    }

    public void test0152() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0152", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The type is malformed", (!this.isMalformed(node) ? 1 : 0) != 0);
        node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The field is not malformed", (boolean)this.isMalformed(node));
        node = this.getASTNode((JavaScriptUnit)result, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The method is not malformed", (boolean)this.isMalformed(node));
    }

    public void test0153() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0153", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The method is not original", (boolean)this.isOriginal(node));
        ASTConverterAST3Test.assertTrue((String)"The method is not malformed", (boolean)this.isMalformed(node));
    }

    public void test0154() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0154", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        IBinding binding = compilationUnit.getPackage().getName().resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"The package binding is null", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"The binding is not a package binding", (boolean)(binding instanceof IPackageBinding));
        IPackageBinding packageBinding = (IPackageBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"The package name is incorrect", (String)"test0154", (String)packageBinding.getName());
        IBinding binding2 = compilationUnit.getPackage().getName().resolveBinding();
        ASTConverterAST3Test.assertTrue((String)"The package binding is not canonical", (binding == binding2 ? 1 : 0) != 0);
    }

    public void test0155() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0155", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"The result is not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)node;
        List parameters = methodDecl.parameters();
        ASTConverterAST3Test.assertTrue((String)"The parameters size is different from 2", (parameters.size() == 2 ? 1 : 0) != 0);
        Object parameter = parameters.get(0);
        ASTConverterAST3Test.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "int i", source);
        parameter = parameters.get(1);
        ASTConverterAST3Test.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "final boolean b", source);
    }

    public void test0156() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0156", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"The result is not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)node;
        List parameters = methodDecl.parameters();
        ASTConverterAST3Test.assertTrue((String)"The parameters size is different from 1", (parameters.size() == 1 ? 1 : 0) != 0);
        Object parameter = parameters.get(0);
        ASTConverterAST3Test.assertTrue((String)"The parameter is not a SingleVariableDeclaration", (boolean)(parameter instanceof SingleVariableDeclaration));
        this.checkSourceRange((ASTNode)parameter, "int i", source);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertTrue((String)"The statements size is different from 2", (statements.size() == 2 ? 1 : 0) != 0);
        ASTNode statement = (ASTNode)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"The statements[0] is a postfixExpression statement", (boolean)(statement instanceof ExpressionStatement));
    }

    public void test0157() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Test0157.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Type binding is null", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"The type binding is canonical", (typeBinding == typeDeclaration.resolveBinding() ? 1 : 0) != 0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertTrue((String)"The body declaration list is empty", (bodyDeclarations.size() != 0 ? 1 : 0) != 0);
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertTrue((String)"The fragment list is empty", (variableFragments.size() != 0 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"the field binding is null", (Object)variableBinding);
        ASTConverterAST3Test.assertFalse((String)"Not a parameter", (boolean)variableBinding.isParameter());
        ASTConverterAST3Test.assertTrue((String)"The field binding is not canonical", (variableBinding == fragment.resolveBinding() ? 1 : 0) != 0);
        typeBinding = variableBinding.getType();
        ASTConverterAST3Test.assertTrue((String)"The type is not an array type", (boolean)typeBinding.isArray());
        ASTConverterAST3Test.assertTrue((String)"The type binding for the field is not canonical", (typeBinding == variableBinding.getType() ? 1 : 0) != 0);
        SimpleName name = fragment.getName();
        ASTConverterAST3Test.assertTrue((String)"is a declaration", (boolean)name.isDeclaration());
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)3, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"not a field", (boolean)((IVariableBinding)binding).isField());
    }

    public void test0158() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Test0158.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Type binding is null", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"The type binding is canonical", (typeBinding == typeDeclaration.resolveBinding() ? 1 : 0) != 0);
        SimpleName simpleName = typeDeclaration.getName();
        ASTConverterAST3Test.assertTrue((String)"is a declaration", (boolean)simpleName.isDeclaration());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)simpleName.getIdentifier(), (String)binding.getName());
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertTrue((String)"The body declaration list is empty", (bodyDeclarations.size() != 0 ? 1 : 0) != 0);
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertTrue((String)"The fragment list is empty", (variableFragments.size() != 0 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"the field binding is null", (Object)variableBinding);
        ASTConverterAST3Test.assertTrue((String)"The field binding is not canonical", (variableBinding == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterAST3Test.assertTrue((String)"The type is not an array type", (boolean)typeBinding2.isArray());
        ASTConverterAST3Test.assertTrue((String)"The type binding for the field is not canonical", (typeBinding2 == variableBinding.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The type binding for the field is not canonical with the declaration type binding", (typeBinding == typeBinding2.getElementType() ? 1 : 0) != 0);
    }

    public void test0159() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0159", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0160() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0160", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Type binding is null", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"The type binding is canonical", (typeBinding == typeDeclaration.resolveBinding() ? 1 : 0) != 0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertTrue((String)"The body declaration list is empty", (bodyDeclarations.size() != 0 ? 1 : 0) != 0);
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"This is not a field", (boolean)(bodyDeclaration instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
        List variableFragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertTrue((String)"The fragment list size is not 2", (variableFragments.size() == 2 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableFragments.get(0);
        IVariableBinding variableBinding1 = fragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"the field binding is null", (Object)variableBinding1);
        ASTConverterAST3Test.assertTrue((String)"The field binding is not canonical", (variableBinding1 == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding type1 = variableBinding1.getType();
        ASTConverterAST3Test.assertNotNull((String)"The type is null", (Object)type1);
        ASTConverterAST3Test.assertTrue((String)"The field type is canonical", (type1 == variableBinding1.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The type is not an array type", (boolean)type1.isArray());
        ASTConverterAST3Test.assertTrue((String)"The type dimension is 1", (type1.getDimensions() == 1 ? 1 : 0) != 0);
        fragment = (VariableDeclarationFragment)variableFragments.get(1);
        IVariableBinding variableBinding2 = fragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"the field binding is null", (Object)variableBinding2);
        ASTConverterAST3Test.assertTrue((String)"The field binding is not canonical", (variableBinding2 == fragment.resolveBinding() ? 1 : 0) != 0);
        ITypeBinding type2 = variableBinding2.getType();
        type2 = variableBinding2.getType();
        ASTConverterAST3Test.assertNotNull((String)"The type is null", (Object)type2);
        ASTConverterAST3Test.assertTrue((String)"The field type is canonical", (type2 == variableBinding2.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The type is not an array type", (boolean)type2.isArray());
        ASTConverterAST3Test.assertTrue((String)"The type dimension is 2", (type2.getDimensions() == 2 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Element type is canonical", (type1.getElementType() == type2.getElementType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"type1.id < type2.id", (variableBinding1.getVariableId() < variableBinding2.getVariableId() ? 1 : 0) != 0);
    }

    public void test0161() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0161", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"The type binding should not be null", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"The modifier is PUBLIC", (int)1, (int)typeBinding.getModifiers());
        ASTConverterAST3Test.assertNull((String)"There is no element type", (Object)typeBinding.getElementType());
        ASTConverterAST3Test.assertEquals((String)"There is no dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertNull((String)"This is not a member type", (Object)typeBinding.getDeclaringClass());
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"Contains the default constructor", (int)1, (int)methods.length);
        ASTConverterAST3Test.assertEquals((String)"The name is not Test", (String)"Test", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((String)"An anonymous class", (!typeBinding.isAnonymous() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A local class", (!typeBinding.isLocal() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A nested class", (!typeBinding.isNested() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A member class", (!typeBinding.isMember() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverterAST3Test.assertTrue((String)"Is nested", (boolean)typeBinding.isTopLevel());
        ASTConverterAST3Test.assertTrue((String)"A primitive type", (!typeBinding.isPrimitive() ? 1 : 0) != 0);
        ITypeBinding superclass = typeBinding.getSuperclass();
        ASTConverterAST3Test.assertNotNull((String)"No superclass", (Object)superclass);
        ASTConverterAST3Test.assertTrue((String)"From source", (!superclass.isFromSource() ? 1 : 0) != 0);
        ITypeBinding supersuperclass = superclass.getSuperclass();
        ASTConverterAST3Test.assertNull((String)"No superclass for java.lang.Object", (Object)supersuperclass);
        ASTConverterAST3Test.assertEquals((String)"Has fields", (int)0, (int)typeBinding.getDeclaredFields().length);
    }

    public void test0162() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0162", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"The type binding should not be null", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"The modifier is PUBLIC", (int)1, (int)typeBinding.getModifiers());
        ASTConverterAST3Test.assertNull((String)"There is no element type", (Object)typeBinding.getElementType());
        ASTConverterAST3Test.assertEquals((String)"There is no dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertNull((String)"This is not a member type", (Object)typeBinding.getDeclaringClass());
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"Contains no methos", (int)0, (int)methods.length);
        ASTConverterAST3Test.assertEquals((String)"The name is not Test", (String)"Test", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((String)"An anonymous class", (!typeBinding.isAnonymous() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A local class", (!typeBinding.isLocal() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A nested class", (!typeBinding.isNested() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A member class", (!typeBinding.isMember() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A class", (!typeBinding.isClass() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverterAST3Test.assertTrue((String)"Is nested", (boolean)typeBinding.isTopLevel());
        ASTConverterAST3Test.assertTrue((String)"A primitive type", (!typeBinding.isPrimitive() ? 1 : 0) != 0);
        ITypeBinding superclass = typeBinding.getSuperclass();
        ASTConverterAST3Test.assertNull((String)"No superclass", (Object)superclass);
        ASTConverterAST3Test.assertEquals((String)"Has fields", (int)0, (int)typeBinding.getDeclaredFields().length);
    }

    public void test0163() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0163", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ASTConverterAST3Test.assertTrue((String)"Not an anonymous type declaration", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation anonymousClass = (ClassInstanceCreation)expression;
        ITypeBinding typeBinding = anonymousClass.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not an anonymous class", (boolean)typeBinding.isAnonymous());
        ASTConverterAST3Test.assertEquals((String)"The modifier is not default", (int)0, (int)typeBinding.getModifiers());
        ASTConverterAST3Test.assertNull((String)"There is no element type", (Object)typeBinding.getElementType());
        ASTConverterAST3Test.assertEquals((String)"There is no dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertNotNull((String)"This is a member type", (Object)typeBinding.getDeclaringClass());
        ASTConverterAST3Test.assertEquals((String)"The name is not empty", (String)"", (String)typeBinding.getName());
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"Contains the default constructor", (int)1, (int)methods.length);
        ASTConverterAST3Test.assertTrue((String)"Not a local class", (boolean)typeBinding.isLocal());
        ASTConverterAST3Test.assertTrue((String)"Not a nested class", (boolean)typeBinding.isNested());
        ASTConverterAST3Test.assertTrue((String)"A member class", (!typeBinding.isMember() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverterAST3Test.assertTrue((String)"Is a top level", (!typeBinding.isTopLevel() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A primitive type", (!typeBinding.isPrimitive() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong qualified name", (String)"", (String)typeBinding.getQualifiedName());
        ITypeBinding superclass = typeBinding.getSuperclass();
        ASTConverterAST3Test.assertNotNull((String)"No superclass", (Object)superclass);
        ASTConverterAST3Test.assertEquals((String)"Has fields", (int)0, (int)typeBinding.getDeclaredFields().length);
    }

    public void test0164() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0164", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an type declaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"An anonymous class", (!typeBinding.isAnonymous() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"The modifier is not default", (int)2, (int)typeBinding.getModifiers());
        ASTConverterAST3Test.assertNull((String)"There is no element type", (Object)typeBinding.getElementType());
        ASTConverterAST3Test.assertEquals((String)"There is no dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertNotNull((String)"This is not a member type", (Object)typeBinding.getDeclaringClass());
        ASTConverterAST3Test.assertEquals((String)"The name is not 'B'", (String)"B", (String)typeBinding.getName());
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"Contains the default constructor", (int)1, (int)methods.length);
        ASTConverterAST3Test.assertTrue((String)"A local class", (!typeBinding.isLocal() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a nested class", (boolean)typeBinding.isNested());
        ASTConverterAST3Test.assertTrue((String)"Not a member class", (boolean)typeBinding.isMember());
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverterAST3Test.assertTrue((String)"Is a top level", (!typeBinding.isTopLevel() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A primitive type", (!typeBinding.isPrimitive() ? 1 : 0) != 0);
        ITypeBinding superclass = typeBinding.getSuperclass();
        ASTConverterAST3Test.assertNotNull((String)"No superclass", (Object)superclass);
        ASTConverterAST3Test.assertEquals((String)"Has fields", (int)0, (int)typeBinding.getDeclaredFields().length);
    }

    public void test0165() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0165", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an type declaration", (boolean)(node instanceof TypeDeclarationStatement));
        TypeDeclarationStatement statement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDeclaration = statement.getDeclaration();
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"An anonymous class", (!typeBinding.isAnonymous() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"The modifier is not default", (int)0, (int)typeBinding.getModifiers());
        ASTConverterAST3Test.assertNull((String)"There is no element type", (Object)typeBinding.getElementType());
        ASTConverterAST3Test.assertEquals((String)"There is no dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertNotNull((String)"This is not a member type", (Object)typeBinding.getDeclaringClass());
        ASTConverterAST3Test.assertEquals((String)"The name is not 'C'", (String)"C", (String)typeBinding.getName());
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"Contains the default constructor", (int)1, (int)methods.length);
        ASTConverterAST3Test.assertTrue((String)"Not a local class", (boolean)typeBinding.isLocal());
        ASTConverterAST3Test.assertTrue((String)"Not a nested class", (boolean)typeBinding.isNested());
        ASTConverterAST3Test.assertTrue((String)"A member class", (!typeBinding.isMember() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertTrue((String)"Not from source", (boolean)typeBinding.isFromSource());
        ASTConverterAST3Test.assertTrue((String)"Is a top level", (!typeBinding.isTopLevel() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"A primitive type", (!typeBinding.isPrimitive() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong qualified name", (String)"", (String)typeBinding.getQualifiedName());
        ITypeBinding superclass = typeBinding.getSuperclass();
        ASTConverterAST3Test.assertNotNull((String)"No superclass", (Object)superclass);
        ASTConverterAST3Test.assertEquals((String)"Has fields", (int)0, (int)typeBinding.getDeclaredFields().length);
    }

    public void test0166() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0166", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"Fragment list is not 4 ", (fragments.size() == 4 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment1 = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding binding1 = fragment1.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding is null", (Object)binding1);
        ASTConverterAST3Test.assertEquals((String)"wrong name for binding1", (String)"x", (String)binding1.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong modifier for binding1", (int)0, (int)binding1.getModifiers());
        ASTConverterAST3Test.assertTrue((String)"a field", (!binding1.isField() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertNull((String)"declaring class is not null", (Object)binding1.getDeclaringClass());
        ITypeBinding typeBinding1 = binding1.getType();
        ASTConverterAST3Test.assertNotNull((String)"typeBinding1 is null", (Object)typeBinding1);
        ASTConverterAST3Test.assertTrue((String)"typeBinding1 is not a primitive type", (boolean)typeBinding1.isPrimitive());
        ASTConverterAST3Test.assertTrue((String)"typeBinding1 is not canonical", (typeBinding1 == binding1.getType() ? 1 : 0) != 0);
        VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fragments.get(1);
        IVariableBinding binding2 = fragment2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding is null", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name for binding2", (String)"z", (String)binding2.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong modifier for binding2", (int)0, (int)binding2.getModifiers());
        ASTConverterAST3Test.assertTrue((String)"a field", (!binding2.isField() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertNull((String)"declaring class is not null", (Object)binding2.getDeclaringClass());
        ITypeBinding typeBinding2 = binding2.getType();
        ASTConverterAST3Test.assertNotNull((String)"typeBinding2 is null", (Object)typeBinding2);
        ASTConverterAST3Test.assertTrue((String)"typeBinding2 is not an array type", (boolean)typeBinding2.isArray());
        ASTConverterAST3Test.assertTrue((String)"typeBinding2 is not canonical", (typeBinding2 == binding2.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"primitive type is not canonical", (typeBinding1 == typeBinding2.getElementType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"dimension is 1", (int)1, (int)typeBinding2.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"it is not int[]", (String)"int[]", (String)typeBinding2.getName());
        VariableDeclarationFragment fragment3 = (VariableDeclarationFragment)fragments.get(2);
        IVariableBinding binding3 = fragment3.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding is null", (Object)binding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name for binding3", (String)"i", (String)binding3.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong modifier for binding3", (int)0, (int)binding3.getModifiers());
        ASTConverterAST3Test.assertTrue((String)"a field", (!binding3.isField() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertNull((String)"declaring class is not null", (Object)binding3.getDeclaringClass());
        ITypeBinding typeBinding3 = binding3.getType();
        ASTConverterAST3Test.assertNotNull((String)"typeBinding3 is null", (Object)typeBinding3);
        ASTConverterAST3Test.assertTrue((String)"typeBinding3 is not an primitive type", (boolean)typeBinding3.isPrimitive());
        ASTConverterAST3Test.assertTrue((String)"typeBinding3 is not canonical", (typeBinding3 == binding3.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"primitive type is not canonical", (typeBinding1 == typeBinding3 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"dimension is 0", (int)0, (int)typeBinding3.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"it is not the primitive type int", (String)"int", (String)typeBinding3.getName());
        VariableDeclarationFragment fragment4 = (VariableDeclarationFragment)fragments.get(3);
        IVariableBinding binding4 = fragment4.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding is null", (Object)binding4);
        ASTConverterAST3Test.assertEquals((String)"wrong name for binding4", (String)"j", (String)binding4.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong modifier for binding4", (int)0, (int)binding4.getModifiers());
        ASTConverterAST3Test.assertTrue((String)"a field", (!binding4.isField() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertNull((String)"declaring class is not null", (Object)binding4.getDeclaringClass());
        ITypeBinding typeBinding4 = binding4.getType();
        ASTConverterAST3Test.assertNotNull((String)"typeBinding4 is null", (Object)typeBinding4);
        ASTConverterAST3Test.assertTrue((String)"typeBinding4 is not an array type", (boolean)typeBinding4.isArray());
        ASTConverterAST3Test.assertTrue((String)"typeBinding4 is not canonical", (typeBinding4 == binding4.getType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"primitive type is not canonical", (typeBinding1 == typeBinding4.getElementType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"dimension is 2", (int)2, (int)typeBinding4.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"it is not int[][]", (String)"int[][]", (String)typeBinding4.getName());
        ASTConverterAST3Test.assertTrue((String)"ids in the wrong order", (binding1.getVariableId() < binding2.getVariableId() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"ids in the wrong order", (binding2.getVariableId() < binding3.getVariableId() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"ids in the wrong order", (binding3.getVariableId() < binding4.getVariableId() ? 1 : 0) != 0);
    }

    public void test0167() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0167", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Instance of VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"fragment list size is not 1", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertNotNull((String)"No initialization", (Object)initialization);
        ASTConverterAST3Test.assertTrue((String)"Not a FieldAccess", (boolean)(initialization instanceof FieldAccess));
        this.checkSourceRange((ASTNode)initialization, "new Test[1+2].length", source);
    }

    public void test0168() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0168.test1", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IPackageBinding packageBinding = typeBinding.getPackage();
        ASTConverterAST3Test.assertNotNull((String)"No package binding", (Object)packageBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"test0168.test1", (String)packageBinding.getName());
        String[] components = packageBinding.getNameComponents();
        ASTConverterAST3Test.assertNotNull((String)"no components", (Object)components);
        ASTConverterAST3Test.assertTrue((String)"components size != 2", (components.length == 2 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong component name", (String)"test0168", (String)components[0]);
        ASTConverterAST3Test.assertEquals((String)"wrong component name", (String)"test1", (String)components[1]);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)packageBinding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Unnamed package", (!packageBinding.isUnnamed() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Package binding is not canonical", (packageBinding == typeBinding.getPackage() ? 1 : 0) != 0);
    }

    public void test0169() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0169", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IPackageBinding packageBinding = typeBinding.getPackage();
        ASTConverterAST3Test.assertNotNull((String)"No package binding", (Object)packageBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"test0169", (String)packageBinding.getName());
        String[] components = packageBinding.getNameComponents();
        ASTConverterAST3Test.assertNotNull((String)"no components", (Object)components);
        ASTConverterAST3Test.assertTrue((String)"components size != 1", (components.length == 1 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong component name", (String)"test0169", (String)components[0]);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)packageBinding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Unnamed package", (!packageBinding.isUnnamed() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Package binding is not canonical", (packageBinding == typeBinding.getPackage() ? 1 : 0) != 0);
    }

    public void test0170() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Test0170.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IPackageBinding packageBinding = typeBinding.getPackage();
        ASTConverterAST3Test.assertNotNull((String)"No package binding", (Object)packageBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"", (String)packageBinding.getName());
        String[] components = packageBinding.getNameComponents();
        ASTConverterAST3Test.assertNotNull((String)"no components", (Object)components);
        ASTConverterAST3Test.assertTrue((String)"components size != 0", (components.length == 0 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)packageBinding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Not an unnamed package", (boolean)packageBinding.isUnnamed());
        ASTConverterAST3Test.assertTrue((String)"Package binding is not canonical", (packageBinding == typeBinding.getPackage() ? 1 : 0) != 0);
    }

    public void test0171() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0171", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() == 2 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IPackageBinding packageBinding = typeBinding.getPackage();
        ASTConverterAST3Test.assertNotNull((String)"No package binding", (Object)packageBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"test0171", (String)packageBinding.getName());
        String[] components = packageBinding.getNameComponents();
        ASTConverterAST3Test.assertNotNull((String)"no components", (Object)components);
        ASTConverterAST3Test.assertTrue((String)"components size != 1", (components.length == 1 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong component name", (String)"test0171", (String)components[0]);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)packageBinding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Unnamed package", (!packageBinding.isUnnamed() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Package binding is not canonical", (packageBinding == typeBinding.getPackage() ? 1 : 0) != 0);
        typeDeclaration = (TypeDeclaration)types.get(1);
        typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IPackageBinding packageBinding2 = typeBinding.getPackage();
        ASTConverterAST3Test.assertNotNull((String)"No package binding", (Object)packageBinding);
        ASTConverterAST3Test.assertTrue((String)"Package binding is not canonical", (packageBinding == packageBinding2 ? 1 : 0) != 0);
    }

    public void test0172() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0172", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        List types = compilationUnit.types();
        ASTConverterAST3Test.assertTrue((String)"The types list is empty", (types.size() != 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"Binding not null", (Object)typeBinding);
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"methods.length != 4", (int)4, (int)methods.length);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertEquals((String)"body declaration size != 3", (int)3, (int)bodyDeclarations.size());
        FunctionDeclaration method1 = (FunctionDeclaration)bodyDeclarations.get(0);
        IFunctionBinding methodBinding1 = method1.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No method binding for foo", (Object)methodBinding1);
        SimpleName simpleName = method1.getName();
        ASTConverterAST3Test.assertTrue((String)"not a declaration", (boolean)simpleName.isDeclaration());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)binding.getName(), (String)simpleName.getIdentifier());
        IFunctionBinding methodBinding = null;
        int i = 0;
        int max = methods.length;
        while (i < max) {
            IFunctionBinding currentMethod = methods[i];
            if ("foo".equals(currentMethod.getName())) {
                methodBinding = currentMethod;
                break;
            }
            ++i;
        }
        ASTConverterAST3Test.assertNotNull((String)"Cannot be null", methodBinding);
        ASTConverterAST3Test.assertTrue((String)"Canonical method binding", (methodBinding1 == methodBinding ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"declaring class is canonical", (typeBinding == methodBinding1.getDeclaringClass() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong modifier", (int)0, (int)methodBinding1.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name for method", (String)"foo", (String)methodBinding1.getName());
        ITypeBinding[] parameters = methodBinding1.getParameterTypes();
        ASTConverterAST3Test.assertNotNull((String)"No parameters", (Object)parameters);
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)parameters.length);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (String)"int[]", (String)parameters[0].getName());
        ASTConverterAST3Test.assertEquals((String)"wrong return type", (String)"void", (String)methodBinding1.getReturnType().getName());
        ASTConverterAST3Test.assertTrue((String)"A constructor", (!methodBinding1.isConstructor() ? 1 : 0) != 0);
        FunctionDeclaration method2 = (FunctionDeclaration)bodyDeclarations.get(1);
        IFunctionBinding methodBinding2 = method2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No method binding for main", (Object)methodBinding2);
        methodBinding = null;
        int i2 = 0;
        int max2 = methods.length;
        while (i2 < max2) {
            IFunctionBinding currentMethod = methods[i2];
            if ("main".equals(currentMethod.getName())) {
                methodBinding = currentMethod;
                break;
            }
            ++i2;
        }
        ASTConverterAST3Test.assertNotNull((String)"Cannot be null", (Object)methodBinding);
        ASTConverterAST3Test.assertTrue((String)"Canonical method binding", (methodBinding2 == methodBinding ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"declaring class is canonical", (typeBinding == methodBinding2.getDeclaringClass() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong modifier", (int)9, (int)methodBinding2.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name for method", (String)"main", (String)methodBinding2.getName());
        ITypeBinding[] parameters2 = methodBinding2.getParameterTypes();
        ASTConverterAST3Test.assertNotNull((String)"No parameters", (Object)parameters2);
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)parameters2.length);
        ASTConverterAST3Test.assertEquals((String)"wrong type for parameter2[0]", (String)"String[]", (String)parameters2[0].getName());
        ASTConverterAST3Test.assertEquals((String)"wrong return type", (String)"void", (String)methodBinding2.getReturnType().getName());
        ASTConverterAST3Test.assertTrue((String)"A constructor", (!methodBinding2.isConstructor() ? 1 : 0) != 0);
        FunctionDeclaration method3 = (FunctionDeclaration)bodyDeclarations.get(2);
        IFunctionBinding methodBinding3 = method3.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No method binding for bar", (Object)methodBinding3);
        methodBinding = null;
        int i3 = 0;
        int max3 = methods.length;
        while (i3 < max3) {
            IFunctionBinding currentMethod = methods[i3];
            if ("bar".equals(currentMethod.getName())) {
                methodBinding = currentMethod;
                break;
            }
            ++i3;
        }
        ASTConverterAST3Test.assertNotNull((String)"Cannot be null", (Object)methodBinding);
        ASTConverterAST3Test.assertTrue((String)"Canonical method binding", (methodBinding3 == methodBinding ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"declaring class is canonical", (typeBinding == methodBinding3.getDeclaringClass() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"wrong modifier", (int)2, (int)methodBinding3.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name for method", (String)"bar", (String)methodBinding3.getName());
        ITypeBinding[] parameters3 = methodBinding3.getParameterTypes();
        ASTConverterAST3Test.assertNotNull((String)"No parameters", (Object)parameters3);
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)parameters3.length);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (String)"String", (String)parameters3[0].getName());
        ASTConverterAST3Test.assertEquals((String)"wrong return type", (String)"String", (String)methodBinding3.getReturnType().getName());
        ASTConverterAST3Test.assertTrue((String)"A constructor", (!methodBinding3.isConstructor() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"The binding is not canonical", (parameters3[0] == methodBinding3.getReturnType() ? 1 : 0) != 0);
    }

    public void test0173() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0173", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        ASTConverterAST3Test.assertTrue((String)"a declaration", (!name.isDeclaration() ? 1 : 0) != 0);
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0174() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0174", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node2 instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node2;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0175() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0175", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node2;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ITypeBinding typeBinding = fragment.getInitializer().resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a primitive type", (boolean)typeBinding.isPrimitive());
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
    }

    public void test0176() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0176", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Return statement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        ASTConverterAST3Test.assertTrue((String)"Not a field access", (boolean)(returnStatement.getExpression() instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)returnStatement.getExpression();
        ITypeBinding typeBinding = fieldAccess.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a primitive type", (boolean)typeBinding.isPrimitive());
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        Expression expr = fieldAccess.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a this expression", (boolean)(expr instanceof ThisExpression));
        ThisExpression thisExpression = (ThisExpression)expr;
        ITypeBinding typeBinding2 = thisExpression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding2.getName());
    }

    public void test0177() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0177", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 1, 1);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an expressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a postfixexpression", (boolean)(ex instanceof PostfixExpression));
        PostfixExpression postfixExpression = (PostfixExpression)ex;
        Expression expr = postfixExpression.getOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)(expr instanceof SimpleName));
        SimpleName name = (SimpleName)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertEquals((String)"return type is not int", (String)"int", (String)variableBinding.getType().getName());
        ASTConverterAST3Test.assertTrue((variableBinding == binding ? 1 : 0) != 0);
    }

    public void test0178() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0178", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 1, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Return statement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a field access", (boolean)(expr instanceof SuperFieldAccess));
        SuperFieldAccess fieldAccess = (SuperFieldAccess)expr;
        ITypeBinding typeBinding = fieldAccess.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a primitive type", (boolean)typeBinding.isPrimitive());
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
    }

    public void test0179() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0179", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
    }

    public void test0180() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0180", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"No an array creation", (boolean)(initialization instanceof ArrayCreation));
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not an array", (boolean)typeBinding.isArray());
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
    }

    public void test0181() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0181", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not an array", (boolean)typeBinding.isArray());
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
    }

    public void test0182() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0182", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10", source);
    }

    public void test0183() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0183", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10 && i < 20", source);
    }

    public void test0184() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0184", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10 || i < 20", source);
    }

    public void test0185() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0185", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i == 10", source);
    }

    public void test0186() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0186", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node2;
        Expression expr = ifStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "o == o", source);
    }

    public void test0187() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0187", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node2;
        Expression expr = whileStatement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i <= 10", source);
    }

    public void test0188() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0188", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 2);
        ASTConverterAST3Test.assertTrue((String)"DoStatement", (boolean)(node2 instanceof DoStatement));
        DoStatement statement = (DoStatement)node2;
        Expression expr = statement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i <= 10", source);
    }

    public void test0189() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0189", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"ForStatement", (boolean)(node2 instanceof ForStatement));
        ForStatement statement = (ForStatement)node2;
        Expression expr = statement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "i < 10", source);
    }

    public void test0190() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0190", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 2, 1);
        ASTConverterAST3Test.assertTrue((String)"IfStatement", (boolean)(node2 instanceof IfStatement));
        IfStatement statement = (IfStatement)node2;
        Expression expr = statement.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No condition", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "scanner.x < selection.start && selection.start < scanner.y", source);
    }

    public void test0191() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0191", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Assignment", (boolean)(ex instanceof Assignment));
        Assignment statement = (Assignment)ex;
        Expression rightExpr = statement.getRightHandSide();
        ASTConverterAST3Test.assertTrue((String)"Not an infix expression", (boolean)(rightExpr instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)rightExpr;
        Expression expr = infixExpression.getRightOperand();
        ASTConverterAST3Test.assertNotNull((String)"No right hand side expression", (Object)expr);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)expr, "2 < 20", source);
    }

    public void test0192() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0192", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)initialization, "0", source);
    }

    public void test0193() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0193", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)initialization, "new Inner()", source);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"Inner", (String)typeBinding.getName());
    }

    public void test0194() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0194", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        Expression initialization = fragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((variableBinding.getType() == typeBinding ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)initialization, "new Inner[10]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array", (boolean)typeBinding.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"Inner[]", (String)typeBinding.getName());
    }

    public void test0195() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0195", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 1, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(ex instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)ex;
        this.checkSourceRange((ASTNode)methodInvocation, "a.useFile(/*]*/a.getFile()/*[*/)", source);
        List list = methodInvocation.arguments();
        ASTConverterAST3Test.assertTrue((String)"Parameter list not empty", (list.size() == 1 ? 1 : 0) != 0);
        Expression parameter = (Expression)list.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method invocation", (boolean)(parameter instanceof FunctionInvocation));
        ITypeBinding typeBinding = parameter.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not a boolean", (String)"File", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)parameter, "a.getFile()", source);
    }

    public void test0196() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0196", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 2);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Assignment", (boolean)(ex instanceof Assignment));
        Assignment statement = (Assignment)ex;
        Expression rightExpr = statement.getRightHandSide();
        ASTConverterAST3Test.assertTrue((String)"Not an instanceof expression", (boolean)(rightExpr instanceof InstanceofExpression));
        ITypeBinding typeBinding = rightExpr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (String)"boolean", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)rightExpr, "inner instanceof Inner", source);
    }

    public void test0197() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0197", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertEquals((String)"Not a compilation unit", (int)15, (int)result.getNodeType());
        JavaScriptUnit unit = (JavaScriptUnit)result;
        this.assertProblemsSize(unit, 0);
        ASTNode node2 = this.getASTNode(unit, 1, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression ex = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(ex instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)ex;
        this.checkSourceRange((ASTNode)methodInvocation, "a.getFile()/*[*/.getName()", source);
        Expression receiver = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a method invocation", (boolean)(receiver instanceof FunctionInvocation));
        FunctionInvocation methodInvocation2 = (FunctionInvocation)receiver;
        ITypeBinding typeBinding = methodInvocation2.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"File", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)methodInvocation2, "a.getFile()", source);
    }

    public void test0198() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0198", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"ReturnStatement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an infixExpression", (boolean)(expr instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)expr;
        Expression left = infixExpression.getLeftOperand();
        ASTConverterAST3Test.assertTrue((String)"Not an InfixExpression", (boolean)(left instanceof InfixExpression));
        InfixExpression infixExpression2 = (InfixExpression)left;
        Expression right = infixExpression2.getRightOperand();
        ASTConverterAST3Test.assertTrue((String)"Not an InfixExpression", (boolean)(right instanceof InfixExpression));
        InfixExpression infixExpression3 = (InfixExpression)right;
        ASTConverterAST3Test.assertEquals((String)"A multiplication", (Object)InfixExpression.Operator.TIMES, (Object)infixExpression3.getOperator());
        ITypeBinding typeBinding = infixExpression3.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)infixExpression3, "20 * 30", source);
    }

    public void test0199() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0199", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an infixExpression", (boolean)(initialization instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)initialization;
        Expression left = infixExpression.getLeftOperand();
        ASTConverterAST3Test.assertTrue((String)"Not an InfixExpression", (boolean)(left instanceof InfixExpression));
        InfixExpression infixExpression2 = (InfixExpression)left;
        Expression right = infixExpression2.getRightOperand();
        ASTConverterAST3Test.assertTrue((String)"Not an InfixExpression", (boolean)(right instanceof InfixExpression));
        InfixExpression infixExpression3 = (InfixExpression)right;
        ASTConverterAST3Test.assertEquals((String)"A multiplication", (Object)InfixExpression.Operator.TIMES, (Object)infixExpression3.getOperator());
        ITypeBinding typeBinding = infixExpression3.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)infixExpression3, "10 * 30", source);
    }

    public void test0200() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0200", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 1, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertTrue((String)"No fragment", (fragments.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an infixExpression", (boolean)(initialization instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)initialization;
        Expression receiver = fieldAccess.getExpression();
        ASTConverterAST3Test.assertTrue((String)"ArrayCreation", (boolean)(receiver instanceof ArrayCreation));
        ArrayCreation arrayCreation = (ArrayCreation)receiver;
        List dimensions = arrayCreation.dimensions();
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)dimensions.size());
        Expression dim = (Expression)dimensions.get(0);
        ASTConverterAST3Test.assertTrue((String)"InfixExpression", (boolean)(dim instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)dim;
        ITypeBinding typeBinding = infixExpression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)infixExpression, "1 + 2", source);
    }

    public void test0201() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0201", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"ForStatement", (boolean)(node2 instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node2;
        List initializers = forStatement.initializers();
        ASTConverterAST3Test.assertTrue((String)"wrong size", (initializers.size() == 1 ? 1 : 0) != 0);
        Expression init = (Expression)initializers.get(0);
        this.checkSourceRange((ASTNode)init, "int i= 0", source);
    }

    public void test0202() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0202", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node2 instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "int f= (2);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        this.checkSourceRange((ASTNode)initialization, "(2)", source);
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"not int", (String)"int", (String)typeBinding.getName());
    }

    public void test0203() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0203", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node2 instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "int f= (2);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)initialization;
        this.checkSourceRange((ASTNode)parenthesizedExpression, "(2)", source);
        Expression expr = parenthesizedExpression.getExpression();
        this.checkSourceRange((ASTNode)expr, "2", source);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"not int", (String)"int", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((String)"type binding is canonical", (typeBinding == parenthesizedExpression.resolveTypeBinding() ? 1 : 0) != 0);
    }

    public void test0204() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0204", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node2 instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node2;
        this.checkSourceRange((ASTNode)fieldDeclaration, "int f= ((2));", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = fragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (boolean)(initialization instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)initialization;
        this.checkSourceRange((ASTNode)parenthesizedExpression, "((2))", source);
        Expression expr = parenthesizedExpression.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (boolean)(expr instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression2 = (ParenthesizedExpression)expr;
        this.checkSourceRange((ASTNode)parenthesizedExpression2, "(2)", source);
        expr = parenthesizedExpression2.getExpression();
        this.checkSourceRange((ASTNode)expr, "2", source);
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"not int", (String)"int", (String)typeBinding.getName());
        typeBinding = parenthesizedExpression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"not int", (String)"int", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((String)"type binding is canonical", (typeBinding == parenthesizedExpression2.resolveTypeBinding() ? 1 : 0) != 0);
    }

    public void test0205() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0205", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"TypeDeclarationStatement", (boolean)(node2 instanceof TypeDeclarationStatement));
        TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)node2;
        AbstractTypeDeclaration typeDeclaration = typeDeclarationStatement.getDeclaration();
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"AA", (String)typeDeclaration.getName().getIdentifier());
        this.checkSourceRange((ASTNode)typeDeclaration, "class AA extends Test {}", source);
    }

    public void test0206() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0206", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 5, 0);
        ASTConverterAST3Test.assertTrue((String)"ReturnStatement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a qualifiedName", (boolean)(expr instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expr;
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not an int (typeBinding)", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)qualifiedName, "field1.field2.field3.field4.i", source);
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (boolean)qualifiedName.getName().isSimpleName());
        SimpleName simpleName = qualifiedName.getName();
        ASTConverterAST3Test.assertTrue((String)"a declaration", (!simpleName.isDeclaration() ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)simpleName, "i", source);
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typebinding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Not an int (typeBinding2)", (String)"int", (String)typeBinding2.getName());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)variableBinding.getDeclaringClass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not default", (int)1, (int)variableBinding.getModifiers());
        Name qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)qualifierName.isQualifiedName());
        this.checkSourceRange((ASTNode)qualifierName, "field1.field2.field3.field4", source);
        ITypeBinding typeBinding5 = qualifierName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding5", (Object)typeBinding5);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding5.getName());
        qualifiedName = (QualifiedName)qualifierName;
        simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "field4", source);
        ITypeBinding typeBinding6 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding6", (Object)typeBinding6);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding6.getName());
        qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)qualifierName.isQualifiedName());
        this.checkSourceRange((ASTNode)qualifierName, "field1.field2.field3", source);
        ITypeBinding typeBinding7 = qualifierName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding7", (Object)typeBinding7);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding7.getName());
        qualifiedName = (QualifiedName)qualifierName;
        simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "field3", source);
        qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)qualifierName.isQualifiedName());
        this.checkSourceRange((ASTNode)qualifierName, "field1.field2", source);
        ITypeBinding typeBinding3 = qualifierName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding3.getName());
        qualifiedName = (QualifiedName)qualifierName;
        simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "field2", source);
        qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (boolean)qualifierName.isSimpleName());
        ASTConverterAST3Test.assertTrue((String)"a declaration", (!((SimpleName)qualifierName).isDeclaration() ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)qualifierName, "field1", source);
        ITypeBinding typeBinding4 = qualifierName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding4", (Object)typeBinding4);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)typeBinding4.getName());
    }

    public void test0207() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0207", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  void foo(final int i) {}", source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0208() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0208", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "void foo(final int i) {}", source);
    }

    public void test0209() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0209", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        JSdoc actualJavadoc = ((FunctionDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "void foo(final int i) {}", source);
    }

    public void test0210() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0210", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        this.checkSourceRange(node, "/** JavaDoc Comment*/\n  int i;", source);
    }

    public void test0211() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0211", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        JSdoc actualJavadoc = ((FieldDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0212() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0212", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        JSdoc actualJavadoc = ((FieldDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "int i;", source);
    }

    public void test0213() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0213", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        String expectedContents = "public class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
    }

    public void test0214() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0214", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        String expectedContents = "public class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
    }

    public void test0215() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0215", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        String expectedContents = "/** JavaDoc Comment*/\npublic class Test {\n  int i;\n}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0216() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0216", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        String expectedContents = "/** JavaDoc Comment*/\n  class B {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0217() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0217", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "class B {}", source);
    }

    public void test0218() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0218", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "public static class B {}", source);
    }

    public void test0219() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0219", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"The node is not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        JSdoc actualJavadoc = ((TypeDeclaration)node).getJavadoc();
        ASTConverterAST3Test.assertTrue((String)"Javadoc must be null", (actualJavadoc == null ? 1 : 0) != 0);
        this.checkSourceRange(node, "public static class B {}", source);
    }

    public void test0220() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0220", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        this.checkSourceRange(node, "{}", source);
    }

    public void test0221() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0221", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        this.checkSourceRange(node, "static {}", source);
    }

    public void test0222() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0222", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNotNull((String)"Javadoc comment should no be null", (Object)actualJavadoc);
        String expectedContents = "/** JavaDoc Comment*/\n  static {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0223() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0223", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNotNull((String)"Javadoc comment should not be null", (Object)actualJavadoc);
        String expectedContents = "/** JavaDoc Comment*/\n  {}";
        this.checkSourceRange(node, expectedContents, source);
        this.checkSourceRange((ASTNode)actualJavadoc, "/** JavaDoc Comment*/", source);
    }

    public void test0224() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0224", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        JSdoc actualJavadoc = ((Initializer)node).getJavadoc();
        ASTConverterAST3Test.assertNull((String)"Javadoc comment should be null", (Object)actualJavadoc);
        this.checkSourceRange(node, "{}", source);
    }

    public void test0225() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0225", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        this.checkSourceRange((ASTNode)labeledStatement.getLabel(), "label", source);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        ContinueStatement statement = (ContinueStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)continueStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "continue label;", source);
        this.checkSourceRange((ASTNode)statement.getLabel(), "label", source);
    }

    public void test0226() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0226", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        LabeledStatement labeledStatement = (LabeledStatement)this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        this.checkSourceRange((ASTNode)labeledStatement.getLabel(), "label", source);
        ForStatement forStatement = (ForStatement)labeledStatement.getBody();
        BreakStatement statement = (BreakStatement)((Block)forStatement.getBody()).statements().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)statement);
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setLabel(this.ast.newSimpleName("label"));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)breakStatement.subtreeMatch(new ASTMatcher(), (Object)statement));
        this.checkSourceRange((ASTNode)statement, "break label;", source);
        this.checkSourceRange((ASTNode)statement.getLabel(), "label", source);
    }

    public void test0227() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0227", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 3, 2, 0);
        ASTConverterAST3Test.assertTrue((String)"ReturnStatement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a qualifiedName", (boolean)(expr instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expr;
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not an long (typeBinding)", (String)"long", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)qualifiedName, "field.fB.fA.j", source);
        SimpleName simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "j", source);
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertEquals((String)"Not an long (typeBinding2)", (String)"long", (String)typeBinding2.getName());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Not A", (String)"A", (String)variableBinding.getDeclaringClass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not default", (int)0, (int)variableBinding.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"j", (String)variableBinding.getName());
        Name qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)qualifierName.isQualifiedName());
        this.checkSourceRange((ASTNode)qualifierName, "field.fB.fA", source);
        qualifiedName = (QualifiedName)qualifierName;
        ITypeBinding typeBinding3 = qualifiedName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"Not an A", (String)"A", (String)typeBinding3.getName());
        simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "fA", source);
        ITypeBinding typeBinding4 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding4", (Object)typeBinding4);
        ASTConverterAST3Test.assertEquals((String)"Not an A", (String)"A", (String)typeBinding4.getName());
        IBinding binding2 = qualifiedName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding2 instanceof IVariableBinding));
        IVariableBinding variableBinding2 = (IVariableBinding)binding2;
        ASTConverterAST3Test.assertEquals((String)"Not B", (String)"B", (String)variableBinding2.getDeclaringClass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not default", (int)0, (int)variableBinding2.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"fA", (String)variableBinding2.getName());
        qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)qualifierName.isQualifiedName());
        this.checkSourceRange((ASTNode)qualifierName, "field.fB", source);
        qualifiedName = (QualifiedName)qualifierName;
        ITypeBinding typeBinding5 = qualifiedName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding5", (Object)typeBinding5);
        ASTConverterAST3Test.assertEquals((String)"Not a B", (String)"B", (String)typeBinding5.getName());
        simpleName = qualifiedName.getName();
        this.checkSourceRange((ASTNode)simpleName, "fB", source);
        ITypeBinding typeBinding6 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typebinding6", (Object)typeBinding6);
        ASTConverterAST3Test.assertEquals((String)"not a B", (String)"B", (String)typeBinding6.getName());
        IBinding binding3 = qualifiedName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding3);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding3 instanceof IVariableBinding));
        IVariableBinding variableBinding3 = (IVariableBinding)binding3;
        ASTConverterAST3Test.assertEquals((String)"Not C", (String)"C", (String)variableBinding3.getDeclaringClass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not default", (int)0, (int)variableBinding3.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"fB", (String)variableBinding3.getName());
        qualifierName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (boolean)qualifierName.isSimpleName());
        this.checkSourceRange((ASTNode)qualifierName, "field", source);
        simpleName = (SimpleName)qualifierName;
        ITypeBinding typeBinding7 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding7", (Object)typeBinding7);
        ASTConverterAST3Test.assertEquals((String)"Not a C", (String)"C", (String)typeBinding7.getName());
        IBinding binding4 = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding4", (Object)binding4);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding4 instanceof IVariableBinding));
        IVariableBinding variableBinding4 = (IVariableBinding)binding4;
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)variableBinding4.getDeclaringClass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not public", (int)1, (int)variableBinding4.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"field", (String)variableBinding4.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong return type", (String)"C", (String)variableBinding4.getType().getName());
    }

    public void test0228() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0228", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"ReturnStatement", (boolean)(node2 instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node2;
        Expression expr = returnStatement.getExpression();
        this.checkSourceRange((ASTNode)expr, "test0228.Test.foo()", source);
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"no qualifier", (Object)qualifier);
        ASTConverterAST3Test.assertTrue((String)"QualifiedName", (boolean)(qualifier instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)qualifier;
        this.checkSourceRange((ASTNode)qualifiedName, "test0228.Test", source);
        ITypeBinding typeBinding = qualifiedName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"Test", (String)typeBinding.getName());
        IBinding binding = qualifiedName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Not a type", (int)2, (int)binding.getKind());
    }

    public void test0229() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0229", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression expr = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        this.checkSourceRange((ASTNode)expr, "System.err.println()", source);
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"QualifiedName", (boolean)(qualifier instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)qualifier;
        ITypeBinding typeBinding = qualifier.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"PrintStream", (String)typeBinding.getName());
        IBinding binding = qualifiedName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"err", (String)variableBinding.getName());
        SimpleName methodName = methodInvocation.getName();
        IBinding binding2 = methodName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
    }

    public void test0230() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0230", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression expr = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        this.checkSourceRange((ASTNode)expr, "err.println()", source);
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"SimpleName", (boolean)(qualifier instanceof SimpleName));
        SimpleName name = (SimpleName)qualifier;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"err", (String)binding.getName());
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wron type name", (String)"PrintStream", (String)typeBinding.getName());
    }

    public void test0231() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0231", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"ExpressionStatement", (boolean)(node2 instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node2;
        Expression expr = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        this.checkSourceRange((ASTNode)expr, "System.err.println()", source);
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"QualifiedName", (boolean)(qualifier instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)qualifier;
        ITypeBinding typeBinding = qualifier.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"PrintStream", (String)typeBinding.getName());
        IBinding binding = qualifiedName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"VariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"err", (String)variableBinding.getName());
        SimpleName methodName = methodInvocation.getName();
        IBinding binding2 = methodName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        Name name = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"SimpleName", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong type name", (String)"System", (String)typeBinding2.getName());
    }

    public void test0232() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0232", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node2 = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"VariableDeclarationStatement", (boolean)(node2 instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node2;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression initialization = variableDeclarationFragment.getInitializer();
        ITypeBinding typeBinding = initialization.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a primitive type", (boolean)typeBinding.isPrimitive());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"int", (String)typeBinding.getName());
        ASTConverterAST3Test.assertTrue((String)"QualifiedName", (boolean)(initialization instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)initialization;
        SimpleName simpleName = qualifiedName.getName();
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertTrue((String)"Not a primitive type", (boolean)typeBinding2.isPrimitive());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"int", (String)typeBinding2.getName());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"IVariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertNull((String)"No declaring class", (Object)variableBinding.getDeclaringClass());
    }

    public void test0233() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0233", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"The compilation unit is malformed", (!this.isMalformed(result) ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"The fiels is not malformed", (!this.isMalformed(node) ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"No problem found", (int)1, (int)unit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"No problem found", (int)1, (int)unit.getProblems().length);
    }

    public void test0234() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0234", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"The fiels is not malformed", (!this.isMalformed(node) ? 1 : 0) != 0);
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"No problem found", (int)1, (int)unit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"No problem found", (int)1, (int)unit.getProblems().length);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertNull((String)"binding not null", (Object)variableBinding);
    }

    public void test0235() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0235", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"The fiels is not malformed", (!this.isMalformed(node) ? 1 : 0) != 0);
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"problems found", (int)0, (int)unit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"problems found", (int)0, (int)unit.getProblems().length);
        ASTConverterAST3Test.assertTrue((String)"FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)variableBinding);
    }

    public void test0237() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "junit.framework", "TestCase.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0238() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0238", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration statement", (boolean)(node instanceof TypeDeclarationStatement));
        TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDecl = typeDeclarationStatement.getDeclaration();
        Object o = typeDecl.bodyDeclarations().get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method", (boolean)(o instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)o;
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Not 1", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(stmt instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)stmt;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a method invocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        this.checkSourceRange((ASTNode)methodInvocation, "Test.this.bar()", source);
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a ThisExpression", (boolean)(qualifier instanceof ThisExpression));
        ThisExpression thisExpression = (ThisExpression)qualifier;
        Name name = thisExpression.getQualifier();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Test", (String)binding.getName());
    }

    public void test0239() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0239", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 1, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration statement", (boolean)(node instanceof TypeDeclarationStatement));
        TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDecl = typeDeclarationStatement.getDeclaration();
        Object o = typeDecl.bodyDeclarations().get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method", (boolean)(o instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)o;
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Not 1", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(stmt instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)stmt;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a SuperMethodInvocation", (boolean)(expr instanceof SuperMethodInvocation));
        SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expr;
        Name name = superMethodInvocation.getQualifier();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"A type binding", (boolean)(binding instanceof ITypeBinding));
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)binding.getName());
        SimpleName methodName = superMethodInvocation.getName();
        IBinding binding2 = methodName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertTrue((String)"No an IFunctionBinding", (boolean)(binding2 instanceof IFunctionBinding));
        IFunctionBinding methodBinding = (IFunctionBinding)binding2;
        ASTConverterAST3Test.assertEquals((String)"Not bar", (String)"bar", (String)methodBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Not T", (String)"T", (String)methodBinding.getDeclaringClass().getName());
    }

    public void test0240() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0240", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration statement", (boolean)(node instanceof TypeDeclarationStatement));
        TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDecl = typeDeclarationStatement.getDeclaration();
        Object o = typeDecl.bodyDeclarations().get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method", (boolean)(o instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)o;
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Not 1", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(stmt instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)stmt;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a field access", (boolean)(expr instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)expr;
        Expression qualifier = fieldAccess.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a ThisExpression", (boolean)(qualifier instanceof ThisExpression));
        ThisExpression thisExpression = (ThisExpression)qualifier;
        Name name = thisExpression.getQualifier();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)binding.getName());
        SimpleName fieldName = fieldAccess.getName();
        IBinding binding2 = fieldName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"f", (String)binding2.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong modifier", (int)1, (int)binding2.getModifiers());
        ITypeBinding typeBinding = fieldName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
    }

    public void test0241() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0241", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (boolean)(node instanceof TypeDeclaration));
        ASTConverterAST3Test.assertTrue((String)"Not a declaration", (boolean)((TypeDeclaration)node).getName().isDeclaration());
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)11, (int)((TypeDeclaration)node).bodyDeclarations().size());
        node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a field declaration", (boolean)(node instanceof FieldDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 2);
        ASTConverterAST3Test.assertTrue((String)"Not a Type declaration", (boolean)(node instanceof TypeDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 3);
        ASTConverterAST3Test.assertTrue((String)"Not a Type declaration", (boolean)(node instanceof TypeDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 4);
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 5);
        ASTConverterAST3Test.assertTrue((String)"Not a field declaration", (boolean)(node instanceof FieldDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 6);
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 7);
        ASTConverterAST3Test.assertTrue((String)"Not a field declaration", (boolean)(node instanceof FieldDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 8);
        ASTConverterAST3Test.assertTrue((String)"Not a field declaration", (boolean)(node instanceof FieldDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 9);
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        node = this.getASTNode((JavaScriptUnit)result, 0, 10);
        ASTConverterAST3Test.assertTrue((String)"Not a Type declaration", (boolean)(node instanceof TypeDeclaration));
    }

    public void test0242() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0242", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 1, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration statement", (boolean)(node instanceof TypeDeclarationStatement));
        TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)node;
        AbstractTypeDeclaration typeDecl = typeDeclarationStatement.getDeclaration();
        Object o = typeDecl.bodyDeclarations().get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method", (boolean)(o instanceof FunctionDeclaration));
        FunctionDeclaration methodDecl = (FunctionDeclaration)o;
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Not 1", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(stmt instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)stmt;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a SuperFieldAccess", (boolean)(expr instanceof SuperFieldAccess));
        SuperFieldAccess superFieldAccess = (SuperFieldAccess)expr;
        Name name = superFieldAccess.getQualifier();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"A type binding", (boolean)(binding instanceof ITypeBinding));
        ASTConverterAST3Test.assertEquals((String)"Not Test", (String)"Test", (String)binding.getName());
        SimpleName fieldName = superFieldAccess.getName();
        IBinding binding2 = fieldName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertTrue((String)"No an IVariableBinding", (boolean)(binding2 instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding2;
        ASTConverterAST3Test.assertEquals((String)"Not f", (String)"f", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Not T", (String)"T", (String)variableBinding.getDeclaringClass().getName());
        ITypeBinding typeBinding2 = fieldName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)typeBinding2.getName());
    }

    public void test0243() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0243", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a try statement", (boolean)(node instanceof TryStatement));
        TryStatement tryStatement = (TryStatement)node;
        List catchClauses = tryStatement.catchClauses();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)catchClauses.size());
        CatchClause catchClause = (CatchClause)catchClauses.get(0);
        this.checkSourceRange((ASTNode)catchClause, "catch (Exception e){m();}", source);
    }

    public void test0244() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0244", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a try statement", (boolean)(node instanceof TryStatement));
        TryStatement tryStatement = (TryStatement)node;
        List catchClauses = tryStatement.catchClauses();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)catchClauses.size());
        CatchClause catchClause = (CatchClause)catchClauses.get(0);
        this.checkSourceRange((ASTNode)catchClause, "catch (RuntimeException e){m();}", source);
        catchClause = (CatchClause)catchClauses.get(1);
        this.checkSourceRange((ASTNode)catchClause, "catch(Exception e) {}", source);
    }

    public void test0245() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0245", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expr = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"not a name", (boolean)(expr instanceof Name));
        Name name = (Name)expr;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Not i", (String)"i", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Not int", (String)"int", (String)variableBinding.getType().getName());
        ASTNode declaringNode = unit.findDeclaringNode((IBinding)variableBinding);
        ASTConverterAST3Test.assertNotNull((String)"No declaring node", (Object)declaringNode);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationFragment", (boolean)(declaringNode instanceof VariableDeclarationFragment));
    }

    public void test0246() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0246", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        List imports = unit.imports();
        ASTConverterAST3Test.assertEquals((String)"wrong imports size", (int)2, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not on demand", (boolean)importDeclaration.isOnDemand());
        this.checkSourceRange((ASTNode)importDeclaration, "import java.util.*;", source);
        IBinding binding = importDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)1, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"java.util", (String)binding.getName());
        importDeclaration = (ImportDeclaration)imports.get(1);
        ASTConverterAST3Test.assertTrue((String)"On demand", (!importDeclaration.isOnDemand() ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)importDeclaration, "import java.io.IOException;", source);
        binding = importDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"IOException", (String)binding.getName());
    }

    public void test0247() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0247", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        PackageDeclaration packageDeclaration = unit.getPackage();
        this.checkSourceRange((ASTNode)packageDeclaration, "package test0247;", source);
        IPackageBinding binding = packageDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)1, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"test0247", (String)binding.getName());
    }

    public void test0248() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0248", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        SimpleName name = singleVariableDeclaration.getName();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"i", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"int", (String)variableBinding.getType().getName());
    }

    public void test0249() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0249", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 2, 1);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an assignment", (boolean)(expression instanceof Assignment));
        Assignment assignment = (Assignment)expression;
        Expression leftHandSide = assignment.getLeftHandSide();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)(leftHandSide instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)leftHandSide;
        SimpleName simpleName = qualifiedName.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"Not a IVariableBinding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"k", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong modifier", (int)8, (int)variableBinding.getModifiers());
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"int", (String)variableBinding.getType().getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong declaring class name", (String)"j", (String)variableBinding.getDeclaringClass().getName());
    }

    public void test0250() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0250", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        SimpleName name = singleVariableDeclaration.getName();
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"i", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"int", (String)variableBinding.getType().getName());
    }

    public void test0251() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0251", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a method invocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "java.lang.System.out.println()", source);
        Expression qualifier = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)(qualifier instanceof QualifiedName));
        this.checkSourceRange((ASTNode)qualifier, "java.lang.System.out", source);
        QualifiedName qualifiedName = (QualifiedName)qualifier;
        Name typeName = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a QualifiedName", (boolean)(typeName instanceof QualifiedName));
        QualifiedName qualifiedTypeName = (QualifiedName)typeName;
        IBinding binding = qualifiedTypeName.getName().resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"System", (String)binding.getName());
        binding = qualifiedTypeName.getQualifier().resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type binding", (int)1, (int)binding.getKind());
    }

    public void test0252() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0252", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a classinstancecreation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        IFunctionBinding methodBinding = classInstanceCreation.resolveConstructorBinding();
        ASTConverterAST3Test.assertNotNull((String)"No methodBinding", (Object)methodBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a constructor", (boolean)methodBinding.isConstructor());
        ASTConverterAST3Test.assertTrue((String)"Not an anonymous class", (boolean)methodBinding.getDeclaringClass().isAnonymous());
        ASTConverterAST3Test.assertEquals((String)"Not an anonymous class of java.lang.Object", (String)"Object", (String)methodBinding.getDeclaringClass().getSuperclass().getName());
        ASTConverterAST3Test.assertEquals((String)"Not an anonymous class of java.lang.Object", (String)"java.lang", (String)methodBinding.getDeclaringClass().getSuperclass().getPackage().getName());
    }

    public void test0253() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0253", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a classinstancecreation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        IFunctionBinding methodBinding = classInstanceCreation.resolveConstructorBinding();
        ASTConverterAST3Test.assertNotNull((String)"No methodBinding", (Object)methodBinding);
        ASTConverterAST3Test.assertTrue((String)"Not a constructor", (boolean)methodBinding.isConstructor());
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)methodBinding.getParameterTypes().length);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"String", (String)methodBinding.getParameterTypes()[0].getName());
    }

    public void test0254() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0254", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a class instance creation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        IFunctionBinding binding = classInstanceCreation.resolveConstructorBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (String)"C", (String)binding.getDeclaringClass().getName());
    }

    public void test0255() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0255", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
    }

    public void test0256() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0256", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
    }

    public void test0257() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0257", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
    }

    public void test0258() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0258", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
    }

    public void test0259() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0259", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0260() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0260", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        IVariableBinding binding = singleVariableDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        SimpleName name = singleVariableDeclaration.getName();
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (boolean)(name instanceof SimpleName));
        SimpleName simpleName = name;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"i", (String)simpleName.getIdentifier());
        IBinding binding2 = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverterAST3Test.assertTrue((String)"binding == binding2", (binding == binding2 ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a variable binding", (boolean)(binding2 instanceof IVariableBinding));
        IVariableBinding variableBinding = (IVariableBinding)binding2;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"i", (String)variableBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (String)"int", (String)variableBinding.getType().getName());
    }

    public void test0261() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0261", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"Wrong msg size", (int)1, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"Wrong pb size", (int)1, (int)compilationUnit.getProblems().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ITypeBinding binding = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNull((String)"got a binding", (Object)binding);
    }

    public void test0262() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0262", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expr = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"Wrong argument list size", (int)1, (int)arguments.size());
        Expression expr2 = (Expression)arguments.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a class instance creation", (boolean)(expr2 instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expr2;
        arguments = classInstanceCreation.arguments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)arguments.size());
        Expression expression2 = (Expression)arguments.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a string literal", (boolean)(expression2 instanceof StringLiteral));
        StringLiteral stringLiteral = (StringLiteral)expression2;
        ITypeBinding typeBinding = stringLiteral.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"String", (String)typeBinding.getName());
    }

    public void test0263() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0263", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expr = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a FunctionInvocation", (boolean)(expr instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expr;
        List arguments = methodInvocation.arguments();
        ASTConverterAST3Test.assertEquals((String)"Wrong argument list size", (int)1, (int)arguments.size());
        Expression expr2 = (Expression)arguments.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (boolean)(expr2 instanceof SimpleName));
        SimpleName simpleName = (SimpleName)expr2;
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0264() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0264", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong fragment size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a classinstancecreation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        AnonymousClassDeclaration anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration();
        ASTConverterAST3Test.assertNotNull((String)"No anonymousclassdeclaration", (Object)anonymousClassDeclaration);
        String expectedSourceRange = "{\n\t\t\tvoid m(int k){\n\t\t\t\tk= i;\n\t\t\t}\n\t\t}";
        this.checkSourceRange((ASTNode)anonymousClassDeclaration, expectedSourceRange, source);
        List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)bodyDeclarations.size());
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(bodyDeclaration instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"m", (String)methodDeclaration.getName().getIdentifier());
    }

    public void test0265() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0265", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0266() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0266", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Inner\\u005b]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type type2 = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        SimpleType simpleType = (SimpleType)type2;
        this.checkSourceRange((ASTNode)simpleType, "Inner", source);
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a simple name", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        this.checkSourceRange((ASTNode)simpleName, "Inner", source);
    }

    public void test0267() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0267", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Inner[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type type2 = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        SimpleType simpleType = (SimpleType)type2;
        this.checkSourceRange((ASTNode)simpleType, "Inner", source);
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a simple name", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        this.checkSourceRange((ASTNode)simpleName, "Inner", source);
    }

    public void test0268() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0268", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "test0268.Test.Inner[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type type2 = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        SimpleType simpleType = (SimpleType)type2;
        this.checkSourceRange((ASTNode)simpleType, "test0268.Test.Inner", source);
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        this.checkSourceRange((ASTNode)name, "test0268.Test.Inner", source);
    }

    public void test0269() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0269", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "test0269.Test.Inner[/**/]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type type2 = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        SimpleType simpleType = (SimpleType)type2;
        this.checkSourceRange((ASTNode)simpleType, "test0269.Test.Inner", source);
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        this.checkSourceRange((ASTNode)name, "test0269.Test.Inner", source);
    }

    public void test0270() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0270", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "test0270.Test.Inner", source);
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        this.checkSourceRange((ASTNode)name, "test0270.Test.Inner", source);
    }

    public void test0271() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0271", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "test0271.Test.Inner[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        Type type2 = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type2.isSimpleType());
        SimpleType simpleType = (SimpleType)type2;
        this.checkSourceRange((ASTNode)simpleType, "test0271.Test.Inner", source);
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        this.checkSourceRange((ASTNode)name, "test0271.Test.Inner", source);
    }

    public void test0272() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0272", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a For statement", (boolean)(node instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (int i= 0; i < 10; i++) foo();", source);
        Statement action = forStatement.getBody();
        this.checkSourceRange((ASTNode)action, "foo();", source);
    }

    public void test0273() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0273", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a For statement", (boolean)(node instanceof ForStatement));
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (int i= 0; i < 10; i++) { foo(); }", source);
        Statement action = forStatement.getBody();
        this.checkSourceRange((ASTNode)action, "{ foo(); }", source);
        ASTConverterAST3Test.assertTrue((String)"Not a block", (boolean)(action instanceof Block));
        Block block = (Block)action;
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        this.checkSourceRange((ASTNode)stmt, "foo();", source);
    }

    public void test0274() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0274", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a While statement", (boolean)(node instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while (i < 10) { foo(i++); }", source);
        Statement action = whileStatement.getBody();
        this.checkSourceRange((ASTNode)action, "{ foo(i++); }", source);
        ASTConverterAST3Test.assertTrue((String)"Not a block", (boolean)(action instanceof Block));
        Block block = (Block)action;
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement stmt = (Statement)statements.get(0);
        this.checkSourceRange((ASTNode)stmt, "foo(i++);", source);
    }

    public void test0275() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0275", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a While statement", (boolean)(node instanceof WhileStatement));
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while (i < 10) foo(i++);", source);
        Statement action = whileStatement.getBody();
        this.checkSourceRange((ASTNode)action, "foo(i++);", source);
    }

    public void test0276() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0276", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "public void foo() {\n\t\tfoo();\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        expectedSource = "{\n\t\tfoo();\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration.getBody(), expectedSource, source);
    }

    public void test0277() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0277", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "public void foo() {\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        expectedSource = "{\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration.getBody(), expectedSource, source);
    }

    public void test0278() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0278", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Class c = java.lang.String.class;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a type literal", (boolean)(expression instanceof TypeLiteral));
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Class", (String)typeBinding.getName());
    }

    public void test0279() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0279", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "Class c = java.lang.String.class;", source);
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a type literal", (boolean)(expression instanceof TypeLiteral));
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Class", (String)typeBinding.getName());
    }

    public void test0280() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0280", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        AST newAst = result.getAST();
        ITypeBinding typeBinding = newAst.resolveWellKnownType("boolean");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"boolean", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("char");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"char", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("byte");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"byte", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("short");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"short", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("int");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"int", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("long");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"long", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("float");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"float", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("double");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"double", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("void");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"void", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Object");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Object", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.String");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"String", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.StringBuffer");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"StringBuffer", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Throwable");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Throwable", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Exception");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Exception", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.RuntimeException");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"RuntimeException", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Error");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Error", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Class");
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Class", (String)typeBinding.getName());
        typeBinding = newAst.resolveWellKnownType("java.lang.Runnable");
        ASTConverterAST3Test.assertNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Cloneable");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.io.Serializable");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Boolean");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Byte");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Character");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Double");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Float");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Integer");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Long");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Short");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
        typeBinding = newAst.resolveWellKnownType("java.lang.Void");
        ASTConverterAST3Test.assertNotNull((String)"typeBinding not null", (Object)typeBinding);
    }

    public void test0281() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0281", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Object o= /*]*/new Object()/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "new Object()", source);
    }

    public void test0282() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0282", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "boolean b = /*]*/true/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "true", source);
    }

    public void test0283() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0283", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "char c = /*]*/'c'/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "'c'", source);
    }

    public void test0284() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0284", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Object o = /*]*/null/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "null", source);
    }

    public void test0285() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0285", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Object o = /*]*/Object.class/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "Object.class", source);
    }

    public void test0286() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0286", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "int i = /**/(2)/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "(2)", source);
    }

    public void test0287() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0287", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "String[] tab = /**/new String[3]/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "new String[3]", source);
    }

    public void test0288() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0288", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "String[] tab = /**/{ }/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "{ }", source);
    }

    public void test0289() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0289", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "String s = /**/tab1[0]/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "tab1[0]", source);
    }

    public void test0290() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0290", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Object o = /*]*/new java.lang.Object()/*[*/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "new java.lang.Object()", source);
    }

    public void test0291() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0291", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"no errors", (int)1, (int)unit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"no errors", (int)1, (int)unit.getProblems().length);
    }

    public void test0292() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0292", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a qualifiedName", (boolean)(expression instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expression;
        SimpleName simpleName = qualifiedName.getName();
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"x", (String)simpleName.getIdentifier());
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"NO binding", (Object)binding);
        ASTConverterAST3Test.assertTrue((String)"Not a variable binding", (boolean)(binding instanceof IVariableBinding));
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"x", (String)binding.getName());
        Name name = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)(name instanceof SimpleName));
        SimpleName simpleName2 = (SimpleName)name;
        IBinding binding2 = simpleName2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertTrue((String)"Not a type binding", (boolean)(binding2 instanceof ITypeBinding));
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Test", (String)binding2.getName());
    }

    public void test0293() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0293", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a class instance creation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        AnonymousClassDeclaration anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration();
        ASTConverterAST3Test.assertNotNull((String)"No body", (Object)anonymousClassDeclaration);
        String expectedSource = "{\n\t\t\tpublic void run() {\n\t\t\t\t/*]*/foo();/*[*/\n\t\t\t}\n\t\t}";
        this.checkSourceRange((ASTNode)anonymousClassDeclaration, expectedSource, source);
        expectedSource = "run= new Runnable() {\n\t\t\tpublic void run() {\n\t\t\t\t/*]*/foo();/*[*/\n\t\t\t}\n\t\t}";
        this.checkSourceRange((ASTNode)variableDeclarationFragment, expectedSource, source);
    }

    public void test0294() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0294", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "public void fails() {\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        Block block = methodDeclaration.getBody();
        expectedSource = "{\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)block, expectedSource, source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        methodDeclaration = (FunctionDeclaration)node;
        block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0295() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0295", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)2, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)2, (int)compilationUnit.getProblems().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"not a method invocation", (boolean)(expression instanceof FunctionInvocation));
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        ITypeBinding typeBinding = methodInvocation.resolveTypeBinding();
        ASTConverterAST3Test.assertNull((String)"type binding is not null", (Object)typeBinding);
    }

    public void test0296() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0296", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        String expectedSource = "public void fails() {\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)methodDeclaration, expectedSource, source);
        Block block = methodDeclaration.getBody();
        expectedSource = "{\n\t\tfoo()\n\t}";
        this.checkSourceRange((ASTNode)block, expectedSource, source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        methodDeclaration = (FunctionDeclaration)node;
        block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0297() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0297", "Test.js");
        this.runConversion(3, sourceUnit, false);
    }

    public void test0298() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0298", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a ReturnStatement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        this.checkSourceRange((ASTNode)expression, "a().length != 3", source);
    }

    public void test0299() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0299", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "int i = (/**/2/**/);", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (boolean)(expression instanceof ParenthesizedExpression));
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
        Expression expression2 = parenthesizedExpression.getExpression();
        this.checkSourceRange((ASTNode)expression2, "2", source);
    }

    public void test0300() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0300", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "boolean b = /**/true/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "true", source);
    }

    public void test0301() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0301", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        this.checkSourceRange((ASTNode)fieldDeclaration, "Object o = /**/null/**/;", source);
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        this.checkSourceRange((ASTNode)expression, "null", source);
    }

    public void test0302() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0302", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a DoStatement", (boolean)(node instanceof DoStatement));
        DoStatement doStatement = (DoStatement)node;
        String expectedSource = "do\n\t\t\tfoo();\n\t\twhile(1 < 10);";
        this.checkSourceRange((ASTNode)doStatement, expectedSource, source);
    }

    public void test0303() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0303", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
    }

    public void test0304() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0304", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        this.checkSourceRange(node, "public void foo(int arg);", source);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        ASTConverterAST3Test.assertNull((String)"Has a body", (Object)block);
    }

    public void test0305() {
        char[] source = "package test0305;\n\nclass Test {\n\tpublic void foo(int arg) {}\n}".toCharArray();
        IJavaScriptProject project = this.getJavaProject("Converter");
        ASTNode result = this.runConversion(3, source, "Test.js", project, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertTrue((String)"not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Test", (String)typeBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong package", (String)"test0305", (String)typeBinding.getPackage().getName());
        ASTConverterAST3Test.assertTrue((String)"Not an interface", (boolean)typeBinding.isClass());
    }

    public void test0306() {
        char[] source = "package java.lang;\n\nclass Object {\n\tpublic void foo(int arg) {}\n}".toCharArray();
        IJavaScriptProject project = this.getJavaProject("Converter");
        ASTNode result = this.runConversion(3, source, "Object.js", project, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertTrue((String)"not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Object", (String)typeBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong package", (String)"java.lang", (String)typeBinding.getPackage().getName());
        ASTConverterAST3Test.assertTrue((String)"Not an interface", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)2, (int)typeBinding.getDeclaredMethods().length);
    }

    public void test0307() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0307", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        ASTConverterAST3Test.assertNotNull((String)"No body", (Object)block);
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a super constructor invocation", (boolean)(statement instanceof SuperConstructorInvocation));
        this.checkSourceRange((ASTNode)statement, "super(10);", source);
    }

    public void test0308() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0308", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"not a method declaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        ASTConverterAST3Test.assertNotNull((String)"No body", (Object)block);
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a super constructor invocation", (boolean)(statement instanceof SuperConstructorInvocation));
        SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)statement;
        IFunctionBinding methodBinding = superConstructorInvocation.resolveConstructorBinding();
        ASTConverterAST3Test.assertNotNull((String)"No methodBinding", (Object)methodBinding);
        IFunctionBinding methodBinding2 = methodDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No methodBinding2", (Object)methodBinding2);
    }

    public void test0309() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0309", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a conditional expression", (boolean)(expression instanceof ConditionalExpression));
        ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
        ITypeBinding typeBinding = conditionalExpression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"int", (String)typeBinding.getName());
    }

    public void test0310() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0310", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)(expression instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expression;
        Name qualifier = qualifiedName.getQualifier();
        IBinding binding = qualifier.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"I", (String)binding.getName());
    }

    public void test0311() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0311", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"not a class instance creation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        AnonymousClassDeclaration anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration();
        ASTConverterAST3Test.assertNotNull((String)"No body", (Object)anonymousClassDeclaration);
        List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertEquals((String)"wrong size for body declarations", (int)1, (int)bodyDeclarations.size());
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(bodyDeclaration instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
        Block block = methodDeclaration.getBody();
        ASTConverterAST3Test.assertNotNull((String)"no body", (Object)block);
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size for statements", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"not a variable declaration statement", (boolean)(statement instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement2 = (VariableDeclarationStatement)statement;
        List fragments2 = variableDeclarationStatement2.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size for fragments2", (int)1, (int)fragments2.size());
        VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)fragments2.get(0);
        Expression expression2 = variableDeclarationFragment2.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a name", (boolean)(expression2 instanceof Name));
        Name name = (Name)expression2;
        this.checkSourceRange((ASTNode)name, "j", source);
        IBinding binding = name.resolveBinding();
        ASTNode declaringNode = compilationUnit.findDeclaringNode(binding);
        ASTConverterAST3Test.assertNotNull((String)"No declaring node", (Object)declaringNode);
        this.checkSourceRange(declaringNode, "int j", source);
        ASTConverterAST3Test.assertTrue((String)"Not a single variable declaration", (boolean)(declaringNode instanceof SingleVariableDeclaration));
    }

    public void test0312() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0312", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"not a class instance creation", (boolean)(expression instanceof ClassInstanceCreation));
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
        AnonymousClassDeclaration anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration();
        ASTConverterAST3Test.assertNotNull((String)"No body", (Object)anonymousClassDeclaration);
        List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertEquals((String)"wrong size for body declarations", (int)1, (int)bodyDeclarations.size());
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (boolean)(bodyDeclaration instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
        Block block = methodDeclaration.getBody();
        ASTConverterAST3Test.assertNotNull((String)"no body", (Object)block);
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size for statements", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"not a variable declaration statement", (boolean)(statement instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement2 = (VariableDeclarationStatement)statement;
        List fragments2 = variableDeclarationStatement2.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size for fragments2", (int)1, (int)fragments2.size());
        VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)fragments2.get(0);
        Expression expression2 = variableDeclarationFragment2.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a name", (boolean)(expression2 instanceof Name));
        Name name = (Name)expression2;
        this.checkSourceRange((ASTNode)name, "j", source);
        IBinding binding = name.resolveBinding();
        ASTNode declaringNode = compilationUnit.findDeclaringNode(binding);
        ASTConverterAST3Test.assertNull((String)"No declaring node is available", (Object)declaringNode);
    }

    public void test0313() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0313", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an InfixExpression", (boolean)(expression instanceof InfixExpression));
        InfixExpression infixExpression = (InfixExpression)expression;
        this.checkSourceRange((ASTNode)infixExpression, "i+j", source);
        Expression expression2 = infixExpression.getLeftOperand();
        this.checkSourceRange((ASTNode)expression2, "i", source);
        ASTConverterAST3Test.assertTrue((String)"Not a name", (boolean)(expression2 instanceof Name));
        Name name = (Name)expression2;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTNode astNode = compilationUnit.findDeclaringNode(binding);
        ASTConverterAST3Test.assertNotNull((String)"No declaring node", (Object)astNode);
        this.checkSourceRange(astNode, "int i", source);
    }

    public void test0314() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0314", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTConverterAST3Test.assertNotNull((String)"No result", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"Not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"Wrong line number", (int)1, (int)compilationUnit.getLineNumber(0));
        ASTConverterAST3Test.assertEquals((String)"Wrong line number", (int)3, (int)compilationUnit.getLineNumber(source.length - 1));
        ASTConverterAST3Test.assertEquals((String)"Wrong line number", (int)-1, (int)compilationUnit.getLineNumber(source.length));
    }

    public void test0315() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0315", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a Return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an instanceof expression", (boolean)(expression instanceof InstanceofExpression));
        InstanceofExpression instanceOfExpression = (InstanceofExpression)expression;
        Type rightOperand = instanceOfExpression.getRightOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleType", (boolean)(rightOperand instanceof SimpleType));
        SimpleType simpleType = (SimpleType)rightOperand;
        Name n = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)(n instanceof QualifiedName));
        QualifiedName name = (QualifiedName)n;
        this.checkSourceRange((ASTNode)name, "java.io.Serializable", source);
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Serializable", (String)typeBinding.getName());
        Name qualifier = name.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (boolean)(qualifier instanceof QualifiedName));
        ITypeBinding typeBinding2 = qualifier.resolveTypeBinding();
        ASTConverterAST3Test.assertNull((String)"typebinding2 is not null", (Object)typeBinding2);
        IBinding binding = qualifier.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)1, (int)binding.getKind());
        IPackageBinding pBinding = (IPackageBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"java.io", (String)pBinding.getName());
    }

    public void test0316() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "", "Hello.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No result", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"Not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)compilationUnit.getProblems().length);
    }

    public void test0317() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0317", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (boolean)(node instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"not an instanceof expression", (boolean)(expression instanceof InstanceofExpression));
        InstanceofExpression instanceOfExpression = (InstanceofExpression)expression;
        Expression left = instanceOfExpression.getLeftOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a Name", (boolean)(left instanceof Name));
        Name name = (Name)left;
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"x", (String)binding.getName());
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typebinding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (String)"Object", (String)typeBinding.getName());
        Type right = instanceOfExpression.getRightOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleType", (boolean)(right instanceof SimpleType));
        SimpleType simpleType = (SimpleType)right;
        name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)(name instanceof SimpleName));
        SimpleName simpleName = (SimpleName)name;
        IBinding binding2 = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding2", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector", (String)binding2.getName());
        ITypeBinding typeBinding2 = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector", (String)typeBinding2.getName());
    }

    public void test0318() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0318", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit unit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"No error", (int)1, (int)unit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"No error", (int)1, (int)unit.getProblems().length);
    }

    public void test0319() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0319", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an array creation", (boolean)(expression instanceof ArrayCreation));
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ITypeBinding typeBinding = arrayCreation.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding.getName());
        ArrayType arrayType = arrayCreation.getType();
        ITypeBinding typeBinding2 = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding2.getName());
        Type type = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)(type instanceof SimpleType));
        SimpleType simpleType = (SimpleType)type;
        ITypeBinding typeBinding3 = simpleType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding3.getName());
    }

    public void test0320() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0320", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "int[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding typeBinding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        Type elementType = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)elementType.isPrimitiveType());
        ITypeBinding typeBinding2 = elementType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding2", (Object)typeBinding2);
    }

    public void test0321() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0321", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding typeBinding = arrayType.resolveBinding();
        this.checkSourceRange((ASTNode)type, "java.lang.Object[][]", source);
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        Type elementType = arrayType.getComponentType();
        ITypeBinding typeBinding2 = elementType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong dimension", (int)1, (int)typeBinding2.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding2.getName());
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)elementType.isArrayType());
        Type elementType2 = ((ArrayType)elementType).getComponentType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)elementType2.isSimpleType());
        ITypeBinding typeBinding3 = elementType2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong dimension", (int)0, (int)typeBinding3.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding3.getName());
    }

    public void test0322() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0322", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a FieldDeclaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a null literal", (boolean)(expression instanceof NullLiteral));
        NullLiteral nullLiteral = (NullLiteral)expression;
        ITypeBinding typeBinding = nullLiteral.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not the null type", (boolean)typeBinding.isNullType());
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)typeBinding.getQualifiedName(), (String)"null");
    }

    public void test0323() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0323", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
    }

    public void test0324() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0324", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
    }

    public void test0325() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0325", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression2 = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an Assignement", (boolean)(expression2 instanceof Assignment));
    }

    public void test0326() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0326", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        char[] source = sourceUnit.getSource().toCharArray();
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an ExpressionStatement", (boolean)(node instanceof ExpressionStatement));
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        this.checkSourceRange((ASTNode)expressionStatement.getExpression(), "a().f= a()", source);
        this.checkSourceRange((ASTNode)expressionStatement, "a().f= a();", source);
    }

    public void test0327() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0327", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"Wrong number of errors", (int)2, (int)compilationUnit.getProblems().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
    }

    public void test0328() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0328", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "java.lang.Object[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding typeBinding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding.getName());
        Type elementType = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)elementType.isSimpleType());
        ITypeBinding typeBinding2 = elementType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding2.getName());
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a array creation", (boolean)(expression instanceof ArrayCreation));
        ITypeBinding typeBinding3 = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding3.getName());
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ArrayInitializer arrayInitializer = arrayCreation.getInitializer();
        ASTConverterAST3Test.assertNotNull((String)"not array initializer", (Object)arrayInitializer);
        ITypeBinding typeBinding4 = arrayInitializer.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding4", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding4.getName());
    }

    public void test0329() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0329", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "java.lang.Object[]", source);
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding typeBinding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding.getName());
        Type elementType = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)elementType.isSimpleType());
        ITypeBinding typeBinding2 = elementType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding2.getName());
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a array creation", (boolean)(expression instanceof ArrayCreation));
        ITypeBinding typeBinding3 = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding3.getName());
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ArrayInitializer arrayInitializer = arrayCreation.getInitializer();
        ASTConverterAST3Test.assertNotNull((String)"not array initializer", (Object)arrayInitializer);
        ITypeBinding typeBinding4 = arrayInitializer.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No typeBinding4", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding4.getName());
    }

    public void test0330() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0330", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)compilationUnit.getProblems().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        IFunctionBinding[] methods = typeBinding.getDeclaredMethods();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)methods.length);
        ASTConverterAST3Test.assertTrue((String)"not a constructor", (boolean)methods[0].isConstructor());
        ASTConverterAST3Test.assertTrue((String)"wrong name", (!methods[0].getName().equals("foo") ? 1 : 0) != 0);
        node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a methodDeclaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNull((String)"method binding not null", (Object)methodBinding);
        node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (node.getNodeType() == 41 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ITypeBinding typeBinding2 = expression.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding2", (Object)typeBinding2);
    }

    public void test0331() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0331", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not an VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a QualifiedName", (boolean)(expression instanceof QualifiedName));
        QualifiedName qualifiedName = (QualifiedName)expression;
        IBinding binding = qualifiedName.getName().resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)3, (int)binding.getKind());
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ASTConverterAST3Test.assertTrue((String)"Not a field", (boolean)variableBinding.isField());
        ASTConverterAST3Test.assertNull((String)"Got a declaring class", (Object)variableBinding.getDeclaringClass());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"length", (String)variableBinding.getName());
    }

    public void test0332() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0332", "LocalSelectionTransfer.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
    }

    public void test0333() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0333", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an array creation", (boolean)(expression instanceof ArrayCreation));
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ITypeBinding typeBinding = arrayCreation.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[][]", (String)typeBinding.getName());
        ArrayType arrayType = arrayCreation.getType();
        ITypeBinding typeBinding2 = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[][]", (String)typeBinding2.getName());
        Type type = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)(type instanceof SimpleType));
        SimpleType simpleType = (SimpleType)type;
        ITypeBinding typeBinding3 = simpleType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding3.getName());
        type = arrayType.getComponentType();
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)(type instanceof ArrayType));
        ArrayType arrayType2 = (ArrayType)type;
        ITypeBinding typeBinding4 = arrayType2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding4", (Object)typeBinding4);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding4.getName());
    }

    public void test0334() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0334", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertTrue((String)"Not a VariableDeclarationStatement", (boolean)(node instanceof VariableDeclarationStatement));
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an array creation", (boolean)(expression instanceof ArrayCreation));
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ITypeBinding typeBinding = arrayCreation.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[][][]", (String)typeBinding.getName());
        ArrayType arrayType = arrayCreation.getType();
        this.checkSourceRange((ASTNode)arrayType, "Object[10][][]", source);
        ITypeBinding typeBinding2 = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding2", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[][][]", (String)typeBinding2.getName());
        Type type = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)(type instanceof SimpleType));
        SimpleType simpleType = (SimpleType)type;
        this.checkSourceRange((ASTNode)simpleType, "Object", source);
        ITypeBinding typeBinding3 = simpleType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding3", (Object)typeBinding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object", (String)typeBinding3.getName());
        type = arrayType.getComponentType();
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)(type instanceof ArrayType));
        ArrayType arrayType2 = (ArrayType)type;
        this.checkSourceRange((ASTNode)arrayType2, "Object[10][]", source);
        ITypeBinding typeBinding4 = arrayType2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding4", (Object)typeBinding4);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[][]", (String)typeBinding4.getName());
        type = arrayType2.getComponentType();
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)(type instanceof ArrayType));
        ArrayType arrayType3 = (ArrayType)type;
        ITypeBinding typeBinding5 = arrayType3.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding5", (Object)typeBinding5);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"Object[]", (String)typeBinding5.getName());
        this.checkSourceRange((ASTNode)arrayType3, "Object[10]", source);
    }

    public void test0335() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0335", "ExceptionTestCaseTest.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getProblems().length);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a type declaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        Type superclassType = typeDeclaration.getSuperclassType();
        ASTConverterAST3Test.assertNotNull((String)"no super class", (Object)superclassType);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)superclassType.getNodeType(), (int)43);
        SimpleType simpleType = (SimpleType)superclassType;
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        QualifiedName qualifiedName = (QualifiedName)name;
        name = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"not a qualified name", (boolean)name.isQualifiedName());
        qualifiedName = (QualifiedName)name;
        name = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"not a simple name", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"junit", (String)binding.getName());
    }

    public void test0336() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0336", "SorterTest.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getProblems().length);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a type declaration", (boolean)(node instanceof TypeDeclaration));
    }

    public void test0337() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0337", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a field declaration", (boolean)(node instanceof FieldDeclaration));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)variableDeclarationFragment, "message= Test.m(\"s\", new String[]{\"g\"})", source);
        this.checkSourceRange((ASTNode)fieldDeclaration, "String message= Test.m(\"s\", new String[]{\"g\"});", source);
    }

    public void test0338() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0338", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List thrownExceptions = methodDeclaration.thrownExceptions();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)thrownExceptions.size());
        Name name = (Name)thrownExceptions.get(0);
        IBinding binding = name.resolveBinding();
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"IOException", (String)binding.getName());
    }

    public void test0339() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0339", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"No errors found", (int)3, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a Type declaration", (boolean)(node instanceof TypeDeclaration));
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)bodyDeclarations.size());
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclarations.get(0);
        this.checkSourceRange((ASTNode)methodDeclaration, "int doQuery(boolean x);", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a FunctionDeclaration", (boolean)(node instanceof FunctionDeclaration));
        String expectedSource = "public void setX(boolean x) {\n \t\t{\n\t\tz\n\t}\n}";
        this.checkSourceRange(node, expectedSource, source);
        int methodEndPosition = node.getStartPosition() + node.getLength();
        node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"not a TypeDeclaration", (boolean)(node instanceof TypeDeclaration));
        int typeEndPosition = node.getStartPosition() + node.getLength();
        ASTConverterAST3Test.assertEquals((String)"different positions", (int)methodEndPosition, (int)typeEndPosition);
    }

    public void test0340() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "p3", "B.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an expression statement", (node.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)node;
        Expression expression = expressionStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        Expression expression2 = methodInvocation.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No receiver", (Object)expression2);
        ITypeBinding binding = expression2.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"A", (String)binding.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"p2", (String)binding.getPackage().getName());
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (expression2.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName qualifiedName = (QualifiedName)expression2;
        SimpleName simpleName = qualifiedName.getName();
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"A", (String)simpleName.getIdentifier());
        ITypeBinding typeBinding = simpleName.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"A", (String)typeBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"p2", (String)typeBinding.getPackage().getName());
        Name name = qualifiedName.getQualifier();
        ASTConverterAST3Test.assertTrue((String)"Not a simple name", (name.getNodeType() == 42 ? 1 : 0) != 0);
        SimpleName simpleName2 = (SimpleName)name;
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"p2", (String)simpleName2.getIdentifier());
        IBinding binding2 = simpleName2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"wrong type", (int)1, (int)binding2.getKind());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"p2", (String)binding2.getName());
        node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an expression statement", (node.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement2 = (ExpressionStatement)node;
        Expression expression3 = expressionStatement2.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an method invocation", (expression3.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)expression3;
        Expression expression4 = methodInvocation2.getExpression();
        ASTConverterAST3Test.assertNotNull((String)"No receiver", (Object)expression4);
        ITypeBinding binding3 = expression4.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)binding3);
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"A", (String)binding3.getName());
        ASTConverterAST3Test.assertEquals((String)"wrong name", (String)"p1", (String)binding3.getPackage().getName());
    }

    public void test0341() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0341", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        String expectedSource = "if (field != null) {\n\t\t\tthrow new IOException();\n\t\t} else if (field == null) {\n\t\t\tthrow new MalformedURLException();\n\t\t} else if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange(node, expectedSource, source);
        IfStatement ifStatement = (IfStatement)node;
        Statement thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new IOException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        Statement elseStatement = ifStatement.getElseStatement();
        expectedSource = "if (field == null) {\n\t\t\tthrow new MalformedURLException();\n\t\t} else if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
        ASTConverterAST3Test.assertTrue((String)"Not a if statement", (elseStatement.getNodeType() == 25 ? 1 : 0) != 0);
        ifStatement = (IfStatement)elseStatement;
        thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new MalformedURLException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        elseStatement = ifStatement.getElseStatement();
        expectedSource = "if (field == null) {\n\t\t\tthrow new InterruptedIOException();\n\t\t} else {\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
        ASTConverterAST3Test.assertTrue((String)"Not a if statement", (elseStatement.getNodeType() == 25 ? 1 : 0) != 0);
        ifStatement = (IfStatement)elseStatement;
        thenStatement = ifStatement.getThenStatement();
        expectedSource = "{\n\t\t\tthrow new InterruptedIOException();\n\t\t}";
        this.checkSourceRange((ASTNode)thenStatement, expectedSource, source);
        elseStatement = ifStatement.getElseStatement();
        expectedSource = "{\n\t\t\tthrow new UnsupportedEncodingException();\n\t\t}";
        this.checkSourceRange((ASTNode)elseStatement, expectedSource, source);
    }

    public void test0343() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0343", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 1, 1);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        String expectedSource = "if (flag)\n\t\t\ti= 10;";
        this.checkSourceRange(node, expectedSource, source);
    }

    /*
     * Exception decompiling
     */
    public void test0344() throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 201->205)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void test0345() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0345", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        List fragments = fieldDeclaration.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an ArrayCreation", (expression.getNodeType() == 3 ? 1 : 0) != 0);
        ArrayCreation arrayCreation = (ArrayCreation)expression;
        ArrayType arrayType = arrayCreation.getType();
        ITypeBinding binding2 = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding2", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"not a type", (int)binding2.getKind(), (int)2);
        ITypeBinding typeBinding2 = binding2;
        ASTConverterAST3Test.assertTrue((String)"Not an array type binding2", (boolean)typeBinding2.isArray());
        Type type = arrayType.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"QualifiedName", (name.getNodeType() == 40 ? 1 : 0) != 0);
        SimpleName simpleName = ((QualifiedName)name).getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"not a type", (int)binding.getKind(), (int)2);
        ITypeBinding typeBinding = (ITypeBinding)binding;
        ASTConverterAST3Test.assertTrue((String)"An array type binding", (!typeBinding.isArray() ? 1 : 0) != 0);
        Type type2 = fieldDeclaration.getType();
        ASTConverterAST3Test.assertTrue((String)"Not a array type", (boolean)type2.isArrayType());
        ArrayType arrayType2 = (ArrayType)type2;
        Type type3 = arrayType2.getElementType();
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type3.isSimpleType());
        SimpleType simpleType2 = (SimpleType)type3;
        Name name2 = simpleType2.getName();
        ASTConverterAST3Test.assertTrue((String)"Not a qualified name", (name2.getNodeType() == 40 ? 1 : 0) != 0);
        SimpleName simpleName2 = ((QualifiedName)name2).getName();
        IBinding binding3 = simpleName2.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding3);
        ASTConverterAST3Test.assertEquals((String)"not a type", (int)binding3.getKind(), (int)2);
        ITypeBinding typeBinding3 = (ITypeBinding)binding3;
        ASTConverterAST3Test.assertTrue((String)"An array type binding", (!typeBinding3.isArray() ? 1 : 0) != 0);
    }

    public void test0346() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0346", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector", source);
        ASTConverterAST3Test.assertTrue((String)"not an array type", (!type.isArrayType() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertTrue((String)"Not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        ASTConverterAST3Test.assertTrue((String)"Not a simpleName", (boolean)name.isSimpleName());
        SimpleName simpleName = (SimpleName)name;
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ITypeBinding typeBinding = (ITypeBinding)binding;
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector", (String)binding.getName());
        ITypeBinding typeBinding2 = simpleType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)typeBinding2.getKind());
        ASTConverterAST3Test.assertTrue((String)"An array", (!typeBinding2.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector", (String)typeBinding2.getName());
    }

    public void test0347() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0347", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector[]", source);
        ASTConverterAST3Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector[]", (String)binding.getName());
    }

    public void test0348() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0348", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "Vector[][]", source);
        ASTConverterAST3Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector[][]", (String)binding.getName());
    }

    public void test0349() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0349", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "Vector[][]", source);
        ASTConverterAST3Test.assertTrue((String)"not an array type", (boolean)type.isArrayType());
        ArrayType arrayType = (ArrayType)type;
        ITypeBinding binding = arrayType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Not an array type", (boolean)binding.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector[][]", (String)binding.getName());
    }

    public void test0350() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0350", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an field declaration", (node.getNodeType() == 23 ? 1 : 0) != 0);
        FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
        Type type = fieldDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "Vector", source);
        ASTConverterAST3Test.assertTrue((String)"not a simple type", (boolean)type.isSimpleType());
        SimpleType simpleType = (SimpleType)type;
        ITypeBinding binding = simpleType.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"An array type", (boolean)binding.isClass());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"Vector", (String)binding.getName());
    }

    public void test0351() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0351", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "int a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "int[] b", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        methodDeclaration = (FunctionDeclaration)node;
        parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "int a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "int b[]", source);
    }

    public void test0352() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0352", "Test2.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        List parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final int a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final int[] b", source);
        node = this.getASTNode(compilationUnit, 0, 1);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        methodDeclaration = (FunctionDeclaration)node;
        parameters = methodDeclaration.parameters();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)parameters.size());
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(0);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final int a", source);
        singleVariableDeclaration = (SingleVariableDeclaration)parameters.get(1);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final int b[]", source);
    }

    public void test0353() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0353", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"not null", (Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an variable declaration", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        this.checkSourceRange((ASTNode)type, "InputStream", source);
        ASTConverterAST3Test.assertTrue((String)"not a simple type", (boolean)type.isSimpleType());
        ITypeBinding binding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding.getKind());
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)binding.isClass());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"InputStream", (String)binding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong package", (String)"java.io", (String)binding.getPackage().getName());
        SimpleType simpleType = (SimpleType)type;
        Name name = simpleType.getName();
        IBinding binding2 = name.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)2, (int)binding2.getKind());
        ITypeBinding typeBinding = (ITypeBinding)binding2;
        ASTConverterAST3Test.assertTrue((String)"Not a class", (boolean)typeBinding.isClass());
        ASTConverterAST3Test.assertEquals((String)"Wrong name", (String)"InputStream", (String)typeBinding.getName());
        ASTConverterAST3Test.assertEquals((String)"Wrong package", (String)"java.io", (String)typeBinding.getPackage().getName());
    }

    public void test0354() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0354", "Test.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)2, (int)compilationUnit.getMessages().length);
    }

    public void test0355() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0355", "Foo.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not an if statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        Expression condition = ifStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an infixExpression", (condition.getNodeType() == 27 ? 1 : 0) != 0);
        InfixExpression infixExpression = (InfixExpression)condition;
        Expression expression = infixExpression.getLeftOperand();
        ASTConverterAST3Test.assertTrue((String)"Not a method invocation expression", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        Expression expression2 = methodInvocation.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesis expression", (expression2.getNodeType() == 36 ? 1 : 0) != 0);
    }

    public void test0356() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0356", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)1, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        Type type = variableDeclarationStatement.getType();
        ITypeBinding binding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)("Binding should NOT be null for type: " + type), (Object)binding);
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)("Expect only one fragment for VariableDeclarationStatement: " + variableDeclarationStatement), (int)1, (int)fragments.size());
        node = (ASTNode)fragments.get(0);
        ASTConverterAST3Test.assertEquals((String)"Not a variable declaration fragment", (int)59, (int)node.getNodeType());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)node;
        Expression initializer = fragment.getInitializer();
        ASTConverterAST3Test.assertEquals((String)("Expect a class instance creation for initializer: " + initializer), (int)14, (int)initializer.getNodeType());
        ClassInstanceCreation instanceCreation = (ClassInstanceCreation)initializer;
        type = instanceCreation.getType();
        binding = type.resolveBinding();
        ASTConverterAST3Test.assertNull((String)("Binding should BE null for type: " + type), (Object)binding);
    }

    public void test0357() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0357", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration statement", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "A", source);
    }

    public void test0358() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0358", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration statement", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        SimpleName name = methodDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "mdd", source);
    }

    public void test0359() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0359", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration statement", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        SimpleName name = methodDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "mdd", source);
    }

    public void test0360() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0360", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
    }

    public void test0361() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0361", "X.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
    }

    public void test0362() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0362", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, false);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        ForStatement forStatement = this.ast.newForStatement();
        VariableDeclarationFragment iFragment = this.ast.newVariableDeclarationFragment();
        iFragment.setName(this.ast.newSimpleName("i"));
        iFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationFragment jFragment = this.ast.newVariableDeclarationFragment();
        jFragment.setName(this.ast.newSimpleName("j"));
        jFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationFragment kFragment = this.ast.newVariableDeclarationFragment();
        kFragment.setName(this.ast.newSimpleName("k"));
        kFragment.setInitializer((Expression)this.ast.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(iFragment);
        variableDeclarationExpression.setType((Type)this.ast.newPrimitiveType(PrimitiveType.INT));
        variableDeclarationExpression.fragments().add(jFragment);
        variableDeclarationExpression.fragments().add(kFragment);
        forStatement.initializers().add(variableDeclarationExpression);
        PostfixExpression iPostfixExpression = this.ast.newPostfixExpression();
        iPostfixExpression.setOperand((Expression)this.ast.newSimpleName("i"));
        iPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(iPostfixExpression);
        PostfixExpression jPostfixExpression = this.ast.newPostfixExpression();
        jPostfixExpression.setOperand((Expression)this.ast.newSimpleName("j"));
        jPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(jPostfixExpression);
        PostfixExpression kPostfixExpression = this.ast.newPostfixExpression();
        kPostfixExpression.setOperand((Expression)this.ast.newSimpleName("k"));
        kPostfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(kPostfixExpression);
        forStatement.setBody((Statement)this.ast.newBlock());
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.ast.newSimpleName("i"));
        infixExpression.setOperator(InfixExpression.Operator.LESS);
        infixExpression.setRightOperand((Expression)this.ast.newNumberLiteral("10"));
        forStatement.setExpression((Expression)infixExpression);
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)forStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        this.checkSourceRange(node, "for (int i=0, j=0, k=0; i<10 ; i++, j++, k++) {}", source);
    }

    public void test0363() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0363", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 1);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not a parenthesized expression", (expression.getNodeType() == 36 ? 1 : 0) != 0);
        Expression expression2 = ((ParenthesizedExpression)expression).getExpression();
        this.checkSourceRange((ASTNode)expression2, "xxxx", source);
    }

    public void test0364() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0364", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "int local;", source);
        SimpleName simpleName = variableDeclarationFragment.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0365() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0365", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        List initializers = forStatement.initializers();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)initializers.size());
        VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)initializers.get(0);
        List fragments = variableDeclarationExpression.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        SimpleName simpleName = variableDeclarationFragment.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No binding", (Object)binding);
    }

    public void test0366() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0366", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        this.checkSourceRange((ASTNode)forStatement, "for (int i = 0; i < 5; ++i);", source);
        Statement statement = forStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0367() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0367", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a while statement", (node.getNodeType() == 61 ? 1 : 0) != 0);
        WhileStatement whileStatement = (WhileStatement)node;
        this.checkSourceRange((ASTNode)whileStatement, "while(i == 2);", source);
        Statement statement = whileStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0368() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0368", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "The label test is never explicitly referenced");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 30 ? 1 : 0) != 0);
        LabeledStatement labeledStatement = (LabeledStatement)node;
        this.checkSourceRange((ASTNode)labeledStatement, "test:;", source);
        Statement statement = labeledStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0369() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0369", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        this.assertProblemsSize(compilationUnit, 1, "The label test is never explicitly referenced");
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 30 ? 1 : 0) != 0);
        LabeledStatement labeledStatement = (LabeledStatement)node;
        this.checkSourceRange((ASTNode)labeledStatement, "test:\\u003B", source);
        Statement statement = labeledStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "\\u003B", source);
    }

    public void test0370() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0370", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)node);
        DoStatement doStatement = this.ast.newDoStatement();
        doStatement.setBody((Statement)this.ast.newEmptyStatement());
        doStatement.setExpression((Expression)this.ast.newBooleanLiteral(true));
        ASTConverterAST3Test.assertTrue((String)"Both AST trees should be identical", (boolean)doStatement.subtreeMatch(new ASTMatcher(), (Object)node));
        String expectedSource = "do ; while(true);";
        this.checkSourceRange(node, expectedSource, source);
        DoStatement doStatement2 = (DoStatement)node;
        Statement statement = doStatement2.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0371() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0371", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        this.checkSourceRange((ASTNode)ifStatement, "if (i == 6);", source);
        Statement statement = ifStatement.getThenStatement();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0372() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0372", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a labeled statement", (node.getNodeType() == 25 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)node;
        this.checkSourceRange((ASTNode)ifStatement, "if (i == 6) {} else ;", source);
        Statement statement = ifStatement.getElseStatement();
        ASTConverterAST3Test.assertTrue((String)"Not an empty statement", (statement.getNodeType() == 20 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, ";", source);
    }

    public void test0373() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0373", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        Statement statement = forStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not a block statement", (statement.getNodeType() == 8 ? 1 : 0) != 0);
        Block block = (Block)statement;
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement2 = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a break statement", (statement2.getNodeType() == 10 ? 1 : 0) != 0);
        BreakStatement breakStatement = (BreakStatement)statement2;
        this.checkSourceRange((ASTNode)breakStatement, "break;", source);
    }

    public void test0374() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0374", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a for statement", (node.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)node;
        Statement statement = forStatement.getBody();
        ASTConverterAST3Test.assertTrue((String)"Not a block statement", (statement.getNodeType() == 8 ? 1 : 0) != 0);
        Block block = (Block)statement;
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)statements.size());
        Statement statement2 = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a break statement", (statement2.getNodeType() == 18 ? 1 : 0) != 0);
        ContinueStatement continueStatement = (ContinueStatement)statement2;
        this.checkSourceRange((ASTNode)continueStatement, "continue;", source);
    }

    public void test0375() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0375", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"problems found", (int)1, (int)compilationUnit.getMessages().length);
        List imports = compilationUnit.imports();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)imports.size());
        ImportDeclaration importDeclaration = (ImportDeclaration)imports.get(0);
        IBinding binding = importDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Not a type binding", (int)2, (int)binding.getKind());
    }

    public void test0376() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0376", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
    }

    public void test0377() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0377", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        IVariableBinding variableBinding = variableDeclarationFragment.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong modifier", (int)16, (int)variableBinding.getModifiers());
    }

    public void test0378() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0378", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        SimpleName name = typeDeclaration.getName();
        this.checkSourceRange((ASTNode)name, "B", source);
    }

    public void test0379() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0379", "Test.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode expression = this.getASTNodeToCompare((JavaScriptUnit)result);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)expression);
        ASTConverterAST3Test.assertTrue((String)"Not a class instance creation", (expression.getNodeType() == 14 ? 1 : 0) != 0);
        ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)expression;
        Type type = classInstanceCreation2.getType();
        this.checkSourceRange((ASTNode)type, "Object", source);
    }

    public void test0380() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0380", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a return statement", (node.getNodeType() == 41 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)node;
        Expression expression = returnStatement.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not a super method invocation", (expression.getNodeType() == 48 ? 1 : 0) != 0);
        SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
        ITypeBinding typeBinding = superMethodInvocation.resolveTypeBinding();
        ASTConverterAST3Test.assertNotNull((String)"no type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"wrong declaring class", (String)typeBinding.getSuperclass().getName(), (String)"Object");
        SimpleName simpleName = superMethodInvocation.getName();
        IBinding binding = simpleName.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"no binding", (Object)binding);
        ASTConverterAST3Test.assertEquals((String)"Wrong type", (int)4, (int)binding.getKind());
        IFunctionBinding methodBinding = (IFunctionBinding)binding;
        ASTConverterAST3Test.assertEquals((String)"Wrong declaring class", (String)methodBinding.getDeclaringClass().getName(), (String)"Object");
    }

    public void test0381() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0381", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        JSdoc javadoc = typeDeclaration.getJavadoc();
        ASTConverterAST3Test.assertNull((String)"Javadoc not null", (Object)javadoc);
    }

    public void test0382() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0382", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0382.A");
    }

    public void test0383() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0383", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0383.A.B");
    }

    public void test0384() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0384", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertEquals((String)"Wrong fully qualified name", (String)typeBinding.getQualifiedName(), (String)"test0384.A.B.D");
    }

    public void test0385() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0385", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)1, (int)compilationUnit.getMessages().length);
    }

    public void test0386() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0386", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a switch statement", (node.getNodeType() == 50 ? 1 : 0) != 0);
        SwitchStatement switchStatement = (SwitchStatement)node;
        List statements = switchStatement.statements();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)5, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not a case statement", (statement.getNodeType() == 49 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "case 1:", source);
        statement = (Statement)statements.get(3);
        ASTConverterAST3Test.assertTrue((String)"Not a default case statement", (statement.getNodeType() == 49 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "default :", source);
    }

    public void test0387() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0387", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"Wrong size", (int)1, (int)fragments.size());
    }

    public void test0388() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0388", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"test0388.A", (String)typeBinding.getQualifiedName());
    }

    public void test0389() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0389", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a type declaration", (node.getNodeType() == 55 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"test0389.A.B", (String)typeBinding.getQualifiedName());
    }

    public void test0390() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0390", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"int", (String)typeBinding.getQualifiedName());
    }

    public void test0391() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0391", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"int[]", (String)typeBinding.getQualifiedName());
    }

    public void test0392() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0392", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
    }

    public void test0393() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0393", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        this.checkSourceRange((ASTNode)type, "String", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)methodDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No method binding", (Object)methodBinding);
        ITypeBinding typeBinding2 = methodBinding.getReturnType();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding2.getQualifiedName());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding2.getDimensions());
    }

    public void test0394() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0394", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        this.checkSourceRange((ASTNode)type, "String", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)0, (int)methodDeclaration.getExtraDimensions());
    }

    public void test0395() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0395", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTConverterAST3Test.assertNotNull((String)"No compilation unit", (Object)result);
        ASTConverterAST3Test.assertTrue((String)"result is not a compilation unit", (boolean)(result instanceof JavaScriptUnit));
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        ASTConverterAST3Test.assertEquals((String)"errors found", (int)0, (int)compilationUnit.getMessages().length);
        ASTNode node = this.getASTNode(compilationUnit, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)methodDeclaration.getExtraDimensions());
        IFunctionBinding methodBinding = methodDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No method binding", (Object)methodBinding);
        ITypeBinding typeBinding2 = methodBinding.getReturnType();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertEquals((String)"Wrong qualified name", (String)"java.lang.String[][]", (String)typeBinding2.getQualifiedName());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)2, (int)typeBinding2.getDimensions());
    }

    public void test0396() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0396", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration method = (FunctionDeclaration)node;
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)singleVariableDeclaration);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final String s[]", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String", source);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)singleVariableDeclaration.getExtraDimensions());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"An array binding", (!typeBinding.isArray() ? 1 : 0) != 0);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)0, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String", (String)typeBinding.getQualifiedName());
        IVariableBinding variableBinding = singleVariableDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ASTConverterAST3Test.assertTrue((String)"Is a parameter", (boolean)variableBinding.isParameter());
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertTrue((String)"Not an array binding", (boolean)typeBinding2.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding2.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[]", (String)typeBinding2.getQualifiedName());
    }

    public void test0397() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0397", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration method = (FunctionDeclaration)node;
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)method.parameters().get(0);
        ASTConverterAST3Test.assertNotNull((String)"Expression should not be null", (Object)singleVariableDeclaration);
        this.checkSourceRange((ASTNode)singleVariableDeclaration, "final String[] \\u0073\\u005B][]", source);
        Type type = singleVariableDeclaration.getType();
        this.checkSourceRange((ASTNode)type, "String[]", source);
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)2, (int)singleVariableDeclaration.getExtraDimensions());
        ITypeBinding typeBinding = type.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding);
        ASTConverterAST3Test.assertTrue((String)"Not an array binding", (boolean)typeBinding.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)1, (int)typeBinding.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[]", (String)typeBinding.getQualifiedName());
        IVariableBinding variableBinding = singleVariableDeclaration.resolveBinding();
        ASTConverterAST3Test.assertNotNull((String)"No variable binding", (Object)variableBinding);
        ASTConverterAST3Test.assertTrue((String)"Is a parameter", (boolean)variableBinding.isParameter());
        ITypeBinding typeBinding2 = variableBinding.getType();
        ASTConverterAST3Test.assertNotNull((String)"No type binding", (Object)typeBinding2);
        ASTConverterAST3Test.assertTrue((String)"Not an array binding", (boolean)typeBinding2.isArray());
        ASTConverterAST3Test.assertEquals((String)"Wrong dimension", (int)3, (int)typeBinding2.getDimensions());
        ASTConverterAST3Test.assertEquals((String)"wrong fully qualified name", (String)"java.lang.String[][][]", (String)typeBinding2.getQualifiedName());
    }

    public void test0398() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0398", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a variable declaration statement", (node.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)node;
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterAST3Test.assertTrue((String)"Not an infix expression", (expression.getNodeType() == 27 ? 1 : 0) != 0);
        InfixExpression infixExpression = (InfixExpression)expression;
        this.checkSourceRange((ASTNode)infixExpression, "(1 + 2) * 3", source);
        Expression expression2 = infixExpression.getLeftOperand();
        ASTConverterAST3Test.assertTrue((String)"Not an parenthesis expression", (expression2.getNodeType() == 36 ? 1 : 0) != 0);
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression2;
        Expression expression3 = parenthesizedExpression.getExpression();
        ASTConverterAST3Test.assertTrue((String)"Not an infix expression", (expression3.getNodeType() == 27 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)expression3, "1 + 2", source);
    }

    public void test0399() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0399", "A.js");
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterAST3Test.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)2, (int)statements.size());
    }

    public void test0400() throws JavaScriptModelException {
        IJavaScriptUnit sourceUnit = this.getCompilationUnit("Converter", "src", "test0400", "A.js");
        char[] source = sourceUnit.getSource().toCharArray();
        ASTNode result = this.runConversion(3, sourceUnit, true);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterAST3Test.assertNotNull((Object)node);
        ASTConverterAST3Test.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterAST3Test.assertTrue((String)"Not a constructor", (boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterAST3Test.assertEquals((String)"wrong size", (int)3, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterAST3Test.assertTrue((String)"Not an superconstructorinvocation", (statement.getNodeType() == 46 ? 1 : 0) != 0);
        this.checkSourceRange((ASTNode)statement, "super();", source);
    }
}

