/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;

public class ASTConverterJavadocTest
extends ConverterTestSetup {
    protected static boolean COPY_DIR = true;
    protected static int[] TEST_COUNTERS = new int[4];
    protected static boolean UNICODE = false;
    final boolean unix;
    static final String UNIX_SUPPORT = System.getProperty("unix");
    static final String DOC_COMMENT_SUPPORT = System.getProperty("doc.support");
    final String docCommentSupport;
    private final int LINE_COMMENT = 100;
    private final int BLOCK_COMMENT = 200;
    private final int DOC_COMMENT = 300;
    List comments = new ArrayList();
    private String chars;
    List allTags = new ArrayList();
    protected IJavaScriptUnit sourceUnit;
    protected boolean resolveBinding = true;
    protected boolean packageBinding = true;
    protected int astLevel = 2;
    protected int savedLevel;
    protected String prefix = "";
    protected boolean debug = false;
    protected StringBuffer problems;
    protected String compilerOption = "ignore";
    protected List failures;
    protected boolean stopOnFailure = true;
    protected IJavaScriptProject currentProject;
    Map savedOptions = null;
    static /* synthetic */ Class class$0;

    public ASTConverterJavadocTest(String name, String support, String unix) {
        super(name);
        this.docCommentSupport = support;
        this.unix = "true".equals(unix);
    }

    public ASTConverterJavadocTest(String name) {
        this(name, "enabled", UNIX_SUPPORT);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterJavadocTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite(clazz.getName());
        if (DOC_COMMENT_SUPPORT == null) {
            ASTConverterJavadocTest.buildSuite(suite, "enabled");
            ASTConverterJavadocTest.buildSuite(suite, "disabled");
        } else {
            String support = DOC_COMMENT_SUPPORT == null ? "disabled" : (DOC_COMMENT_SUPPORT.equals("disabled") ? "disabled" : "enabled");
            ASTConverterJavadocTest.buildSuite(suite, support);
        }
        return suite;
    }

    public static void buildSuite(TestSuite suite, String support) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterJavadocTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> c = clazz;
        Method[] methods = c.getMethods();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (methods[i].getName().startsWith("test")) {
                suite.addTest((Test)new ASTConverterJavadocTest(methods[i].getName(), support, UNIX_SUPPORT));
            }
            ++i;
        }
        if (UNIX_SUPPORT == null && "enabled".equals(support)) {
            i = 0;
            max = methods.length;
            while (i < max) {
                if (methods[i].getName().startsWith("test")) {
                    suite.addTest((Test)new ASTConverterJavadocTest(methods[i].getName(), support, "true"));
                }
                ++i;
            }
        }
    }

    protected void copyDirectory(File sourceDir, File targetDir) throws IOException {
        if (COPY_DIR) {
            super.copyDirectory(sourceDir, targetDir);
        } else {
            targetDir.mkdirs();
            File sourceFile = new File(sourceDir, ".project");
            File targetFile = new File(targetDir, ".project");
            targetFile.createNewFile();
            this.copy(sourceFile, targetFile);
            sourceFile = new File(sourceDir, ".classpath");
            targetFile = new File(targetDir, ".classpath");
            targetFile.createNewFile();
            this.copy(sourceFile, targetFile);
        }
    }

    public String getName() {
        String strUnix = this.unix ? " - Unix" : "";
        return "Doc " + this.docCommentSupport + strUnix + " - " + super.getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        TEST_COUNTERS[0] = TEST_COUNTERS[0] + 1;
        this.failures = new ArrayList();
        this.problems = new StringBuffer();
        this.workingCopies = null;
        this.savedLevel = this.astLevel;
    }

    protected void tearDown() throws Exception {
        int size = this.failures.size();
        String title = String.valueOf(size) + " positions/bindings were incorrect in " + this.getName();
        if (size == 0) {
            TEST_COUNTERS[1] = TEST_COUNTERS[1] + 1;
        } else if (this.problems.length() > 0) {
            if (this.debug) {
                System.out.println("Compilation warnings/errors occured:");
                System.out.println(this.problems.toString());
            }
            TEST_COUNTERS[2] = TEST_COUNTERS[2] + 1;
        } else {
            TEST_COUNTERS[3] = TEST_COUNTERS[3] + 1;
            System.out.println(String.valueOf(title) + ":");
            int i = 0;
            while (i < size) {
                System.out.println("\t- " + this.failures.get(i));
                ++i;
            }
        }
        ASTConverterJavadocTest.assertTrue((String)title, (size == 0 || this.problems.length() > 0 ? 1 : 0) != 0);
        super.tearDown();
        this.astLevel = this.savedLevel;
    }

    public void tearDownSuite() throws Exception {
        if (this.currentProject != null && this.savedOptions != null) {
            this.currentProject.setOptions(this.savedOptions);
        }
        super.tearDownSuite();
        if (TEST_COUNTERS[0] != TEST_COUNTERS[1]) {
            NumberFormat intFormat = NumberFormat.getInstance();
            intFormat.setMinimumIntegerDigits(3);
            intFormat.setMaximumIntegerDigits(3);
            System.out.println("=====================================");
            System.out.println(String.valueOf(intFormat.format(TEST_COUNTERS[0])) + " tests have been executed:");
            System.out.println("  - " + intFormat.format(TEST_COUNTERS[1]) + " tests have been actually executed.");
            System.out.println("  - " + intFormat.format(TEST_COUNTERS[2]) + " tests were skipped due to compilation errors.");
            System.out.println("  - " + intFormat.format(TEST_COUNTERS[3]) + " tests failed.");
        }
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project) {
        ASTParser parser = ASTParser.newParser((int)this.astLevel);
        parser.setSource(source);
        parser.setUnitName(unitName);
        parser.setProject(project);
        parser.setResolveBindings(this.resolveBinding);
        return parser.createAST(null);
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project, Map options) {
        if (project == null) {
            ASTParser parser = ASTParser.newParser((int)this.astLevel);
            parser.setSource(source);
            parser.setUnitName(unitName);
            parser.setCompilerOptions(options);
            parser.setResolveBindings(this.resolveBinding);
            return parser.createAST(null);
        }
        return this.runConversion(source, unitName, project);
    }

    private char getNextChar(char[] source, int idx) {
        char ch = source[idx];
        int charLength = 1;
        int pos = idx;
        this.chars = null;
        if (ch == '\\' && source[idx + 1] == 'u') {
            int c4;
            int c3;
            int c2;
            int c1;
            ++charLength;
            while (source[idx + charLength] == 'u') {
                ++charLength;
            }
            if ((c1 = ScannerHelper.getNumericValue((char)source[idx + charLength++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getNumericValue((char)source[idx + charLength++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getNumericValue((char)source[idx + charLength++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getNumericValue((char)source[idx + charLength++])) > 15 || c4 < 0) {
                return ch;
            }
            ch = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            this.chars = new String(source, pos, charLength);
        }
        return ch;
    }

    protected void setSourceComment(char[] source) throws ArrayIndexOutOfBoundsException {
        this.comments = new ArrayList();
        this.allTags = new ArrayList();
        StringBuffer buffer = null;
        int comment = 0;
        boolean end = false;
        boolean lineStarted = false;
        String tag = null;
        ArrayList<String> tags = new ArrayList<String>();
        int length = source.length;
        char previousChar = '\u0000';
        char currentChar = '\u0000';
        int i = 0;
        block23: while (i < length) {
            previousChar = currentChar;
            currentChar = this.getNextChar(source, i);
            i += this.chars == null ? 1 : this.chars.length();
            block0 : switch (comment) {
                case 0: {
                    block9 : switch (currentChar) {
                        case '/': {
                            comment = 1;
                            buffer = new StringBuffer();
                            if (this.chars == null) {
                                buffer.append(currentChar);
                                break;
                            }
                            buffer.append(this.chars);
                            break;
                        }
                        case '\'': {
                            while (i < length) {
                                currentChar = this.getNextChar(source, i);
                                i += this.chars == null ? 1 : this.chars.length();
                                if (currentChar == '\\') {
                                    currentChar = this.getNextChar(source, i);
                                    i += this.chars == null ? 1 : this.chars.length();
                                    continue;
                                }
                                if (currentChar == '\'') continue block23;
                            }
                            continue block23;
                        }
                        case '\"': {
                            while (i < length) {
                                currentChar = this.getNextChar(source, i);
                                i += this.chars == null ? 1 : this.chars.length();
                                if (currentChar == '\\') {
                                    currentChar = this.getNextChar(source, i);
                                    i += this.chars == null ? 1 : this.chars.length();
                                    continue;
                                }
                                if (currentChar != '\"') continue;
                                currentChar = this.getNextChar(source, i);
                                if (currentChar != '\"') break block9;
                                i += this.chars == null ? 1 : this.chars.length();
                            }
                            break block9;
                        }
                    }
                    continue block23;
                }
                case 1: {
                    switch (currentChar) {
                        case '/': {
                            if (this.chars == null) {
                                buffer.append(currentChar);
                            } else {
                                buffer.append(this.chars);
                            }
                            comment = 100;
                            break block0;
                        }
                        case '*': {
                            if (this.chars == null) {
                                buffer.append(currentChar);
                            } else {
                                buffer.append(this.chars);
                            }
                            comment = 2;
                            break block0;
                        }
                    }
                    comment = 0;
                    break;
                }
                case 2: {
                    comment = currentChar == '*' ? 3 : 200;
                    if (this.chars == null) {
                        buffer.append(currentChar);
                        break;
                    }
                    buffer.append(this.chars);
                    break;
                }
                case 3: {
                    if (currentChar == '/') {
                        if (this.chars == null) {
                            buffer.append(currentChar);
                        } else {
                            buffer.append(this.chars);
                        }
                        this.comments.add(buffer.toString());
                        this.allTags.add(new ArrayList());
                        comment = 0;
                        break;
                    }
                    comment = 300;
                }
                case 300: {
                    if (tag != null) {
                        if (currentChar >= 'a' && currentChar <= 'z') {
                            tag = String.valueOf(tag) + currentChar;
                        } else {
                            tags.add(tag);
                            tag = null;
                        }
                    }
                    switch (currentChar) {
                        case '@': {
                            if (lineStarted && previousChar != '{') break;
                            tag = "";
                            lineStarted = true;
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            lineStarted = false;
                            break;
                        }
                        case '*': {
                            break;
                        }
                        default: {
                            if (Character.isWhitespace(currentChar)) break;
                            lineStarted = true;
                        }
                    }
                }
                case 200: {
                    if (this.chars == null) {
                        buffer.append(currentChar);
                    } else {
                        buffer.append(this.chars);
                    }
                    if (end && currentChar == '/') {
                        comment = 0;
                        lineStarted = false;
                        this.comments.add(buffer.toString());
                        this.allTags.add(tags);
                        tags = new ArrayList();
                    }
                    end = currentChar == '*';
                    break;
                }
                case 100: {
                    if (currentChar == '\r' || currentChar == '\n') {
                        comment = 0;
                        this.comments.add(buffer.toString());
                        this.allTags.add(tags);
                        break;
                    }
                    if (this.chars == null) {
                        buffer.append(currentChar);
                        break;
                    }
                    buffer.append(this.chars);
                    break;
                }
            }
        }
    }

    char[] getUnicodeSource(char[] source) {
        int length = source.length;
        int unicodeLength = length * 6;
        char[] unicodeSource = new char[unicodeLength];
        int u = 0;
        int i = 0;
        while (i < length) {
            if (source[i] == '\\' && source[i + 1] == 'u') {
                int c4;
                int c3;
                int c2;
                unicodeSource[u++] = source[i];
                unicodeSource[u++] = source[++i];
                int c1 = ScannerHelper.getNumericValue((char)source[i + 1]);
                if (c1 > 15 || c1 < 0 || (c2 = ScannerHelper.getNumericValue((char)source[i + 2])) > 15 || c2 < 0 || (c3 = ScannerHelper.getNumericValue((char)source[i + 3])) > 15 || c3 < 0 || (c4 = ScannerHelper.getNumericValue((char)source[i + 4])) > 15 || c4 < 0) {
                    throw new RuntimeException("Invalid unicode in source at " + i);
                }
                int j = 0;
                while (j < 4) {
                    unicodeSource[u++] = source[++i];
                    ++j;
                }
            } else {
                unicodeSource[u++] = 92;
                unicodeSource[u++] = 117;
                unicodeSource[u++] = 48;
                unicodeSource[u++] = 48;
                int val = source[i] / 16;
                unicodeSource[u++] = (char)(val < 10 ? val + 48 : val - 10 + 97);
                val = source[i] % 16;
                unicodeSource[u++] = (char)(val < 10 ? val + 48 : val - 10 + 97);
            }
            ++i;
        }
        if (u != unicodeLength) {
            char[] result = new char[u];
            System.arraycopy(unicodeSource, 0, result, 0, u);
            return result;
        }
        return unicodeSource;
    }

    char[] getUnixSource(char[] source) {
        int length;
        int unixLength = length = source.length;
        char[] unixSource = new char[unixLength];
        int u = 0;
        int i = 0;
        while (i < length) {
            if (source[i] == '\r' && source[i + 1] == '\n') {
                ++i;
            }
            unixSource[u++] = source[i];
            ++i;
        }
        if (u != unixLength) {
            char[] result = new char[u];
            System.arraycopy(unixSource, 0, result, 0, u);
            return result;
        }
        return unixSource;
    }

    int allTags(JSdoc docComment) {
        int all = 0;
        ListIterator tags = docComment.tags().listIterator();
        while (tags.hasNext()) {
            TagElement tagElement = (TagElement)tags.next();
            if (tagElement.getTagName() != null) {
                ++all;
            }
            ListIterator fragments = tagElement.fragments().listIterator();
            while (fragments.hasNext()) {
                ASTNode node = (ASTNode)fragments.next();
                if (node.getNodeType() != 65) continue;
                ++all;
            }
        }
        return all;
    }

    private void addFailure(String msg) {
        this.failures.add(msg);
    }

    protected void assumeTrue(String msg, boolean cond) {
        if (!cond) {
            this.addFailure(msg);
            if (this.stopOnFailure) {
                ASTConverterJavadocTest.assertTrue((String)msg, (boolean)cond);
            }
        }
    }

    protected void assumeNull(String msg, Object obj) {
        if (obj != null) {
            this.addFailure(msg);
            if (this.stopOnFailure) {
                ASTConverterJavadocTest.assertNull((String)msg, (Object)obj);
            }
        }
    }

    protected void assumeNotNull(String msg, Object obj) {
        if (obj == null) {
            this.addFailure(msg);
            if (this.stopOnFailure) {
                ASTConverterJavadocTest.assertNotNull((String)msg, (Object)obj);
            }
        }
    }

    protected void assumeEquals(String msg, int expected, int actual) {
        if (expected != actual) {
            this.addFailure(String.valueOf(msg) + ", expected=" + expected + " actual=" + actual);
            if (this.stopOnFailure) {
                ASTConverterJavadocTest.assertEquals((String)msg, (int)expected, (int)actual);
            }
        }
    }

    protected void assumeEquals(String msg, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.addFailure(String.valueOf(msg) + ", expected:<" + expected + "> actual:<" + actual + '>');
        if (this.stopOnFailure) {
            ASTConverterJavadocTest.assertEquals((String)msg, (Object)expected, (Object)actual);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verifyPositions(JSdoc docComment, char[] source) {
        stop = this.stopOnFailure;
        start = docComment.getStartPosition();
        end = start + docComment.getLength() - 1;
        v0 = String.valueOf(this.prefix) + "Misplaced javadoc start at <" + start + ">: " + docComment;
        this.assumeTrue(v0, source[start++] == '/' && source[start++] == '*' && source[start++] == '*');
        tagStart = start;
        tags = docComment.tags().listIterator();
        ** GOTO lbl17
        {
            ++tagStart;
            do {
                if (source[tagStart] == '*' || Character.isWhitespace(source[tagStart])) continue block0;
                tagElement = (TagElement)tags.next();
                teStart = tagElement.getStartPosition();
                this.assumeEquals(String.valueOf(this.prefix) + "Wrong start position <" + teStart + "> for tag element: " + tagElement, tagStart, teStart);
                this.verifyPositions(tagElement, source);
                tagStart += tagElement.getLength();
lbl17:
                // 2 sources

            } while (tags.hasNext());
        }
        while (source[tagStart] == '*' || Character.isWhitespace(source[tagStart])) {
            ++tagStart;
        }
        this.assumeTrue(String.valueOf(this.prefix) + "Misplaced javadoc end at <" + tagStart + '>', source[tagStart - 1] == '*' && source[tagStart] == '/');
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong javadoc length at <" + end + ">: ", tagStart, end);
        this.stopOnFailure = stop;
        ASTConverterJavadocTest.assertTrue((boolean)(stop == false || this.failures.size() == 0));
    }

    /*
     * Unable to fully structure code
     */
    private void verifyPositions(TagElement tagElement, char[] source) {
        text = null;
        tagName = tagElement.getTagName();
        tagStart = tagElement.getStartPosition();
        if (tagElement.isNested()) {
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong start position <" + tagStart + "> for " + tagElement, 123, source[tagStart++]);
        }
        if (tagName != null) {
            text = new String(source, tagStart, tagName.length());
            this.assumeEquals(String.valueOf(this.prefix) + "Misplaced tag name at <" + tagStart + ">: ", tagName, text);
            tagStart += tagName.length();
        }
        previousFragment = null;
        elements = tagElement.fragments().listIterator();
        while (elements.hasNext()) {
            block48: {
                block52: {
                    block51: {
                        block50: {
                            block49: {
                                fragment = (ASTNode)elements.next();
                                if (fragment.getNodeType() != 66) ** GOTO lbl73
                                if (previousFragment == null && "@param".equals(tagName) && ((TextElement)fragment).getText().equals("<")) {
                                    start = tagStart;
                                    while (source[start] == ' ' || Character.isWhitespace(source[start])) {
                                        ++start;
                                    }
                                    text = new String(source, start, fragment.getLength());
                                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced text element at <" + fragment.getStartPosition() + ">: ", text, ((TextElement)fragment).getText());
                                    start += fragment.getLength();
                                    this.assumeTrue(String.valueOf(this.prefix) + "Unexpected fragment end for " + tagElement, elements.hasNext());
                                    fragment = (ASTNode)elements.next();
                                    while (source[start] == ' ' || Character.isWhitespace(source[start])) {
                                        ++start;
                                    }
                                    this.assumeEquals(String.valueOf(this.prefix) + "Unexpected node type for tag element " + tagElement, 42, fragment.getNodeType());
                                    name = (Name)fragment;
                                    this.verifyNamePositions(start, name, source);
                                    start += fragment.getLength();
                                    this.assumeTrue(String.valueOf(this.prefix) + "Unexpected fragment end for " + tagElement, elements.hasNext());
                                    fragment = (ASTNode)elements.next();
                                    while (source[start] == ' ' || Character.isWhitespace(source[start])) {
                                        ++start;
                                    }
                                    text = new String(source, start, fragment.getLength());
                                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced text element at <" + fragment.getStartPosition() + ">: ", text, ((TextElement)fragment).getText());
                                    start += fragment.getLength();
                                    fragment = name;
                                    tagStart += start - tagStart - name.getLength();
                                } else {
                                    if (previousFragment == null) {
                                        if (tagName != null && (source[tagStart] == '\r' || source[tagStart] == '\n')) {
                                            while (source[tagStart] == '*' || Character.isWhitespace(source[tagStart])) {
                                                ++tagStart;
                                            }
                                        }
                                    } else if (previousFragment.getNodeType() == 66) {
                                        this.assumeTrue(String.valueOf(this.prefix) + "Wrong length at <" + previousFragment.getStartPosition() + "> for text element " + previousFragment, source[tagStart] == '\r' || source[tagStart] == '\n');
                                        while (source[tagStart] == '*' || Character.isWhitespace(source[tagStart])) {
                                            ++tagStart;
                                        }
                                    } else if ("@param".equals(tagName) && previousFragment.getNodeType() == 42 && ((TextElement)fragment).getText().equals(">")) {
                                        while (source[tagStart] == ' ' || Character.isWhitespace(source[tagStart])) {
                                            ++tagStart;
                                        }
                                    } else {
                                        start = tagStart;
                                        newLine = false;
                                        while (source[start] == '*' || Character.isWhitespace(source[start])) {
                                            ++start;
                                            if (source[tagStart] != '\r' && source[tagStart] != '\n') continue;
                                            newLine = true;
                                        }
                                        if (newLine) {
                                            tagStart = start;
                                        }
                                    }
                                    text = new String(source, tagStart, fragment.getLength());
                                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced text element at <" + fragment.getStartPosition() + ">: ", text, ((TextElement)fragment).getText());
                                }
                                break block48;
lbl-1000:
                                // 1 sources

                                {
                                    ++tagStart;
lbl73:
                                    // 2 sources

                                    ** while (source[tagStart] == '*' || Character.isWhitespace((char)source[tagStart]))
                                }
lbl74:
                                // 1 sources

                                if (fragment.getNodeType() != 42 && fragment.getNodeType() != 40) break block49;
                                this.verifyNamePositions(tagStart, (Name)fragment, source);
                                break block48;
                            }
                            if (fragment.getNodeType() != 65) break block50;
                            inlineTag = (TagElement)fragment;
                            this.assumeEquals(String.valueOf(this.prefix) + "Tag element <" + inlineTag + "> has wrong start position", tagStart, inlineTag.getStartPosition());
                            this.verifyPositions(inlineTag, source);
                            break block48;
                        }
                        if (fragment.getNodeType() != 67) break block51;
                        memberRef = (MemberRef)fragment;
                        start = tagStart;
                        qualifier = memberRef.getQualifier();
                        if (qualifier != null) {
                            this.verifyNamePositions(start, qualifier, source);
                            start += qualifier.getLength();
                            while (source[start] == '*' || Character.isWhitespace(source[start])) {
                                ++start;
                            }
                        }
                        this.assumeEquals(String.valueOf(this.prefix) + "Misplaced # separator at <" + start + "> for member ref " + memberRef, 35, source[start]);
                        ++start;
                        while (source[start] == '*' || Character.isWhitespace(source[start])) {
                            ++start;
                        }
                        name = memberRef.getName();
                        text = new String(source, start, name.getLength());
                        this.assumeEquals(String.valueOf(this.prefix) + "Misplaced member ref at <" + start + ">: ", text, name.toString());
                        this.verifyNamePositions(start, (Name)name, source);
                        break block48;
                    }
                    if (fragment.getNodeType() != 68) break block48;
                    methodRef = (FunctionRef)fragment;
                    start = tagStart;
                    qualifier = methodRef.getQualifier();
                    if (qualifier != null) {
                        this.verifyNamePositions(start, qualifier, source);
                        start += qualifier.getLength();
                        while (source[start] == '*' || Character.isWhitespace(source[start])) {
                            ++start;
                        }
                    }
                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced # separator at <" + start + "> for method ref: " + methodRef, 35, source[start]);
                    ++start;
                    while (source[start] == '*' || Character.isWhitespace(source[start])) {
                        ++start;
                    }
                    name = methodRef.getName();
                    nameLength = name.getLength();
                    text = new String(source, start, nameLength);
                    if (text.equals(name.toString())) break block52;
                    if (!methodRef.getQualifier().isQualifiedName()) ** GOTO lbl133
                    text = new String(source, start, methodRef.getQualifier().getLength());
                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced method ref name at <" + start + ">: ", text, methodRef.getQualifier().toString());
                    while (source[start] != '.' || Character.isWhitespace(source[start])) {
                        ++start;
                    }
                    ++start;
                    break block52;
lbl-1000:
                    // 1 sources

                    {
                        ++start;
lbl133:
                        // 2 sources

                        ** while (source[start] != '.' || Character.isWhitespace((char)source[start]))
                    }
lbl134:
                    // 1 sources

                    text = new String(source, ++start, nameLength);
                    this.assumeEquals(String.valueOf(this.prefix) + "Misplaced method ref name at <" + start + ">: ", text, name.toString());
                }
                this.verifyNamePositions(start, (Name)name, source);
                start += nameLength;
                while (source[start] == '*' || Character.isWhitespace(source[start])) {
                    ++start;
                }
                if (source[start] == '(') {
                    ++start;
                    parameters = methodRef.parameters().listIterator();
                    while (parameters.hasNext()) {
                        param = (FunctionRefParameter)parameters.next();
                        lastParam = parameters.hasNext() == false;
                        while (source[start] == '*' || Character.isWhitespace(source[start])) {
                            ++start;
                        }
                        type = param.getType();
                        if (type.isSimpleType()) {
                            this.verifyNamePositions(start, ((SimpleType)type).getName(), source);
                        } else if (type.isPrimitiveType()) {
                            text = new String(source, start, type.getLength());
                            this.assumeEquals(String.valueOf(this.prefix) + "Misplaced method ref parameter type at <" + start + "> for method ref: " + methodRef, text, type.toString());
                        } else if (type.isArrayType()) {
                            elementType = ((ArrayType)param.getType()).getElementType();
                            if (elementType.isSimpleType()) {
                                this.verifyNamePositions(start, ((SimpleType)elementType).getName(), source);
                            } else if (elementType.isPrimitiveType()) {
                                text = new String(source, start, elementType.getLength());
                                this.assumeEquals(String.valueOf(this.prefix) + "Misplaced method ref parameter type at <" + start + "> for method ref: " + methodRef, text, elementType.toString());
                            }
                        }
                        start += type.getLength();
                        while (Character.isWhitespace(source[start])) {
                            ++start;
                        }
                        if (lastParam && this.astLevel != 2 && param.isVarargs()) {
                            p = 0;
                            while (p < 3) {
                                this.assumeTrue(String.valueOf(this.prefix) + "Missing ellipsis for vararg method ref parameter at <" + start + "> for method ref: " + methodRef, source[start++] == '.');
                                ++p;
                            }
                        }
                        while (Character.isWhitespace(source[start])) {
                            ++start;
                        }
                        name = param.getName();
                        if (name != null) {
                            text = new String(source, start, name.getLength());
                            this.assumeEquals(String.valueOf(this.prefix) + "Misplaced method ref parameter name at <" + start + "> for method ref: " + methodRef, text, name.toString());
                            start += name.getLength();
                        }
                        while (source[start] == '*' || Character.isWhitespace(source[start])) {
                            ++start;
                        }
                        this.assumeTrue(String.valueOf(this.prefix) + "Misplaced parameter end at <" + start + "> for method ref: " + methodRef, source[start] == ',' || source[start] == ')');
                        if (source[++start] == ')') break;
                    }
                }
            }
            tagStart += fragment.getLength();
            previousFragment = fragment;
        }
        if (tagElement.isNested()) {
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong end character at <" + tagStart + "> for " + tagElement, 125, source[tagStart++]);
        }
    }

    private void verifyNamePositions(int nameStart, Name name, char[] source) {
        String str;
        if (name.isQualifiedName()) {
            QualifiedName qualified = (QualifiedName)name;
            int start = qualified.getName().getStartPosition();
            String str2 = new String(source, start, qualified.getName().getLength());
            this.assumeEquals(String.valueOf(this.prefix) + "Misplaced or wrong name for qualified name: " + name, str2, qualified.getName().toString());
            this.verifyNamePositions(nameStart, ((QualifiedName)name).getQualifier(), source);
        }
        if ((str = new String(source, nameStart, name.getLength())).indexOf(10) < 0) {
            this.assumeEquals(String.valueOf(this.prefix) + "Misplaced name for qualified name: ", str, name.toString());
        } else if (this.debug) {
            System.out.println(String.valueOf(this.prefix) + "Name contains new line for qualified name: " + name);
        }
    }

    private void verifyBindings(JSdoc docComment) {
        boolean stop = this.stopOnFailure;
        ListIterator tags = docComment.tags().listIterator();
        while (tags.hasNext()) {
            this.verifyBindings((TagElement)tags.next());
        }
        this.stopOnFailure = stop;
        ASTConverterJavadocTest.assertTrue((!stop || this.failures.size() == 0 ? 1 : 0) != 0);
    }

    private void verifyBindings(TagElement tagElement) {
        ListIterator elements = tagElement.fragments().listIterator();
        IBinding previousBinding = null;
        ASTNode previousFragment = null;
        boolean resolvedBinding = false;
        while (elements.hasNext()) {
            ASTNode fragment = (ASTNode)elements.next();
            if (fragment.getNodeType() == 66) {
                TextElement text = (TextElement)fragment;
                if (resolvedBinding) {
                    if (previousBinding == null) {
                        this.assumeTrue(String.valueOf(this.prefix) + "Reference '" + previousFragment + "' should be bound!", text.getText().trim().indexOf("Unknown") >= 0);
                    } else {
                        this.assumeTrue(String.valueOf(this.prefix) + "Unknown reference '" + previousFragment + "' should NOT be bound!", text.getText().trim().indexOf("Unknown") < 0);
                    }
                }
                previousBinding = null;
                resolvedBinding = false;
            } else if (fragment.getNodeType() == 65) {
                this.verifyBindings((TagElement)fragment);
                previousBinding = null;
                resolvedBinding = false;
            } else {
                FunctionRef methodRef;
                resolvedBinding = true;
                if (fragment.getNodeType() == 42) {
                    previousBinding = ((Name)fragment).resolveBinding();
                } else if (fragment.getNodeType() == 40) {
                    QualifiedName name = (QualifiedName)fragment;
                    previousBinding = name.resolveBinding();
                    this.verifyNameBindings((Name)name);
                } else if (fragment.getNodeType() == 67) {
                    MemberRef memberRef = (MemberRef)fragment;
                    previousBinding = memberRef.resolveBinding();
                    if (previousBinding != null) {
                        SimpleName name = memberRef.getName();
                        this.assumeNotNull(String.valueOf(this.prefix) + name + " binding was not foundfound in " + fragment, name.resolveBinding());
                        this.verifyNameBindings(memberRef.getQualifier());
                    }
                } else if (fragment.getNodeType() == 68 && (previousBinding = (methodRef = (FunctionRef)fragment).resolveBinding()) != null) {
                    SimpleName methodName = methodRef.getName();
                    IBinding methNameBinding = methodName.resolveBinding();
                    Name methodQualifier = methodRef.getQualifier();
                    this.assumeNotNull(String.valueOf(this.prefix) + methodName + " binding was not found in " + fragment, methNameBinding);
                    this.verifyNameBindings(methodQualifier);
                    ListIterator parameters = methodRef.parameters().listIterator();
                    while (parameters.hasNext()) {
                        FunctionRefParameter param = (FunctionRefParameter)parameters.next();
                        Type type = param.getType();
                        this.assumeNotNull(String.valueOf(this.prefix) + type + " binding was not found in " + fragment, type.resolveBinding());
                        if (type.isSimpleType()) {
                            this.verifyNameBindings(((SimpleType)type).getName());
                            continue;
                        }
                        if (!type.isArrayType()) continue;
                        Type elementType = ((ArrayType)param.getType()).getElementType();
                        this.assumeNotNull(String.valueOf(this.prefix) + elementType + " binding was not found in " + fragment, elementType.resolveBinding());
                        if (!elementType.isSimpleType()) continue;
                        this.verifyNameBindings(((SimpleType)elementType).getName());
                    }
                }
            }
            previousFragment = fragment;
        }
        this.assumeTrue(String.valueOf(this.prefix) + "Reference '" + (previousFragment == null ? tagElement : previousFragment) + "' should be bound!", !resolvedBinding || previousBinding != null);
    }

    private void verifyNameBindings(Name name) {
        if (name != null) {
            IBinding binding = name.resolveBinding();
            if (name.toString().indexOf("Unknown") > 0) {
                this.assumeNull(String.valueOf(this.prefix) + name + " binding should be null!", binding);
            } else {
                this.assumeNotNull(String.valueOf(this.prefix) + name + " binding was not found!", binding);
            }
            SimpleName simpleName = null;
            int index = 0;
            while (name.isQualifiedName()) {
                simpleName = ((QualifiedName)name).getName();
                binding = simpleName.resolveBinding();
                if (simpleName.getIdentifier().equalsIgnoreCase("Unknown")) {
                    this.assumeNull(String.valueOf(this.prefix) + simpleName + " binding should be null!", binding);
                } else {
                    this.assumeNotNull(String.valueOf(this.prefix) + simpleName + " binding was not found!", binding);
                }
                if (index > 0 && this.packageBinding) {
                    this.assumeEquals(String.valueOf(this.prefix) + "Wrong binding type!", 1, binding.getKind());
                }
                ++index;
                name = ((QualifiedName)name).getQualifier();
                binding = name.resolveBinding();
                if (name.toString().indexOf("Unknown") > 0) {
                    this.assumeNull(String.valueOf(this.prefix) + name + " binding should be null!", binding);
                } else {
                    this.assumeNotNull(String.valueOf(this.prefix) + name + " binding was not found!", binding);
                }
                if (!this.packageBinding) continue;
                this.assumeEquals(String.valueOf(this.prefix) + "Wrong binding type!", 1, binding.getKind());
            }
        }
    }

    protected void verifyComments(String test) throws JavaScriptModelException {
        IJavaScriptUnit[] units = this.getCompilationUnits("Converter", "src", "javadoc." + test);
        int i = 0;
        while (i < units.length) {
            this.verifyComments(units[i]);
            ++i;
        }
    }

    protected void verifyWorkingCopiesComments() throws JavaScriptModelException {
        this.assumeNotNull("No working copies to verify!", this.workingCopies);
        int length = this.workingCopies.length;
        this.assumeTrue("We need to have at least one working copy to verify!", length > 0);
        int i = 0;
        while (i < length) {
            this.verifyComments(this.workingCopies[i]);
            ++i;
        }
    }

    protected JavaScriptUnit verifyComments(IJavaScriptUnit unit) throws JavaScriptModelException {
        this.sourceUnit = unit;
        this.prefix = String.valueOf(unit.getElementName()) + ": ";
        String sourceStr = this.sourceUnit.getSource();
        if (this.savedOptions != null && !this.sourceUnit.getJavaScriptProject().getElementName().equals(this.currentProject.getElementName())) {
            this.currentProject.setOptions(this.savedOptions);
            this.savedOptions = null;
        }
        this.currentProject = this.sourceUnit.getJavaScriptProject();
        if (this.savedOptions == null) {
            this.savedOptions = this.currentProject.getOptions(false);
        }
        this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", this.compilerOption);
        this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.compilerOption);
        this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.compilerOption);
        this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.methodWithConstructorName", "ignore");
        this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", this.docCommentSupport);
        char[] source = sourceStr.toCharArray();
        String fileName = unit.getPath().toString();
        try {
            return this.verifyComments(fileName, source);
        }
        catch (RuntimeException ex) {
            TEST_COUNTERS[3] = TEST_COUNTERS[3] + 1;
            throw ex;
        }
    }

    protected JavaScriptUnit verifyComments(String fileName, char[] source) {
        return this.verifyComments(fileName, source, null);
    }

    protected JavaScriptUnit verifyComments(String fileName, char[] source, Map options) {
        IProblem[] problemsList;
        int length;
        char[] testedSource = source;
        if (UNICODE) {
            testedSource = this.getUnicodeSource(source);
        } else if (this.unix) {
            testedSource = this.getUnixSource(source);
        }
        this.setSourceComment(testedSource);
        List unitComments = null;
        String sourceLevel = null;
        String complianceLevel = null;
        if (this.currentProject != null && this.astLevel == 3) {
            complianceLevel = this.currentProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
            sourceLevel = this.currentProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
            this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        }
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(testedSource, fileName, this.currentProject, options);
        if (this.compilerOption.equals("error")) {
            this.assumeEquals(String.valueOf(this.prefix) + "Unexpected problems", 0, compilUnit.getProblems().length);
        } else if (this.compilerOption.equals("warning") && (length = (problemsList = compilUnit.getProblems()).length) > 0) {
            this.problems.append("  - " + this.prefix + length + " problems:");
            int i = 0;
            while (i < problemsList.length) {
                this.problems.append("\t+ ");
                this.problems.append(problemsList[i]);
                this.problems.append("\n");
                ++i;
            }
        }
        unitComments = compilUnit.getCommentList();
        this.assumeNotNull(String.valueOf(this.prefix) + "Unexpected problems", unitComments);
        int size = unitComments.size();
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments!", this.comments.size(), size);
        int i = 0;
        while (i < size) {
            Comment comment = (Comment)unitComments.get(i);
            List tags = (List)this.allTags.get(i);
            String stringComment = (String)this.comments.get(i);
            String text = new String(testedSource, comment.getStartPosition(), comment.getLength());
            this.assumeEquals(String.valueOf(this.prefix) + "Flattened comment does NOT match source!", stringComment, text);
            if (comment.isDocComment()) {
                JSdoc docComment = (JSdoc)comment;
                if (this.docCommentSupport.equals("enabled")) {
                    this.assumeEquals(String.valueOf(this.prefix) + "Invalid tags number in javadoc:\n" + docComment + "\n", tags.size(), this.allTags(docComment));
                    this.verifyPositions(docComment, testedSource);
                    if (this.resolveBinding) {
                        this.verifyBindings(docComment);
                    }
                } else {
                    this.assumeEquals("Javadoc should be flat!", 0, docComment.tags().size());
                }
            }
            ++i;
        }
        if (sourceLevel != null) {
            this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.compliance", complianceLevel);
            this.currentProject.setOption("org.eclipse.wst.jsdt.core.compiler.source", sourceLevel);
        }
        return compilUnit;
    }

    public void test000() throws JavaScriptModelException {
        this.verifyComments("test000");
    }

    public void test001() throws JavaScriptModelException {
        this.verifyComments("test001");
    }

    public void test002() throws JavaScriptModelException {
        this.verifyComments("test002");
    }

    public void test003() throws JavaScriptModelException {
        this.verifyComments("test003");
    }

    public void test004() throws JavaScriptModelException {
        this.verifyComments("test004");
    }

    public void test005() throws JavaScriptModelException {
        this.verifyComments("test005");
    }

    public void test006() throws JavaScriptModelException {
        this.verifyComments("test006");
    }

    public void test007() throws JavaScriptModelException {
        this.verifyComments("test007");
    }

    public void test008() throws JavaScriptModelException {
        this.verifyComments("test008");
    }

    public void test009() throws JavaScriptModelException {
        this.verifyComments("test009");
    }

    public void test010() throws JavaScriptModelException {
        this.verifyComments("test010");
    }

    public void test011() throws JavaScriptModelException {
        this.problems = new StringBuffer();
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.test011", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, true);
        this.assumeNotNull("No compilation unit", result);
    }

    public void test012() throws JavaScriptModelException {
        this.verifyComments("test012");
    }

    public void test013() throws JavaScriptModelException {
        this.verifyComments("test013");
    }

    public void test014() throws JavaScriptModelException {
        this.verifyComments("test014");
    }

    public void test015() throws JavaScriptModelException {
        this.verifyComments("test015");
    }

    protected void verifyMapper(String folder, int count, int[] indexes) throws JavaScriptModelException {
        IJavaScriptUnit[] units = this.getCompilationUnits("Converter", "src", "javadoc." + folder);
        int i = 0;
        while (i < units.length) {
            Comment comment;
            this.sourceUnit = units[i];
            ASTNode result = this.runConversion(this.sourceUnit, false);
            JavaScriptUnit compilUnit = (JavaScriptUnit)result;
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", count, compilUnit.getCommentList().size());
            ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
            this.assumeNotNull("We should get a non-null ast node", node);
            this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
            FunctionDeclaration method = (FunctionDeclaration)node;
            int commentStart = method.getStartPosition();
            if (indexes[0] >= 0) {
                Comment comment2 = (Comment)compilUnit.getCommentList().get(indexes[0]);
                commentStart = comment2.getStartPosition();
            }
            int startPosition = compilUnit.getExtendedStartPosition((ASTNode)method);
            this.assumeEquals("Method " + node + " does not start at the right position", commentStart, startPosition);
            int methodEnd = startPosition + compilUnit.getExtendedLength((ASTNode)method) - 1;
            int commentEnd = method.getStartPosition() + method.getLength() - 1;
            if (indexes[1] >= 0) {
                comment = (Comment)compilUnit.getCommentList().get(indexes[1]);
                commentEnd = comment.getStartPosition() + comment.getLength() - 1;
            }
            this.assumeEquals("Method " + node + " does not have the correct length", commentEnd, methodEnd);
            node = this.getASTNode((JavaScriptUnit)result, 0, 1);
            this.assumeNotNull("We should get a non-null ast node", node);
            this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
            method = (FunctionDeclaration)node;
            commentStart = method.getStartPosition();
            if (indexes[2] >= 0) {
                comment = (Comment)compilUnit.getCommentList().get(indexes[2]);
                commentStart = comment.getStartPosition();
            }
            startPosition = compilUnit.getExtendedStartPosition((ASTNode)method);
            this.assumeEquals("Method " + node + " does not start at the right position", commentStart, startPosition);
            methodEnd = startPosition + compilUnit.getExtendedLength((ASTNode)method) - 1;
            commentEnd = method.getStartPosition() + method.getLength() - 1;
            if (indexes[3] >= 0) {
                comment = (Comment)compilUnit.getCommentList().get(indexes[3]);
                commentEnd = comment.getStartPosition() + comment.getLength() - 1;
            }
            this.assumeEquals("Method " + node + " does not have the correct length", commentEnd, methodEnd);
            ++i;
        }
    }

    public void test100() throws JavaScriptModelException {
        this.verifyMapper("test100", 16, new int[]{2, 7, 8, 15});
    }

    public void test101() throws JavaScriptModelException {
        this.verifyMapper("test101", 8, new int[]{1, 3, 4, 7});
    }

    public void test102() throws JavaScriptModelException {
        this.verifyMapper("test102", 16, new int[]{4, 9, 10, 13});
    }

    public void test103() throws JavaScriptModelException {
        this.verifyMapper("test103", 8, new int[]{2, 4, 5, 6});
    }

    public void test104() throws JavaScriptModelException {
        this.verifyMapper("test104", 16, new int[]{2, 7, 8, 15});
    }

    public void test105() throws JavaScriptModelException {
        this.verifyMapper("test105", 16, new int[]{-1, 11, -1, 15});
    }

    public void test106() throws JavaScriptModelException {
        this.verifyMapper("test106", 8, new int[]{-1, 5, -1, 7});
    }

    public void test107() throws JavaScriptModelException {
        this.verifyMapper("test107", 16, new int[]{2, 7, 8, -1});
    }

    public void test108() throws JavaScriptModelException {
        this.verifyMapper("test108", 8, new int[]{1, 3, 4, -1});
    }

    public void testBug54776() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug54776", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 2, compilUnit.getCommentList().size());
        Comment comment = (Comment)compilUnit.getCommentList().get(0);
        int commentStart = comment.getStartPosition();
        int extendedLength = ((Comment)compilUnit.getCommentList().get(1)).getStartPosition() - commentStart + comment.getLength();
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a type declaration", node.getNodeType() == 55);
        TypeDeclaration typeDecl = (TypeDeclaration)node;
        FieldDeclaration[] fields = typeDecl.getFields();
        this.assumeEquals("We should have a field declaration", 1, fields.length);
        List fragments = fields[0].fragments();
        this.assumeEquals("We should have a variable fragment", 1, fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        Expression expression = fragment.getInitializer();
        this.assumeTrue("We should get an expression", expression instanceof FunctionInvocation);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        int methodStart = compilUnit.getExtendedStartPosition((ASTNode)methodInvocation);
        this.assumeEquals("Method invocation " + methodInvocation + " does not start at the right position", commentStart, methodStart);
        int methodLength = compilUnit.getExtendedLength((ASTNode)methodInvocation);
        this.assumeEquals("Method invocation " + methodInvocation + " does not have the correct length", extendedLength, methodLength);
    }

    public void testBug55221a() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55221.a", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 1, compilUnit.getCommentList().size());
        Comment comment = (Comment)compilUnit.getCommentList().get(0);
        int commentStart = comment.getStartPosition();
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        FunctionDeclaration method = (FunctionDeclaration)node;
        int methodStart = compilUnit.getExtendedStartPosition((ASTNode)method);
        this.assumeEquals("Method " + method + " does not start at the right position", method.getStartPosition(), methodStart);
        int methodLength = compilUnit.getExtendedLength((ASTNode)method);
        this.assumeEquals("Method declaration " + method + " does not end at the right position", method.getLength(), methodLength);
        node = method.getBody();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a block", node.getNodeType() == 8);
        Block block = (Block)node;
        int blockStart = compilUnit.getExtendedStartPosition((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not start at the right position", block.getStartPosition(), blockStart);
        int blockLength = compilUnit.getExtendedLength((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not have the correct length", block.getLength(), blockLength);
        node = this.getASTNode(compilUnit, 0, 1);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        method = (FunctionDeclaration)node;
        this.assumeEquals("Method declaration " + method + " does not start at the right position", commentStart, method.getStartPosition());
    }

    public void testBug55221b() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55221.b", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 1, compilUnit.getCommentList().size());
        Comment comment = (Comment)compilUnit.getCommentList().get(0);
        int commentStart = comment.getStartPosition();
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        FunctionDeclaration method = (FunctionDeclaration)node;
        int methodStart = compilUnit.getExtendedStartPosition((ASTNode)method);
        this.assumeEquals("Method " + method + " does not start at the right position", method.getStartPosition(), methodStart);
        int methodLength = compilUnit.getExtendedLength((ASTNode)method);
        this.assumeEquals("Method declaration " + method + " does not end at the right position", method.getLength(), methodLength);
        node = method.getBody();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a block", node.getNodeType() == 8);
        Block block = (Block)node;
        int blockStart = compilUnit.getExtendedStartPosition((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not start at the right position", block.getStartPosition(), blockStart);
        int blockLength = compilUnit.getExtendedLength((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not have the correct length", block.getLength(), blockLength);
        node = this.getASTNode(compilUnit, 0, 1);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        method = (FunctionDeclaration)node;
        this.assumeEquals("Method declaration " + method + " does not start at the right position", commentStart, method.getStartPosition());
    }

    public void testBug55221c() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55221.c", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 1, compilUnit.getCommentList().size());
        Comment comment = (Comment)compilUnit.getCommentList().get(0);
        int commentStart = comment.getStartPosition();
        int commentEnd = commentStart + comment.getLength() - 1;
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        FunctionDeclaration method = (FunctionDeclaration)node;
        int methodStart = compilUnit.getExtendedStartPosition((ASTNode)method);
        this.assumeEquals("Method " + method + " does not start at the right position", method.getStartPosition(), methodStart);
        int methodLength = compilUnit.getExtendedLength((ASTNode)method);
        this.assumeEquals("Method " + method + " does not end at the right position", commentEnd, methodStart + methodLength - 1);
        node = method.getBody();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a block", node.getNodeType() == 8);
        Block block = (Block)node;
        int blockStart = compilUnit.getExtendedStartPosition((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not start at the right position", block.getStartPosition(), blockStart);
        int blockLength = compilUnit.getExtendedLength((ASTNode)block);
        this.assumeEquals("Body block " + block + " does not end at the right position", commentEnd, blockStart + blockLength - 1);
        node = this.getASTNode(compilUnit, 0, 1);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        method = (FunctionDeclaration)node;
        methodStart = compilUnit.getExtendedStartPosition((ASTNode)method);
        this.assumeEquals("Method " + method + " does not start at the right position", method.getStartPosition(), methodStart);
        methodLength = compilUnit.getExtendedLength((ASTNode)method);
        this.assumeEquals("Method declaration " + method + " does not end at the right position", method.getLength(), methodLength);
    }

    public void testBug55221d() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55221.d", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 2, compilUnit.getCommentList().size());
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not a method declaration", node.getNodeType() == 31);
        FunctionDeclaration method = (FunctionDeclaration)node;
        int methodStart = compilUnit.getExtendedStartPosition((ASTNode)method);
        this.assumeEquals("Method " + method + " does not start at the right position", method.getStartPosition(), methodStart);
        int methodLength = compilUnit.getExtendedLength((ASTNode)method);
        this.assumeEquals("Method " + method + " does not have the right length", methodLength, method.getLength());
        node = method.getReturnType();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not return type", node.getNodeType() == 39);
        PrimitiveType returnType = (PrimitiveType)node;
        int returnStart = compilUnit.getExtendedStartPosition((ASTNode)returnType);
        this.assumeEquals("Return type " + returnType + " does not start at the right position", returnType.getStartPosition(), returnStart);
        int returnLength = compilUnit.getExtendedLength((ASTNode)returnType);
        this.assumeEquals("Return type " + returnType + " does not have the right length", returnType.getLength(), returnLength);
    }

    public void testBug55223a() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55223", "TestA.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 2, compilUnit.getCommentList().size());
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeEquals("Not a method declaration", 31, node.getNodeType());
        FunctionDeclaration method = (FunctionDeclaration)node;
        node = method.getBody();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeEquals("Not a block", 8, node.getNodeType());
        Block block = (Block)node;
        Iterator statements = block.statements().iterator();
        int idx = 0;
        while (statements.hasNext()) {
            node = (ExpressionStatement)statements.next();
            this.assumeEquals("Not a block", 21, node.getNodeType());
            ExpressionStatement statement = (ExpressionStatement)node;
            int statementStart = statement.getStartPosition();
            int statementEnd = statementStart + statement.getLength() - 1;
            if (idx < 2) {
                Comment comment = (Comment)compilUnit.getCommentList().get(idx);
                int commentStart = comment.getStartPosition();
                statementEnd = commentStart + comment.getLength() - 1;
            }
            int extendedStart = compilUnit.getExtendedStartPosition((ASTNode)statement);
            this.assumeEquals("Statement " + statement + " does not start at the right position", statementStart, extendedStart);
            int extendedEnd = extendedStart + compilUnit.getExtendedLength((ASTNode)statement) - 1;
            this.assumeEquals("Statement " + statement + " does not end at the right position", statementEnd, extendedEnd);
            ++idx;
        }
    }

    public void testBug55223b() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug55223", "TestB.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit compilUnit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, compilUnit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 2, compilUnit.getCommentList().size());
        Comment comment = (Comment)compilUnit.getCommentList().get(1);
        int commentStart = comment.getStartPosition();
        ASTNode node = this.getASTNode(compilUnit, 0, 0);
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeEquals("Not a method declaration", 31, node.getNodeType());
        FunctionDeclaration method = (FunctionDeclaration)node;
        node = method.getReturnType();
        this.assumeNotNull("We should get a non-null ast node", node);
        this.assumeTrue("Not return type", node.getNodeType() == 43);
        SimpleType returnType = (SimpleType)node;
        int returnStart = compilUnit.getExtendedStartPosition((ASTNode)returnType);
        this.assumeEquals("Return type " + returnType + " does not start at the right position", commentStart, returnStart);
        int returnEnd = returnStart + compilUnit.getExtendedLength((ASTNode)returnType) - 1;
        this.assumeEquals("Return type " + returnType + " does not end at the right length", returnType.getStartPosition() + returnType.getLength() - 1, returnEnd);
    }

    public void testBug48489() throws JavaScriptModelException {
        this.verifyComments("testBug48489");
    }

    public void testBug50898() throws JavaScriptModelException {
        IJavaScriptUnit unit = this.getCompilationUnit("Converter", "src", "javadoc.testBug50898", "Test.js");
        this.packageBinding = false;
        this.verifyComments(unit);
    }

    public void testBug51226() throws JavaScriptModelException {
        IJavaScriptUnit[] units = this.getCompilationUnits("Converter", "src", "javadoc.testBug51226");
        int i = 0;
        while (i < units.length) {
            ASTNode result = this.runConversion(units[i], false);
            JavaScriptUnit unit = (JavaScriptUnit)result;
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, unit.getProblems().length);
            this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 1, unit.getCommentList().size());
            Comment comment = (Comment)unit.getCommentList().get(0);
            this.assumeTrue(String.valueOf(this.prefix) + "Comment should be a Javadoc one", comment.isDocComment());
            if (this.docCommentSupport.equals("enabled")) {
                JSdoc docComment = (JSdoc)comment;
                this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of tags", 1, docComment.tags().size());
                TagElement tagElement = (TagElement)docComment.tags().get(0);
                this.assumeNull(String.valueOf(this.prefix) + "Wrong type of tag [" + tagElement + "]", tagElement.getTagName());
                this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of fragments in tag [" + tagElement + "]", 1, tagElement.fragments().size());
                ASTNode fragment = (ASTNode)tagElement.fragments().get(0);
                this.assumeEquals(String.valueOf(this.prefix) + "Invalid type for fragment [" + fragment + "]", 66, fragment.getNodeType());
                TextElement textElement = (TextElement)fragment;
                this.assumeEquals(String.valueOf(this.prefix) + "Invalid content for text element ", "Test", textElement.getText());
                if (this.debug) {
                    System.out.println(docComment + "\nsuccessfully verified.");
                }
            }
            ++i;
        }
    }

    public void testBug51241() throws JavaScriptModelException {
        this.verifyComments("testBug51241");
    }

    public void testBug51363() throws JavaScriptModelException {
        this.sourceUnit = this.getCompilationUnit("Converter", "src", "javadoc.testBug51363", "Test.js");
        ASTNode result = this.runConversion(this.sourceUnit, false);
        JavaScriptUnit unit = (JavaScriptUnit)result;
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of problems", 0, unit.getProblems().length);
        this.assumeEquals(String.valueOf(this.prefix) + "Wrong number of comments", 2, unit.getCommentList().size());
        Comment comment = (Comment)unit.getCommentList().get(0);
        this.assumeTrue(String.valueOf(this.prefix) + "Comment should be a line comment ", comment.isLineComment());
        String sourceStr = this.sourceUnit.getSource();
        int startPos = comment.getStartPosition() + comment.getLength();
        this.assumeEquals("Wrong length for line comment " + comment, "\\u000D\\u000A", sourceStr.substring(startPos, startPos + 12));
        if (this.debug) {
            System.out.println(comment + "\nsuccessfully verified.");
        }
        comment = (Comment)unit.getCommentList().get(1);
        this.assumeTrue(String.valueOf(this.prefix) + "Comment should be a line comment", comment.isLineComment());
        sourceStr = this.sourceUnit.getSource();
        startPos = comment.getStartPosition() + comment.getLength();
        this.assumeEquals("Wrong length for line comment " + comment, "\\u000Dvoid", sourceStr.substring(startPos, startPos + 10));
        if (this.debug) {
            System.out.println(comment + "\nsuccessfully verified.");
        }
    }

    public void testBug51476() throws JavaScriptModelException {
        this.verifyComments("testBug51476");
    }

    public void testBug51478() throws JavaScriptModelException {
        this.verifyComments("testBug51478");
    }

    public void testBug51508() throws JavaScriptModelException {
        this.verifyComments("testBug51508");
    }

    public void testBug51650() throws JavaScriptModelException {
        this.verifyComments("testBug51650");
    }

    public void testBug51770() throws JavaScriptModelException {
        this.verifyComments("testBug51770");
    }

    public void testBug52908() throws JavaScriptModelException {
        this.verifyComments("testBug52908");
    }

    public void testBug52908a() throws JavaScriptModelException {
        this.verifyComments("testBug52908a");
    }

    public void testBug52908unicode() throws JavaScriptModelException {
        this.verifyComments("testBug52908unicode");
    }

    public void testBug53276() throws JavaScriptModelException {
        this.verifyComments("testBug53276");
    }

    public void testBug53075() throws JavaScriptModelException {
        IJavaScriptUnit unit = this.getCompilationUnit("Converter", "src", "javadoc.testBug53075", "X.js");
        boolean pb = this.packageBinding;
        this.packageBinding = false;
        JavaScriptUnit compilUnit = this.verifyComments(unit);
        if (this.docCommentSupport.equals("enabled")) {
            Comment comment = (Comment)compilUnit.getCommentList().get(0);
            this.assumeTrue(String.valueOf(this.prefix) + "Comment should be a javadoc comment ", comment.isDocComment());
            JSdoc docComment = (JSdoc)comment;
            TagElement tagElement = (TagElement)docComment.tags().get(0);
            this.assumeEquals("Wrong tag type!", "@link", tagElement.getTagName());
            tagElement = (TagElement)docComment.tags().get(1);
            this.assumeEquals("Wrong tag type!", "@linkplain", tagElement.getTagName());
        }
        this.packageBinding = pb;
    }

    public void testBug53757() throws JavaScriptModelException {
        this.verifyComments("testBug53757");
    }

    public void testBug51600() throws JavaScriptModelException {
        this.verifyComments("testBug51600");
    }

    public void testBug51617() throws JavaScriptModelException {
        this.stopOnFailure = false;
        String[] unbound = new String[]{"e"};
        this.verifyComments("testBug51617");
        if (this.docCommentSupport.equals("enabled")) {
            int size = unbound.length;
            int i = 0;
            int f = 0;
            while (i < size) {
                ASTConverterJavadocTest.assertTrue((String)"Invalid number of failures!", (this.failures.size() > f ? 1 : 0) != 0);
                String failure = (String)this.failures.get(f);
                String expected = "Reference '" + unbound[i] + "' should be bound!";
                if (expected.equals(failure.substring(failure.indexOf(32) + 1))) {
                    this.failures.remove(f);
                } else {
                    ++f;
                    --i;
                }
                ++i;
            }
        }
        this.stopOnFailure = true;
    }

    public void testBug54424() throws JavaScriptModelException {
        this.stopOnFailure = false;
        String[] unbound = new String[]{"tho", "from", "A#getList(int,long,boolean)", "#getList(Object,java.util.AbstractList)", "from", "#getList(int from,long tho)", "to"};
        this.verifyComments("testBug54424");
        if (this.docCommentSupport.equals("enabled")) {
            int size = unbound.length;
            int i = 0;
            int f = 0;
            while (i < size) {
                ASTConverterJavadocTest.assertTrue((String)"Invalid number of failures!", (this.failures.size() > f ? 1 : 0) != 0);
                String failure = (String)this.failures.get(f);
                String expected = "Reference '" + unbound[i] + "' should be bound!";
                if (expected.equals(failure.substring(failure.indexOf(32) + 1))) {
                    this.failures.remove(f);
                } else {
                    ++f;
                    --i;
                }
                ++i;
            }
        }
        this.stopOnFailure = true;
    }

    public void testBug63044() throws JavaScriptModelException {
        this.verifyComments("testBug63044");
    }

    public void testBug51660() throws JavaScriptModelException {
        this.stopOnFailure = false;
        IJavaScriptUnit unit = this.getCompilationUnit("Converter", "src", "javadoc.testBug51660", "Test.js");
        JavaScriptUnit compilUnit = this.verifyComments(unit);
        if (this.docCommentSupport.equals("enabled")) {
            String[] tagNames = new String[]{"@ejb", "@ejb", "@ejb", "@ejb", "@ejb", "@ejb", "@ejb(bean", "@ejb)bean", "@ejb", "@ejb+bean", "@ejb,bean", "@ejb-bean", "@ejb.bean", "@ejb/bean", "@ejb", "@ejb;bean", "@ejb", "@ejb=bean", "@ejb", "@ejb?bean", "@ejb@bean", "@ejb[bean", "@ejb\\bean", "@ejb]bean", "@ejb^bean", "@ejb`bean", "@ejb{bean", "@ejb|bean", "@ejb", "@ejb~bean", "@unknown"};
            String[] tagTexts = new String[]{"!bean test non-java id character '!' (val=33) in tag name", "\"bean test non-java id character '\"' (val=34) in tag name", "#bean test non-java id character '#' (val=35) in tag name", "%bean test non-java id character '%' (val=37) in tag name", "&bean test non-java id character '&' (val=38) in tag name", "'bean test non-java id character ''' (val=39) in tag name", " test non-java id character '(' (val=40) in tag name", " test non-java id character ')' (val=41) in tag name", "*bean test non-java id character '*' (val=42) in tag name", " test non-java id character '+' (val=43) in tag name", " test non-java id character ',' (val=44) in tag name", " test non-java id character '-' (val=45) in tag name", " test non-java id character '.' (val=46) in tag name", " test non-java id character '/' (val=47) in tag name", ":bean test non-java id character ':' (val=58) in tag name", " test non-java id character ';' (val=59) in tag name", "<bean test non-java id character '<' (val=60) in tag name", " test non-java id character '=' (val=61) in tag name", ">bean test non-java id character '>' (val=62) in tag name", " test non-java id character '?' (val=63) in tag name", " test non-java id character '@' (val=64) in tag name", " test non-java id character '[' (val=91) in tag name", " test non-java id character '\\' (val=92) in tag name", " test non-java id character ']' (val=93) in tag name", " test non-java id character '^' (val=94) in tag name", " test non-java id character '`' (val=96) in tag name", " test non-java id character '{' (val=123) in tag name", " test non-java id character '|' (val=124) in tag name", "}bean test non-java id character '}' (val=125) in tag name", " test non-java id character '~' (val=126) in tag name", " test java id"};
            Comment comment = (Comment)compilUnit.getCommentList().get(0);
            this.assumeTrue(String.valueOf(this.prefix) + "Comment should be a javadoc comment ", comment.isDocComment());
            JSdoc docComment = (JSdoc)comment;
            int size = docComment.tags().size();
            int i = 0;
            while (i < size) {
                TagElement tagElement = (TagElement)docComment.tags().get(i);
                this.assumeEquals("Wrong tag name for:" + tagElement, tagNames[i], tagElement.getTagName());
                this.assumeEquals("Wrong fragments size for :" + tagElement, 1, tagElement.fragments().size());
                ASTNode fragment = (ASTNode)tagElement.fragments().get(0);
                this.assumeEquals("Wrong fragments type for :" + tagElement, 66, fragment.getNodeType());
                TextElement textElement = (TextElement)fragment;
                this.assumeEquals("Wrong text for tag!", tagTexts[i], textElement.getText());
                ++i;
            }
        }
        this.stopOnFailure = true;
    }

    public void testBug65174() throws JavaScriptModelException {
        this.verifyComments("testBug65174");
    }

    public void testBug65253() throws JavaScriptModelException {
        this.verifyComments("testBug65253");
    }

    public void testBug65288() throws JavaScriptModelException {
        this.verifyComments("testBug65288");
    }

    public void testBug68017() throws JavaScriptModelException {
        this.verifyComments("testBug68017");
    }

    public void testBug68025() throws JavaScriptModelException {
        this.verifyComments("testBug68025");
    }

    public void testBug69272() throws JavaScriptModelException {
        this.verifyComments("testBug69272");
    }

    public void testBug69275() throws JavaScriptModelException {
        this.verifyComments("testBug69275");
    }

    public void testBug69302() throws JavaScriptModelException {
        this.verifyComments("testBug69302");
    }

    public void testBug68726() throws JavaScriptModelException {
        this.verifyComments("testBug68726");
    }

    public void testBug70892_JLS2() throws JavaScriptModelException {
        int level = this.astLevel;
        this.astLevel = 2;
        this.verifyComments("testBug70892");
        this.astLevel = level;
    }

    public void testBug70892_JLS3() throws JavaScriptModelException {
        int level = this.astLevel;
        this.astLevel = 3;
        this.verifyComments("testBug70892");
        this.astLevel = level;
    }

    public void testBug51911() throws JavaScriptModelException {
        this.verifyComments("testBug51911");
    }

    public void testBug73348() throws JavaScriptModelException {
        this.verifyComments("testBug73348");
    }

    public void testBug77644() throws JavaScriptModelException {
        this.verifyComments("testBug77644");
    }

    public void testBug79809() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/javadoc/b79809/Test.js", "package javadoc.b79809;\n/**\n * @param <E>  Class type parameter\n * @see Object\n */\npublic class Test<E> {\n\t/**\n\t * @param t\n\t * @param <T> Method type parameter\n\t */\n\t<T> void foo(T t) {}\n}\n");
        this.verifyWorkingCopiesComments();
    }

    public void testBug79809b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/javadoc/b79809/Test.js", "package javadoc.b79809;\n\n/**\n * New tags for 5.0\n *  - literal: {@literal a<B>c}\n *  - code: {@code abc}\n *  - value: {@value System#out}\n */\npublic class Test {\n\n}\n");
        this.verifyWorkingCopiesComments();
    }

    public void testBug79904() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/javadoc/b79904/Test.js", "package javadoc.b79904;\n/**\n * @param <E>\n * @see Object\n */\npublic class Test<E> {\n\t/**\n\t * @param t\n\t * @param <T>\n\t */\n\t<T> void foo(T t) {}\n}\n");
        this.verifyWorkingCopiesComments();
    }

    public void testBug80221() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/javadoc/b80221/Test.js", "package javadoc.b80221;\npublic class Test {\n\t/**\n\t * @see Object Unknown: ref is not resolved due to compile error...\n\t */\n\tpublic foo() {\n\t\treturn 1;\n\t}\n}\n");
        this.verifyWorkingCopiesComments();
    }

    public void testBug80257() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b80257/Test.js", "package javadoc.b80257;\nimport java.util.*;\npublic class Test {\n\t/**\n\t * @see ArrayList\n\t * @return {@link java.util.List}\n\t */\n\tList<String> getList() {\n\t\treturn new ArrayList<String>();\n\t}\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            TagElement firstTag = (TagElement)docComment.tags().get(0);
            TagElement secondTag = (TagElement)docComment.tags().get(1);
            TagElement inlineTag = (TagElement)secondTag.fragments().get(1);
            ASTConverterJavadocTest.assertEquals((String)("Invalid number of fragments for tag element: " + firstTag), (int)1, (int)firstTag.fragments().size());
            ASTNode node = (ASTNode)firstTag.fragments().get(0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid kind of name reference for tag element: " + firstTag), (int)42, (int)node.getNodeType());
            SimpleName seeRef = (SimpleName)node;
            IBinding binding = seeRef.resolveBinding();
            ASTConverterJavadocTest.assertTrue((String)"Wrong kind of binding", (boolean)(binding instanceof ITypeBinding));
            ASTConverterJavadocTest.assertEquals((String)("Invalid number of fragments for inline tag element: " + inlineTag), (int)1, (int)inlineTag.fragments().size());
            node = (ASTNode)inlineTag.fragments().get(0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid kind of name reference for tag element: " + inlineTag), (int)40, (int)node.getNodeType());
            QualifiedName linkRef = (QualifiedName)node;
            binding = linkRef.resolveBinding();
            ASTConverterJavadocTest.assertTrue((String)"Wrong kind of binding", (boolean)(binding instanceof ITypeBinding));
        }
    }

    public void testBug83804() throws CoreException, JavaScriptModelException {
        this.astLevel = 3;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getCompilationUnit("Converter15", "src", "javadoc.b83804", "package-info.js");
        this.workingCopies[1] = this.getCompilationUnit("Converter15", "src", "javadoc.b83804", "Test.js");
        this.verifyWorkingCopiesComments();
    }

    public void testBug83804a() throws CoreException, JavaScriptModelException {
        this.astLevel = 3;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getCompilationUnit("Converter15", "src", "javadoc.b83804a", "package-info.js");
        this.workingCopies[1] = this.getCompilationUnit("Converter15", "src", "javadoc.b83804a", "Test.js");
        this.verifyWorkingCopiesComments();
    }

    public void testBug84049() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b84049/Test.js", "package javadoc.b84049;\npublic class Test {\n\t/**\n\t * @see Object\n\t */\n\tfoo() {\n\t}\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            JSdoc methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            int javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            SimpleName methodName = methodDeclaration.getName();
            int nameStart = methodName.getStartPosition();
            ASTConverterJavadocTest.assertTrue((String)"Method simple name should not include javadoc comment", (nameStart > javadocStart + methodJavadoc.getLength() ? 1 : 0) != 0);
            int extendedStart = compilUnit.getExtendedStartPosition((ASTNode)methodName);
            ASTConverterJavadocTest.assertEquals((String)"Method simple name start position should not be extended!", (int)nameStart, (int)extendedStart);
            int extendedLength = compilUnit.getExtendedLength((ASTNode)methodName);
            ASTConverterJavadocTest.assertEquals((String)"Method simple name length should not be extended!", (int)methodName.getLength(), (int)extendedLength);
        }
    }

    public void testBug87845() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b87845/Test.js", "package javadoc.b87845;\npublic class Test {\n\tpublic void foo(int a, int b) {} \n\tpublic void foo(int a, int... args) {}\n\tpublic void foo(String... args) {}\n\tpublic void foo(Exception str, boolean... args) {}\n\t/**\n\t* @see Test#foo(int, int)\n\t* @see Test#foo(int, int[])\n\t* @see Test#foo(int, int...)\n\t* @see Test#foo(String[])\n\t* @see Test#foo(String...)\n\t* @see Test#foo(Exception, boolean[])\n\t* @see Test#foo(Exception, boolean...)\n\t*/\n\tpublic void valid() {}\n\t/**\n\t* @see Test#foo(int)\n\t* @see Test#foo(int, int, int)\n\t* @see Test#foo()\n\t* @see Test#foo(String)\n\t* @see Test#foo(String, String)\n\t* @see Test#foo(Exception)\n\t* @see Test#foo(Exception, boolean)\n\t* @see Test#foo(Exception, boolean, boolean)\n\t*/\n\tpublic void invalid() {}\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            List tags = docComment.tags();
            int size = tags.size();
            int i = 0;
            while (i < size) {
                TagElement tag = (TagElement)docComment.tags().get(i);
                ASTConverterJavadocTest.assertEquals((String)("Invalid number of fragment for see reference: " + tag), (int)1, (int)tag.fragments().size());
                ASTNode node = (ASTNode)tag.fragments().get(0);
                ASTConverterJavadocTest.assertEquals((String)("Invalid kind of name reference for tag element: " + tag), (int)68, (int)node.getNodeType());
                FunctionRef methodRef = (FunctionRef)node;
                List parameters = methodRef.parameters();
                int paramSize = parameters.size();
                int j = 0;
                while (j < paramSize) {
                    node = (ASTNode)parameters.get(j);
                    ASTConverterJavadocTest.assertEquals((String)("Invalid kind of method parameter: " + node), (int)69, (int)node.getNodeType());
                    FunctionRefParameter parameter = (FunctionRefParameter)node;
                    if (j == paramSize - 1) {
                        switch (i) {
                            case 2: 
                            case 4: 
                            case 6: {
                                ASTConverterJavadocTest.assertTrue((String)("Method parameter \"" + parameter + "\" should be varargs!"), (boolean)parameter.isVarargs());
                                break;
                            }
                            default: {
                                ASTConverterJavadocTest.assertFalse((String)("Method parameter \"" + parameter + "\" should not be varargs!"), (boolean)parameter.isVarargs());
                                break;
                            }
                        }
                    } else {
                        ASTConverterJavadocTest.assertFalse((String)("Method parameter \"" + parameter + "\" should not be varargs!"), (boolean)parameter.isVarargs());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void testBug93880_15a() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/Test.js", "/**\n * Javadoc\n */\npackage javadoc.b93880;\npublic class Test {\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertTrue((String)"Javadoc should be set on package declaration", (docComment == packDecl.getJavadoc() ? 1 : 0) != 0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_15b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertTrue((String)"Javadoc should be set on package declaration", (docComment == packDecl.getJavadoc() ? 1 : 0) != 0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_15c() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\nprivate package javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertTrue((String)"Javadoc should be set on package declaration", (docComment == packDecl.getJavadoc() ? 1 : 0) != 0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_15d() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\n@Deprecated\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            ASTConverterJavadocTest.assertNotNull((String)"Compilation unit should have a package declaration", (Object)packDecl);
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertTrue((String)"Javadoc should be set on package declaration", (docComment == packDecl.getJavadoc() ? 1 : 0) != 0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_15e() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/* (non-javadoc)\n * No comment\n */\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertNull((String)"Package declaration should not have any javadoc", (Object)packDecl.getJavadoc());
            ASTConverterJavadocTest.assertTrue((String)"Source range of PackageDeclaration should NOT include Javadoc child", (packDecl.getStartPosition() > comment.getStartPosition() + comment.getLength() ? 1 : 0) != 0);
        }
    }

    public void testBug93880_14a() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/Test.js", "/**\n * Javadoc\n */\npackage javadoc.b93880;\npublic class Test {\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_14b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_14c() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\nprivate package javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_14d() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/**\n * Javadoc for all package\n */\n@Deprecated\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            ASTConverterJavadocTest.assertNotNull((String)"Compilation unit should have a package declaration", (Object)packDecl);
            JSdoc docComment = (JSdoc)compilUnit.getCommentList().get(0);
            ASTConverterJavadocTest.assertEquals((String)"Source range of PackageDeclaration should include Javadoc child", (int)docComment.getStartPosition(), (int)packDecl.getStartPosition());
        }
    }

    public void testBug93880_14e() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b93880/package-info.js", "/* (non-javadoc)\n * No comment\n */\npackage javadoc.b93880;");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            PackageDeclaration packDecl = compilUnit.getPackage();
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertTrue((String)"Source range of PackageDeclaration should NOT not include Javadoc child", (packDecl.getStartPosition() > comment.getStartPosition() + comment.getLength() ? 1 : 0) != 0);
        }
    }

    public void testBug99507() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b99507/X.js", "package javadoc.b99507;\npublic class X {\n}\n/** @param test*/");
        this.verifyComments(this.workingCopies[0]);
    }

    public void testBug99507b() throws JavaScriptModelException {
        String source = "/**\n@param country*/";
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(source.toCharArray());
        parser.createAST(null);
    }

    public void testBug100041() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b100041/X.js", "package javadoc.b100041;\nclass X {\n\tstatic Object object;\n\tstatic void foo() {\n\t\t/**\n\t\t * javadoc comment.\n\t\t */\n\t\tif (object instanceof String) {\n\t\t\tfinal String clr = null;\n\t\t}\n\t}\n}");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            int commentStart = comment.getStartPosition();
            int commentEnd = commentStart + comment.getLength();
            ASTNode node = this.getASTNode(compilUnit, 0, 1, 0);
            ASTConverterJavadocTest.assertEquals((String)("Expected if statement for node: " + node), (int)25, (int)node.getNodeType());
            IfStatement ifStatement = (IfStatement)node;
            ASTConverterJavadocTest.assertTrue((String)("Invalid start position for IfStatement: " + ifStatement), (ifStatement.getStartPosition() > commentEnd ? 1 : 0) != 0);
            Statement statement = ifStatement.getThenStatement();
            ASTConverterJavadocTest.assertEquals((String)("Expected block for node: " + statement), (int)8, (int)statement.getNodeType());
            Block block = (Block)statement;
            ASTConverterJavadocTest.assertTrue((String)("Invalid start position for Block: " + block), (block.getStartPosition() > commentEnd ? 1 : 0) != 0);
            List statements = block.statements();
            ASTConverterJavadocTest.assertEquals((String)("Invalid number of statements for block: " + block), (int)1, (int)statements.size());
            statement = (Statement)statements.get(0);
            ASTConverterJavadocTest.assertEquals((String)("Expected variable declaration statement for node: " + statement), (int)60, (int)statement.getNodeType());
            VariableDeclarationStatement varDecl = (VariableDeclarationStatement)statement;
            ASTConverterJavadocTest.assertTrue((String)("Invalid start position for : VariableDeclarationStatement" + varDecl), (varDecl.getStartPosition() > commentEnd ? 1 : 0) != 0);
        }
    }

    public void testBug100041b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b100041/X.js", "package javadoc.b100041;\nclass X {\n\tstatic Object object;\n\tstatic void foo() {\n\t\t/**\n\t\t * javadoc comment.\n\t\t */\n\t\tif (object instanceof String)\n\t\t\treturn;\n\t}\n}");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            int commentStart = comment.getStartPosition();
            int commentEnd = commentStart + comment.getLength();
            ASTNode node = this.getASTNode(compilUnit, 0, 1, 0);
            ASTConverterJavadocTest.assertEquals((String)("Expected if statement for node: " + node), (int)25, (int)node.getNodeType());
            IfStatement ifStatement = (IfStatement)node;
            ASTConverterJavadocTest.assertTrue((String)("Invalid start position for IfStatement: " + ifStatement), (ifStatement.getStartPosition() > commentEnd ? 1 : 0) != 0);
            Statement statement = ifStatement.getThenStatement();
            ASTConverterJavadocTest.assertEquals((String)("Expected block for node: " + statement), (int)41, (int)statement.getNodeType());
            ReturnStatement returnStatement = (ReturnStatement)statement;
            ASTConverterJavadocTest.assertTrue((String)("Invalid start position for Block: " + returnStatement), (returnStatement.getStartPosition() > commentEnd ? 1 : 0) != 0);
        }
    }

    public void testBug100041c() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b100041/Z.js", "package javadoc.b100041;\npublic class Z {\n\t/** C1 */\n\tclass Z1 {}\n\t/** C2 */\n\tZ1 z1;\n\t/** C3 */\n\tpublic static void foo(Object object) {\n\t\t/** C4 */\n\t\tclass ZZ {\n\t\t\t/** C5 */\n\t\t\tZZ zz;\n\t\t\t/** C6 */\n\t\t\tpublic void bar() {}\n\t\t}\n\t}\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            int size = unitComments.size();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)6, (int)size);
            JSdoc[] javadocs = new JSdoc[size];
            Iterator iterator = unitComments.iterator();
            int i = 0;
            while (i < size) {
                Comment comment = (Comment)iterator.next();
                ASTConverterJavadocTest.assertEquals((String)("Expect javadoc for comment: " + comment), (int)29, (int)comment.getNodeType());
                javadocs[i] = (JSdoc)comment;
                ++i;
            }
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Expected type declaration for node: " + node), (int)55, (int)node.getNodeType());
            TypeDeclaration typeDeclaration = (TypeDeclaration)node;
            int javadocStart = javadocs[0].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for TypeDeclaration: " + typeDeclaration), (int)typeDeclaration.getStartPosition(), (int)javadocStart);
            node = this.getASTNode(compilUnit, 0, 1);
            ASTConverterJavadocTest.assertEquals((String)("Expected field declaration for node: " + node), (int)23, (int)node.getNodeType());
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            javadocStart = javadocs[1].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for FieldDeclaration: " + fieldDeclaration), (int)fieldDeclaration.getStartPosition(), (int)javadocStart);
            node = this.getASTNode(compilUnit, 0, 2);
            ASTConverterJavadocTest.assertEquals((String)("Expected method declaration for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            javadocStart = javadocs[2].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for FunctionDeclaration: " + methodDeclaration), (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            node = this.getASTNode(compilUnit, 0, 2, 0);
            ASTConverterJavadocTest.assertEquals((String)("Expected type declaration for node: " + node), (int)56, (int)node.getNodeType());
            typeDeclaration = (TypeDeclaration)((TypeDeclarationStatement)node).getDeclaration();
            javadocStart = javadocs[3].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for TypeDeclaration: " + typeDeclaration), (int)typeDeclaration.getStartPosition(), (int)javadocStart);
            List bodyDeclarations = typeDeclaration.bodyDeclarations();
            node = (ASTNode)bodyDeclarations.get(0);
            ASTConverterJavadocTest.assertEquals((String)("Expected field declaration for node: " + node), (int)23, (int)node.getNodeType());
            fieldDeclaration = (FieldDeclaration)node;
            javadocStart = javadocs[4].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for FieldDeclaration: " + fieldDeclaration), (int)fieldDeclaration.getStartPosition(), (int)javadocStart);
            node = (ASTNode)bodyDeclarations.get(1);
            ASTConverterJavadocTest.assertEquals((String)("Expected method declaration for node: " + node), (int)31, (int)node.getNodeType());
            methodDeclaration = (FunctionDeclaration)node;
            javadocStart = javadocs[5].getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)("Invalid start position for FunctionDeclaration: " + methodDeclaration), (int)methodDeclaration.getStartPosition(), (int)javadocStart);
        }
    }

    public void testBug103304() throws JavaScriptModelException {
        this.packageBinding = false;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b103304/Test.js", "package javadoc.b103304;\ninterface IAFAState {\n    public class ValidationException extends Exception {\n        public ValidationException(String variableName, IAFAState subformula) {\n            super(\"Variable '\"+variableName+\"' may be unbound in '\"+subformula+\"'\");\n        }\n    }\n}\npublic class Test {\n\t/**\n\t * @see IAFAState.ValidationException#IAFAState.ValidationException(String, IAFAState)\n\t */\n\tIAFAState.ValidationException valid;\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            Iterator unitComments = compilUnit.getCommentList().iterator();
            while (unitComments.hasNext()) {
                Comment comment = (Comment)unitComments.next();
                ASTConverterJavadocTest.assertEquals((String)"Comment should be javadoc", (int)comment.getNodeType(), (int)29);
                JSdoc javadoc = (JSdoc)comment;
                List tags = javadoc.tags();
                int size = tags.size();
                int i = 0;
                while (i < size) {
                    TagElement tag = (TagElement)javadoc.tags().get(i);
                    ASTConverterJavadocTest.assertEquals((String)("Invalid number of fragment for see reference: " + tag), (int)1, (int)tag.fragments().size());
                    ASTNode node = (ASTNode)tag.fragments().get(0);
                    ASTConverterJavadocTest.assertEquals((String)("Invalid kind of name reference for tag element: " + tag), (int)68, (int)node.getNodeType());
                    ++i;
                }
            }
        }
    }

    public void testBug106581() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b106581/A.js", "package javadoc.b106581;\npublic class A {\n    /**\n     * @param x\n     */ \n     public void foo(int x) {},\n}\n");
        JavaScriptUnit compilUnit = this.verifyComments(this.workingCopies[0]);
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertEquals((String)"Comment should be javadoc", (int)comment.getNodeType(), (int)29);
            JSdoc docComment = (JSdoc)comment;
            TagElement tag = (TagElement)docComment.tags().get(0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid number of fragment for tag: " + tag), (int)1, (int)tag.fragments().size());
            ASTNode node = (ASTNode)tag.fragments().get(0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid kind of name reference for tag element: " + tag), (int)42, (int)node.getNodeType());
            SimpleName simpleName = (SimpleName)node;
            ASTConverterJavadocTest.assertNotNull((String)("We should have a type binding for simple name: " + simpleName), (Object)simpleName.resolveTypeBinding());
        }
    }

    public void testBug108622() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b108622/Test.js", "package javadoc.b108622;\n/**\n * \n */\npublic abstract class Test {\n\n\t/**\n\t * \n\t */\n\tpublic abstract Zork getFoo();\n\n\t/**\n\t * \n\t */\n\tpublic abstract void setFoo(Zork dept);\n\n}");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            ASTConverterJavadocTest.assertEquals((String)"Invalid method name", (String)"getFoo", (String)methodDeclaration.getName().toString());
            JSdoc methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            int javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            node = this.getASTNode(compilUnit, 0, 1);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            methodDeclaration = (FunctionDeclaration)node;
            ASTConverterJavadocTest.assertEquals((String)"Invalid method name", (String)"setFoo", (String)methodDeclaration.getName().toString());
            methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
        }
    }

    public void testBug113108a() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b113108/Test.js", "package javadoc.b113108;\n/** C0 */\npublic class Test {\n\t/* C1 */\n\t/** C2 */\n\t// C3\n\tpublic void foo() {\n\t\t/* C4 */\n\t}\n\t/* C5 */\n\t/** C6 */\n\t// C7\n}");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            ASTConverterJavadocTest.assertEquals((String)"Invalid method name", (String)"foo", (String)methodDeclaration.getName().toString());
            JSdoc methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            int javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            int index = compilUnit.firstLeadingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid first leading comment for " + methodDeclaration), (int)1, (int)index);
            index = compilUnit.lastTrailingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid last trailing comment for " + methodDeclaration), (int)7, (int)index);
        }
    }

    public void testBug113108b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b113108/Test.js", "package javadoc.b113108;\n/** C0 */\npublic class Test {\n\t/** C1 */\n\t// C2\n\t/* C3 */\n\tpublic void foo() {\n\t\t// C4\n\t}\n\t/** C5 */\n\t/// C6\n\t/* C7 */\n}");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            ASTConverterJavadocTest.assertEquals((String)"Invalid method name", (String)"foo", (String)methodDeclaration.getName().toString());
            JSdoc methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            int javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            int index = compilUnit.firstLeadingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid first leading comment for " + methodDeclaration), (int)1, (int)index);
            index = compilUnit.lastTrailingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid last trailing comment for " + methodDeclaration), (int)7, (int)index);
        }
    }

    public void testBug113108c() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b113108/Test.js", "package javadoc.b113108;\n/** C0 */\npublic class Test {\n\t// C1\n\t/* C2 */\n\t/** C3 */\n\tpublic void foo() {\n\t\t/** C4 */\n\t}\n\t// C5\n\t/* C6 */\n\t/** C7 */\n}");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)31, (int)node.getNodeType());
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
            ASTConverterJavadocTest.assertEquals((String)"Invalid method name", (String)"foo", (String)methodDeclaration.getName().toString());
            JSdoc methodJavadoc = methodDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"FunctionDeclaration have a javadoc comment", (Object)methodJavadoc);
            int javadocStart = methodJavadoc.getStartPosition();
            ASTConverterJavadocTest.assertEquals((String)"Method declaration should include javadoc comment", (int)methodDeclaration.getStartPosition(), (int)javadocStart);
            int index = compilUnit.firstLeadingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid first leading comment for " + methodDeclaration), (int)1, (int)index);
            index = compilUnit.lastTrailingCommentIndex((ASTNode)methodDeclaration);
            ASTConverterJavadocTest.assertEquals((String)("Invalid last trailing comment for " + methodDeclaration), (int)7, (int)index);
        }
    }

    public void testBug125676() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b125676/A.js", "package javadoc.b125676;\npublic class A {\n        /**\n         * @category \n         * When searching for field matches, it will exclusively find read accesses, as\n         * opposed to write accesses. Note that some expressions are considered both\n         * as field read/write accesses: for example, x++; x+= 1;\n         * \n         * @since 2.0\n         */\n        int READ_ACCESSES = 4;\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/Converter15/src/javadoc/b125676/B.js", "package javadoc.b125676;\npublic class B {\n        /**\n         * @category test\n         */\n        int field1;\n        /**\n         * @category     test\n         */\n        int field2;\n        /**\n         * @category test    \n         */\n        int field3;\n        /**\n         * @category    test    \n         */\n        int field4;\n        /** @category test */\n        int field5;\n\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/Converter15/src/javadoc/b125676/C.js", "package javadoc.b125676;\npublic class C { \n        /**\n         * @category test mutli ids\n         */\n        int field1;\n        /**\n         * @category    test    mutli    ids   \n         */\n        int field2;\n        /** @category    test    mutli    ids*/\n        int field3;\n}\n");
        this.verifyWorkingCopiesComments();
    }

    public void testBug125903() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.astLevel = 3;
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b125903/Test.js", "package javadoc.b125903;\n/**\n * {@ link java.lang.String}\n * @ since 2.1\n */\npublic class Test {\n\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            ASTNode node = this.getASTNode(compilUnit, 0);
            ASTConverterJavadocTest.assertEquals((String)("Invalid type for node: " + node), (int)55, (int)node.getNodeType());
            TypeDeclaration typeDeclaration = (TypeDeclaration)node;
            JSdoc javadoc = typeDeclaration.getJavadoc();
            ASTConverterJavadocTest.assertNotNull((String)"TypeDeclaration should have a javadoc comment", (Object)javadoc);
            List tags = javadoc.tags();
            TagElement tag = (TagElement)tags.get(0);
            tag = (TagElement)tag.fragments().get(0);
            ASTConverterJavadocTest.assertEquals((String)"Tag name should be empty", (String)tag.getTagName(), (String)"@");
            tag = (TagElement)tags.get(1);
            ASTConverterJavadocTest.assertEquals((String)"Tag name should be empty", (String)tag.getTagName(), (String)"@");
        }
    }

    public void testBug130752() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b130752/Test.js", "/* Ceci n'est pas\n * une ligne. */\npackage javadoc.b130752;\npublic class Test {\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertEquals((String)"Comment should be javadoc", (int)comment.getNodeType(), (int)64);
        }
    }

    public void testBug130752b() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b130752/Test.js", "// Line comment\npackage javadoc.b130752;\npublic class Test {\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertEquals((String)"Comment should be javadoc", (int)comment.getNodeType(), (int)63);
        }
    }

    public void testBug130752c() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter15/src/javadoc/b130752/Test.js", "/** Javadoc comment */\npackage javadoc.b130752;\npublic class Test {\n}\n");
        JavaScriptUnit compilUnit = (JavaScriptUnit)this.runConversion(this.workingCopies[0], true);
        this.verifyWorkingCopiesComments();
        if (this.docCommentSupport.equals("enabled")) {
            List unitComments = compilUnit.getCommentList();
            ASTConverterJavadocTest.assertEquals((String)"Wrong number of comments", (int)1, (int)unitComments.size());
            Comment comment = (Comment)unitComments.get(0);
            ASTConverterJavadocTest.assertEquals((String)"Comment should be javadoc", (int)comment.getNodeType(), (int)29);
        }
    }
}

