/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter.comment;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.core.tests.formatter.comment.CommentTestCase;

public class JavaDocTestCase
extends CommentTestCase {
    protected static final String INFIX = " * ";
    protected static final String POSTFIX = " */";
    protected static final String PREFIX = "/**";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.formatter.comment.JavaDocTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaDocTestCase.buildTestSuite(clazz);
    }

    public JavaDocTestCase(String name) {
        super(name);
    }

    protected int getCommentKind() {
        return 64;
    }

    public void testSingleLineComment1() {
        JavaDocTestCase.assertEquals((String)(PREFIX + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/**\t\t" + DELIMITER + "*\t test*/"));
    }

    public void testSingleLineComment2() {
        JavaDocTestCase.assertEquals((String)(PREFIX + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/**test" + DELIMITER + "\t" + POSTFIX));
    }

    public void testSingleLineComment3() {
        JavaDocTestCase.assertEquals((String)(PREFIX + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat(PREFIX + DELIMITER + "* test\t*/"));
    }

    public void testSingleLineComment4() {
        JavaDocTestCase.assertEquals((String)(PREFIX + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/**test" + DELIMITER + POSTFIX));
    }

    public void testSingleLineCommentSpace1() {
        JavaDocTestCase.assertEquals((String)"/** test */", (String)this.testFormat("/**test*/"));
    }

    public void testSingleLineCommentSpace2() {
        JavaDocTestCase.assertEquals((String)"/** test */", (String)this.testFormat("/**test */"));
    }

    public void testSingleLineCommentSpace3() {
        JavaDocTestCase.assertEquals((String)"/** test */", (String)this.testFormat("/**test*/"));
    }

    public void testSingleLineCommentSpace4() {
        JavaDocTestCase.assertEquals((String)"/** test test */", (String)this.testFormat("/** test   test*/"));
    }

    public void testSingleLineCommentTabs1() {
        JavaDocTestCase.assertEquals((String)"/** test test */", (String)this.testFormat("/**\ttest\ttest */"));
    }

    public void testSingleLineCommentTabs2() {
        JavaDocTestCase.assertEquals((String)"/** test test */", (String)this.testFormat("/**\ttest\ttest*/"));
    }

    public void testMultiLineCommentBreak1() {
        String input = "/** test<br>test */";
        String expected = PREFIX + DELIMITER + INFIX + "test<br>" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)expected, (String)this.testFormat(input));
    }

    public void testMultiLineCommentCodeSnippet1() {
        String prefix = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX;
        String postfix = String.valueOf(DELIMITER) + INFIX + "</pre>" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + "while (i != 0) i--;" + postfix;
        String expected = String.valueOf(prefix) + "while (i != 0)" + DELIMITER + INFIX + "\ti--;" + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentCodeSnippet2() {
        String prefix = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX;
        String postfix = String.valueOf(DELIMITER) + INFIX + "</pre>" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + "while (i != 0) { i--; }" + postfix;
        String expected = String.valueOf(prefix) + "while (i != 0) {" + DELIMITER + INFIX + "\ti--;" + DELIMITER + INFIX + "}" + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentCodeSnippet3() {
        String input = PREFIX + DELIMITER + "<pre>" + DELIMITER + "while (i != 0)" + DELIMITER + "i--;" + DELIMITER + "</pre>" + DELIMITER + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX + "while (i != 0)" + DELIMITER + INFIX + "\ti--;" + DELIMITER + INFIX + "</pre>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentCodeSnippetHtmlEntities1() {
        String prefix = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX;
        String postfix = String.valueOf(DELIMITER) + INFIX + "</pre>" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + "System.out.println(\"test\");" + postfix;
        String expected = String.valueOf(prefix) + "System.out.println(&quot;test&quot;);" + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentIndentTabs1() {
        String prefix = "public class Test {" + DELIMITER + "\t\t";
        String content = PREFIX + DELIMITER + "\t\t\t" + INFIX + "test test" + DELIMITER + "\t\t\t\t" + POSTFIX;
        String postfix = String.valueOf(DELIMITER) + "}";
        String expected = PREFIX + DELIMITER + "\t\t" + INFIX + "test test" + DELIMITER + "\t\t" + POSTFIX;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        JavaDocTestCase.assertEquals((String)(String.valueOf(prefix) + expected + postfix), (String)this.testFormat(String.valueOf(prefix) + content + postfix, prefix.length(), content.length()));
    }

    public void testMultiLineCommentIndentSpaces1() {
        String prefix = "public class Test {" + DELIMITER + "\t";
        String content = PREFIX + DELIMITER + "\t\t" + INFIX + "test test" + DELIMITER + "        " + POSTFIX;
        String postfix = String.valueOf(DELIMITER) + "}";
        String expected = PREFIX + DELIMITER + "   " + INFIX + "test test" + DELIMITER + "   " + POSTFIX;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "3");
        JavaDocTestCase.assertEquals((String)(String.valueOf(prefix) + expected + postfix), (String)this.testFormat(String.valueOf(prefix) + content + postfix, prefix.length(), content.length()));
    }

    public void testMultiLineCommentIndentSpaces2() {
        String prefix = "public class Test {" + DELIMITER + "    ";
        String content = PREFIX + DELIMITER + "\t\t" + INFIX + "test test" + DELIMITER + "        " + POSTFIX;
        String postfix = String.valueOf(DELIMITER) + "}";
        String expected = PREFIX + DELIMITER + "      " + INFIX + "test test" + DELIMITER + "      " + POSTFIX;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "3");
        JavaDocTestCase.assertEquals((String)(String.valueOf(prefix) + expected + postfix), (String)this.testFormat(String.valueOf(prefix) + content + postfix, prefix.length(), content.length()));
    }

    public void testMultiLineCommentIndentSpaces3() {
        String prefix = "public class Test {" + DELIMITER + "  \t  ";
        String content = PREFIX + DELIMITER + "\t\t" + INFIX + "test test" + DELIMITER + "        " + POSTFIX;
        String postfix = String.valueOf(DELIMITER) + "}";
        String expected = PREFIX + DELIMITER + "      " + INFIX + "test test" + DELIMITER + "      " + POSTFIX;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "3");
        JavaDocTestCase.assertEquals((String)(String.valueOf(prefix) + expected + postfix), (String)this.testFormat(String.valueOf(prefix) + content + postfix, prefix.length(), content.length()));
    }

    public void testMultiLineCommentIndentSpaces4() {
        String prefix = "public class Test {" + DELIMITER + "   \t   ";
        String content = PREFIX + DELIMITER + "\t\t" + INFIX + "test test" + DELIMITER + "        " + POSTFIX;
        String postfix = String.valueOf(DELIMITER) + "}";
        String expected = PREFIX + DELIMITER + "         " + INFIX + "test test" + DELIMITER + "         " + POSTFIX;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "3");
        JavaDocTestCase.assertEquals((String)(String.valueOf(prefix) + expected + postfix), (String)this.testFormat(String.valueOf(prefix) + content + postfix, prefix.length(), content.length()));
    }

    public void testMultiLineCommentBlankLineAfterPre1() {
        String input = PREFIX + DELIMITER + INFIX + "<pre></pre>" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "<pre></pre>" + DELIMITER + INFIX + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentLineBreakBeforeImmutableRegions1() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "22");
        String expected = input = PREFIX + DELIMITER + INFIX + "a <code>test</code>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentLineBreakBeforeImmutableRegions2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "21");
        String input = PREFIX + DELIMITER + INFIX + "a <code>test</code>" + DELIMITER + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "a" + DELIMITER + INFIX + "<code>test</code>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentLineBreakBeforeImmutableRegions3() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "20");
        String expected = input = PREFIX + DELIMITER + INFIX + "a <code>" + DELIMITER + INFIX + "testestestestestestestestestest" + DELIMITER + INFIX + "</code>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags1() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "do not insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        String expected = input = PREFIX + DELIMITER + INFIX + "Description" + DELIMITER + INFIX + "@param test" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "true");
        String prefix = PREFIX + DELIMITER + INFIX + "Description";
        String postfix = String.valueOf(DELIMITER) + INFIX + "@param test" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags3() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "true");
        String expected = input = PREFIX + DELIMITER + INFIX + "Description" + DELIMITER + INFIX + DELIMITER + INFIX + "@param test" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags4() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "do not insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "true");
        String prefix = PREFIX + DELIMITER + INFIX + "Description";
        String postfix = String.valueOf(DELIMITER) + INFIX + "@param test" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String expected = String.valueOf(prefix) + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags5() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "do not insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines", "false");
        String expected = input = PREFIX + DELIMITER + INFIX + "Description" + DELIMITER + INFIX + "@param test" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags6() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines", "true");
        String prefix = PREFIX + DELIMITER + INFIX + "Description";
        String postfix = String.valueOf(DELIMITER) + INFIX + "@param test" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags7() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines", "true");
        String expected = input = PREFIX + DELIMITER + INFIX + "Description" + DELIMITER + INFIX + DELIMITER + INFIX + "@param test" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineCommentBlankLineBeforeJavadoctags8() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.insert_new_line_before_root_tags", "do not insert");
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines", "true");
        String prefix = PREFIX + DELIMITER + INFIX + "Description";
        String postfix = String.valueOf(DELIMITER) + INFIX + "@param test" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String expected = String.valueOf(prefix) + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testLineBreaksBetweenEmptyJavaDocTags1() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        String expected = input = PREFIX + DELIMITER + INFIX + "@custom1" + DELIMITER + INFIX + DELIMITER + INFIX + "@custom2" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testLineBreaksBetweenEmptyJavaDocTags2() {
        String input;
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        String expected = input = PREFIX + DELIMITER + INFIX + "@custom1" + DELIMITER + INFIX + "@custom2" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testNoChange1() {
        String content = PREFIX + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testNoFormat1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "false");
        String content = PREFIX + DELIMITER + INFIX + "test" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testNoFormat2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_comments", "false");
        String content = PREFIX + DELIMITER + INFIX + "test" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testInlineTag1() {
        String input;
        String expected = input = PREFIX + DELIMITER + INFIX + "{@link Object} has many methods." + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testInlineTag2() {
        String input;
        String expected = input = PREFIX + DELIMITER + INFIX + "{@link Object}s are cool." + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultilineInlineTag1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "20");
        String prefix = PREFIX + DELIMITER + INFIX + "{@link Object}";
        String postfix = "has many methods." + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + " " + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultilineInlineTag2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "20");
        String prefix = PREFIX + DELIMITER + INFIX + "{@link Objecterr}s";
        String postfix = "are cool." + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + " " + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testTagWordbreaks1() {
        String input;
        String expected = input = PREFIX + DELIMITER + INFIX + "<code>Object</code> rocks." + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testTagWordbreaks2() {
        String input;
        String expected = input = PREFIX + DELIMITER + INFIX + "<code>Object</code>s are cool." + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultilineTagWordbreaks1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "20");
        String prefix = PREFIX + DELIMITER + INFIX + "<code>Object</code>";
        String postfix = "rocks." + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + " " + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultilineTagWordbreaks2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "20");
        String prefix = PREFIX + DELIMITER + INFIX + "Foo";
        String postfix = "<code>Obj</code>s" + DELIMITER + POSTFIX;
        String input = String.valueOf(prefix) + " " + postfix;
        String expected = String.valueOf(prefix) + DELIMITER + INFIX + postfix;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineComment() {
        String input = PREFIX + DELIMITER + " TOTO " + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "TOTO" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testMultiLineComment2() {
        String input = PREFIX + DELIMITER + "TOTO" + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "TOTO" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testNoExtraNewlineWithPre1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_source_code", "true");
        String input = PREFIX + DELIMITER + INFIX + "<pre>wrap here</pre>" + DELIMITER + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX + "wrap here" + DELIMITER + INFIX + "</pre>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        expected = PREFIX + DELIMITER + INFIX + "<pre>" + DELIMITER + INFIX + "wrap here" + DELIMITER + INFIX + "</pre>" + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void testNoExtraNewlineWithPre2() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_source_code", "false");
        String input = PREFIX + DELIMITER + INFIX + "<pre>wrap here</pre>" + DELIMITER + POSTFIX;
        String expected = PREFIX + DELIMITER + INFIX + "<pre>wrap here</pre>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        result = this.testFormat(result);
        expected = PREFIX + DELIMITER + INFIX + "<pre>wrap here</pre>" + DELIMITER + POSTFIX;
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void test109605() {
        String input = PREFIX + DELIMITER + "\t\t\t * <pre>" + DELIMITER + "\t\t\t * " + DELIMITER + "\t\t\t * </pre>" + DELIMITER + "\t\t\t * " + DELIMITER + "\t\t\t * " + DELIMITER + "\t\t\t * @author Darren Pearce" + DELIMITER + "\t\t\t * @version 22-Sep-2005" + DELIMITER + "\t\t\t * " + DELIMITER + "\t\t\t */";
        String expected = PREFIX + DELIMITER + " * <pre>" + DELIMITER + " * </pre>" + DELIMITER + INFIX + DELIMITER + INFIX + DELIMITER + " * @author Darren Pearce" + DELIMITER + " * @version 22-Sep-2005" + DELIMITER + INFIX + DELIMITER + POSTFIX;
        String result = this.testFormat(input);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void test60453() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "80");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        String input = "/** Creates a new instance of DynamicEventChannel  sdf sdfs dsdf dsfsd fd fsd fsdf sdf dsfsd (on the same line)" + DELIMITER + "* @pre obj != null" + DELIMITER + "*/";
        String expected = PREFIX + DELIMITER + " * Creates a new instance of DynamicEventChannel sdf sdfs dsdf dsfsd fd fsd fsdf" + DELIMITER + " * sdf dsfsd (on the same line)" + DELIMITER + INFIX + DELIMITER + " * @pre obj != null" + DELIMITER + POSTFIX;
        String result = this.testFormat(input, options);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void test60453_2() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "80");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines", "false");
        String input = "/** Creates a new instance of DynamicEventChannel  sdf sdfs dsdf dsfsd fd fsd fsdf sdf dsfsd (on the same line)" + DELIMITER + "* @pre obj != null" + DELIMITER + "*/";
        String expected = PREFIX + DELIMITER + " * Creates a new instance of DynamicEventChannel sdf sdfs dsdf dsfsd fd fsd fsdf" + DELIMITER + " * sdf dsfsd (on the same line)" + DELIMITER + INFIX + DELIMITER + " * @pre obj != null" + DELIMITER + POSTFIX;
        String result = this.testFormat(input, options);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }

    public void test75460() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "200");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_source_code", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", "false");
        String input = PREFIX + DELIMITER + "<pre>" + DELIMITER + "            Object[] objects = new Object[3];" + DELIMITER + "            objects[0] = new String(\"Hallo Welt !!!\");" + DELIMITER + "            objects[1] = new String(\"Test !!!\");" + DELIMITER + "            objects[2] = new Integer(\"1980\");" + DELIMITER + "            ObjectFile.write(pathname, objects);" + DELIMITER + "            Object[] objs = ObjectFile.read(pathname);" + DELIMITER + "            for(int i = 0; i < objs.length; i++)" + DELIMITER + "            {" + DELIMITER + "              System.out.println(objs[i].toString());" + DELIMITER + "            }" + DELIMITER + "</pre>" + DELIMITER + "*/";
        String expected = PREFIX + DELIMITER + " * <pre>" + DELIMITER + " * Object[] objects = new Object[3];" + DELIMITER + " * objects[0] = new String(&quot;Hallo Welt !!!&quot;);" + DELIMITER + " * objects[1] = new String(&quot;Test !!!&quot;);" + DELIMITER + " * objects[2] = new Integer(&quot;1980&quot;);" + DELIMITER + " * ObjectFile.write(pathname, objects);" + DELIMITER + " * Object[] objs = ObjectFile.read(pathname);" + DELIMITER + " * for (int i = 0; i &lt; objs.length; i++) {" + DELIMITER + " * \tSystem.out.println(objs[i].toString());" + DELIMITER + " * }" + DELIMITER + " * </pre>" + DELIMITER + POSTFIX;
        String result = this.testFormat(input, options);
        JavaDocTestCase.assertEquals((String)expected, (String)result);
    }
}

