/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.CompletionTestsRequestor;
import org.eclipse.wst.jsdt.core.tests.model.ContainerInitializer;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.codeassist.RelevanceConstants;

public class CompletionTests2
extends ModifyingResourceTests
implements RelevanceConstants {
    public static final String DEFUALT_JSDTSCOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n       <classpathentry kind=\"src\" path=\"\"/>\n       <classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.launching.JRE_CONTAINER\"/>\n       <classpathentry kind=\"output\" path=\"\"/>\n</classpath>";
    public static final String DEFAULT_PROJECT_LEFT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n     <name>";
    public static final String DEFAULT_PROJECT_RIGHT = "</name>\n     <comment></comment>\n     <projects>\n     </projects>\n     <buildSpec>\n     \t<buildCommand>\n            <name>org.eclipse.wst.jsdt.core.javascriptValidator</name>\n               <arguments>\n               </arguments>\n         </buildCommand>\n     </buildSpec>\n     <natures>\n       <nature>org.eclipse.wst.jsdt.core.jsNature</nature>\n     </natures>\n</projectDescription>";
    static /* synthetic */ Class class$0;

    public CompletionTests2(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("Completion");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("Completion");
        super.tearDownSuite();
    }

    protected static void assertResults(String expected, String actual) {
        try {
            CompletionTests2.assertEquals((String)expected, (String)actual);
        }
        catch (ComparisonFailure c) {
            System.out.println(actual);
            System.out.println();
            throw c;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CompletionTests2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CompletionTests2.buildModelTestSuite(clazz);
    }

    File createFile(File parent, String name, String content) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        return file;
    }

    File createDirectory(File parent, String name) {
        File dir = new File(parent, name);
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug29832() throws Exception {
        try {
            IFile f = this.getFile("/Completion/ZZZ.js");
            IJavaScriptProject p = this.createJavaProject("P1", new String[]{"/"}, new String[0]);
            IFile libFile = this.createFile("/P1/ZZZ.js", f.getContents());
            this.addLibraryEntry(p, libFile.getLocation().toString(), true);
            this.createJavaProject("P2", new String[]{"/"}, new String[0], new String[]{"/P1"});
            this.createFile("/P2/X.js", "function testZZZClass {\n  var z = new ZZZ();\n  z;\n}");
            CompletionTests2.waitUntilIndexesReady();
            CompletionTestsRequestor requestor = new CompletionTestsRequestor();
            IJavaScriptUnit cu = this.getCompilationUnit("P2", "", "", "X.js");
            String str = cu.getSource();
            String completeBehind = "z";
            int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            CompletionTests2.assertEquals((String)"element:ZZZ    completion:ZZZ    relevance:9\nelement:ZZZ    completion:ZZZ()    relevance:11\nelement:ZZZ    completion:ZZZ()    relevance:11\nelement:z    completion:z    relevance:26", (String)requestor.getResults());
            p.getProject().delete(true, false, null);
            File dest = this.getWorkspaceRoot().getLocation().toFile();
            File pro = this.createDirectory(dest, "P1");
            File proSet = this.createDirectory(pro, ".settings");
            this.createFile(proSet, ".jsdtscope", DEFUALT_JSDTSCOPE);
            this.createFile(pro, ".project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n     <name>org.eclipse.wst.jsdt.core</name>\n     <comment></comment>\n     <projects>\n     </projects>\n     <buildSpec>\n     \t<buildCommand>\n            <name>org.eclipse.wst.jsdt.core.javascriptValidator</name>\n               <arguments>\n               </arguments>\n         </buildCommand>\n     </buildSpec>\n     <natures>\n       <nature>org.eclipse.wst.jsdt.core.jsNature</nature>\n     </natures>\n</projectDescription>");
            this.createFile(pro, "ZZZ.js", "function testZZZClass {\n  var z = new ZZZ();\n  z;\n}");
            final IProject project = this.getWorkspaceRoot().getProject("P1");
            IWorkspaceRunnable populate = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(null);
                    project.open(null);
                }
            };
            this.getWorkspace().run(populate, null);
            JavaScriptCore.create((IProject)project);
            CompletionTests2.waitUntilIndexesReady();
            requestor = new CompletionTestsRequestor();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            CompletionTests2.assertEquals((String)"element:z    completion:z    relevance:25\nelement:z    completion:z    relevance:26", (String)requestor.getResults());
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var14_16 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug33560() throws Exception {
        try {
            IFile f = this.getFile("/Completion/ZZZ.js");
            IJavaScriptProject p = this.createJavaProject("P1", new String[]{"/"}, new String[0]);
            IFile libFile = this.createFile("/P1/ZZZ.js", f.getContents());
            this.addLibraryEntry(p, libFile.getLocation().toString(), true);
            this.createJavaProject("P2", new String[]{"/"}, new String[0], new String[]{"/P1"});
            this.createJavaProject("P3", new String[]{"/"}, new String[0], new String[]{"/P1"});
            this.createFile("/P3/X.js", "function testZZZClass {\n  var z = new ZZZ();\n  z;\n}");
            CompletionTests2.waitUntilIndexesReady();
            CompletionTestsRequestor requestor = new CompletionTestsRequestor();
            IJavaScriptUnit cu = this.getCompilationUnit("P3", "", "", "X.js");
            String str = cu.getSource();
            String completeBehind = "z";
            int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            CompletionTests2.assertEquals((String)"element:ZZZ    completion:ZZZ    relevance:9\nelement:ZZZ    completion:ZZZ()    relevance:11\nelement:ZZZ    completion:ZZZ()    relevance:11\nelement:z    completion:z    relevance:26", (String)requestor.getResults());
            p.getProject().delete(true, false, null);
            File dest = this.getWorkspaceRoot().getLocation().toFile();
            File pro = this.createDirectory(dest, "P1");
            File proSet = this.createDirectory(pro, ".settings");
            this.createFile(proSet, ".jsdtscope", DEFUALT_JSDTSCOPE);
            this.createFile(pro, ".project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n     <name>org.eclipse.wst.jsdt.core</name>\n     <comment></comment>\n     <projects>\n     </projects>\n     <buildSpec>\n     \t<buildCommand>\n            <name>org.eclipse.wst.jsdt.core.javascriptValidator</name>\n               <arguments>\n               </arguments>\n         </buildCommand>\n     </buildSpec>\n     <natures>\n       <nature>org.eclipse.wst.jsdt.core.jsNature</nature>\n     </natures>\n</projectDescription>");
            File src = this.createDirectory(pro, "src");
            this.createDirectory(src, "pz");
            this.createFile(pro, "ZZZ.js", "function testZZZClass {\n  var z = new ZZZ();\n  z;\n}");
            final IProject project = this.getWorkspaceRoot().getProject("P1");
            IWorkspaceRunnable populate = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(null);
                    project.open(null);
                }
            };
            this.getWorkspace().run(populate, null);
            JavaScriptCore.create((IProject)project);
            CompletionTests2.waitUntilIndexesReady();
            requestor = new CompletionTestsRequestor();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            CompletionTests2.assertEquals((String)"element:z    completion:z    relevance:25\nelement:z    completion:z    relevance:26", (String)requestor.getResults());
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            this.deleteProject("P3");
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
        this.deleteProject("P3");
    }

    public static class CompletionContainerInitializer
    implements ContainerInitializer.ITestInitializer {
        Map containerValues = new HashMap();
        CoreException exception;

        public CompletionContainerInitializer(String projectName, String[] libPaths, boolean[] areExported) {
            this(projectName, libPaths, areExported, null);
        }

        public CompletionContainerInitializer(String projectName, String[] libPaths, boolean[] areExported, String[] forbiddenRefrences) {
            int libPathsLength = libPaths.length;
            char[][] charLibPaths = new char[libPathsLength][];
            int i = 0;
            while (i < libPathsLength) {
                charLibPaths[i] = libPaths[i].toCharArray();
                ++i;
            }
            this.containerValues.put(projectName, this.newContainer(charLibPaths, areExported, forbiddenRefrences));
        }

        protected DefaultContainer newContainer(char[][] libPaths, boolean[] areExperted, String[] forbiddenRefrences) {
            return new DefaultContainer(libPaths, areExperted, forbiddenRefrences);
        }

        public boolean allowFailureContainer() {
            return true;
        }

        public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
            if (this.containerValues == null) {
                return;
            }
            try {
                JavaScriptCore.setJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject[])new IJavaScriptProject[]{project}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{(IJsGlobalScopeContainer)this.containerValues.get(project.getElementName())}, null);
            }
            catch (CoreException e) {
                this.exception = e;
                throw e;
            }
        }

        public static class DefaultContainer
        implements IJsGlobalScopeContainer {
            char[][] libPaths;
            boolean[] areExported;
            String[] forbiddenReferences;

            public DefaultContainer(char[][] libPaths, boolean[] areExported, String[] forbiddenReferences) {
                this.libPaths = libPaths;
                this.areExported = areExported;
                this.forbiddenReferences = forbiddenReferences;
            }

            public IIncludePathEntry[] getClasspathEntries() {
                return this.getIncludepathEntries();
            }

            public IIncludePathEntry[] getIncludepathEntries() {
                int length = this.libPaths.length;
                IIncludePathEntry[] entries = new IIncludePathEntry[length];
                int j = 0;
                while (j < length) {
                    IAccessRule[] accessRules;
                    Path path = new Path(new String(this.libPaths[j]));
                    boolean isExported = this.areExported[j];
                    if (this.forbiddenReferences != null && this.forbiddenReferences[j] != null && this.forbiddenReferences[j].length() != 0) {
                        StringTokenizer tokenizer = new StringTokenizer(this.forbiddenReferences[j], ";");
                        int count = tokenizer.countTokens();
                        accessRules = new IAccessRule[count];
                        String token = null;
                        int i = 0;
                        while (i < count) {
                            token = tokenizer.nextToken();
                            accessRules[i] = JavaScriptCore.newAccessRule((IPath)new Path(token), (int)1);
                            ++i;
                        }
                    } else {
                        accessRules = new IAccessRule[]{};
                    }
                    entries[j] = path.segmentCount() == 1 ? JavaScriptCore.newProjectEntry((IPath)path, (IAccessRule[])accessRules, (boolean)true, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)isExported) : JavaScriptCore.newLibraryEntry((IPath)path, null, null, (IAccessRule[])accessRules, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)isExported);
                    ++j;
                }
                return entries;
            }

            public String getDescription() {
                return "Test container";
            }

            public int getKind() {
                return 1;
            }

            public IPath getPath() {
                return new Path("org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER");
            }

            public String[] resolvedLibraryImport(String a) {
                return new String[]{a};
            }
        }
    }
}

