/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.JavaSearchTests;

public class JavaSearchJavadocTests
extends JavaSearchTests {
    Map originalOptions;
    static /* synthetic */ Class class$0;

    public JavaSearchJavadocTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.originalOptions = JAVA_PROJECT.getOptions(true);
        JAVA_PROJECT.setOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        this.resultCollector.showAccuracy = true;
        this.resultCollector.showInsideDoc = true;
    }

    public void tearDown() throws Exception {
        JAVA_PROJECT.setOptions(this.originalOptions);
        super.tearDown();
    }

    private void setJavadocOptions() {
        JAVA_PROJECT.setOption("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
        JAVA_PROJECT.setOption("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", "error");
    }

    private void disableJavadocOptions() {
        JAVA_PROJECT.setOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "disabled");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchJavadocTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchJavadocTests.buildModelTestSuite(clazz);
    }

    public void testJavadocTypeDeclaration() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.search((IJavaScriptElement)type, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched [JavadocSearched] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeStringDeclaration() throws CoreException {
        this.search("JavadocSearched", 0, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched [JavadocSearched] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeDeclarationWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        this.search((IJavaScriptElement)type, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched [JavadocSearched] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldDeclaration() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IField field = type.getField("javadocSearchedVar");
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched.javadocSearchedVar [javadocSearchedVar] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldStringDeclaration() throws CoreException {
        this.search("javadocSearchedVar", 4, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched.javadocSearchedVar [javadocSearchedVar] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldDeclarationWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IField field = type.getField("javadocSearchedVar");
        this.setJavadocOptions();
        this.search((IJavaScriptElement)field, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java j1.JavadocSearched.javadocSearchedVar [javadocSearchedVar] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodDeclaration() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("javadocSearchedMethod", null);
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod() [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodArgDeclaration() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("javadocSearchedMethod", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod(String) [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodStringDeclaration() throws CoreException {
        this.search("javadocSearchedMethod", 1, 0, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod() [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod(String) [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodDeclarationWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("javadocSearchedMethod", null);
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod() [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodArgDeclarationWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("javadocSearchedMethod", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 0, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocSearched.java void j1.JavadocSearched.javadocSearchedMethod(String) [javadocSearchedMethod] EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [j1.JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [j1.JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeStringReference() throws CoreException {
        this.search("JavadocSearched", 0, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [j1.JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [j1.JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeStringReferenceWithJavadoc() throws CoreException {
        this.setJavadocOptions();
        this.search("JavadocSearched", 0, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocTypeStringReferenceWithJavadocDisabled() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.disableJavadocOptions();
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testJavadocFieldReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IField field = type.getField("javadocSearchedVar");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedVar] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldStringReference() throws CoreException {
        this.search("javadocSearchedVar", 4, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedVar] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IField field = type.getField("javadocSearchedVar");
        this.setJavadocOptions();
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedVar] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldStringReferenceWithJavadoc() throws CoreException {
        this.setJavadocOptions();
        this.search("javadocSearchedVar", 4, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedVar] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedVar] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocFieldStringReferenceWithJavadocDisabled() throws CoreException {
        this.disableJavadocOptions();
        this.search("javadocSearchedVar", 4, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testJavadocMethodReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("javadocSearchedMethod", null);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodArgReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("javadocSearchedMethod", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodStringReference() throws CoreException {
        this.search("javadocSearchedMethod", 1, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("javadocSearchedMethod", null);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodArgReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("javadocSearchedMethod", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodStringReferenceWithJavadoc() throws CoreException {
        this.setJavadocOptions();
        this.search("javadocSearchedMethod", 1, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [javadocSearchedMethod(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [javadocSearchedMethod(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testJavadocMethodArgReferenceWithJavadocDisabled() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("javadocSearchedMethod", new String[]{"QString;"});
        this.disableJavadocOptions();
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("", this.resultCollector);
    }

    public void testJavadocConstructorReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("JavadocSearched", null);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched()] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorArgReference() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("JavadocSearched", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched(String)] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorStringReference() throws CoreException {
        this.search("JavadocSearched", 3, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched(String)] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("JavadocSearched", null);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched()] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorArgReferenceWithJavadoc() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        this.setJavadocOptions();
        IFunction method = type.getFunction("JavadocSearched", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched(String)] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorStringReferenceWithJavadoc() throws CoreException {
        this.setJavadocOptions();
        this.search("JavadocSearched", 3, 2, this.getJavaSearchScope(), (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched()] POTENTIAL_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocInvalidRef.java void j1.JavadocInvalidRef.invalid() [JavadocSearched(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched()] EXACT_MATCH INSIDE_JAVADOC\nsrc/j1/JavadocValidRef.java void j1.JavadocValidRef.valid() [JavadocSearched(String)] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testJavadocConstructorReferenceWithJavadocDisabled() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j1", "JavadocSearched.js").getType("JavadocSearched");
        IFunction method = type.getFunction("JavadocSearched", null);
        this.disableJavadocOptions();
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("");
    }

    private void setUpJavadocTypeParameterReferences() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearch15/src/b81190/Test.js", "package b81190;\n/**\n * @param <T1> First class type parameter\n * @param <T2> Second class type parameter\n * @param <T3> Last class type parameter\n */\npublic class Test<T1, T2, T3> {\n\t/**\n\t * @param <U> Method type parameter\n\t * @param x Method parameter\n\t */\n\t<U> void generic(U x, T1 t) {\n\t\tObject o = x;\n\t\to.toString();\n\t}\n}\n");
    }

    public void testJavadocParameterReferences01() throws CoreException {
        this.setUpJavadocTypeParameterReferences();
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])this.workingCopies);
        ILocalVariable local = this.selectLocalVariable(this.workingCopies[0], "x", 2);
        this.search((IJavaScriptElement)local, 2, scope);
        this.assertSearchResults("src/b81190/Test.java void b81190.Test.generic(U, T1) [x] EXACT_MATCH INSIDE_JAVADOC\nsrc/b81190/Test.java void b81190.Test.generic(U, T1) [x] EXACT_MATCH OUTSIDE_JAVADOC");
    }

    public void testBug47909() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j3", "Y.js").getType("Y");
        this.setJavadocOptions();
        IFunction method = type.getFunction("Y", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("test47909.jar void j3.X.bar() EXACT_MATCH OUTSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47968type() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j2", "Bug47968.js").getType("Bug47968");
        this.setJavadocOptions();
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j2/Bug47968s.java j2.Bug47968s [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [Bug47968] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [Bug47968] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47968field() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j2", "Bug47968.js").getType("Bug47968");
        this.setJavadocOptions();
        IField field = type.getField("x");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j2/Bug47968s.java j2.Bug47968s [x] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [x] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [x] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [x] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47968method() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j2", "Bug47968.js").getType("Bug47968");
        this.setJavadocOptions();
        IFunction method = type.getFunction("foo", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j2/Bug47968s.java j2.Bug47968s [foo(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [foo(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [foo(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [foo(int)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47968constructor() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch", "src", "j2", "Bug47968.js").getType("Bug47968");
        this.setJavadocOptions();
        IFunction method = type.getFunction("Bug47968", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j2/Bug47968s.java j2.Bug47968s [Bug47968(String)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s.y [Bug47968(String)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java j2.Bug47968s() [Bug47968(String)] EXACT_MATCH INSIDE_JAVADOC\nsrc/j2/Bug47968s.java void j2.Bug47968s.bar() [Bug47968(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47209type() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j4", "TT47209.js").getType("TT47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "TF47209.js").getType("TF47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "TC47209.js").getType("TC47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "TT47209.js").getType("TM47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        this.assertSearchResults("src/j4/TT47209.java j4.TT47209 [TT47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/TF47209.java j4.TF47209.f47209 [TF47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/TC47209.java j4.TC47209(String) [TC47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/TM47209.java void j4.TM47209.m47209(int) [TM47209] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47209field() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j4", "FT47209.js").getType("FT47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "FF47209.js").getType("FF47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "FC47209.js").getType("FC47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "FT47209.js").getType("FM47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        this.assertSearchResults("src/j4/FT47209.java j4.FT47209 [FT47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/FF47209.java j4.FF47209.f47209 [FF47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/FC47209.java j4.FC47209(String) [FC47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/FM47209.java void j4.FM47209.m47209(int) [FM47209] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47209method() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j4", "MT47209.js").getType("MT47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "MF47209.js").getType("MF47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "MC47209.js").getType("MC47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "MT47209.js").getType("MM47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        this.assertSearchResults("src/j4/MT47209.java j4.MT47209 [MT47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/MF47209.java j4.MF47209.f47209 [MF47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/MC47209.java j4.MC47209(String) [MC47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/MM47209.java void j4.MM47209.m47209(int) [MM47209] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug47209constructor() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j4", "CT47209.js").getType("CT47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "CF47209.js").getType("CF47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "CC47209.js").getType("CC47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        type = this.getCompilationUnit("JavaSearch", "src", "j4", "CT47209.js").getType("CM47209");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        this.assertSearchResults("src/j4/CT47209.java j4.CT47209 [CT47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/CF47209.java j4.CF47209.f47209 [CF47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/CC47209.java j4.CC47209(String) [CC47209] EXACT_MATCH INSIDE_JAVADOC\nsrc/j4/CM47209.java void j4.CM47209.m47209(int) [CM47209] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug49994() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j5", "Bug49994.js").getType("Bug49994");
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScope());
        this.assertSearchResults("", this.resultCollector);
    }

    public void testBug49994field() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j5", "Bug49994.js").getType("Bug49994");
        IField field = type.getField("field");
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j5/Bug49994.java void j5.Bug49994.foo() [field] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug49994method() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j5", "Bug49994.js").getType("Bug49994");
        IFunction method = type.getFunction("bar", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j5/Bug49994.java void j5.Bug49994.foo() [bar()] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug49994constructor() throws CoreException {
        this.setJavadocOptions();
        IType type = this.getCompilationUnit("JavaSearch", "src", "j5", "Bug49994.js").getType("Bug49994");
        IFunction method = type.getFunction("Bug49994", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScope(), this.resultCollector);
        this.assertSearchResults("src/j5/Bug49994.java void j5.Bug49994.foo() [Bug49994(String)] EXACT_MATCH INSIDE_JAVADOC", this.resultCollector);
    }

    public void testBug83285() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearch/src/b83285/A.js", "package b83285;\nclass A { }\nclass C {\n    /**\n     * Link {@link #C(String)} was also wrongly warned...\n     */\n    private String fGerman;\n    public C(String german) {\n        fGerman = german;\n    }\n}");
        IFunction[] methods = this.workingCopies[0].getType("C").getFunctions();
        JavaSearchJavadocTests.assertEquals((String)"Invalid number of methods", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2, this.getJavaSearchScope());
        this.assertSearchResults("src/b83285/A.java b83285.C.fGerman [C(String)] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug83285a() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearch/src/b83285/A.js", "package b83285;\nclass A {\n\tA(char c) {}\n}\nclass B {\n\tB(Exception ex) {}\n\tvoid foo() {} \n\tclass C { \n\t    /**\n\t     * Link {@link #B(Exception)} OK\n\t     * Link {@link #C(String)} OK\n\t     * Link {@link #foo()} OK\n\t     * Link {@link #bar()} OK\n\t     */\n\t    public C(String str) {}\n\t\tvoid bar() {}\n\t}\n}");
        IFunction[] methods = this.workingCopies[0].getType("B").getFunctions();
        JavaSearchJavadocTests.assertEquals((String)"Invalid number of methods", (int)2, (int)methods.length);
        int i = 0;
        int l = methods.length;
        while (i < l) {
            this.search((IJavaScriptElement)methods[i], 2, this.getJavaSearchScope());
            ++i;
        }
        this.assertSearchResults("src/b83285/A.java b83285.B$C(String) [B(Exception)] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83285/A.java b83285.B$C(String) [foo()] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug83285b() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearch/src/b83285/A.js", "package b83285;\nclass A {\n\tA(char c) {}\n}\nclass B {\n\tB(Exception ex) {}\n\tvoid foo() {} \n\tclass C { \n\t    /**\n\t     * Link {@link #B(Exception)} OK\n\t     * Link {@link #C(String)} OK\n\t     * Link {@link #foo()} OK\n\t     * Link {@link #bar()} OK\n\t     */\n\t    public C(String str) {}\n\t\tvoid bar() {}\n\t}\n}");
        IFunction[] methods = this.workingCopies[0].getType("B").getType("C").getFunctions();
        JavaSearchJavadocTests.assertEquals((String)"Invalid number of methods", (int)2, (int)methods.length);
        int i = 0;
        int l = methods.length;
        while (i < l) {
            this.search((IJavaScriptElement)methods[i], 2, this.getJavaSearchScope());
            ++i;
        }
        this.assertSearchResults("src/b83285/A.java b83285.B$C(String) [C(String)] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83285/A.java b83285.B$C(String) [bar()] EXACT_MATCH INSIDE_JAVADOC");
    }
}

