/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;

public class NameLookupTests2
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public NameLookupTests2(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.NameLookupTests2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return NameLookupTests2.buildModelTestSuite(clazz);
    }

    private NameLookup getNameLookup(JavaProject project) throws JavaScriptModelException {
        return project.newNameLookup(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackageFragmentRootAndPackageFrament() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src1"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0]);
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/P1"))};
            p2.setRawIncludepath(classpath, null);
            IPackageFragment[] res = this.getNameLookup((JavaProject)p2).findPackageFragments("p1", false);
            NameLookupTests2.assertTrue((String)"Should get no package fragment", (res == null ? 1 : 0) != 0);
            IIncludePathEntry[] classpath2 = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P1/src1")), JavaScriptCore.newSourceEntry((IPath)new Path("/P1/src2"))};
            p1.setRawIncludepath(classpath2, null);
            this.createFolder("/P1/src2/p1");
            res = this.getNameLookup((JavaProject)p2).findPackageFragments("p1", false);
            NameLookupTests2.assertTrue((String)"Should get 'p1' package fragment", (res != null && res.length == 1 && res[0].getElementName().equals("p1") ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackageFragment() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src1"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0]);
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newProjectEntry((IPath)new Path("/P1"))};
            p2.setRawIncludepath(classpath, null);
            IPackageFragment[] res = this.getNameLookup((JavaProject)p2).findPackageFragments("p1", false);
            NameLookupTests2.assertTrue((String)"Should get no package fragment", (res == null ? 1 : 0) != 0);
            this.createFolder("/P1/src1/p1");
            res = this.getNameLookup((JavaProject)p2).findPackageFragments("p1", false);
            NameLookupTests2.assertTrue((String)"Should get 'p1' package fragment", (res != null && res.length == 1 && res[0].getElementName().equals("p1") ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackageFragment2() throws CoreException {
        try {
            JavaProject project = (JavaProject)this.createJavaProject("P", new String[]{"src"});
            this.createFolder("/P/src/p1");
            IPackageFragment[] pkgs = this.getNameLookup(project).findPackageFragments("p1", false);
            this.assertElementsEqual("Didn't find p1", "p1 [in src [in P]]", (IJavaScriptElement[])pkgs);
            this.createFolder("/P/src/p2");
            pkgs = this.getNameLookup(project).findPackageFragments("p2", false);
            this.assertElementsEqual("Didn't find p2", "p2 [in src [in P]]", (IJavaScriptElement[])pkgs);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDuplicateTypesInWorkingCopies() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        try {
            JavaProject project = (JavaProject)this.createJavaProject("P");
            this.workingCopies[0] = this.getWorkingCopy("/P/X.js", "function foo() {\n}");
            this.workingCopies[1] = this.getWorkingCopy("/P/Y.js", "function foo() {\n}");
            this.workingCopies[2] = this.getWorkingCopy("/P/Z.js", "function foo() {\n}");
            NameLookup nameLookup = project.newNameLookup(this.workingCopies);
            NameLookup.Answer answer = nameLookup.findBinding("foo", "", 8, false, 30, false, false, null);
            NameLookupTests2.assertEquals((String)"Unepexted ", (String)"foo", (String)((IJavaScriptElement)answer.element).getElementName());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindDefaultPackageFragmentInNonDefaultRoot() throws CoreException {
        try {
            JavaProject project = (JavaProject)this.createJavaProject("P", new String[]{"src"});
            IPackageFragment pkg = this.getNameLookup(project).findPackageFragment((IPath)new Path("/P/src"));
            this.assertElementsEqual("Didn't find default package", "<default> [in src [in P]]", new IJavaScriptElement[]{pkg});
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindPackageFragmentWithWorkingCopy() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        try {
            JavaProject project = (JavaProject)this.createJavaProject("P");
            this.createFolder("/P/p1");
            this.workingCopies[0] = this.getWorkingCopy("/P/p1/X.js", "function X() {\n}");
            NameLookup nameLookup = project.newNameLookup(this.workingCopies);
            IPackageFragment[] pkgs = nameLookup.findPackageFragments("p1", false);
            this.assertElementsEqual("Unexpected packages", "p1 [in <project root> [in P]]", (IJavaScriptElement[])pkgs);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindBinaryTypeWithDollarName() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.addLibrary(project, "lib.jar", "libsrc.zip", new String[]{"p/X.js", "package p;\npublic class X {\n  public class $1 {\n    public class $2 {\n    }\n  }\n}"}, "1.4");
            IType type = this.getNameLookup((JavaProject)project).findType("p.X$$1", false, 30);
            this.assertTypesEqual("Unexpected type", "p.X$$1\n", new IType[]{type});
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindBinaryTypeWithSameNameAsMember() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"/P/lib"}, new String[0]);
            this.createFolder("/P/lib/p");
            this.createFile("/P/lib/p/X.js", "");
            this.createFile("/P/lib/p/X$X.js", "");
            IType type = this.getNameLookup((JavaProject)project).findType("p.X", false, 30);
            this.assertTypesEqual("Unexpected type", "p.X\n", new IType[]{type});
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }
}

