/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.net.URL;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.xs.XSModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.xpath2.processor.CollationProvider;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.osgi.framework.Bundle;

public class TestBugs
extends AbstractPsychoPathTest {
    private static final String URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR = "urn:x-eclipse:xpath20:funky-collator";
    private Bundle bundle;

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.eclipse.wst.xml.xpath2.processor.tests");
    }

    public void testNamesWhichAreKeywords() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug311480.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "(/element/eq eq 'eq') or //child::xs:*";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringLengthWithElementArg() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273719.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "string-length(x) > 2";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug273795Arity2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273795.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "substring(x, 3) = 'happy'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug273795Arity3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273795.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "substring(x, 3, 4) = 'happ'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "x/string() = 'unhappy'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringLengthFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "x/string-length() = 7";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testNormalizeSpaceFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "x/normalize-space() = 'unhappy'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAnyUriEqualityBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:anyURI('abc') eq xs:anyURI('abc')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBaseUriBug() throws Exception {
        this.loadDOMDocument(new URL("http://www.w3schools.com/xml/note.xml"));
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        String xpath = "base-uri(note) eq xs:anyURI('http://www.w3schools.com/xml/note.xml')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testDocumentUriBug() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        this.domDoc = docBuilder.parse("http://www.w3schools.com/xml/note.xml");
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        String xpath = "document-uri(/) eq xs:anyURI('http://www.w3schools.com/xml/note.xml')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = "false";
        if (result != null) {
            actual = result.string_value();
        }
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBooleanTypeBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273719.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:boolean('1') eq xs:boolean('true')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testDateConstructorBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274792.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:date(x) eq xs:date('2009-01-01')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testIntegerDataTypeBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274805.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:integer(x) gt 100";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testLongDataType() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:long('9223372036854775807') gt 0";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testIntDataType() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:int('2147483647') gt 0";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testSchemaAwarenessForAttributes() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug276134.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug276134.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "person/@dob eq xs:date('2006-12-10')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testSchemaAwarenessForElements() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug276134_2.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug276134_2.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "person/dob eq xs:date('2006-12-10')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testNilled() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        TestBugs.assertTrue((boolean)this.evaluateBoolean((DynamicContext)dc, "empty( nilled( / ) )"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean((DynamicContext)dc, "empty( nilled( /root/@attr1 ) )"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean((DynamicContext)dc, "empty( nilled( /root/element1/text() ) )"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean((DynamicContext)dc, "nilled(/root/element1)"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean((DynamicContext)dc, "nilled(/root/element2)"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean((DynamicContext)dc, "nilled(/root/element3)"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean((DynamicContext)dc, "nilled(/root/element4)"));
    }

    private boolean evaluateBoolean(DynamicContext dc, String xpath) throws Exception {
        XPath path = this.compileXPath(dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator(dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        return result.value();
    }

    public void testXSNonPositiveInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:nonPositiveInteger('0') eq 0";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNegativeInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:negativeInteger('-1') eq -1";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSShort() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:short('-32768') eq -32768";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNonNegativeInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:nonNegativeInteger('0') eq 0";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedLong() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:unsignedLong('0') eq 0";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSPositiveInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:positiveInteger('1') eq 1";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSByte() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:byte('-128') eq -128";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedInt() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:unsignedInt('4294967295') eq xs:unsignedInt('4294967295')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedShort() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:unsignedShort('65535') eq 65535";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSYearMonthDurationMultiply() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P2Y11M') * 2.3";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"P6Y9M", (String)actual);
    }

    public void testXSYearMonthDurationDivide1() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P2Y11M') div 1.5";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"P1Y11M", (String)actual);
    }

    public void testXSYearMonthDurationDivide2() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P3Y4M') div xs:yearMonthDuration('-P1Y4M')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDecimal result = (XSDecimal)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"-2.5", (String)actual);
    }

    public void testXSDayTimeDurationMultiply() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:dayTimeDuration('PT2H10M') * 2.1";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"PT4H33M", (String)actual);
    }

    public void testXSDayTimeDurationDivide() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:dayTimeDuration('P1DT2H30M10.5S') div 1.5";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"PT17H40M7S", (String)actual);
    }

    public void testNegativeZeroDouble() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "-(xs:double('0'))";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSDouble result = (XSDouble)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"-0", (String)actual);
    }

    public void testNegativeZeroFloat() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "-(xs:float('0'))";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSFloat result = (XSFloat)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"-0", (String)actual);
    }

    public void testXSUnsignedByte() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:unsignedByte('255') eq 255";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSBase64Binary() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:base64Binary('cmxjZ3R4c3JidnllcmVuZG91aWpsbXV5Z2NhamxpcmJkaWFhbmFob2VsYXVwZmJ1Z2dmanl2eHlzYmhheXFtZXR0anV2dG1q') eq xs:base64Binary('cmxjZ3R4c3JidnllcmVuZG91aWpsbXV5Z2NhamxpcmJkaWFhbmFob2VsYXVwZmJ1Z2dmanl2eHlzYmhheXFtZXR0anV2dG1q')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSHexBinary() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:hexBinary('767479716c6a647663') eq xs:hexBinary('767479716c6a647663')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testElementTypedValue() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode eq 'air'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug286061_quoted_string_literals_no_normalize() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "'\"\"'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        String resultValue = rs.first().string_value();
        TestBugs.assertEquals((String)"\"\"", (String)resultValue);
    }

    public void testBug286061_quoted_string_literals() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "concat(  'Don''t try this' ,  \" at \"\"home\"\",\"  ,  ' she said'  )";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        String resultValue = rs.first().string_value();
        TestBugs.assertEquals((String)"Don't try this at \"home\", she said", (String)resultValue);
    }

    public void testBug280555_collations() throws Exception {
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        dc.set_collation_provider(this.createLengthCollatorProvider());
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        XPath path = this.compileXPath((DynamicContext)dc, " 'abc' < 'de' ");
        XSBoolean bval = (XSBoolean)eval.evaluate((XPathNode)path).first();
        TestBugs.assertTrue((String)"'abc' < 'def' for normal collations", (boolean)bval.value());
        dc.set_default_collation(URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR);
        XSBoolean bval2 = (XSBoolean)eval.evaluate((XPathNode)path).first();
        TestBugs.assertFalse((String)"'abc' < 'def' for normal collations", (boolean)bval2.value());
    }

    public void testXPathDefaultNamespace() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/xpathDefNamespaceTest.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.addXPathDefaultNamespace("http://xyz");
        String xpath = "X/message = 'hello'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element()";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode, modeType)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode, abc)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testXPathInstanceOf5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(x, x_Type)*";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf5_2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example) instance of element(x, x_Type)+";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertEquals((boolean)false, (boolean)result.value());
    }

    public void testXPathInstanceOf5_3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example/x) instance of element(x, x_Type)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertFalse((boolean)result.value());
    }

    public void testXPathInstanceOf5_4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example/x) instance of element(x, x_Type)+";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertTrue((boolean)result.value());
    }

    public void testXPathInstanceOf5_5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "(/Example/x instance of x_Type+) and (/Example/x[2]/@mesg instance of mesg_Type)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertEquals((boolean)true, (boolean)result.value());
    }

    public void testXPathInstanceOf6() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(*, x_Type)*";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf7() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(x, x_Type)+";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceNonExistantElement() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(x)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testFnNumber_Evaluation1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/fnNumberBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/fnNumberBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "number(Example/x) ge 18";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFnNumber_Evaluation2() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "number(xs:unsignedByte('20')) ge 18";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute()";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(xx)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(*, mesg_Type)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(*, abc)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(mesg, mesg_Type)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test6() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(mesg, abc)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test7() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/x/@mesg instance of attribute(mesg, mesg_Type)*";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFnNameContextUndefined() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "Example/*[1]/name() eq 'x'";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.string_value();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNormalizedString() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "xs:normalizedString('abcs\t') eq xs:normalizedString('abcs')";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        boolean testSuccess = false;
        try {
            eval.evaluate((XPathNode)path);
        }
        catch (DynamicError dynamicError) {
            testSuccess = true;
        }
        TestBugs.assertTrue((boolean)testSuccess);
    }

    private CollationProvider createLengthCollatorProvider() {
        return new CollationProvider(){

            public Comparator get_collation(String name) {
                if (name.equals(TestBugs.URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR)) {
                    return new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.length() - o2.length();
                        }
                    };
                }
                return null;
            }
        };
    }

    public void testParseElementKeywordsAsNodes() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "/element/attribute";
        this.compileXPath((DynamicContext)dc, xpath);
    }
}

