/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ListIterator;
import org.apache.xerces.xs.XSModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.w3c.dom.Document;

public class TestWTPDOMXPath2
extends AbstractPsychoPathTest {
    IDOMModel model = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.model != null) {
            this.model.releaseFromRead();
        }
    }

    public void testSimpleWTPDOM() throws Exception {
        this.bundle = Platform.getBundle((String)"org.eclipse.wst.xml.xpath2.processor.tests");
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273719.xml");
        this.domDoc = this.load(fileURL);
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        String xpath = "string-length(x) > 2";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        AnyType result = rs.first();
        String actual = result.string_value();
        TestWTPDOMXPath2.assertEquals((String)"true", (String)actual);
    }

    public void test_ForExpr005() throws Exception {
        String inputFile = "/TestSources/fsx.xml";
        String xqFile = "/Queries/XQuery/Expressions/FLWORExpr/ForExpr/ForExpr005.xq";
        String resultFile = "/ExpectedTestResults/Expressions/FLWORExpr/ForExpr/ForExpr005.xml";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_ForExprType013() throws Exception {
        String inputFile = "/TestSources/orderData.xml";
        String xqFile = "/Queries/XQuery/Expressions/FLWORExpr/ForExprType/ForExprType013.xq";
        String expectedResult = "XPST0003";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        DefaultDynamicContext dc = this.setupDynamicContext(null);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes001_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes001.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes001-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_filterexpressionhc1() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/SeqExpr/FilterExpr/filterexpressionhc1.xq";
        String resultFile = "/ExpectedTestResults/Expressions/SeqExpr/FilterExpr/filterexpressionhc1.txt";
        String expectedResult = "<result>" + this.getExpectedResult(resultFile) + "</result>";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<result>" + this.buildXMLResultString(rs) + "</result>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_Axes002_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes002.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes002-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_abbreviatedSyntax_1() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-1.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_abbreviatedSyntax_2() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-2.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_abbreviatedSyntax_3() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-3.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-3.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_abbreviatedSyntax_5() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-5.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/AbbrAxes/abbreviatedSyntax-5.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_nodeexpression3() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeSame/nodeexpression3.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeSame/nodeexpression3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression4() throws Exception {
        String inputFile = "/TestSources/staff.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeSame/nodeexpression4.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeSame/nodeexpression4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression9() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeSame/nodeexpression9.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeSame/nodeexpression9.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression11() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeSame/nodeexpression11.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeSame/nodeexpression11.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_1() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-1.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_2() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-2.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_3() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-3.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_4() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-4.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_5() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-5.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-5.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_predicates_6() throws Exception {
        String inputFile = "/TestSources/atomicns.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Predicates/predicates-6.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Predicates/predicates-6.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes074_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes074.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes074-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes074_2() throws Exception {
        String inputFile = "/TestSources/Tree1Text.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes074.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes074-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes074_3() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes074.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes074-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes074_4() throws Exception {
        String inputFile = "/TestSources/TreeRepeat.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes074.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes074-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes075_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes075.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes075-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes075_2() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes075.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes075-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes075_3() throws Exception {
        String inputFile = "/TestSources/TreeCompass.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes075.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes075-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes075_4() throws Exception {
        String inputFile = "/TestSources/TreeStack.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes075.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes075-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes076_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes076.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes076-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes076_2() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes076.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes076-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes076_3() throws Exception {
        String inputFile = "/TestSources/Tree1Text.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes076.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes076-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes076_4() throws Exception {
        String inputFile = "/TestSources/TreeRepeat.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes076.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes076-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes077_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes077.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes077-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes077_2() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes077.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes077-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes077_3() throws Exception {
        String inputFile = "/TestSources/TreeRepeat.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes077.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes077-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes078_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes078.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes078-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes078_2() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes078.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes078-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes078_3() throws Exception {
        String inputFile = "/TestSources/TreeCompass.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes078.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes078-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes078_4() throws Exception {
        String inputFile = "/TestSources/TreeStack.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes078.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes078-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes079_1() throws Exception {
        String inputFile = "/TestSources/TreeTrunc.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes079.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes079-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes079_2() throws Exception {
        String inputFile = "/TestSources/Tree1Child.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes079.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes079-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_Axes079_3() throws Exception {
        String inputFile = "/TestSources/Tree1Text.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/Steps/Axes/Axes079.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/Steps/Axes/Axes079-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression17() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeBefore/nodeexpression17.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeBefore/nodeexpression17.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression19() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeBefore/nodeexpression19.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeBefore/nodeexpression19.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression20() throws Exception {
        String inputFile = "/TestSources/staff.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeBefore/nodeexpression20.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeBefore/nodeexpression20.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression25() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeBefore/nodeexpression25.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeBefore/nodeexpression25.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_nodeexpression27() throws Exception {
        String inputFile = "/TestSources/works.xml";
        String xqFile = "/Queries/XQuery/Expressions/Operators/NodeOp/NodeBefore/nodeexpression27.xq";
        String resultFile = "/ExpectedTestResults/Expressions/Operators/NodeOp/NodeBefore/nodeexpression27.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public Document load(URL url) throws Exception {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = url.openStream();
        if (inStream == null) {
            throw new FileNotFoundException("Can't file resource stream " + url.getFile());
        }
        this.model = (IDOMModel)modelManager.getModelForRead(url.getFile(), inStream, null);
        return this.model.getDocument();
    }

    public void test_unabbreviatedSyntax_1() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-1.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_2() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-2.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-2.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_3() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-3.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_8() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-8.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-8.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_9() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-9.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-9.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_12() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-12.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-12.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_13() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-13.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-13.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_14() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-14.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-14.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_15() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-15.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-15.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_16() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-16.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-16.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_18() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-18.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-18.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_19() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-19.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-19.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_20() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-20.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-20.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_21() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-21.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-21.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_22() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-22.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-22.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_23() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-23.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-23.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_26() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-26.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-26.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_27() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-27.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-27.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_28() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-28.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-28.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_29() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-29.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-29.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_30() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-30.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-30.txt";
        String expectedResult = "<result>" + this.getExpectedResult(resultFile) + "</result>";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<result>" + this.buildXMLResultString(rs) + "</result>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_31() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-31.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-31.txt";
        String expectedResult = this.formatResultString(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_unabbreviatedSyntax_32() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-32.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-32.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_unabbreviatedSyntax_33() throws Exception {
        String inputFile = "/TestSources/works-mod.xml";
        String xqFile = "/Queries/XQuery/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-33.xq";
        String resultFile = "/ExpectedTestResults/Expressions/PathExpr/UnabbrAxes/unabbreviatedSyntax-33.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_ReturnExpr011() throws Exception {
        String inputFile = "/TestSources/fsx.xml";
        String xqFile = "/Queries/XQuery/Expressions/FLWORExpr/ReturnExpr/ReturnExpr011.xq";
        String resultFile = "/ExpectedTestResults/Expressions/FLWORExpr/ReturnExpr/ReturnExpr011.xml";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.domDoc = this.load(fileURL);
        XSModel schema = null;
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildXMLResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        TestWTPDOMXPath2.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    protected String buildXMLResultString(ResultSequence rs) throws Exception {
        ListIterator iterator = rs.iterator();
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            AnyType aat = (AnyType)iterator.next();
            if (aat instanceof NodeType) {
                NodeType nodeType = (NodeType)aat;
                IDOMNode node = (IDOMNode)nodeType.node_value();
                buffer = buffer.append(node.getSource());
                continue;
            }
            buffer = buffer.append(aat.string_value());
        }
        return buffer.toString();
    }
}

