/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.testsuite.functions;

import java.net.URL;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;

public class InScopePrefixesFuncTest
extends AbstractPsychoPathTest {
    public void test_fn_in_scope_prefixes_2() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeFunc/InScopePrefixesFunc/fn-in-scope-prefixes-2.xq";
        String expectedResult = "XPTY0004";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        InScopePrefixesFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void testInScopePrefixesRoot() throws Exception {
        String inputFile = "/TestSources/fsx_NS.xml";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        dc.add_namespace("fsx", "http://www.example.com/filesystem");
        String xpath = "fn:in-scope-prefixes(./fsx:MyComputer)";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        String actual = this.buildResultString(rs);
        InScopePrefixesFuncTest.assertEquals((String)"XPath Result Error: ", (String)"fs", (String)actual);
    }

    public void testInScopePrefixesChildNode() throws Exception {
        String inputFile = "/TestSources/fsx_NS.xml";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        dc.add_namespace("fsx", "http://www.example.com/filesystem");
        String xpath = "fn:in-scope-prefixes(./fsx:MyComputer/fsx:Drive[1])";
        XPath path = this.compileXPath((DynamicContext)dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        String actual = this.buildResultString(rs);
        InScopePrefixesFuncTest.assertEquals((String)"XPath Result Error: ", (String)"fs", (String)actual);
    }
}

