/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkChangeTrackingAnnotation;

public class JavaEclipseLinkChangeTracking
extends AbstractJavaJpaContextNode
implements EclipseLinkChangeTracking {
    protected JavaResourcePersistentType resourcePersistentType;
    protected EclipseLinkChangeTrackingType specifiedType;

    public JavaEclipseLinkChangeTracking(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    protected String getChangeTrackingAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    protected EclipseLinkChangeTrackingAnnotation getChangeTrackingAnnotation() {
        return (EclipseLinkChangeTrackingAnnotation)this.resourcePersistentType.getAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void addChangeTrackingAnnotation() {
        this.resourcePersistentType.addAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void removeChangeTrackingAnnotation() {
        this.resourcePersistentType.removeAnnotation(this.getChangeTrackingAnnotationName());
    }

    public EclipseLinkChangeTrackingType getType() {
        return this.getSpecifiedType() != null ? this.getSpecifiedType() : this.getDefaultType();
    }

    public EclipseLinkChangeTrackingType getDefaultType() {
        return DEFAULT_TYPE;
    }

    public EclipseLinkChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(EclipseLinkChangeTrackingType newSpecifiedType) {
        if (this.specifiedType == newSpecifiedType) {
            return;
        }
        EclipseLinkChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (newSpecifiedType != null) {
            if (this.getChangeTrackingAnnotation() == null) {
                this.addChangeTrackingAnnotation();
            }
            this.getChangeTrackingAnnotation().setValue(EclipseLinkChangeTrackingType.toJavaResourceModel(newSpecifiedType));
        } else if (this.getChangeTrackingAnnotation() != null) {
            this.removeChangeTrackingAnnotation();
        }
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(EclipseLinkChangeTrackingType newSpecifiedType) {
        EclipseLinkChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        EclipseLinkChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        this.specifiedType = this.changeTrackingType(changeTrackingAnnotation);
    }

    public void update(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        EclipseLinkChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        this.setSpecifiedType_(this.changeTrackingType(changeTrackingAnnotation));
    }

    protected EclipseLinkChangeTrackingType changeTrackingType(EclipseLinkChangeTrackingAnnotation changeTracking) {
        if (changeTracking == null) {
            return null;
        }
        if (changeTracking.getValue() == null) {
            return EclipseLinkChangeTracking.DEFAULT_TYPE;
        }
        return EclipseLinkChangeTrackingType.fromJavaResourceModel(changeTracking.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        EclipseLinkChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        TextRange textRange = changeTrackingAnnotation == null ? null : changeTrackingAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }
}

