/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.java.JavaEclipseLinkConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkTypeConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConverterHolderImpl
extends AbstractJavaJpaContextNode
implements JavaEclipseLinkConverterHolder {
    protected JavaResourcePersistentType resourcePersistentType;
    protected JavaEclipseLinkCustomConverter customConverter;
    protected JavaEclipseLinkObjectTypeConverter objectTypeConverter;
    protected JavaEclipseLinkStructConverter structConverter;
    protected JavaEclipseLinkTypeConverter typeConverter;

    public JavaEclipseLinkConverterHolderImpl(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public EclipseLinkCustomConverter getCustomConverter() {
        return this.customConverter;
    }

    @Override
    public EclipseLinkCustomConverter addCustomConverter() {
        if (this.customConverter != null) {
            throw new IllegalStateException("custom converter already exists");
        }
        this.customConverter = this.buildCustomConverter();
        this.resourcePersistentType.addAnnotation(this.customConverter.getAnnotationName());
        this.firePropertyChanged("customConverter", null, this.customConverter);
        return this.customConverter;
    }

    protected void addCustomConverter_() {
        this.customConverter = this.buildCustomConverter();
        this.firePropertyChanged("customConverter", null, this.customConverter);
    }

    @Override
    public void removeCustomConverter() {
        if (this.customConverter == null) {
            throw new IllegalStateException("converter is null");
        }
        JavaEclipseLinkCustomConverter oldConverter = this.customConverter;
        this.customConverter = null;
        this.resourcePersistentType.removeAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("customConverter", oldConverter, null);
    }

    protected void removeCustomConverter_() {
        this.customConverter = null;
        this.firePropertyChanged("customConverter", this.customConverter, null);
    }

    protected String getConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    protected EclipseLinkConverterAnnotation getResourceConverter() {
        return (EclipseLinkConverterAnnotation)this.resourcePersistentType.getAnnotation(this.getConverterAnnotationName());
    }

    @Override
    public EclipseLinkObjectTypeConverter getObjectTypeConverter() {
        return this.objectTypeConverter;
    }

    @Override
    public EclipseLinkObjectTypeConverter addObjectTypeConverter() {
        if (this.objectTypeConverter != null) {
            throw new IllegalStateException("object type converter already exists");
        }
        this.objectTypeConverter = this.buildObjectTypeConverter();
        this.resourcePersistentType.addAnnotation(this.objectTypeConverter.getAnnotationName());
        this.firePropertyChanged("objectTypeConverter", null, this.objectTypeConverter);
        return this.objectTypeConverter;
    }

    protected void addObjectTypeConverter_() {
        this.objectTypeConverter = this.buildObjectTypeConverter();
        this.firePropertyChanged("objectTypeConverter", null, this.objectTypeConverter);
    }

    @Override
    public void removeObjectTypeConverter() {
        if (this.objectTypeConverter == null) {
            throw new IllegalStateException("object type converter is null");
        }
        JavaEclipseLinkObjectTypeConverter oldConverter = this.objectTypeConverter;
        this.objectTypeConverter = null;
        this.resourcePersistentType.removeAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("objectTypeConverter", oldConverter, null);
    }

    protected void removeObjectTypeConverter_() {
        JavaEclipseLinkObjectTypeConverter oldConverter = this.objectTypeConverter;
        this.objectTypeConverter = null;
        this.firePropertyChanged("objectTypeConverter", oldConverter, null);
    }

    protected String getObjectTypeConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    protected EclipseLinkObjectTypeConverterAnnotation getResourceObjectTypeConverter() {
        return (EclipseLinkObjectTypeConverterAnnotation)this.resourcePersistentType.getAnnotation(this.getObjectTypeConverterAnnotationName());
    }

    @Override
    public EclipseLinkTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public EclipseLinkTypeConverter addTypeConverter() {
        if (this.typeConverter != null) {
            throw new IllegalStateException("type converter already exists");
        }
        this.typeConverter = this.buildTypeConverter();
        this.resourcePersistentType.addAnnotation(this.typeConverter.getAnnotationName());
        this.firePropertyChanged("typeConverter", null, this.typeConverter);
        return this.typeConverter;
    }

    protected void addTypeConverter_() {
        this.typeConverter = this.buildTypeConverter();
        this.firePropertyChanged("typeConverter", null, this.typeConverter);
    }

    @Override
    public void removeTypeConverter() {
        if (this.typeConverter == null) {
            throw new IllegalStateException("type converter is null");
        }
        JavaEclipseLinkTypeConverter oldConverter = this.typeConverter;
        this.typeConverter = null;
        this.resourcePersistentType.removeAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("typeConverter", oldConverter, null);
    }

    protected void removeTypeConverter_() {
        JavaEclipseLinkTypeConverter oldConverter = this.typeConverter;
        this.typeConverter = null;
        this.firePropertyChanged("typeConverter", oldConverter, null);
    }

    protected String getTypeConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.TypeConverter";
    }

    protected EclipseLinkTypeConverterAnnotation getResourceTypeConverter() {
        return (EclipseLinkTypeConverterAnnotation)this.resourcePersistentType.getAnnotation(this.getTypeConverterAnnotationName());
    }

    @Override
    public EclipseLinkStructConverter getStructConverter() {
        return this.structConverter;
    }

    @Override
    public EclipseLinkStructConverter addStructConverter() {
        if (this.structConverter != null) {
            throw new IllegalStateException("struct converter already exists");
        }
        this.structConverter = this.buildStructConverter();
        this.resourcePersistentType.addAnnotation(this.structConverter.getAnnotationName());
        this.firePropertyChanged("structConverter", null, this.structConverter);
        return this.structConverter;
    }

    protected void addStructConverter_() {
        this.structConverter = this.buildStructConverter();
        this.firePropertyChanged("structConverter", null, this.structConverter);
    }

    @Override
    public void removeStructConverter() {
        if (this.structConverter == null) {
            throw new IllegalStateException("struct converter is null");
        }
        JavaEclipseLinkStructConverter oldConverter = this.structConverter;
        this.structConverter = null;
        this.resourcePersistentType.removeAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("structConverter", oldConverter, null);
    }

    protected void removeStructConverter_() {
        JavaEclipseLinkStructConverter oldConverter = this.structConverter;
        this.structConverter = null;
        this.firePropertyChanged("structConverter", oldConverter, null);
    }

    protected String getStructConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.StructConverter";
    }

    protected EclipseLinkStructConverterAnnotation getResourceStructConverter() {
        return (EclipseLinkStructConverterAnnotation)this.resourcePersistentType.getAnnotation(this.getStructConverterAnnotationName());
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.updateCustomConverter();
        this.updateObjectTypeConverter();
        this.updateTypeConverter();
        this.updateStructConverter();
    }

    protected void updateCustomConverter() {
        if (this.getResourceConverter() != null) {
            if (this.customConverter != null) {
                this.customConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addCustomConverter_();
            }
        } else if (this.customConverter != null) {
            this.removeCustomConverter_();
        }
    }

    protected void updateObjectTypeConverter() {
        if (this.getResourceObjectTypeConverter() != null) {
            if (this.objectTypeConverter != null) {
                this.objectTypeConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addObjectTypeConverter_();
            }
        } else if (this.objectTypeConverter != null) {
            this.removeObjectTypeConverter_();
        }
    }

    protected void updateTypeConverter() {
        if (this.getResourceTypeConverter() != null) {
            if (this.typeConverter != null) {
                this.typeConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addTypeConverter_();
            }
        } else if (this.typeConverter != null) {
            this.removeTypeConverter();
        }
    }

    protected void updateStructConverter() {
        if (this.getResourceStructConverter() != null) {
            if (this.structConverter != null) {
                this.structConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addStructConverter_();
            }
        } else if (this.structConverter != null) {
            this.removeStructConverter_();
        }
    }

    @Override
    public void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.initializeCustomConverter();
        this.initializeObjectTypeConverter();
        this.initializeTypeConverter();
        this.initializeStructConverter();
    }

    protected void initializeCustomConverter() {
        if (this.getResourceConverter() != null) {
            this.customConverter = this.buildCustomConverter();
        }
    }

    protected void initializeObjectTypeConverter() {
        if (this.getResourceObjectTypeConverter() != null) {
            this.objectTypeConverter = this.buildObjectTypeConverter();
        }
    }

    protected void initializeTypeConverter() {
        if (this.getResourceTypeConverter() != null) {
            this.typeConverter = this.buildTypeConverter();
        }
    }

    protected void initializeStructConverter() {
        if (this.getResourceStructConverter() != null) {
            this.structConverter = this.buildStructConverter();
        }
    }

    protected JavaEclipseLinkCustomConverter buildCustomConverter() {
        JavaEclipseLinkCustomConverter contextConverter = new JavaEclipseLinkCustomConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected JavaEclipseLinkTypeConverter buildTypeConverter() {
        JavaEclipseLinkTypeConverter contextConverter = new JavaEclipseLinkTypeConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected JavaEclipseLinkObjectTypeConverter buildObjectTypeConverter() {
        JavaEclipseLinkObjectTypeConverter contextConverter = new JavaEclipseLinkObjectTypeConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected JavaEclipseLinkStructConverter buildStructConverter() {
        JavaEclipseLinkStructConverter contextConverter = new JavaEclipseLinkStructConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.customConverter != null) {
            this.customConverter.validate(messages, reporter, astRoot);
        }
        if (this.objectTypeConverter != null) {
            this.objectTypeConverter.validate(messages, reporter, astRoot);
        }
        if (this.typeConverter != null) {
            this.typeConverter.validate(messages, reporter, astRoot);
        }
        if (this.structConverter != null) {
            this.structConverter.validate(messages, reporter, astRoot);
        }
    }
}

