/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkStructConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements EclipseLinkStructConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.StructConverter");
    private static final DeclarationAnnotationElementAdapter<String> CONVERTER_ADAPTER = SourceEclipseLinkStructConverterAnnotation.buildConverterAdapter();
    private final AnnotationElementAdapter<String> converterAdapter;
    private String converter;

    public SourceEclipseLinkStructConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.converterAdapter = new MemberAnnotationElementAdapter(member, CONVERTER_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.StructConverter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.converter = this.buildConverter(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncConverter(this.buildConverter(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(String converter) {
        if (this.attributeValueHasChanged(this.converter, converter)) {
            this.converter = converter;
            this.converterAdapter.setValue((Object)converter);
        }
    }

    private void syncConverter(String astConverter) {
        String old = this.converter;
        this.converter = astConverter;
        this.firePropertyChanged("converter", old, astConverter);
    }

    private String buildConverter(CompilationUnit astRoot) {
        return (String)this.converterAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getConverterTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CONVERTER_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildConverterAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "converter", false, StringExpressionConverter.instance());
    }
}

