/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.layouts;

import java.util.Iterator;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BindingEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.model.BindingContentPlaceHolder;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBindingMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBindingOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;

public class BindingContentLayout
extends AbstractLayout {
    BindingEditPart bindingEditPart;

    public BindingContentLayout(BindingEditPart bindingEditPart) {
        this.bindingEditPart = bindingEditPart;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (this.bindingEditPart.isExpanded()) {
            Rectangle clientArea = container.getClientArea();
            return new Dimension(clientArea.width, clientArea.height);
        }
        return new Dimension(0, 0);
    }

    public void layout(IFigure container) {
        Rectangle clientArea = container.getClientArea();
        Iterator i = this.bindingEditPart.getChildren().iterator();
        while (i.hasNext()) {
            AbstractGraphicalEditPart childEditPart = (AbstractGraphicalEditPart)i.next();
            AbstractGraphicalEditPart correspondingEditPart = null;
            Object model = childEditPart.getModel();
            if (model instanceof IBindingOperation) {
                IOperation operation = ((IBindingOperation)model).getOperation();
                correspondingEditPart = this.getEditPart(operation);
            } else if (model instanceof IBindingMessageReference) {
                IMessageReference messageReference = ((IBindingMessageReference)model).getMessageReference();
                correspondingEditPart = this.getEditPart(messageReference);
            } else if (model instanceof BindingContentPlaceHolder) {
                Object correspondingModel = ((BindingContentPlaceHolder)model).getModel();
                correspondingEditPart = this.getEditPart(correspondingModel);
            }
            if (correspondingEditPart == null) continue;
            IFigure figure = correspondingEditPart.getFigure();
            if (correspondingEditPart instanceof INamedEditPart) {
                figure = ((INamedEditPart)correspondingEditPart).getLabelFigure();
            }
            Rectangle bounds = figure.getBounds();
            Rectangle newBounds = new Rectangle(clientArea.x, bounds.y, clientArea.width, bounds.height);
            childEditPart.getFigure().setBounds(newBounds);
        }
    }

    protected AbstractGraphicalEditPart getEditPart(Object model) {
        EditPart editPart;
        if (model != null && (editPart = (EditPart)this.bindingEditPart.getViewer().getEditPartRegistry().get(model)) instanceof AbstractGraphicalEditPart) {
            return (AbstractGraphicalEditPart)editPart;
        }
        return null;
    }
}

