/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebParam;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class RemoveAnnotationFromMethodParameterTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "Calculator.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(@WebParam(name=\"i\")");
        classContents.append("int i, int k) {\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebParam.class.getSimpleName(), null);
    }

    public void testRemoveAnnotationFromMethodParameter() {
        try {
            RemoveAnnotationFromMethodParameterTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromMethodParameterTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("add", new String[]{"I", "I"});
            RemoveAnnotationFromMethodParameterTest.assertNotNull((Object)method);
            ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (String)"i");
            RemoveAnnotationFromMethodParameterTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (Annotation)this.annotation));
            RemoveAnnotationFromMethodParameterTest.assertNotNull((Object)this.source.getImport(WebParam.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)localVariable, (Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)localVariable, (String)WebParam.class.getCanonicalName()));
            RemoveAnnotationFromMethodParameterTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            RemoveAnnotationFromMethodParameterTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (Annotation)this.annotation));
            RemoveAnnotationFromMethodParameterTest.assertFalse((boolean)this.source.getImport(WebParam.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            RemoveAnnotationFromMethodParameterTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

