/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.operations.AbstractJpaFileCreationDataModelProvider;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmFileCreationDataModelProvider
extends AbstractJpaFileCreationDataModelProvider
implements OrmFileCreationDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new OrmFileCreationOperation(this.getDataModel());
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = super.getPropertyNames();
        propertyNames.add("OrmFileCreationDataModelProperties.DEFAULT_ACCESS");
        propertyNames.add("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        propertyNames.add("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        }
        return super.isPropertyEnabled(propertyName);
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        PersistenceUnit pUnit;
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return null;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT") && (pUnit = this.getDefaultPersistenceUnit()) != null) {
            return pUnit.getName();
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    protected String getDefaultFilePath() {
        return new Path("META-INF/orm.xml").toPortableString();
    }

    @Override
    protected String getDefaultVersion() {
        if (this.getProject() == null) {
            return null;
        }
        return JptCorePlugin.getJpaPlatform(this.getProject()).getMostRecentSupportedResourceType(JptCorePlugin.ORM_XML_CONTENT_TYPE).getVersion();
    }

    protected PersistenceUnit getDefaultPersistenceUnit() {
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.persistenceUnitsSize() == 0) {
            return null;
        }
        return persistence.persistenceUnits().next();
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 2);
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 4);
        } else if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 3);
        }
        return ok;
    }

    @Override
    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            DataModelPropertyDescriptor[] accessTypes = new DataModelPropertyDescriptor[]{this.accessPropertyDescriptor(null), this.accessPropertyDescriptor(AccessType.FIELD), this.accessPropertyDescriptor(AccessType.PROPERTY)};
            return accessTypes;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return (DataModelPropertyDescriptor[])ArrayTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>((Iterator)new CompositeIterator(null, this.persistenceUnitNames())){

                protected DataModelPropertyDescriptor transform(String next) {
                    return OrmFileCreationDataModelProvider.this.persistenceUnitPropertyDescriptor(next);
                }
            }, (Object[])new DataModelPropertyDescriptor[0]);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    @Override
    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.persistenceUnitPropertyDescriptor(this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor accessPropertyDescriptor(AccessType accessType) {
        if (accessType == null) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)accessType, accessType.getName());
    }

    DataModelPropertyDescriptor persistenceUnitPropertyDescriptor(String persistenceUnitName) {
        if (StringTools.stringIsEmpty((String)persistenceUnitName)) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)persistenceUnitName);
    }

    @Override
    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT") || propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            status = this.validatePersistenceUnit();
        }
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected boolean fileVersionSupported(String fileVersion) {
        return fileVersion.equals("1.0") || fileVersion.equals("2.0");
    }

    @Override
    protected boolean fileVersionSupportedForFacetVersion(String fileVersion, String jpaFacetVersion) {
        return !jpaFacetVersion.equals("1.0") || !fileVersion.equals("2.0");
    }

    protected IStatus validatePersistenceUnit() {
        boolean addToPUnit = this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        String projectName = this.getStringProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        if (addToPUnit) {
            if (StringTools.stringIsEmpty((String)pUnitName)) {
                return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_DOES_NOT_SPECIFIED, (Object)pUnitName));
            }
            if (this.getPersistenceUnit() == null) {
                return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_NOT_IN_PROJECT, (Object)pUnitName, (Object)projectName));
            }
        }
        return Status.OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() {
        Persistence persistence;
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = StringTools.stringIsEmpty((String)pUnitName) ? null : this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
        Persistence persistence2 = persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
        if (persistence != null) {
            ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
            while (stream.hasNext()) {
                PersistenceUnit next = (PersistenceUnit)stream.next();
                if (!pUnitName.equals(next.getName())) continue;
                return next;
            }
        }
        return null;
    }

    protected Iterator<PersistenceUnit> persistenceUnits() {
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
        Persistence persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
        return persistence == null ? EmptyIterator.instance() : persistence.persistenceUnits();
    }

    protected Iterator<String> persistenceUnitNames() {
        return new TransformationIterator<PersistenceUnit, String>(this.persistenceUnits()){

            protected String transform(PersistenceUnit next) {
                return next.getName();
            }
        };
    }
}

