/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.launching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.Connector;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptImageRegistry;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;

public class JavaScriptConnectTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    Text description = null;
    Combo connectorcombo = null;
    Connector selectedconnector = null;
    Group argumentsgroup = null;
    HashMap editormap = new HashMap();

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
        Group group = SWTFactory.createGroup(comp, Messages.connector, 1, 2, 768);
        this.connectorcombo = SWTFactory.createCombo((Composite)group, 0x800808, 1, null);
        GridData gd = (GridData)this.connectorcombo.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.connectorcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptConnectTab.this.handleConnectorSelected();
            }
        });
        this.description = SWTFactory.createText((Composite)group, 72, 1);
        gd = (GridData)this.description.getLayoutData();
        gd.heightHint = 30;
        List connectors = JavaScriptDebugPlugin.getConnectionsManager().getConnectors();
        Connector connector = null;
        int i = 0;
        while (i < connectors.size()) {
            connector = (Connector)connectors.get(i);
            this.connectorcombo.add(connector.name());
            this.connectorcombo.setData(connector.name(), (Object)connector);
            ++i;
        }
        this.argumentsgroup = SWTFactory.createGroup(comp, Messages.connector_properties, 2, 2, 768);
        this.argumentsgroup.setVisible(false);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.wst.jsdt.debug.ui.connect_tab");
    }

    Connector getSelectedConnector() {
        if (this.connectorcombo.getItemCount() > 0) {
            int idx = this.connectorcombo.getSelectionIndex();
            idx = idx < 0 ? 0 : idx;
            String name = this.connectorcombo.getItem(idx);
            return (Connector)this.connectorcombo.getData(name);
        }
        return null;
    }

    void handleConnectorSelected() {
        Connector connect = this.getSelectedConnector();
        if (connect == null || connect.equals(this.selectedconnector)) {
            return;
        }
        this.selectedconnector = connect;
        String desc = this.selectedconnector.description();
        if (desc != null) {
            this.description.setText(desc);
        } else {
            this.description.setText(Messages.no_description_provided);
        }
        this.editormap.clear();
        Control[] children = this.argumentsgroup.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        PreferenceStore store = new PreferenceStore();
        Map.Entry entry = null;
        Connector.Argument argument = null;
        IntegerFieldEditor editor = null;
        String key = null;
        Iterator iter = this.selectedconnector.defaultArguments().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            key = (String)entry.getKey();
            argument = (Connector.Argument)entry.getValue();
            if (argument instanceof Connector.IntegerArgument) {
                store.setDefault(argument.name(), ((Connector.IntegerArgument)argument).intValue());
                editor = new IntegerFieldEditor(argument.name(), argument.label(), (Composite)this.argumentsgroup);
            } else if (argument instanceof Connector.BooleanArgument) {
                store.setDefault(argument.name(), ((Connector.BooleanArgument)argument).booleanValue());
                editor = new BooleanFieldEditor(argument.name(), argument.label(), (Composite)this.argumentsgroup);
            } else if (argument instanceof Connector.StringArgument) {
                store.setDefault(argument.name(), argument.value());
                editor = new StringFieldEditor(argument.name(), argument.label(), (Composite)this.argumentsgroup);
            } else if (argument instanceof Connector.SelectedArgument) {
                List choices = ((Connector.SelectedArgument)argument).choices();
                String[][] namesAndValues = new String[choices.size()][2];
                int count = 0;
                Iterator iter2 = choices.iterator();
                while (iter2.hasNext()) {
                    String choice;
                    namesAndValues[count][0] = choice = (String)iter2.next();
                    namesAndValues[count][1] = choice;
                    ++count;
                }
                store.setDefault(argument.name(), argument.value());
                editor = new ComboFieldEditor(argument.name(), argument.label(), namesAndValues, (Composite)this.argumentsgroup);
            }
            if (editor == null) continue;
            editor.setPreferenceStore((IPreferenceStore)store);
            editor.loadDefault();
            editor.setPropertyChangeListener((IPropertyChangeListener)this);
            this.editormap.put(key, editor);
            editor = null;
        }
        GridLayout gd = (GridLayout)this.argumentsgroup.getLayout();
        gd.marginHeight = 5;
        gd.marginWidth = 5;
        this.argumentsgroup.getParent().layout(true);
        this.argumentsgroup.setVisible(true);
        this.argumentsgroup.layout(true);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        keys = this.editormap.keySet().iterator();
        connector = this.getSelectedConnector();
        if (connector != null) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            key = (String)keys.next();
            arg = (Connector.Argument)connector.defaultArguments().get(key);
            editor = (FieldEditor)this.editormap.get(key);
            if (!(editor instanceof StringFieldEditor) || arg.isValid(value = ((StringFieldEditor)editor).getStringValue())) continue;
            this.setErrorMessage(NLS.bind((String)Messages.the_argument_0_is_not_valid, (Object[])new String[]{arg.name()}));
            return false;
lbl12:
            // 2 sources

            ** while (keys.hasNext())
        }
lbl13:
        // 1 sources

        return true;
    }

    public String getName() {
        return Messages.connect;
    }

    public Image getImage() {
        return JavaScriptImageRegistry.getSharedImage("IMG_CONNECT");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            Connector connector;
            String connectorid = configuration.getAttribute("connector_id", null);
            if (connectorid != null && (connector = JavaScriptDebugPlugin.getConnectionsManager().getConnector(connectorid)) != null) {
                int idx = this.connectorcombo.indexOf(connector.name());
                if (idx > -1) {
                    this.connectorcombo.select(idx);
                    this.handleConnectorSelected();
                    Map argmap = configuration.getAttribute("argument_map", null);
                    if (argmap != null) {
                        Map.Entry entry = null;
                        Connector.Argument argument = null;
                        String key = null;
                        FieldEditor editor = null;
                        Iterator iter = argmap.entrySet().iterator();
                        while (iter.hasNext()) {
                            entry = iter.next();
                            key = (String)entry.getKey();
                            argument = (Connector.Argument)connector.defaultArguments().get(key);
                            editor = (FieldEditor)this.editormap.get(key);
                            if (argument == null || editor == null) continue;
                            String value = (String)argmap.get(key);
                            if (argument instanceof Connector.StringArgument || argument instanceof Connector.SelectedArgument) {
                                editor.getPreferenceStore().setValue(key, value);
                            } else if (argument instanceof Connector.BooleanArgument) {
                                editor.getPreferenceStore().setValue(key, Boolean.valueOf(value).booleanValue());
                            } else if (argument instanceof Connector.IntegerArgument) {
                                editor.getPreferenceStore().setValue(key, new Integer(value).intValue());
                            }
                            editor.load();
                        }
                    }
                } else {
                    this.connectorcombo.select(0);
                    this.handleConnectorSelected();
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Connector connector = this.getSelectedConnector();
        if (connector != null) {
            configuration.setAttribute("connector_id", connector.id());
            Map.Entry entry = null;
            FieldEditor editor = null;
            String key = null;
            HashMap<String, String> argmap = new HashMap<String, String>();
            Connector.Argument argument = null;
            Iterator iter = this.editormap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                editor = (FieldEditor)entry.getValue();
                if (!editor.isValid()) {
                    return;
                }
                key = (String)entry.getKey();
                argument = (Connector.Argument)connector.defaultArguments().get(key);
                if (argument == null) continue;
                editor.store();
                if (argument instanceof Connector.StringArgument || argument instanceof Connector.SelectedArgument) {
                    argmap.put(key, editor.getPreferenceStore().getString(key));
                    continue;
                }
                if (argument instanceof Connector.BooleanArgument) {
                    argmap.put(key, Boolean.valueOf(editor.getPreferenceStore().getBoolean(key)).toString());
                    continue;
                }
                if (!(argument instanceof Connector.IntegerArgument)) continue;
                argmap.put(key, new Integer(editor.getPreferenceStore().getInt(key)).toString());
            }
            configuration.setAttribute("argument_map", argmap);
        } else {
            configuration.removeAttribute("argument_map");
            configuration.removeAttribute("connector_id");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        List connectors = JavaScriptDebugPlugin.getConnectionsManager().getConnectors();
        if (!connectors.isEmpty()) {
            configuration.setAttribute("connector_id", ((Connector)connectors.get(0)).id());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }
}

