/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDBasicType;
import org.eclipse.wst.dtd.core.internal.emf.DTDDefaultKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumGroupKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumerationType;
import org.eclipse.wst.dtd.core.internal.emf.DTDLexicalInfo;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.DTDPackage;
import org.eclipse.wst.dtd.core.internal.emf.DTDType;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDFactoryImpl;

public class DTDAttributeImpl
extends EAttributeImpl
implements DTDAttribute {
    DTDLexicalInfo lexInfo = new DTDLexicalInfo();
    protected static final String COMMENT_EDEFAULT = null;
    protected String comment = COMMENT_EDEFAULT;
    protected static final DTDDefaultKind DEFAULT_KIND_EDEFAULT = DTDDefaultKind.IMPLIED_LITERAL;
    protected DTDDefaultKind defaultKind = DEFAULT_KIND_EDEFAULT;
    protected static final String DEFAULT_VALUE_STRING_EDEFAULT = null;
    protected String defaultValueString = DEFAULT_VALUE_STRING_EDEFAULT;
    protected DTDEntity attributeNameReferencedEntity = null;
    protected DTDEntity attributeTypeReferencedEntity = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DTDType getDTDType() {
        return (DTDType)this.getEType();
    }

    public void setDTDType(DTDType type) {
        this.setEType((EClassifier)type);
    }

    public void setDTDBasicType(int value) {
        DTDFactoryImpl factory = (DTDFactoryImpl)DTDFactoryImpl.instance();
        switch (value) {
            case 0: {
                this.setDTDType(factory.getDTDBasicType_NONE());
                break;
            }
            case 1: {
                this.setDTDType(factory.getDTDBasicType_CDATA());
                break;
            }
            case 2: {
                this.setDTDType(factory.getDTDBasicType_ID());
                break;
            }
            case 3: {
                this.setDTDType(factory.getDTDBasicType_IDREF());
                break;
            }
            case 4: {
                this.setDTDType(factory.getDTDBasicType_IDREFS());
                break;
            }
            case 5: {
                this.setDTDType(factory.getDTDBasicType_ENTITY());
                break;
            }
            case 6: {
                this.setDTDType(factory.getDTDBasicType_ENTITIES());
                break;
            }
            case 7: {
                this.setDTDType(factory.getDTDBasicType_NMTOKEN());
                break;
            }
            case 8: {
                this.setDTDType(factory.getDTDBasicType_NMTOKENS());
            }
        }
    }

    public String unparse() {
        StringBuffer result = new StringBuffer(128);
        result.append(this.getName());
        StringBuffer value = new StringBuffer();
        switch (this.getDefaultKind().getValue()) {
            case 1: {
                value.append("#IMPLIED");
                break;
            }
            case 2: {
                value.append("#REQUIRED");
                break;
            }
            case 3: {
                String type = this.getDTDType().toString();
                if (type.equals("Identifier (ID)") || type.equals("ID Reference (IDREF)") || type.equals("Enumerated Name Tokens") || type.equals("ID References (IDREFS)")) break;
                value.append("#FIXED \"").append(this.getDefaultValueString()).append("\"");
                break;
            }
            case 4: {
                String defaultValue = this.getDefaultValueString();
                if (defaultValue == null) break;
                value.append("\"").append(defaultValue).append("\"");
            }
        }
        DTDEntity typeEnt = this.getAttributeTypeReferencedEntity();
        if (typeEnt != null) {
            result.append(" %" + typeEnt.getName() + "; ").append(value);
        } else {
            DTDType dtdType = this.getDTDType();
            if (dtdType instanceof DTDBasicType) {
                switch (((DTDBasicType)dtdType).getKind().getValue()) {
                    case 1: {
                        result.append(" CDATA ").append(value);
                        break;
                    }
                    case 2: {
                        result.append(" ID ").append(value);
                        break;
                    }
                    case 3: {
                        result.append(" IDREF ").append(value);
                        break;
                    }
                    case 4: {
                        result.append(" IDREFS ").append(value);
                        break;
                    }
                    case 5: {
                        result.append(" ENTITY ").append(value);
                        break;
                    }
                    case 6: {
                        result.append(" ENTITIES ").append(value);
                        break;
                    }
                    case 7: {
                        result.append(" NMTOKEN ").append(value);
                        break;
                    }
                    case 8: {
                        result.append(" NMTOKENS ").append(value);
                    }
                }
            } else if (dtdType instanceof DTDEnumerationType) {
                result.append(" ").append(this.buildEnumString((DTDEnumerationType)dtdType)).append(value);
            }
        }
        return result.toString();
    }

    private String buildEnumString(DTDEnumerationType enumType) {
        Iterator i;
        String result = "";
        if (enumType.getKind().getValue() == 2) {
            result = String.valueOf(result) + "NOTATION ";
        }
        if ((i = enumType.getEnumLiterals().iterator()).hasNext()) {
            result = String.valueOf(result) + "(" + ((EEnumLiteral)i.next()).toString();
            while (i.hasNext()) {
                result = String.valueOf(result) + " | " + ((EEnumLiteral)i.next()).toString();
            }
            result = String.valueOf(result) + ") ";
        }
        return result;
    }

    public DTDEnumerationType createDTDEnumeration(String[] enumValues, int enumKind) {
        DTDEnumerationType enumeration = DTDFactoryImpl.instance().createDTDEnumerationType();
        DTDEnumGroupKind groupKind = DTDEnumGroupKind.get(enumKind);
        enumeration.setKind(groupKind);
        if (enumValues != null) {
            int i = 0;
            while (i < enumValues.length) {
                EcorePackage ePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
                EEnumLiteral enumLiteral = ((EcoreFactory)ePackage.getEFactoryInstance()).createEEnumLiteral();
                enumLiteral.setName(enumValues[i]);
                enumLiteral.setValue(i);
                enumeration.getEnumLiterals().add((Object)enumLiteral);
                ++i;
            }
        }
        this.getDTDElement().getDTDFile().getDTDEnumerationType().add((Object)enumeration);
        return enumeration;
    }

    public String getPathname() {
        return null;
    }

    public DTDObject findObject(String relativePath) {
        return null;
    }

    public Collection getEnumeratedValues() {
        ArrayList<String> result = new ArrayList<String>();
        DTDType type = this.getDTDType();
        if (type instanceof DTDEnumerationType) {
            DTDEnumerationType enumType = (DTDEnumerationType)type;
            Iterator i = enumType.getEnumLiterals().iterator();
            while (i.hasNext()) {
                result.add(((EEnumLiteral)i.next()).toString());
            }
        }
        return result;
    }

    public int getStartOffset() {
        return this.lexInfo.getStartOffset();
    }

    public void setStartOffset(int v) {
        this.lexInfo.setStartOffset(v);
    }

    public int getEndOffset() {
        return this.lexInfo.getEndOffset();
    }

    public void setEndOffset(int v) {
        this.lexInfo.setEndOffset(v);
    }

    protected EClass eStaticClass() {
        return DTDPackage.eINSTANCE.getDTDAttribute();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldComment, (Object)this.comment));
        }
    }

    public DTDDefaultKind getDefaultKind() {
        return this.defaultKind;
    }

    public void setDefaultKind(DTDDefaultKind newDefaultKind) {
        DTDDefaultKind oldDefaultKind = this.defaultKind;
        DTDDefaultKind dTDDefaultKind = this.defaultKind = newDefaultKind == null ? DEFAULT_KIND_EDEFAULT : newDefaultKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldDefaultKind, (Object)this.defaultKind));
        }
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    public void setDefaultValueString(String newDefaultValueString) {
        String oldDefaultValueString = this.defaultValueString;
        this.defaultValueString = newDefaultValueString;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldDefaultValueString, (Object)this.defaultValueString));
        }
    }

    public DTDEntity getAttributeNameReferencedEntity() {
        if (this.attributeNameReferencedEntity != null && this.attributeNameReferencedEntity.eIsProxy()) {
            DTDEntity oldAttributeNameReferencedEntity = this.attributeNameReferencedEntity;
            this.attributeNameReferencedEntity = (DTDEntity)EcoreUtil.resolve((EObject)this.attributeNameReferencedEntity, (EObject)this);
            if (this.attributeNameReferencedEntity != oldAttributeNameReferencedEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 23, (Object)oldAttributeNameReferencedEntity, (Object)this.attributeNameReferencedEntity));
            }
        }
        return this.attributeNameReferencedEntity;
    }

    public DTDEntity basicGetAttributeNameReferencedEntity() {
        return this.attributeNameReferencedEntity;
    }

    public NotificationChain basicSetAttributeNameReferencedEntity(DTDEntity newAttributeNameReferencedEntity, NotificationChain msgs) {
        DTDEntity oldAttributeNameReferencedEntity = this.attributeNameReferencedEntity;
        this.attributeNameReferencedEntity = newAttributeNameReferencedEntity;
        if (this.eNotificationRequired()) {
            if (msgs == null) {
                msgs = new NotificationChainImpl(4);
            }
            msgs.add((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldAttributeNameReferencedEntity, (Object)newAttributeNameReferencedEntity));
        }
        return msgs;
    }

    public void setAttributeNameReferencedEntity(DTDEntity newAttributeNameReferencedEntity) {
        if (newAttributeNameReferencedEntity != this.attributeNameReferencedEntity) {
            NotificationChain msgs = null;
            if (this.attributeNameReferencedEntity != null) {
                InternalEObject internalEObject = (InternalEObject)this.attributeNameReferencedEntity;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 6, (Class)clazz, msgs);
            }
            if (newAttributeNameReferencedEntity != null) {
                InternalEObject internalEObject = (InternalEObject)newAttributeNameReferencedEntity;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 6, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetAttributeNameReferencedEntity(newAttributeNameReferencedEntity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newAttributeNameReferencedEntity, (Object)newAttributeNameReferencedEntity));
        }
    }

    public DTDEntity getAttributeTypeReferencedEntity() {
        if (this.attributeTypeReferencedEntity != null && this.attributeTypeReferencedEntity.eIsProxy()) {
            DTDEntity oldAttributeTypeReferencedEntity = this.attributeTypeReferencedEntity;
            this.attributeTypeReferencedEntity = (DTDEntity)EcoreUtil.resolve((EObject)this.attributeTypeReferencedEntity, (EObject)this);
            if (this.attributeTypeReferencedEntity != oldAttributeTypeReferencedEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 24, (Object)oldAttributeTypeReferencedEntity, (Object)this.attributeTypeReferencedEntity));
            }
        }
        return this.attributeTypeReferencedEntity;
    }

    public DTDEntity basicGetAttributeTypeReferencedEntity() {
        return this.attributeTypeReferencedEntity;
    }

    public NotificationChain basicSetAttributeTypeReferencedEntity(DTDEntity newAttributeTypeReferencedEntity, NotificationChain msgs) {
        DTDEntity oldAttributeTypeReferencedEntity = this.attributeTypeReferencedEntity;
        this.attributeTypeReferencedEntity = newAttributeTypeReferencedEntity;
        if (this.eNotificationRequired()) {
            if (msgs == null) {
                msgs = new NotificationChainImpl(4);
            }
            msgs.add((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldAttributeTypeReferencedEntity, (Object)newAttributeTypeReferencedEntity));
        }
        return msgs;
    }

    public void setAttributeTypeReferencedEntity(DTDEntity newAttributeTypeReferencedEntity) {
        if (newAttributeTypeReferencedEntity != this.attributeTypeReferencedEntity) {
            NotificationChain msgs = null;
            if (this.attributeTypeReferencedEntity != null) {
                InternalEObject internalEObject = (InternalEObject)this.attributeTypeReferencedEntity;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
            }
            if (newAttributeTypeReferencedEntity != null) {
                InternalEObject internalEObject = (InternalEObject)newAttributeTypeReferencedEntity;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 7, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetAttributeTypeReferencedEntity(newAttributeTypeReferencedEntity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)newAttributeTypeReferencedEntity, (Object)newAttributeTypeReferencedEntity));
        }
    }

    public DTDElement getDTDElement() {
        if (this.eContainerFeatureID() != 25) {
            return null;
        }
        return (DTDElement)this.eContainer;
    }

    public void setDTDElement(DTDElement newDTDElement) {
        if (newDTDElement != this.eContainer || this.eContainerFeatureID() != 25 && newDTDElement != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDTDElement)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString() + ".");
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDTDElement != null) {
                InternalEObject internalEObject = (InternalEObject)newDTDElement;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 27, (Class)clazz, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newDTDElement, 25, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, (Object)newDTDElement, (Object)newDTDElement));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        block12: {
            if (featureID < 0) break block12;
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 23: {
                    if (this.attributeNameReferencedEntity == null) return this.basicSetAttributeNameReferencedEntity((DTDEntity)otherEnd, msgs);
                    InternalEObject internalEObject = (InternalEObject)this.attributeNameReferencedEntity;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    msgs = internalEObject.eInverseRemove((InternalEObject)this, 6, (Class)clazz, msgs);
                    return this.basicSetAttributeNameReferencedEntity((DTDEntity)otherEnd, msgs);
                }
                case 24: {
                    if (this.attributeTypeReferencedEntity == null) return this.basicSetAttributeTypeReferencedEntity((DTDEntity)otherEnd, msgs);
                    InternalEObject internalEObject = (InternalEObject)this.attributeTypeReferencedEntity;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDEntity");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    msgs = internalEObject.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                    return this.basicSetAttributeTypeReferencedEntity((DTDEntity)otherEnd, msgs);
                }
                case 25: {
                    if (this.eContainer == null) return this.eBasicSetContainer(otherEnd, 25, msgs);
                    msgs = this.eBasicRemoveFromContainer(msgs);
                    return this.eBasicSetContainer(otherEnd, 25, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer == null) return this.eBasicSetContainer(otherEnd, featureID, msgs);
        msgs = this.eBasicRemoveFromContainer(msgs);
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (baseClass == null ? featureID : this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 23: {
                    return this.basicSetAttributeNameReferencedEntity(null, msgs);
                }
                case 24: {
                    return this.basicSetAttributeTypeReferencedEntity(null, msgs);
                }
                case 25: {
                    return this.eBasicSetContainer(null, 25, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID() < 0) break block6;
            switch (this.eContainerFeatureID()) {
                case 25: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.wst.dtd.core.internal.emf.DTDElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 27, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID(), null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 8: {
                if (resolve) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
            case 10: {
                return this.isChangeable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.isVolatile() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isTransient() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.getDefaultValueLiteral();
            }
            case 14: {
                return this.getDefaultValue();
            }
            case 4: {
                return new Integer(this.getLowerBound());
            }
            case 5: {
                return new Integer(this.getUpperBound());
            }
            case 6: {
                return this.isMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.getEContainingClass();
            }
            case 15: {
                return this.isUnsettable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.isID() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                if (resolve) {
                    return this.getEAttributeType();
                }
                return this.basicGetEAttributeType();
            }
            case 20: {
                return this.getComment();
            }
            case 21: {
                return this.getDefaultKind();
            }
            case 22: {
                return this.getDefaultValueString();
            }
            case 23: {
                if (resolve) {
                    return this.getAttributeNameReferencedEntity();
                }
                return this.basicGetAttributeNameReferencedEntity();
            }
            case 24: {
                if (resolve) {
                    return this.getAttributeTypeReferencedEntity();
                }
                return this.basicGetAttributeTypeReferencedEntity();
            }
            case 25: {
                return this.getDTDElement();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 8: {
                this.setEType((EClassifier)newValue);
                return;
            }
            case 10: {
                this.setChangeable((Boolean)newValue);
                return;
            }
            case 11: {
                this.setVolatile((Boolean)newValue);
                return;
            }
            case 12: {
                this.setTransient((Boolean)newValue);
                return;
            }
            case 3: {
                this.setUnique((Boolean)newValue);
                return;
            }
            case 13: {
                this.setDefaultValueLiteral((String)newValue);
                return;
            }
            case 4: {
                this.setLowerBound((Integer)newValue);
                return;
            }
            case 5: {
                this.setUpperBound((Integer)newValue);
                return;
            }
            case 15: {
                this.setUnsettable((Boolean)newValue);
                return;
            }
            case 18: {
                this.setID((Boolean)newValue);
                return;
            }
            case 20: {
                this.setComment((String)newValue);
                return;
            }
            case 21: {
                this.setDefaultKind((DTDDefaultKind)((Object)newValue));
                return;
            }
            case 22: {
                this.setDefaultValueString((String)newValue);
                return;
            }
            case 23: {
                this.setAttributeNameReferencedEntity((DTDEntity)newValue);
                return;
            }
            case 24: {
                this.setAttributeTypeReferencedEntity((DTDEntity)newValue);
                return;
            }
            case 25: {
                this.setDTDElement((DTDElement)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 8: {
                this.setEType(null);
                return;
            }
            case 10: {
                this.setChangeable(true);
                return;
            }
            case 11: {
                this.setVolatile(false);
                return;
            }
            case 12: {
                this.setTransient(false);
                return;
            }
            case 3: {
                this.setUnique(true);
                return;
            }
            case 13: {
                this.setDefaultValueLiteral(DEFAULT_VALUE_LITERAL_EDEFAULT);
                return;
            }
            case 4: {
                this.setLowerBound(0);
                return;
            }
            case 5: {
                this.setUpperBound(1);
                return;
            }
            case 15: {
                this.setUnsettable(false);
                return;
            }
            case 18: {
                this.setID(false);
                return;
            }
            case 20: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
            case 21: {
                this.setDefaultKind(DEFAULT_KIND_EDEFAULT);
                return;
            }
            case 22: {
                this.setDefaultValueString(DEFAULT_VALUE_STRING_EDEFAULT);
                return;
            }
            case 23: {
                this.setAttributeNameReferencedEntity(null);
                return;
            }
            case 24: {
                this.setAttributeTypeReferencedEntity(null);
                return;
            }
            case 25: {
                this.setDTDElement(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return this.eAnnotations != null && !this.getEAnnotations().isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 8: {
                return this.eType != null;
            }
            case 10: {
                return (this.eFlags & 0x400) == 0;
            }
            case 11: {
                return (this.eFlags & 0x800) != 0;
            }
            case 12: {
                return (this.eFlags & 0x1000) != 0;
            }
            case 3: {
                return (this.eFlags & 0x200) == 0;
            }
            case 13: {
                return DEFAULT_VALUE_LITERAL_EDEFAULT == null ? this.defaultValueLiteral != null : !DEFAULT_VALUE_LITERAL_EDEFAULT.equals(this.defaultValueLiteral);
            }
            case 14: {
                return this.getDefaultValue() != null;
            }
            case 4: {
                return this.lowerBound != 0;
            }
            case 5: {
                return this.upperBound != 1;
            }
            case 6: {
                return this.isMany();
            }
            case 7: {
                return this.isRequired();
            }
            case 17: {
                return this.getEContainingClass() != null;
            }
            case 15: {
                return (this.eFlags & 0x2000) != 0;
            }
            case 18: {
                return (this.eFlags & 0x8000) != 0;
            }
            case 19: {
                return this.basicGetEAttributeType() != null;
            }
            case 20: {
                return COMMENT_EDEFAULT == null ? this.comment != null : !COMMENT_EDEFAULT.equals(this.comment);
            }
            case 21: {
                return this.defaultKind != DEFAULT_KIND_EDEFAULT;
            }
            case 22: {
                return DEFAULT_VALUE_STRING_EDEFAULT == null ? this.defaultValueString != null : !DEFAULT_VALUE_STRING_EDEFAULT.equals(this.defaultValueString);
            }
            case 23: {
                return this.attributeNameReferencedEntity != null;
            }
            case 24: {
                return this.attributeTypeReferencedEntity != null;
            }
            case 25: {
                return this.getDTDElement() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (comment: ");
        result.append(this.comment);
        result.append(", defaultKind: ");
        result.append((Object)this.defaultKind);
        result.append(", defaultValueString: ");
        result.append(this.defaultValueString);
        result.append(')');
        return result.toString();
    }
}

