/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddClasspathFoldersParticipant
extends AbstractFlattenParticipant {
    private List<IFlatResource> list;

    public boolean shouldIgnoreReference(IVirtualComponent rootComponent, IVirtualReference referenced, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        return rootComponent instanceof IClasspathDependencyProvider && referenced.getReferencedComponent() instanceof IClasspathDependencyComponent && ((IClasspathDependencyComponent)referenced.getReferencedComponent()).isClassFolder();
    }

    public void finalize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        this.list = resources;
        if (!(component instanceof IClasspathDependencyProvider)) {
            return;
        }
        try {
            this.addClassFolderDependencies((IClasspathDependencyProvider)component);
        }
        catch (CoreException coreException) {}
    }

    private void addClassFolderDependencies(IClasspathDependencyProvider component) throws CoreException {
        if (!component.isBinary()) {
            IVirtualReference[] cpRefs = component.getJavaClasspathReferences();
            int i = 0;
            while (i < cpRefs.length) {
                IClasspathDependencyComponent cpComp;
                IVirtualReference cpRef = cpRefs[i];
                IPath runtimePath = cpRef.getRuntimePath();
                IVirtualComponent comp = cpRef.getReferencedComponent();
                if (comp instanceof IClasspathDependencyComponent && (cpComp = (IClasspathDependencyComponent)comp).isClassFolder()) {
                    IPath targetPath = null;
                    targetPath = runtimePath.makeRelative();
                    IContainer container = cpComp.getClassFolder();
                    new VirtualComponentFlattenUtility(this.list, null).addContainer(container, targetPath);
                }
                ++i;
            }
        }
    }
}

