/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context;

import junit.framework.TestCase;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.core.internal.operations.PersistenceFileCreationDataModelProvider;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JpaProjectTests
extends TestCase {
    static final String BASE_PROJECT_NAME = JpaProjectTests.class.getSimpleName();
    TestJpaProject jpaProject;

    public JpaProjectTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jpaProject = TestJpaProject.buildJpaProject(BASE_PROJECT_NAME, false, this.buildJpaConfigDataModel());
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"generic");
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected void tearDown() throws Exception {
        this.jpaProject.getProject().delete(true, true, null);
        this.jpaProject = null;
        super.tearDown();
    }

    protected JpaProject getJpaProject() {
        return this.jpaProject.getJpaProject();
    }

    public void testGetPersistenceXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNull((Object)resource);
        this.createPersistenceXmlFile();
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createPersistenceXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new PersistenceFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.getDefaultOperation().execute(null, null);
    }

    private void createOrmXmlFile(String filePath) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.setProperty("JpaFileCreationDataModelProperties.FILE_PATH", (Object)filePath);
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetMappingFileResourceDifferentlyName() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

