/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaPersistentAttributeTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentAttributeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getName());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setSpecifiedMappingKey(null);
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testGetSpecifiedMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaIdMapping));
        persistentAttribute.setSpecifiedMappingKey(null);
        GenericJavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        GenericJavaPersistentAttributeTests.assertNotNull((Object)persistentAttribute.getMapping());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey(null);
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMappingKey());
    }

    public void testDefaultMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getDefaultMappingKey());
    }

    public void testSetSpecifiedMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        GenericJavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.setPrimaryAnnotation("javax.persistence.Embedded", EmptyIterable.instance());
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.setPrimaryAnnotation("javax.persistence.Basic", EmptyIterable.instance());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getSpecifiedMapping().getKey());
    }

    public void testGetAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }

    public void testGetAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }
}

