/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaIdMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdMappingGeneratedValue() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.GeneratedValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@GeneratedValue").append(CR);
            }
        });
    }

    public JavaIdMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)idMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        idMapping.setConverter("temporalConverter");
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        idMapping.setConverter("noConverter");
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.DATE);
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)((TemporalConverter)idMapping.getConverter()).getTemporalType());
        attributeResource.removeAnnotation("javax.persistence.Temporal");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((String)"noConverter", (String)idMapping.getConverter().getType());
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        JavaIdMappingTests.assertSame((Object)idMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getDefaultName());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)idMapping.getPersistenceUnit().generatorsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        this.getJpaProject().synchronizeContextModel();
        attributeResource.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)2, (int)attributeResource.annotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().generatorsSize());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().generatorsSize());
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        try {
            idMapping.getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        idMapping.getGeneratorContainer().removeSequenceGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            idMapping.getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)idMapping.getPersistenceUnit().generatorsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertEquals((int)2, (int)attributeResource.annotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().generatorsSize());
        idMapping.getGeneratorContainer().getTableGenerator().setName("foo");
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().generatorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        idMapping.getGeneratorContainer().addTableGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        try {
            idMapping.getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        idMapping.getGeneratorContainer().removeTableGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        try {
            idMapping.getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.GeneratedValue");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)2, (int)attributeResource.annotationsSize());
    }

    public void testGetGeneratedValue2() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithIdMappingGeneratedValue();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)2, (int)attributeResource.annotationsSize());
    }

    public void testAddGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        idMapping.addGeneratedValue();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        try {
            idMapping.addGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.GeneratedValue");
        this.getJpaProject().synchronizeContextModel();
        idMapping.removeGeneratedValue();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
        try {
            idMapping.removeGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }
}

