/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaQueryHintTests
extends ContextModelTestCase {
    private static final String QUERY_NAME = "QUERY_NAME";

    private ICompilationUnit createTestEntityWithNamedQuery() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQuery(name=\"QUERY_NAME\", hints=@QueryHint())");
            }
        });
    }

    public JavaQueryHintTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hints().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        QueryHintAnnotation javaQueryHint = (QueryHintAnnotation)((NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery")).hints().next();
        JavaQueryHintTests.assertNull((Object)javaQueryHint.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
        javaQueryHint.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertEquals((String)"foo", (String)javaQueryHint.getName());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        javaQueryHint.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertNull((Object)javaQueryHint.getName());
        JavaQueryHintTests.assertEquals((int)0, (int)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hintsSize());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hints().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        QueryHintAnnotation javaQueryhint = (QueryHintAnnotation)((NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery")).hints().next();
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
        queryHint.setName("foo");
        JavaQueryHintTests.assertEquals((String)"foo", (String)javaQueryhint.getName());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        queryHint.setName(null);
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
    }

    public void testUpdateValue() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hints().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        QueryHintAnnotation javaQueryhint = (QueryHintAnnotation)((NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery")).hints().next();
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
        javaQueryhint.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertEquals((String)"foo", (String)javaQueryhint.getValue());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getValue());
        javaQueryhint.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getValue());
        JavaQueryHintTests.assertEquals((int)0, (int)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hintsSize());
    }

    public void testModifyValue() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().namedQueries().next()).hints().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        QueryHintAnnotation javaQueryhint = (QueryHintAnnotation)((NamedQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedQuery")).hints().next();
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
        queryHint.setValue("foo");
        JavaQueryHintTests.assertEquals((String)"foo", (String)javaQueryhint.getValue());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getValue());
        queryHint.setValue(null);
        JavaQueryHintTests.assertNull((Object)javaQueryhint.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
    }
}

