/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaTableTests
extends ContextModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Table(name=\"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestSubType() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createAbstractTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
                sb.append("abstract");
            }
        });
    }

    public JavaTableTests(String name) {
        super(name);
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getTable().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getTable().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getTable().getDefaultName());
        this.getJavaEntity().setSpecifiedName("foo");
        JavaTableTests.assertEquals((String)"foo", (String)this.getJavaEntity().getTable().getDefaultName());
    }

    public void testGetDefaultNameSingleTableInheritance() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaTableTests.assertNotSame((Object)this.getJavaEntity(), (Object)rootEntity);
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)childEntity.getTable().getDefaultName());
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)rootEntity.getTable().getDefaultName());
        rootEntity.setSpecifiedName("foo");
        JavaTableTests.assertEquals((String)"foo", (String)childEntity.getTable().getDefaultName());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        JavaEntity javaEntity = ormEntity.getJavaEntity();
        JavaTableTests.assertNull((Object)javaEntity.getTable().getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        JavaTableTests.assertEquals((String)"FOO", (String)javaEntity.getTable().getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        JavaTableTests.assertEquals((String)"BAR", (String)javaEntity.getTable().getDefaultSchema());
        ormEntity.getTable().setSpecifiedSchema("XML_SCHEMA");
        JavaTableTests.assertEquals((String)"BAR", (String)javaEntity.getTable().getDefaultSchema());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)"FOO", (String)this.getJavaEntity().getTable().getDefaultSchema());
        IFile file = this.getOrmXmlResource().getFile();
        this.getXmlPersistenceUnit().getMappingFiles().remove((Object)mappingFileRef);
        JavaTableTests.assertEquals((String)"FOO", (String)this.getJavaEntity().getTable().getDefaultSchema());
        file.delete(true, null);
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultSchema());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getTable().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getTable().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().getTable().setSpecifiedName("foo");
        JavaTableTests.assertEquals((String)"foo", (String)this.getJavaEntity().getTable().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertEquals((String)"foo", (String)table.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().getTable().setSpecifiedName(null);
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertNull((Object)table);
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaTableTests.assertEquals((String)"foo", (String)this.getJavaEntity().getTable().getSpecifiedName());
        typeResource.removeAnnotation("javax.persistence.Table");
        this.getJpaProject().synchronizeContextModel();
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getSpecifiedName());
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.setCatalog("myCatalog");
        this.getJpaProject().synchronizeContextModel();
        JavaTableTests.assertEquals((String)"myCatalog", (String)this.getJavaEntity().getTable().getSpecifiedCatalog());
        JavaTableTests.assertEquals((String)"myCatalog", (String)this.getJavaEntity().getTable().getCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultCatalog());
        this.getJavaEntity().getTable().setSpecifiedCatalog("myCatalog");
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultCatalog());
    }

    public void testUpdateDefaultCatalogFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        JavaEntity javaEntity = ormEntity.getJavaEntity();
        JavaTableTests.assertNull((Object)javaEntity.getTable().getDefaultCatalog());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedCatalog("FOO");
        JavaTableTests.assertEquals((String)"FOO", (String)javaEntity.getTable().getDefaultCatalog());
        this.getEntityMappings().setSpecifiedCatalog("BAR");
        JavaTableTests.assertEquals((String)"BAR", (String)javaEntity.getTable().getDefaultCatalog());
        ormEntity.getTable().setSpecifiedCatalog("XML_CATALOG");
        JavaTableTests.assertEquals((String)"BAR", (String)javaEntity.getTable().getDefaultCatalog());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((String)"FOO", (String)this.getJavaEntity().getTable().getDefaultCatalog());
        IFile file = this.getOrmXmlResource().getFile();
        this.getXmlPersistenceUnit().getMappingFiles().remove((Object)mappingFileRef);
        JavaTableTests.assertEquals((String)"FOO", (String)this.getJavaEntity().getTable().getDefaultCatalog());
        file.delete(true, null);
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.setSpecifiedCatalog("myCatalog");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableResource = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertEquals((String)"myCatalog", (String)tableResource.getCatalog());
        table.setSpecifiedCatalog(null);
        JavaTableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.setSchema("mySchema");
        this.getJpaProject().synchronizeContextModel();
        JavaTableTests.assertEquals((String)"mySchema", (String)this.getJavaEntity().getTable().getSpecifiedSchema());
        JavaTableTests.assertEquals((String)"mySchema", (String)this.getJavaEntity().getTable().getSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultSchema());
        this.getJavaEntity().getTable().setSpecifiedSchema("mySchema");
        JavaTableTests.assertNull((Object)this.getJavaEntity().getTable().getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.setSpecifiedSchema("mySchema");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableResource = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertEquals((String)"mySchema", (String)tableResource.getSchema());
        table.setSpecifiedSchema(null);
        JavaTableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator uniqueConstraints = this.getJavaEntity().getTable().uniqueConstraints();
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        tableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = this.getJavaEntity().getTable().uniqueConstraints();
        JavaTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaTableTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableTests.assertEquals((int)0, (int)this.getJavaEntity().getTable().uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        tableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaTableTests.assertEquals((int)2, (int)this.getJavaEntity().getTable().uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(0).addColumnName(0, "BAR");
        table.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        ListIterator uniqueConstraints = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        ListIterator uniqueConstraints = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertEquals((int)3, (int)tableAnnotation.uniqueConstraintsSize());
        table.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        table.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        table.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        JavaTableTests.assertEquals((int)3, (int)tableAnnotation.uniqueConstraintsSize());
        table.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        table.moveUniqueConstraint(0, 1);
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = tableAnnotation.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        TableAnnotation tableAnnotation = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        tableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        tableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        tableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = table.uniqueConstraints();
        JavaTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAbstractEntityGetDefaultNameTablePerClassInheritance() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity concreteEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaTableTests.assertEquals((String)"AnnotationTestTypeChild", (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaTableTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        JavaTableTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getSpecifiedInheritanceStrategy());
        JavaTableTests.assertEquals(null, (Object)concreteEntity.getSpecifiedInheritanceStrategy());
        JavaTableTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)concreteEntity.getDefaultInheritanceStrategy());
        JavaTableTests.assertEquals(null, (String)abstractEntity.getTable().getDefaultName());
        JavaTableTests.assertEquals(null, (String)abstractEntity.getTable().getDefaultCatalog());
        JavaTableTests.assertEquals(null, (String)abstractEntity.getTable().getDefaultSchema());
        JavaTableTests.assertEquals((String)"AnnotationTestTypeChild", (String)concreteEntity.getTable().getDefaultName());
        JavaTableTests.assertEquals(null, (String)concreteEntity.getTable().getDefaultCatalog());
        JavaTableTests.assertEquals(null, (String)concreteEntity.getTable().getDefaultSchema());
    }
}

