/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmAttributeOverrideTests
extends ContextModelTestCase {
    public OrmAttributeOverrideTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        XmlAttributeOverride attributeOverrideResource = (XmlAttributeOverride)entityResource.getAttributeOverrides().get(0);
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        OrmAttributeOverrideTests.assertNull((Object)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertNull((Object)attributeOverrideResource.getName());
        OrmAttributeOverrideTests.assertTrue((boolean)overrideContainer.attributeOverrides().hasNext());
        OrmAttributeOverrideTests.assertFalse((boolean)entityResource.getAttributeOverrides().isEmpty());
        attributeOverrideResource.setName("FOO");
        OrmAttributeOverrideTests.assertEquals((String)"FOO", (String)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getName());
        attributeOverrideResource.setName(null);
        OrmAttributeOverrideTests.assertNull((Object)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertNull((Object)attributeOverrideResource.getName());
        attributeOverrideResource.setName("FOO");
        OrmAttributeOverrideTests.assertEquals((String)"FOO", (String)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getName());
        entityResource.getAttributeOverrides().remove(0);
        OrmAttributeOverrideTests.assertFalse((boolean)overrideContainer.attributeOverrides().hasNext());
        OrmAttributeOverrideTests.assertTrue((boolean)entityResource.getAttributeOverrides().isEmpty());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        XmlAttributeOverride attributeOverrideResource = (XmlAttributeOverride)entityResource.getAttributeOverrides().get(0);
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        OrmAttributeOverrideTests.assertNull((Object)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertNull((Object)attributeOverrideResource.getName());
        ormAttributeOverride.setName("foo");
        OrmAttributeOverrideTests.assertEquals((String)"foo", (String)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertEquals((String)"foo", (String)attributeOverrideResource.getName());
        ormAttributeOverride.setName(null);
        OrmAttributeOverrideTests.assertNull((Object)ormAttributeOverride.getName());
        OrmAttributeOverrideTests.assertNull((Object)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
    }
}

