/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddedId;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmEmbeddedIdMappingTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public OrmEmbeddedIdMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityEmbeddedIdMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.EmbeddedId", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @EmbeddedId");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testEmbeddedIdMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (AttributeOverride)((EmbeddedMapping)ormPersistentAttribute.getMapping()).getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"override", (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedIdMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        XmlEmbeddedId embeddedResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        OrmEmbeddedIdMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        XmlEmbeddedId embeddedResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        OrmEmbeddedIdMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).setName("BAZ");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)embeddedIdResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(0);
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embeddedId", "foo");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((String)"foo", (String)ormEmbeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.virtualAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("address");
        OrmEmbeddedIdMapping embeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaEmbeddedIdMapping javaEmbeddedIdMapping = (JavaEmbeddedIdMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaEmbeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType2.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        OrmEmbeddedIdMappingTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        OrmEmbeddedIdMappingTests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        OrmEmbeddedIdMappingTests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        OrmEmbeddedIdMappingTests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("address").makeSpecified();
        embeddedIdMapping = (OrmEmbeddedIdMapping)persistentType.getAttributeNamed("address").getMapping();
        attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getColumn().getDefaultName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        OrmEmbeddedIdMappingTests.assertEquals(null, (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUnique());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isNullable());
        OrmEmbeddedIdMappingTests.assertEquals((int)255, (int)attributeOverride.getColumn().getLength());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getPrecision());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getDefaultName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        ((OrmAttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)((OrmAttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)ormEmbeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator ormAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormAttributeOverride.getName());
        OrmColumn ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"A_STATE", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)ormColumn.getSpecifiedName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmEmbeddedIdMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embeddedId", "address");
        OrmEmbeddedIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)ormEmbeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)ormEmbeddedIdMapping.getAttributeOverrideContainer().specifiedAttributeOverridesSize());
    }
}

