/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinColumnInAssociationOverrideJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnInAssociationOverrideJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmEntityTests
extends ContextModelTestCase {
    protected static final String CHILD_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_CHILD_TYPE_NAME = "test.AnnotationTestTypeChild";

    public OrmEntityTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityDefaultFieldAccess() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityFieldAccess() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityPropertyAccess() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(OrmEntityTests.CHILD_TYPE_NAME).append(" ");
                sb.append("extends ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private void createTestSubTypeUnmapped() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(OrmEntityTests.CHILD_TYPE_NAME).append(" ");
                sb.append("extends ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Basic", "javax.persistence.Version", "javax.persistence.Transient", "javax.persistence.Embedded", "javax.persistence.EmbeddedId", "javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @Basic");
                sb.append(CR);
                sb.append("    private int basic;").append(CR);
                sb.append(CR);
                sb.append("    @Version");
                sb.append(CR);
                sb.append("    private int version;").append(CR);
                sb.append(CR);
                sb.append("    @Transient");
                sb.append(CR);
                sb.append("    private int transient;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    private int embedded;").append(CR);
                sb.append(CR);
                sb.append("    @EmbeddedId");
                sb.append(CR);
                sb.append("    private int embeddedId;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild oneToOne;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int oneToMany;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int manyToOne;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int manyToMany;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestAbstractType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private ICompilationUnit createAbstractTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
                sb.append("abstract");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private void createTestIdClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append("TestTypeId").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestTypeId.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedName());
        OrmEntityTests.assertNull((Object)entityResource.getName());
        entityResource.setName("foo");
        OrmEntityTests.assertEquals((String)"foo", (String)ormEntity.getSpecifiedName());
        OrmEntityTests.assertEquals((String)"foo", (String)entityResource.getName());
        entityResource.setName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedName());
        OrmEntityTests.assertNull((Object)entityResource.getName());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedName());
        OrmEntityTests.assertNull((Object)entityResource.getName());
        ormEntity.setSpecifiedName("foo");
        OrmEntityTests.assertEquals((String)"foo", (String)ormEntity.getSpecifiedName());
        OrmEntityTests.assertEquals((String)"foo", (String)entityResource.getName());
        ormEntity.setSpecifiedName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedName());
        OrmEntityTests.assertNull((Object)entityResource.getName());
    }

    public void testUpdateDefaultName() throws Exception {
        this.createTestEntityFieldAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getDefaultName());
        ormEntity.getJavaEntity().setSpecifiedName("Foo");
        OrmEntityTests.assertEquals((String)"Foo", (String)ormEntity.getDefaultName());
        entityResource.setClassName("com.Bar");
        OrmEntityTests.assertEquals((String)"Bar", (String)ormEntity.getDefaultName());
        entityResource.setClassName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getDefaultName());
        entityResource.setClassName("test.AnnotationTestType");
        OrmEntityTests.assertEquals((String)"Foo", (String)ormEntity.getDefaultName());
        entityResource.setMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getDefaultName());
        ormEntity.getJavaEntity().setSpecifiedName("Foo1");
        OrmEntityTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getDefaultName());
        entityResource.setMetadataComplete(null);
        OrmEntityTests.assertEquals((String)"Foo1", (String)ormEntity.getDefaultName());
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((String)"Foo", (String)ormEntity.getName());
        entityResource.setClassName("com.Bar");
        OrmEntityTests.assertEquals((String)"Bar", (String)ormEntity.getName());
        entityResource.setName("Baz");
        OrmEntityTests.assertEquals((String)"Baz", (String)ormEntity.getName());
        entityResource.setClassName(null);
        OrmEntityTests.assertEquals((String)"Baz", (String)ormEntity.getName());
        entityResource.setName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getName());
    }

    public void testUpdateClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmEntityTests.assertEquals((String)"model.Foo", (String)entityResource.getClassName());
        entityResource.setClassName("com.Bar");
        OrmEntityTests.assertEquals((String)"com.Bar", (String)ormEntity.getClass_());
        OrmEntityTests.assertEquals((String)"com.Bar", (String)entityResource.getClassName());
        entityResource.setClassName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getClass_());
        OrmEntityTests.assertNull((Object)entityResource.getClassName());
    }

    public void testModifyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmEntityTests.assertEquals((String)"model.Foo", (String)entityResource.getClassName());
        ormEntity.setClass("com.Bar");
        OrmEntityTests.assertEquals((String)"com.Bar", (String)ormEntity.getClass_());
        OrmEntityTests.assertEquals((String)"com.Bar", (String)entityResource.getClassName());
        ormEntity.setClass(null);
        OrmEntityTests.assertNull((Object)ormEntity.getClass_());
        OrmEntityTests.assertNull((Object)entityResource.getClassName());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
        entityResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)entityResource.getAccess());
        entityResource.setAccess(null);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entityResource.getAccess());
        ormPersistentType.setSpecifiedAccess(null);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
    }

    public void testUpdateDefaultAccessFromPersistenceUnitDefaults() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        OrmEntityTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        OrmEntityTests.assertNull((Object)entityResource.getAccess());
    }

    public void testUpdateDefaultAccessFromJava() throws Exception {
        this.createTestEntityDefaultFieldAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().setSpecifiedAccess(null);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(null);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("id").setSpecifiedMappingKey("id");
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.PROPERTY);
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("id").setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
    }

    public void testUpdateDefaultAccessFromJavaFieldAccess() throws Exception {
        this.createTestEntityFieldAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
    }

    public void testUpdateDefaultAccessFromJavaPropertyAccess() throws Exception {
        this.createTestEntityPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
    }

    public void testUpdateDefaultAccessNoUnderlyingJava() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
    }

    public void testUpdateSpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        entityResource.setMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)entityResource.getMetadataComplete());
        entityResource.setMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)entityResource.getMetadataComplete());
        entityResource.setMetadataComplete(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
    }

    public void testModifySpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertTrue((boolean)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertTrue((boolean)entityResource.getMetadataComplete());
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertFalse((boolean)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertFalse((boolean)entityResource.getMetadataComplete());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
    }

    public void testUpdateDefaultMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertFalse((boolean)ormEntity.isDefaultMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertTrue((boolean)ormEntity.isDefaultMetadataComplete());
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertFalse((boolean)ormEntity.isDefaultMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertTrue((boolean)ormEntity.isDefaultMetadataComplete());
        OrmEntityTests.assertTrue((boolean)ormEntity.isMetadataComplete());
    }

    public void testUpdateMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertFalse((boolean)ormEntity.isMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertTrue((boolean)ormEntity.isMetadataComplete());
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEntityTests.assertFalse((boolean)ormEntity.isMetadataComplete());
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEntityTests.assertNull((Object)entityResource.getMetadataComplete());
    }

    public void testUpdateInheritanceStrategy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance());
        entityResource.setInheritance(OrmFactory.eINSTANCE.createInheritance());
        entityResource.getInheritance().setStrategy(org.eclipse.jpt.core.resource.orm.InheritanceType.TABLE_PER_CLASS);
        OrmEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)ormEntity.getInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.InheritanceType.TABLE_PER_CLASS, (Object)entityResource.getInheritance().getStrategy());
    }

    public void testUpdateDefaultInheritanceStrategyFromJava() throws Exception {
        this.createTestEntityDefaultFieldAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getDefaultInheritanceStrategy());
        ormEntity.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)ormEntity.getDefaultInheritanceStrategy());
        ormEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getDefaultInheritanceStrategy());
        ormEntity.setSpecifiedInheritanceStrategy(null);
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)ormEntity.getDefaultInheritanceStrategy());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getDefaultInheritanceStrategy());
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)ormEntity.getDefaultInheritanceStrategy());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getDefaultInheritanceStrategy());
    }

    public void testUpdateDefaultInheritanceStrategyFromParent() throws Exception {
        this.createTestEntityDefaultFieldAccess();
        this.createTestSubType();
        OrmPersistentType superPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType subPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntity parentXmlEntity = (OrmEntity)superPersistentType.getMapping();
        OrmEntity childXmlEntity = (OrmEntity)subPersistentType.getMapping();
        OrmEntityTests.assertEquals((Object)parentXmlEntity, (Object)childXmlEntity.getParentEntity());
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childXmlEntity.getDefaultInheritanceStrategy());
        parentXmlEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)parentXmlEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childXmlEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertNull((Object)childXmlEntity.getSpecifiedInheritanceStrategy());
        parentXmlEntity.setSpecifiedInheritanceStrategy(null);
        parentXmlEntity.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)parentXmlEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)childXmlEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertNull((Object)parentXmlEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)childXmlEntity.getSpecifiedInheritanceStrategy());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)parentXmlEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childXmlEntity.getDefaultInheritanceStrategy());
    }

    public void testUpdateSpecifiedInheritanceStrategy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance());
        entityResource.setInheritance(OrmFactory.eINSTANCE.createInheritance());
        entityResource.getInheritance().setStrategy(org.eclipse.jpt.core.resource.orm.InheritanceType.JOINED);
        OrmEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.InheritanceType.JOINED, (Object)entityResource.getInheritance().getStrategy());
        entityResource.getInheritance().setStrategy(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance().getStrategy());
        entityResource.getInheritance().setStrategy(org.eclipse.jpt.core.resource.orm.InheritanceType.SINGLE_TABLE);
        OrmEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.InheritanceType.SINGLE_TABLE, (Object)entityResource.getInheritance().getStrategy());
        entityResource.setInheritance(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance());
    }

    public void testModifySpecifiedInheritanceStrategy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance());
        ormEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        OrmEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.InheritanceType.TABLE_PER_CLASS, (Object)entityResource.getInheritance().getStrategy());
        ormEntity.setSpecifiedInheritanceStrategy(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertNull((Object)entityResource.getInheritance());
    }

    public void testAddSpecifiedSecondaryTable() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmSecondaryTable secondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        secondaryTable.setSpecifiedName("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmSecondaryTable secondaryTable2 = ormEntity.addSpecifiedSecondaryTable(0);
        secondaryTable2.setSpecifiedName("BAR");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).getName());
        OrmSecondaryTable secondaryTable3 = ormEntity.addSpecifiedSecondaryTable(1);
        secondaryTable3.setSpecifiedName("BAZ");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(2)).getName());
        ListIterator secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((Object)secondaryTable2, secondaryTables.next());
        OrmEntityTests.assertEquals((Object)secondaryTable3, secondaryTables.next());
        OrmEntityTests.assertEquals((Object)secondaryTable, secondaryTables.next());
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
    }

    public void testRemoveSpecifiedSecondaryTable() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        ormEntity.addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        ormEntity.addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getSecondaryTables().size());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmEntityTests.assertEquals((int)2, (int)entityResource.getSecondaryTables().size());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).getName());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmEntityTests.assertEquals((int)1, (int)entityResource.getSecondaryTables().size());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmEntityTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testMoveSpecifiedSecondaryTable() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        ormEntity.addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        ormEntity.addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getSecondaryTables().size());
        ormEntity.moveSpecifiedSecondaryTable(2, 0);
        ListIterator secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(2)).getName());
        ormEntity.moveSpecifiedSecondaryTable(0, 1);
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(2)).getName());
    }

    public void testUpdateSecondaryTables() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setName("FOO");
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(1)).setName("BAR");
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(2)).setName("BAZ");
        ListIterator secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        entityResource.getSecondaryTables().move(2, 0);
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        entityResource.getSecondaryTables().move(0, 1);
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        entityResource.getSecondaryTables().remove(1);
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        entityResource.getSecondaryTables().remove(1);
        secondaryTables = ormEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        entityResource.getSecondaryTables().remove(0);
        OrmEntityTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
    }

    public void testVirtualSecondaryTables() throws Exception {
        this.createTestEntityFieldAccess();
        this.createTestSubType();
        OrmPersistentType superPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType subPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntity parentOrmEntity = (OrmEntity)superPersistentType.getMapping();
        OrmEntity childOrmEntity = (OrmEntity)subPersistentType.getMapping();
        JavaEntity javaEntity = childOrmEntity.getJavaEntity();
        JavaSecondaryTable javaSecondaryTableFoo = javaEntity.addSpecifiedSecondaryTable(0);
        javaSecondaryTableFoo.setSpecifiedName("FOO");
        OrmSecondaryTable virtualSecondaryTableFoo = (OrmSecondaryTable)childOrmEntity.virtualSecondaryTables().next();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)childOrmEntity.secondaryTables().next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)virtualSecondaryTableFoo.getName());
        OrmEntityTests.assertEquals((int)0, (int)virtualSecondaryTableFoo.specifiedPrimaryKeyJoinColumnsSize());
        OrmEntityTests.assertEquals((String)"id", (String)virtualSecondaryTableFoo.getDefaultPrimaryKeyJoinColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)virtualSecondaryTableFoo.getDefaultPrimaryKeyJoinColumn().getDefaultReferencedColumnName());
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.specifiedSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)1, (int)childOrmEntity.virtualSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)1, (int)childOrmEntity.secondaryTablesSize());
        javaEntity.addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        ListIterator virtualSecondaryTables = childOrmEntity.virtualSecondaryTables();
        ListIterator secondaryTables = childOrmEntity.secondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)virtualSecondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)virtualSecondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)secondaryTables.next()).getName());
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.specifiedSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.virtualSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.secondaryTablesSize());
        childOrmEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.virtualSecondaryTablesSize());
        childOrmEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.virtualSecondaryTablesSize());
        childOrmEntity.setSecondaryTablesDefinedInXml(true);
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.virtualSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.specifiedSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.secondaryTablesSize());
        ListIterator specifiedSecondaryTables = childOrmEntity.specifiedSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)specifiedSecondaryTables.next()).getName());
        OrmSecondaryTable specifiedSecondaryTableFoo = (OrmSecondaryTable)specifiedSecondaryTables.next();
        OrmEntityTests.assertEquals((String)"FOO", (String)specifiedSecondaryTableFoo.getName());
        OrmEntityTests.assertEquals((int)0, (int)specifiedSecondaryTableFoo.specifiedPrimaryKeyJoinColumnsSize());
        OrmEntityTests.assertEquals((String)"id", (String)specifiedSecondaryTableFoo.getDefaultPrimaryKeyJoinColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)specifiedSecondaryTableFoo.getDefaultPrimaryKeyJoinColumn().getDefaultReferencedColumnName());
        childOrmEntity.removeSpecifiedSecondaryTable(0);
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.virtualSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)1, (int)childOrmEntity.specifiedSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)1, (int)childOrmEntity.secondaryTablesSize());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)childOrmEntity.specifiedSecondaryTables().next()).getName());
        childOrmEntity.removeSpecifiedSecondaryTable(0);
        OrmEntityTests.assertEquals((int)0, (int)childOrmEntity.specifiedSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.virtualSecondaryTablesSize());
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.secondaryTablesSize());
        virtualSecondaryTables = childOrmEntity.virtualSecondaryTables();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmSecondaryTable)virtualSecondaryTables.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmSecondaryTable)virtualSecondaryTables.next()).getName());
        parentOrmEntity.addSpecifiedSecondaryTable(0).setSpecifiedName("PARENT_TABLE");
        OrmEntityTests.assertEquals((int)2, (int)childOrmEntity.virtualSecondaryTablesSize());
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEntityFieldAccess();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)entity.associatedTables()));
        entity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        OrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)entity.associatedTables()));
        entity.addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        OrmEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)entity.associatedTables()));
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
    }

    public void testTableNameIsInvalid() throws Exception {
    }

    public void testMakeEntityEmbeddable() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity entity = (OrmEntity)entityPersistentType.getMapping();
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        entity.setSpecifiedDiscriminatorValue("DISC_VALUE");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        entity.setSpecifiedName("ENTITY_NAME");
        entityPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)entityPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getSpecifiedAccess());
    }

    public void testMakeEntityEmbeddable2() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        OrmEntity entity = (OrmEntity)entityPersistentType.getMapping();
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        entity.setSpecifiedDiscriminatorValue("DISC_VALUE");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        entity.setSpecifiedName("ENTITY_NAME");
        entityPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)entityPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getSpecifiedAccess());
    }

    public void testMakeEntityMappedSuperclass() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity entity = (OrmEntity)entityPersistentType.getMapping();
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        entity.setSpecifiedDiscriminatorValue("DISC_VALUE");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        entity.setSpecifiedName("ENTITY_NAME");
        entityPersistentType.setMappingKey("mappedSuperclass");
        XmlMappedSuperclass mappedSuperclass = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)mappedSuperclass.getClassName());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclass.getMetadataComplete());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclass.getAccess());
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)entityPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getSpecifiedAccess());
    }

    public void testMakeEntityMappedSuperclass2() throws Exception {
        this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity entity = (OrmEntity)entityPersistentType.getMapping();
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        entity.setSpecifiedDiscriminatorValue("DISC_VALUE");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        entity.setSpecifiedName("ENTITY_NAME");
        entityPersistentType.setMappingKey("mappedSuperclass");
        XmlMappedSuperclass mappedSuperclass = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmEntityTests.assertEquals((String)"model.Foo", (String)mappedSuperclass.getClassName());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclass.getMetadataComplete());
        OrmEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclass.getAccess());
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)entityPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getSpecifiedAccess());
    }

    public void testAddSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getSequenceGenerator());
        ormEntity.getGeneratorContainer().addSequenceGenerator();
        OrmEntityTests.assertNotNull((Object)entityResource.getSequenceGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        try {
            ormEntity.getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getSequenceGenerator());
        ormEntity.getGeneratorContainer().addSequenceGenerator();
        OrmEntityTests.assertNotNull((Object)entityResource.getSequenceGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        ormEntity.getGeneratorContainer().removeSequenceGenerator();
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getSequenceGenerator());
        try {
            ormEntity.getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getSequenceGenerator());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().generatorsSize());
        entityResource.setSequenceGenerator(OrmFactory.eINSTANCE.createXmlSequenceGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNotNull((Object)entityResource.getSequenceGenerator());
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().generatorsSize());
        ormEntity.getGeneratorContainer().getSequenceGenerator().setName("foo");
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().generatorsSize());
        entityResource.setSequenceGenerator(null);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getSequenceGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getSequenceGenerator());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().generatorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getTableGenerator());
        ormEntity.getGeneratorContainer().addTableGenerator();
        OrmEntityTests.assertNotNull((Object)entityResource.getTableGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        try {
            ormEntity.getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getTableGenerator());
        ormEntity.getGeneratorContainer().addTableGenerator();
        OrmEntityTests.assertNotNull((Object)entityResource.getTableGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        ormEntity.getGeneratorContainer().removeTableGenerator();
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getTableGenerator());
        try {
            ormEntity.getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getTableGenerator());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().generatorsSize());
        entityResource.setTableGenerator(OrmFactory.eINSTANCE.createXmlTableGenerator());
        OrmEntityTests.assertNotNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNotNull((Object)entityResource.getTableGenerator());
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().generatorsSize());
        ormEntity.getGeneratorContainer().getTableGenerator().setName("foo");
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().generatorsSize());
        entityResource.setTableGenerator(null);
        OrmEntityTests.assertNull((Object)ormEntity.getGeneratorContainer().getTableGenerator());
        OrmEntityTests.assertNull((Object)entityResource.getTableGenerator());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().generatorsSize());
    }

    public void testUpdateDiscriminatorColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNotNull((Object)ormEntity.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setName("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)ormEntity.getDiscriminatorColumn().getSpecifiedName());
        OrmEntityTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getName());
        entityResource.getDiscriminatorColumn().setName(null);
        OrmEntityTests.assertNull((Object)ormEntity.getDiscriminatorColumn().getSpecifiedName());
        OrmEntityTests.assertNull((Object)entityResource.getDiscriminatorColumn().getName());
        entityResource.setDiscriminatorColumn(null);
        OrmEntityTests.assertNotNull((Object)ormEntity.getDiscriminatorColumn());
    }

    public void testUpdateDiscriminatorValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertNull((Object)entityResource.getDiscriminatorValue());
        entityResource.setDiscriminatorValue("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorValue());
        entityResource.setDiscriminatorValue(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertNull((Object)entityResource.getDiscriminatorValue());
    }

    public void testModifyDiscriminatorValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertNull((Object)entityResource.getDiscriminatorValue());
        ormEntity.setSpecifiedDiscriminatorValue("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorValue());
        ormEntity.setSpecifiedDiscriminatorValue(null);
        OrmEntityTests.assertNull((Object)ormEntity.getSpecifiedDiscriminatorValue());
        OrmEntityTests.assertNull((Object)entityResource.getDiscriminatorValue());
    }

    public void testGetDefaultDiscriminatorValue() throws Exception {
        this.createTestEntityFieldAccess();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        JavaEntity javaEntity = (JavaEntity)persistentType.getJavaPersistentType().getMapping();
        OrmEntityTests.assertEquals(null, (String)ormEntity.getDefaultDiscriminatorValue());
        this.createTestSubType();
        this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntityTests.assertEquals((String)ormEntity.getName(), (String)ormEntity.getDefaultDiscriminatorValue());
        javaEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(DiscriminatorType.INTEGER);
        OrmEntityTests.assertNull((Object)ormEntity.getDefaultDiscriminatorValue());
        javaEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(null);
        javaEntity.setSpecifiedDiscriminatorValue("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)ormEntity.getDefaultDiscriminatorValue());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((String)ormEntity.getName(), (String)ormEntity.getDefaultDiscriminatorValue());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        primaryKeyJoinColumn.setSpecifiedName("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn2 = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        primaryKeyJoinColumn2.setSpecifiedName("BAR");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn3 = ormEntity.addSpecifiedPrimaryKeyJoinColumn(1);
        primaryKeyJoinColumn3.setSpecifiedName("BAZ");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ListIterator primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((Object)primaryKeyJoinColumn2, primaryKeyJoinColumns.next());
        OrmEntityTests.assertEquals((Object)primaryKeyJoinColumn3, primaryKeyJoinColumns.next());
        OrmEntityTests.assertEquals((Object)primaryKeyJoinColumn, primaryKeyJoinColumns.next());
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getPrimaryKeyJoinColumns().size());
        ormEntity.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmEntityTests.assertEquals((int)2, (int)entityResource.getPrimaryKeyJoinColumns().size());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).getName());
        ormEntity.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmEntityTests.assertEquals((int)1, (int)entityResource.getPrimaryKeyJoinColumns().size());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        ormEntity.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmEntityTests.assertEquals((int)0, (int)entityResource.getPrimaryKeyJoinColumns().size());
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        ormEntity.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getPrimaryKeyJoinColumns().size());
        ormEntity.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ormEntity.moveSpecifiedPrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(2)).getName());
    }

    public void testUpdatePrimaryKeyJoinColumns() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        entityResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        entityResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        ((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).setName("FOO");
        ((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(1)).setName("BAR");
        ((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(2)).setName("BAZ");
        ListIterator primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        entityResource.getPrimaryKeyJoinColumns().move(2, 0);
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        entityResource.getPrimaryKeyJoinColumns().move(0, 1);
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        entityResource.getPrimaryKeyJoinColumns().remove(1);
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        entityResource.getPrimaryKeyJoinColumns().remove(1);
        primaryKeyJoinColumns = ormEntity.specifiedPrimaryKeyJoinColumns();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmEntityTests.assertFalse((boolean)ormEntity.specifiedPrimaryKeyJoinColumns().hasNext());
    }

    public void testDefaultPrimaryKeyJoinColumns() throws Exception {
        this.createTestType();
        this.createTestSubTypeUnmapped();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        childPersistentType.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        persistentType.getAttributeNamed("id").makeSpecified("id");
        ((OrmEntity)persistentType.getMapping()).setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmEntity childEntity = (OrmEntity)childPersistentType.getMapping();
        OrmEntityTests.assertTrue((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultReferencedColumnName());
        childPersistentType.getJavaPersistentType().setMappingKey("entity");
        persistentType.getJavaPersistentType().setMappingKey("entity");
        OrmEntityTests.assertTrue((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultReferencedColumnName());
        OrmPrimaryKeyJoinColumn specifiedPkJoinColumn = childEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        specifiedPkJoinColumn.setSpecifiedName("FOO");
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName("BAR");
        OrmEntityTests.assertFalse((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        childEntity.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmEntityTests.assertTrue((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultReferencedColumnName());
        childPersistentType.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        persistentType.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        specifiedPkJoinColumn = childEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        specifiedPkJoinColumn.setSpecifiedName("FOO");
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName("BAR");
        OrmEntityTests.assertFalse((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        ((XmlEntity)childEntity.getResourceTypeMapping()).getPrimaryKeyJoinColumns().remove(0);
        OrmEntityTests.assertTrue((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultReferencedColumnName());
    }

    public void testDefaultPrimaryKeyJoinColumnsFromJava() throws Exception {
        this.createTestEntityFieldAccess();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        ((JavaEntity)persistentType.getJavaPersistentType().getMapping()).setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmEntity childEntity = (OrmEntity)childPersistentType.getMapping();
        OrmEntityTests.assertTrue((boolean)childEntity.defaultPrimaryKeyJoinColumns().hasNext());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)((OrmPrimaryKeyJoinColumn)childEntity.defaultPrimaryKeyJoinColumns().next()).getDefaultReferencedColumnName());
        JavaEntity javaEntity = (JavaEntity)childPersistentType.getJavaPersistentType().getMapping();
        JavaPrimaryKeyJoinColumn javaPrimaryKeyJoinColumn = javaEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        javaPrimaryKeyJoinColumn.setSpecifiedName("FOO");
        javaPrimaryKeyJoinColumn.setSpecifiedReferencedColumnName("BAR");
        JavaPrimaryKeyJoinColumn javaPrimaryKeyJoinColumn2 = javaEntity.addSpecifiedPrimaryKeyJoinColumn(1);
        javaPrimaryKeyJoinColumn2.setSpecifiedName("FOO2");
        javaPrimaryKeyJoinColumn2.setSpecifiedReferencedColumnName("BAR2");
        childPersistentType.getJavaPersistentType().setMappingKey("entity");
        persistentType.getJavaPersistentType().setMappingKey("entity");
        ListIterator defaultPrimaryKeyJoinColumns = childEntity.defaultPrimaryKeyJoinColumns();
        OrmPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn = (OrmPrimaryKeyJoinColumn)defaultPrimaryKeyJoinColumns.next();
        OrmEntityTests.assertEquals((String)"FOO", (String)defaultPrimaryKeyJoinColumn.getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)defaultPrimaryKeyJoinColumn.getReferencedColumnName());
        defaultPrimaryKeyJoinColumn = (OrmPrimaryKeyJoinColumn)defaultPrimaryKeyJoinColumns.next();
        OrmEntityTests.assertEquals((String)"FOO2", (String)defaultPrimaryKeyJoinColumn.getName());
        OrmEntityTests.assertEquals((String)"BAR2", (String)defaultPrimaryKeyJoinColumn.getReferencedColumnName());
        OrmEntityTests.assertFalse((boolean)defaultPrimaryKeyJoinColumns.hasNext());
        childEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        defaultPrimaryKeyJoinColumns = childEntity.defaultPrimaryKeyJoinColumns();
        defaultPrimaryKeyJoinColumn = (OrmPrimaryKeyJoinColumn)defaultPrimaryKeyJoinColumns.next();
        OrmEntityTests.assertEquals((String)"id", (String)defaultPrimaryKeyJoinColumn.getDefaultName());
        OrmEntityTests.assertEquals((String)"id", (String)defaultPrimaryKeyJoinColumn.getDefaultReferencedColumnName());
        OrmEntityTests.assertFalse((boolean)defaultPrimaryKeyJoinColumns.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).setName("BAZ");
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getAttributeOverrides().size());
        overrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).getName());
        overrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(1);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(1);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(0);
        OrmEntityTests.assertFalse((boolean)overrideContainer.specifiedAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        OrmEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getName());
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getColumn().getName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)attributeOverride.getColumn().getTable());
        OrmEntityTests.assertEquals(null, (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEntityTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEntityTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEntityTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUnique());
        OrmEntityTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isNullable());
        OrmEntityTests.assertEquals((int)255, (int)attributeOverride.getColumn().getLength());
        OrmEntityTests.assertEquals((int)0, (int)attributeOverride.getColumn().getPrecision());
        OrmEntityTests.assertEquals((int)0, (int)attributeOverride.getColumn().getScale());
        ((OrmAttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        OrmEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getName());
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getName());
        ((OrmAttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        entity.setSpecifiedMetadataComplete(Boolean.FALSE);
        ((JavaAttributeOverride)entity.getJavaEntity().getAttributeOverrideContainer().virtualAttributeOverrides().next()).setVirtual(false);
        JavaColumn javaColumn = ((JavaAttributeOverride)entity.getJavaEntity().getAttributeOverrideContainer().specifiedAttributeOverrides().next()).getColumn();
        javaColumn.setSpecifiedName("FOO");
        javaColumn.setSpecifiedTable("BAR");
        javaColumn.setColumnDefinition("COLUMN_DEF");
        javaColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaColumn.setSpecifiedUnique(Boolean.TRUE);
        javaColumn.setSpecifiedNullable(Boolean.FALSE);
        javaColumn.setSpecifiedLength(Integer.valueOf(7));
        javaColumn.setSpecifiedPrecision(Integer.valueOf(8));
        javaColumn.setSpecifiedScale(Integer.valueOf(9));
        OrmEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getSpecifiedTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedInsertable());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedUpdatable());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)attributeOverride.getColumn().getSpecifiedUnique());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedNullable());
        OrmEntityTests.assertEquals((Object)7, (Object)attributeOverride.getColumn().getSpecifiedLength());
        OrmEntityTests.assertEquals((Object)8, (Object)attributeOverride.getColumn().getSpecifiedPrecision());
        OrmEntityTests.assertEquals((Object)9, (Object)attributeOverride.getColumn().getSpecifiedScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getName());
        persistentType2.getAttributeNamed("basic").makeSpecified();
        OrmBasicMapping basicMapping = (OrmBasicMapping)persistentType2.getAttributeNamed("basic").getMapping();
        basicMapping.getColumn().setSpecifiedName("MY_NAME");
        basicMapping.getColumn().setSpecifiedTable("BAR");
        basicMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        basicMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        basicMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        basicMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        basicMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        basicMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        basicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        basicMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        OrmEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        OrmEntityTests.assertEquals((String)"MY_NAME", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEntityTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEntityTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEntityTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        OrmEntityTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        OrmEntityTests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        OrmEntityTests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        OrmEntityTests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getSpecifiedTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedInsertable());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedUpdatable());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)attributeOverride.getColumn().getSpecifiedUnique());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)attributeOverride.getColumn().getSpecifiedNullable());
        OrmEntityTests.assertEquals((Object)7, (Object)attributeOverride.getColumn().getSpecifiedLength());
        OrmEntityTests.assertEquals((Object)8, (Object)attributeOverride.getColumn().getSpecifiedPrecision());
        OrmEntityTests.assertEquals((Object)9, (Object)attributeOverride.getColumn().getSpecifiedScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
    }

    public void testVirtualAttributeOverridesNoJavaEntity() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        persistentType.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        OrmEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"basic", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEntityTests.assertEquals((String)"name", (String)attributeOverride.getName());
    }

    public void testAttributeOverrideColumnDefaults() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        ((OrmAttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)attributeOverride.getColumn().getDefaultTable());
        ((JavaEntity)persistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)"FOO", (String)attributeOverride.getColumn().getDefaultTable());
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)attributeOverride.getColumn().getDefaultTable());
        entity.setSpecifiedMetadataComplete(Boolean.FALSE);
        entity.getTable().setSpecifiedName("BAR");
        OrmEntityTests.assertEquals((String)"foo", (String)attributeOverride.getColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getDefaultTable());
    }

    public void testAttributeOverrideColumnDefaultsNoJavaAnnotations() throws Exception {
        this.createTestType();
        this.createTestSubTypeUnmapped();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        ((OrmPersistentAttribute)persistentType.getSuperPersistentType().getAttributeNamed("id")).makeSpecified();
        BasicMapping basicMapping = (BasicMapping)persistentType.getSuperPersistentType().getAttributeNamed("id").getSpecifiedMapping();
        basicMapping.getColumn().setSpecifiedName("MY_COLUMN");
        basicMapping.getColumn().setSpecifiedTable("BAR");
        OrmEntityTests.assertEquals((String)"MY_COLUMN", (String)attributeOverride.getColumn().getDefaultName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getDefaultTable());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        attributeOverride = (OrmAttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"MY_COLUMN", (String)attributeOverride.getColumn().getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getTable());
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntityDefaultFieldAccess();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Entity entity = (Entity)persistentType.getMapping();
        Iterator overridableAttributes = persistentType.getMapping().overridableAttributeNames();
        OrmEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        entity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = entity.overridableAttributeNames();
        OrmEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntityDefaultFieldAccess();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Entity entity = (Entity)persistentType.getMapping();
        Iterator overridableAttributeNames = persistentType.getMapping().overridableAttributeNames();
        entity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = entity.overridableAttributeNames();
        OrmEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        OrmEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        OrmEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        Iterator overridableAttributes = entity.allOverridableAttributeNames();
        OrmEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmPersistentType abstractPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmEntity abstractEntity = (OrmEntity)abstractPersistentType.getMapping();
        Iterator overridableAttributes = entity.allOverridableAttributeNames();
        OrmEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        overridableAttributes = abstractEntity.allOverridableAttributeNames();
        OrmEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        OrmEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testVirtualAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        OrmPersistentType abstractPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType concretePersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        Entity concreteEntity = (Entity)concretePersistentType.getMapping();
        AttributeOverrideContainer overrideContainer = concreteEntity.getAttributeOverrideContainer();
        OrmEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        OrmEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        OrmBasicMapping idMapping = (OrmBasicMapping)abstractPersistentType.getAttributeNamed("id").getMapping();
        idMapping.getPersistentAttribute().makeSpecified();
        idMapping = (OrmBasicMapping)abstractPersistentType.getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        OrmEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        OrmEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = virtualAttributeOverride.setVirtual(false);
        OrmEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("FOO");
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).setName("BAR");
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(2)).setName("BAZ");
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getAssociationOverrides().size());
        overrideContainer.moveSpecifiedAssociationOverride(2, 0);
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(2)).getName());
        overrideContainer.moveSpecifiedAssociationOverride(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(2)).getName());
    }

    public void testUpdateAssociationOverrides() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("FOO");
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).setName("BAR");
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(2)).setName("BAZ");
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().move(2, 0);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().move(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        OrmEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(0);
        OrmEntityTests.assertFalse((boolean)overrideContainer.specifiedAssociationOverrides().hasNext());
    }

    public void testVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        OrmEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        OrmAssociationOverride associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        OrmJoinColumnInAssociationOverrideJoiningStrategy joiningStrategy = associationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmEntityTests.assertEquals((String)"oneToOne", (String)associationOverride.getName());
        OrmEntityTests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        OrmJoinColumn joinColumn = (OrmJoinColumn)joiningStrategy.joinColumns().next();
        OrmEntityTests.assertEquals((String)"oneToOne_id", (String)joinColumn.getName());
        OrmEntityTests.assertEquals((String)"id", (String)joinColumn.getReferencedColumnName());
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)joinColumn.getTable());
        OrmEntityTests.assertEquals(null, (String)joinColumn.getColumnDefinition());
        OrmEntityTests.assertEquals((boolean)true, (boolean)joinColumn.isInsertable());
        OrmEntityTests.assertEquals((boolean)true, (boolean)joinColumn.isUpdatable());
        OrmEntityTests.assertEquals((boolean)false, (boolean)joinColumn.isUnique());
        OrmEntityTests.assertEquals((boolean)true, (boolean)joinColumn.isNullable());
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        OrmEntityTests.assertEquals((String)"manyToOne", (String)associationOverride.getName());
        OrmEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        OrmEntityTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        OrmEntityTests.assertEquals((String)"manyToOne", (String)associationOverride.getName());
        entity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEntityTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        OrmEntityTests.assertEquals((String)"manyToOne", (String)associationOverride.getName());
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        entity.setSpecifiedMetadataComplete(Boolean.FALSE);
        ((JavaAssociationOverride)entity.getJavaEntity().getAssociationOverrideContainer().virtualAssociationOverrides().next()).setVirtual(false);
        JavaAssociationOverride javaAssociationOverride = (JavaAssociationOverride)entity.getJavaEntity().getAssociationOverrideContainer().specifiedAssociationOverrides().next();
        JavaJoinColumnInAssociationOverrideJoiningStrategy javaJoiningStrategy = javaAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaJoinColumn javaJoinColumn = (JavaJoinColumn)javaJoiningStrategy.joinColumns().next();
        javaJoinColumn.setSpecifiedName("FOO");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCE");
        javaJoinColumn.setSpecifiedTable("BAR");
        javaJoinColumn.setColumnDefinition("COLUMN_DEF");
        javaJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaJoinColumn.setSpecifiedUnique(Boolean.TRUE);
        javaJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        OrmEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        joiningStrategy = associationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmEntityTests.assertEquals((String)"oneToOne", (String)associationOverride.getName());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)joiningStrategy.joinColumns().next();
        OrmEntityTests.assertEquals((String)"FOO", (String)ormJoinColumn.getSpecifiedName());
        OrmEntityTests.assertEquals((String)"REFERENCE", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        OrmEntityTests.assertEquals((String)"BAR", (String)ormJoinColumn.getSpecifiedTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF", (String)ormJoinColumn.getColumnDefinition());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        joiningStrategy = associationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmEntityTests.assertEquals((String)"manyToOne", (String)associationOverride.getName());
        OrmEntityTests.assertEquals(null, (String)((OrmJoinColumn)joiningStrategy.joinColumns().next()).getSpecifiedName());
        persistentType2.getAttributeNamed("manyToOne").makeSpecified();
        OrmManyToOneMapping manyToOneMapping = (OrmManyToOneMapping)persistentType2.getAttributeNamed("manyToOne").getMapping();
        joinColumn = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_NAME");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERNCE_NAME");
        joinColumn.setSpecifiedTable("BAR2");
        joinColumn.setColumnDefinition("COLUMN_DEF2");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        OrmEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        joiningStrategy = associationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmEntityTests.assertEquals((String)"manyToOne", (String)associationOverride.getName());
        ormJoinColumn = (OrmJoinColumn)joiningStrategy.joinColumns().next();
        OrmEntityTests.assertEquals((String)"MY_NAME", (String)ormJoinColumn.getSpecifiedName());
        OrmEntityTests.assertEquals((String)"MY_REFERNCE_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        OrmEntityTests.assertEquals((String)"BAR2", (String)ormJoinColumn.getSpecifiedTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF2", (String)ormJoinColumn.getColumnDefinition());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        associationOverride = (OrmAssociationOverride)virtualAssociationOverrides.next();
        joiningStrategy = associationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmEntityTests.assertEquals((String)"oneToOne", (String)associationOverride.getName());
        ormJoinColumn = (OrmJoinColumn)joiningStrategy.joinColumns().next();
        OrmEntityTests.assertEquals((String)"FOO", (String)ormJoinColumn.getSpecifiedName());
        OrmEntityTests.assertEquals((String)"REFERENCE", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        OrmEntityTests.assertEquals((String)"BAR", (String)ormJoinColumn.getSpecifiedTable());
        OrmEntityTests.assertEquals((String)"COLUMN_DEF", (String)ormJoinColumn.getColumnDefinition());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
    }

    public void testAddNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmNamedQuery namedQuery = ormEntity.getQueryContainer().addNamedQuery(0);
        namedQuery.setName("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmNamedQuery namedQuery2 = ormEntity.getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        OrmNamedQuery namedQuery3 = ormEntity.getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
        ListIterator namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((Object)namedQuery2, namedQueries.next());
        OrmEntityTests.assertEquals((Object)namedQuery3, namedQueries.next());
        OrmEntityTests.assertEquals((Object)namedQuery, namedQueries.next());
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedQuery(0).setName("FOO");
        ormEntity.getQueryContainer().addNamedQuery(1).setName("BAR");
        ormEntity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getNamedQueries().size());
        ormEntity.getQueryContainer().removeNamedQuery(0);
        OrmEntityTests.assertEquals((int)2, (int)entityResource.getNamedQueries().size());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        ormEntity.getQueryContainer().removeNamedQuery(0);
        OrmEntityTests.assertEquals((int)1, (int)entityResource.getNamedQueries().size());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        ormEntity.getQueryContainer().removeNamedQuery(0);
        OrmEntityTests.assertEquals((int)0, (int)entityResource.getNamedQueries().size());
    }

    public void testMoveNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedQuery(0).setName("FOO");
        ormEntity.getQueryContainer().addNamedQuery(1).setName("BAR");
        ormEntity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getNamedQueries().size());
        ormEntity.getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
        ormEntity.getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().queriesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        ((XmlNamedQuery)entityResource.getNamedQueries().get(0)).setName("FOO");
        ((XmlNamedQuery)entityResource.getNamedQueries().get(1)).setName("BAR");
        ((XmlNamedQuery)entityResource.getNamedQueries().get(2)).setName("BAZ");
        ListIterator namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedQueries.hasNext());
        OrmEntityTests.assertEquals((int)3, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedQueries().move(2, 0);
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedQueries.hasNext());
        entityResource.getNamedQueries().move(0, 1);
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedQueries.hasNext());
        entityResource.getNamedQueries().remove(1);
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedQueries.hasNext());
        OrmEntityTests.assertEquals((int)2, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedQueries().remove(1);
        namedQueries = ormEntity.getQueryContainer().namedQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedQueries.hasNext());
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedQueries().remove(0);
        OrmEntityTests.assertFalse((boolean)ormEntity.getQueryContainer().namedQueries().hasNext());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().queriesSize());
    }

    public void testAddNamedNativeQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmNamedNativeQuery namedNativeQuery = ormEntity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmNamedNativeQuery namedNativeQuery2 = ormEntity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).getName());
        OrmNamedNativeQuery namedNativeQuery3 = ormEntity.getQueryContainer().addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(2)).getName());
        ListIterator namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((Object)namedNativeQuery2, namedNativeQueries.next());
        OrmEntityTests.assertEquals((Object)namedNativeQuery3, namedNativeQueries.next());
        OrmEntityTests.assertEquals((Object)namedNativeQuery, namedNativeQueries.next());
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        ormEntity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        ormEntity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getNamedNativeQueries().size());
        ormEntity.getQueryContainer().removeNamedNativeQuery(0);
        OrmEntityTests.assertEquals((int)2, (int)entityResource.getNamedNativeQueries().size());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).getName());
        ormEntity.getQueryContainer().removeNamedNativeQuery(0);
        OrmEntityTests.assertEquals((int)1, (int)entityResource.getNamedNativeQueries().size());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        ormEntity.getQueryContainer().removeNamedNativeQuery(0);
        OrmEntityTests.assertEquals((int)0, (int)entityResource.getNamedNativeQueries().size());
    }

    public void testMoveNamedNativeQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        ormEntity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        ormEntity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntityTests.assertEquals((int)3, (int)entityResource.getNamedNativeQueries().size());
        ormEntity.getQueryContainer().moveNamedNativeQuery(2, 0);
        ListIterator namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(2)).getName());
        ormEntity.getQueryContainer().moveNamedNativeQuery(0, 1);
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(2)).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().queriesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        entityResource.getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        entityResource.getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        ((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(0)).setName("FOO");
        ((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(1)).setName("BAR");
        ((XmlNamedNativeQuery)entityResource.getNamedNativeQueries().get(2)).setName("BAZ");
        ListIterator namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedNativeQueries.hasNext());
        OrmEntityTests.assertEquals((int)3, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedNativeQueries().move(2, 0);
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedNativeQueries.hasNext());
        entityResource.getNamedNativeQueries().move(0, 1);
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedNativeQueries.hasNext());
        entityResource.getNamedNativeQueries().remove(1);
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedNativeQueries.hasNext());
        OrmEntityTests.assertEquals((int)2, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedNativeQueries().remove(1);
        namedNativeQueries = ormEntity.getQueryContainer().namedNativeQueries();
        OrmEntityTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        OrmEntityTests.assertFalse((boolean)namedNativeQueries.hasNext());
        OrmEntityTests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().queriesSize());
        entityResource.getNamedNativeQueries().remove(0);
        OrmEntityTests.assertFalse((boolean)ormEntity.getQueryContainer().namedNativeQueries().hasNext());
        OrmEntityTests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().queriesSize());
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestIdClass();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmIdClassReference idClassRef = ormEntity.getIdClassReference();
        OrmEntityTests.assertNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        entityResource.setIdClass(OrmFactory.eINSTANCE.createXmlClassReference());
        OrmEntityTests.assertNotNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        entityResource.getIdClass().setClassName(nonExistentIdClassName);
        OrmEntityTests.assertEquals((String)nonExistentIdClassName, (String)entityResource.getIdClass().getClassName());
        OrmEntityTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        entityResource.getIdClass().setClassName(existentIdClassName);
        OrmEntityTests.assertEquals((String)existentIdClassName, (String)entityResource.getIdClass().getClassName());
        OrmEntityTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNotNull((Object)idClassRef.getIdClass());
        entityResource.getIdClass().setClassName(null);
        OrmEntityTests.assertNotNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        entityResource.setIdClass(OrmFactory.eINSTANCE.createXmlClassReference());
        entityResource.getIdClass().setClassName("model.Foo");
        entityResource.setIdClass(null);
        OrmEntityTests.assertNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        this.createTestIdClass();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmIdClassReference idClassRef = ormEntity.getIdClassReference();
        OrmEntityTests.assertNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        idClassRef.setSpecifiedIdClassName(nonExistentIdClassName);
        OrmEntityTests.assertEquals((String)nonExistentIdClassName, (String)entityResource.getIdClass().getClassName());
        OrmEntityTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClassRef.setSpecifiedIdClassName(existentIdClassName);
        OrmEntityTests.assertEquals((String)existentIdClassName, (String)entityResource.getIdClass().getClassName());
        OrmEntityTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNotNull((Object)idClassRef.getIdClass());
        idClassRef.setSpecifiedIdClassName(null);
        OrmEntityTests.assertNull((Object)entityResource.getIdClass());
        OrmEntityTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmEntityTests.assertNull((Object)idClassRef.getIdClass());
    }

    public void testGetPrimaryKeyColumnNameWithAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType superPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmPersistentType subPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntity childXmlEntity = (OrmEntity)subPersistentType.getMapping();
        superPersistentType.getAttributeNamed("id").makeSpecified("id");
        OrmEntityTests.assertEquals((String)"id", (String)childXmlEntity.getPrimaryKeyColumnName());
        ((OrmIdMapping)superPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        OrmEntityTests.assertEquals((String)"MY_ID", (String)childXmlEntity.getPrimaryKeyColumnName());
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)childXmlEntity.getAttributeOverrideContainer().virtualAttributeOverrides().next();
        OrmEntityTests.assertEquals((String)"id", (String)ormAttributeOverride.getName());
        ormAttributeOverride = ormAttributeOverride.setVirtual(false);
        ormAttributeOverride.getColumn().setSpecifiedName("ID");
        OrmEntityTests.assertEquals((String)"ID", (String)childXmlEntity.getPrimaryKeyColumnName());
    }

    public void testDiscriminatorValueIsUndefinedConcreteClass() throws Exception {
        this.createTestType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmEntityTests.assertTrue((boolean)entity.discriminatorValueIsUndefined());
        this.createTestSubType();
        this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntityTests.assertFalse((boolean)entity.discriminatorValueIsUndefined());
    }

    public void testDiscriminatorValueIsAllowedAbstractClass() throws Exception {
        this.createTestAbstractType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)persistentType.getMapping();
        OrmEntityTests.assertTrue((boolean)entity.discriminatorValueIsUndefined());
        this.createTestSubType();
        this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmEntityTests.assertTrue((boolean)entity.discriminatorValueIsUndefined());
    }

    public void testDiscriminatorColumnIsAllowed() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        OrmPersistentType concretePersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmPersistentType abstractPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Entity concreteEntity = (Entity)concretePersistentType.getMapping();
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)abstractPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        OrmEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        OrmEntityTests.assertFalse((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
        ((JavaEntity)abstractPersistentType.getJavaPersistentType().getMapping()).setSpecifiedInheritanceStrategy(null);
        OrmEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        OrmEntityTests.assertTrue((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
    }

    public void testAbstractEntityGetDefaultDiscriminatorColumnNameTablePerClassInheritance() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        OrmPersistentType concretePersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_CHILD_TYPE_NAME);
        OrmPersistentType abstractPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Entity concreteEntity = (Entity)concretePersistentType.getMapping();
        OrmEntityTests.assertEquals((String)CHILD_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)abstractPersistentType.getMapping();
        OrmEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        OrmEntityTests.assertEquals(null, (Object)abstractEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertEquals(null, (Object)concreteEntity.getSpecifiedInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)concreteEntity.getDefaultInheritanceStrategy());
        OrmEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        OrmEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        OrmEntityTests.assertEquals(null, (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmEntityTests.assertEquals(null, (String)concreteEntity.getDiscriminatorColumn().getDefaultName());
        OrmEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        OrmEntityTests.assertEquals(null, (String)abstractEntity.getDefaultDiscriminatorValue());
        OrmEntityTests.assertTrue((boolean)concreteEntity.discriminatorValueIsUndefined());
        OrmEntityTests.assertEquals(null, (String)concreteEntity.getDefaultDiscriminatorValue());
    }
}

