/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmGeneratedValueTests
extends ContextModelTestCase {
    public OrmGeneratedValueTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmGeneratedValue ormGeneratedValue = ormIdMapping.addGeneratedValue();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        XmlGeneratedValue generatedValueResource = idResource.getGeneratedValue();
        generatedValueResource.setGenerator("FOO");
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)ormGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)generatedValueResource.getGenerator());
        generatedValueResource.setGenerator(null);
        OrmGeneratedValueTests.assertNull((Object)ormGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertNull((Object)generatedValueResource.getGenerator());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmGeneratedValue ormGeneratedValue = ormIdMapping.addGeneratedValue();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        XmlGeneratedValue generatedValueResource = idResource.getGeneratedValue();
        ormGeneratedValue.setSpecifiedGenerator("FOO");
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)generatedValueResource.getGenerator());
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)ormGeneratedValue.getSpecifiedGenerator());
        ormGeneratedValue.setSpecifiedGenerator(null);
        OrmGeneratedValueTests.assertNull((Object)generatedValueResource.getGenerator());
        OrmGeneratedValueTests.assertNull((Object)ormGeneratedValue.getSpecifiedGenerator());
    }

    public void testDefaultsFromJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormIdAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        IdMapping ormIdMapping = (IdMapping)ormIdAttribute.getMapping();
        OrmGeneratedValueTests.assertEquals(null, (Object)ormIdMapping.getGeneratedValue());
        IdMapping javaIdMapping = (IdMapping)((JavaPersistentAttribute)ormPersistentType.getJavaPersistentType().attributes().next()).getMapping();
        GeneratedValue javaGeneratedValue = javaIdMapping.addGeneratedValue();
        javaGeneratedValue.setSpecifiedGenerator("Foo");
        javaGeneratedValue.setSpecifiedStrategy(GenerationType.SEQUENCE);
        OrmGeneratedValueTests.assertEquals((String)"Foo", (String)ormIdMapping.getGeneratedValue().getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)ormIdMapping.getGeneratedValue().getSpecifiedStrategy());
        OrmGeneratedValueTests.assertEquals((String)"Foo", (String)javaGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)javaGeneratedValue.getSpecifiedStrategy());
        ormIdAttribute.makeSpecified();
        ormIdAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        ormIdMapping = (IdMapping)ormIdAttribute.getMapping();
        OrmGeneratedValueTests.assertEquals(null, (Object)ormIdMapping.getGeneratedValue());
        OrmGeneratedValueTests.assertEquals((String)"Foo", (String)javaGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)javaGeneratedValue.getSpecifiedStrategy());
        ormIdAttribute.makeVirtual();
        ormIdAttribute = ormPersistentType.getAttributeNamed("id");
        ormIdMapping = (IdMapping)ormIdAttribute.getMapping();
        OrmGeneratedValueTests.assertEquals((String)"Foo", (String)ormIdMapping.getGeneratedValue().getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)ormIdMapping.getGeneratedValue().getSpecifiedStrategy());
        OrmGeneratedValueTests.assertEquals((String)"Foo", (String)javaGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)javaGeneratedValue.getSpecifiedStrategy());
    }
}

