/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;

public class OrmMappedSuperclassTests
extends ContextModelTestCase {
    public OrmMappedSuperclassTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private void createTestIdClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append("TestTypeId").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestTypeId.java", sourceWriter);
    }

    public void testUpdateClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getClassName());
        mappedSuperclassResource.setClassName("com.Bar");
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)mappedSuperclassResource.getClassName());
        mappedSuperclassResource.setClassName(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getClassName());
    }

    public void testModifyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)mappedSuperclassResource.getClassName());
        ormMappedSuperclass.setClass("com.Bar");
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertEquals((String)"com.Bar", (String)mappedSuperclassResource.getClassName());
        ormMappedSuperclass.setClass(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getClass_());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getClassName());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
        mappedSuperclassResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)mappedSuperclassResource.getAccess());
        mappedSuperclassResource.setAccess(null);
        OrmMappedSuperclassTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclassResource.getAccess());
        ormPersistentType.setSpecifiedAccess(null);
        OrmMappedSuperclassTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getAccess());
    }

    public void testUpdateSpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(Boolean.TRUE);
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(Boolean.FALSE);
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)mappedSuperclassResource.getMetadataComplete());
        mappedSuperclassResource.setMetadataComplete(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testModifySpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)mappedSuperclassResource.getMetadataComplete());
        ormMappedSuperclass.setSpecifiedMetadataComplete(null);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testUpdateDefaultMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isDefaultMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testUpdateMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmMappedSuperclassTests.assertTrue((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmMappedSuperclassTests.assertFalse((boolean)ormMappedSuperclass.isMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getMetadataComplete());
    }

    public void testMakeMappedSuperclassEntity() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclassPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmMappedSuperclassTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmMappedSuperclassTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)mappedSuperclassPersistentType.getSpecifiedAccess());
    }

    public void testMakeMappedSuperclassEntity2() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo2");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclassPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmMappedSuperclassTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmMappedSuperclassTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)mappedSuperclassPersistentType.getSpecifiedAccess());
        ListIterator persistentTypes = this.getEntityMappings().getPersistentTypes().iterator();
        OrmMappedSuperclassTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmMappedSuperclassTests.assertEquals((String)"entity", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }

    public void testMakeMappedSuperclassEmbeddable() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclassPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)mappedSuperclassPersistentType.getSpecifiedAccess());
    }

    public void testMakeMappedSuperclassEmbeddable2() throws Exception {
        OrmPersistentType mappedSuperclassPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo2");
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)mappedSuperclassPersistentType.getMapping();
        mappedSuperclassPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        mappedSuperclass.setSpecifiedMetadataComplete(Boolean.TRUE);
        mappedSuperclassPersistentType.setMappingKey("embeddable");
        XmlEmbeddable embeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)embeddable.getClassName());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)embeddable.getMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddable.getAccess());
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)mappedSuperclassPersistentType.getMapping();
        OrmMappedSuperclassTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmMappedSuperclassTests.assertEquals((Object)AccessType.PROPERTY, (Object)mappedSuperclassPersistentType.getSpecifiedAccess());
        ListIterator persistentTypes = this.getEntityMappings().getPersistentTypes().iterator();
        OrmMappedSuperclassTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmMappedSuperclassTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestIdClass();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        OrmIdClassReference idClassRef = ormMappedSuperclass.getIdClassReference();
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        mappedSuperclassResource.setIdClass(OrmFactory.eINSTANCE.createXmlClassReference());
        OrmMappedSuperclassTests.assertNotNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        mappedSuperclassResource.getIdClass().setClassName(nonExistentIdClassName);
        OrmMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)mappedSuperclassResource.getIdClass().getClassName());
        OrmMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        mappedSuperclassResource.getIdClass().setClassName(existentIdClassName);
        OrmMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)mappedSuperclassResource.getIdClass().getClassName());
        OrmMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNotNull((Object)idClassRef.getIdClass());
        mappedSuperclassResource.getIdClass().setClassName(null);
        OrmMappedSuperclassTests.assertNotNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        mappedSuperclassResource.setIdClass(OrmFactory.eINSTANCE.createXmlClassReference());
        mappedSuperclassResource.getIdClass().setClassName("model.Foo");
        mappedSuperclassResource.setIdClass(null);
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        this.createTestIdClass();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo");
        XmlMappedSuperclass mappedSuperclassResource = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)ormPersistentType.getMapping();
        OrmIdClassReference idClassRef = ormMappedSuperclass.getIdClassReference();
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        idClassRef.setSpecifiedIdClassName(nonExistentIdClassName);
        OrmMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)mappedSuperclassResource.getIdClass().getClassName());
        OrmMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClassRef.setSpecifiedIdClassName(existentIdClassName);
        OrmMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)mappedSuperclassResource.getIdClass().getClassName());
        OrmMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNotNull((Object)idClassRef.getIdClass());
        idClassRef.setSpecifiedIdClassName(null);
        OrmMappedSuperclassTests.assertNull((Object)mappedSuperclassResource.getIdClass());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        OrmMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
    }
}

