/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.jpa2.context.java.JavaCollectionTable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.resource.java.CollectionTable2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaCollectionTable2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaCollectionTable2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithElementCollection() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidElementCollection() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
                sb.append("    private Collection<String> projects;").append(CR);
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable);
        attributeResource.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getName());
        resourceCollectionTable.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable.getName());
        resourceCollectionTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getName());
        attributeResource.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable3 = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable3);
        collectionTable.setSpecifiedName("foo");
        resourceCollectionTable3 = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)resourceCollectionTable3.getName());
        collectionTable.setSpecifiedName(null);
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedName());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"AnnotationTestType_projects", (String)collectionTable.getDefaultName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
        attributeResource.addAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"AnnotationTestType_projects", (String)collectionTable.getDefaultName());
        GenericJavaCollectionTable2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
        this.getJavaEntity().setSpecifiedName("Foo");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"Foo_projects", (String)collectionTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable);
        attributeResource.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getSchema());
        resourceCollectionTable.setSchema(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable.getSchema());
        resourceCollectionTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getSchema());
        attributeResource.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable);
        collectionTable.setSpecifiedSchema("foo");
        resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)resourceCollectionTable.getSchema());
        collectionTable.setSpecifiedSchema(null);
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedSchema());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable);
        attributeResource.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getCatalog());
        resourceCollectionTable.setCatalog(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable.getCatalog());
        resourceCollectionTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)resourceCollectionTable.getCatalog());
        attributeResource.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)resourceCollectionTable);
        collectionTable.setSpecifiedCatalog("foo");
        resourceCollectionTable = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)resourceCollectionTable.getCatalog());
        collectionTable.setSpecifiedCatalog(null);
        GenericJavaCollectionTable2_0Tests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        GenericJavaCollectionTable2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinColumn joinColumn = collectionTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(0).getName());
        JoinColumn joinColumn2 = collectionTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(1).getName());
        JoinColumn joinColumn3 = collectionTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        ListIterator joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericJavaCollectionTable2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericJavaCollectionTable2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        collectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        collectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        collectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((int)3, (int)joinTableResource.joinColumnsSize());
        collectionTable.removeSpecifiedJoinColumn(0);
        GenericJavaCollectionTable2_0Tests.assertEquals((int)2, (int)joinTableResource.joinColumnsSize());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        collectionTable.removeSpecifiedJoinColumn(0);
        GenericJavaCollectionTable2_0Tests.assertEquals((int)1, (int)joinTableResource.joinColumnsSize());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        collectionTable.removeSpecifiedJoinColumn(0);
        GenericJavaCollectionTable2_0Tests.assertEquals((int)0, (int)joinTableResource.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        collectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        collectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        collectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((int)3, (int)joinTableResource.joinColumnsSize());
        collectionTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        collectionTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(1).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)attributeResource.addAnnotation("javax.persistence.CollectionTable");
        joinTableResource.addJoinColumn(0);
        joinTableResource.addJoinColumn(1);
        joinTableResource.addJoinColumn(2);
        joinTableResource.joinColumnAt(0).setName("FOO");
        joinTableResource.joinColumnAt(1).setName("BAR");
        joinTableResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.specifiedJoinColumns();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)collectionTable.specifiedJoinColumns().hasNext());
    }

    public void testGetDefaultJoinColumn() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        GenericJavaCollectionTable2_0Tests.assertEquals((int)0, (int)collectionTable.specifiedJoinColumnsSize());
        collectionTable.addSpecifiedJoinColumn(0);
        GenericJavaCollectionTable2_0Tests.assertEquals((int)1, (int)collectionTable.specifiedJoinColumnsSize());
        collectionTable.removeSpecifiedJoinColumn(0);
        GenericJavaCollectionTable2_0Tests.assertEquals((int)0, (int)collectionTable.specifiedJoinColumnsSize());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        ListIterator uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertTrue((boolean)uniqueConstraints.hasNext());
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        GenericJavaCollectionTable2_0Tests.assertEquals((int)0, (int)collectionTable.uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCollectionTable2_0Tests.assertEquals((int)2, (int)collectionTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        collectionTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        collectionTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        collectionTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        GenericJavaCollectionTable2_0Tests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        collectionTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        collectionTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)attributeResource.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        joinTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.uniqueConstraints();
        GenericJavaCollectionTable2_0Tests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

