/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericOrmPersistentType2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmPersistentType2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldPropertySpecified() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }

            @Override
            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Access(AccessType.FIELD)");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityFieldSpecifiedPropertyAnnotated() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.FIELD)");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestEntityPropertySpecified() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    public void testGetAccessWithJavaAnnotations() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.makeSpecified();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testGetAccessWithJavaAnnotationsProperty() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getSpecifiedAccess());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.makeSpecified();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getSpecifiedAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testVirtualAttributes() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualAttributes = ormPersistentType.virtualAttributes();
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testVirtualAttributes2() throws Exception {
        this.createTestEntityPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualAttributes = ormPersistentType.virtualAttributes();
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        virtualAttributes = ormPersistentType.virtualAttributes();
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testVirtualAttributes3() throws Exception {
        this.createTestEntityFieldSpecifiedPropertyAnnotated();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentAttribute.makeSpecified();
        virtualAttributes = ormPersistentType.virtualAttributes();
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        OrmPersistentAttribute specifiedPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)specifiedPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedPersistentAttribute.getSpecifiedAccess());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        virtualAttributes = ormPersistentType.virtualAttributes();
        ormPersistentAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testGetDefaultAccess() throws Exception {
        this.createTestEntityPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        javaPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        javaPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
    }
}

