/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.core.resource.java.EnumType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class MapKeyEnumerated2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public MapKeyEnumerated2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKeyEnumerated() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyEnumerated"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyEnumerated");
            }
        });
    }

    private ICompilationUnit createTestMapKeyEnumeratedWithValue() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyEnumerated", "javax.persistence.EnumType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyEnumerated(EnumType.ORDINAL)");
            }
        });
    }

    public void testMapKeyEnumerated() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyEnumerated");
        MapKeyEnumerated2_0AnnotationTests.assertNotNull((Object)enumerated);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumeratedWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyEnumerated");
        MapKeyEnumerated2_0AnnotationTests.assertEquals((Object)EnumType.ORDINAL, (Object)enumerated.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumerated();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(EnumType.STRING);
        this.assertSourceContains("@MapKeyEnumerated(STRING)", cu);
        enumerated.setValue(null);
        this.assertSourceDoesNotContain("@MapKeyEnumerated(", cu);
        this.assertSourceContains("@MapKeyEnumerated", cu);
    }
}

