/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverridesAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AttributeOverridesTests
extends JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE";

    public AttributeOverridesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAttributeOverrideOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverrideWithColumnOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"MY_COLUMN\")))");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1))");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverridesAnnotation attributeOverrides = (AttributeOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AttributeOverrides");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeOverrides.getNestedAnnotations().iterator().next();
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
    }

    public void testGetNullColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverridesAnnotation attributeOverrides = (AttributeOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AttributeOverrides");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeOverrides.getNestedAnnotations().iterator().next();
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertNull((Object)column);
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverridesAnnotation attributeOverrides = (AttributeOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AttributeOverrides");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeOverrides.getNestedAnnotations().iterator().next();
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName("Foo");
        AttributeOverridesTests.assertEquals((String)"Foo", (String)attributeOverride.getName());
        this.assertSourceContains("@AttributeOverrides(@AttributeOverride(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverridesAnnotation attributeOverrides = (AttributeOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AttributeOverrides");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeOverrides.getNestedAnnotations().iterator().next();
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName(null);
        AttributeOverridesTests.assertNull((Object)attributeOverride.getName());
        this.assertSourceDoesNotContain("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE\")", cu);
        this.assertSourceContains("@AttributeOverride", cu);
        this.assertSourceContains("@AttributeOverrides", cu);
    }

    public void testColumnGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverridesAnnotation attributeOverrides = (AttributeOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AttributeOverrides");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeOverrides.getNestedAnnotations().iterator().next();
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides").next();
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName("Foo");
        this.assertSourceContains("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"Foo\")))", cu);
        column.setName(null);
        AttributeOverridesTests.assertNull((Object)attributeOverride.getColumn());
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")", cu);
    }

    public void testAddAttributeOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),@AttributeOverride(name = \"BAR\")})", cu);
        AttributeOverridesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        AttributeOverridesTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testAddAttributeOverrideToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),@AttributeOverride(name = \"BAR\")})", cu);
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"BAZ\"),@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)), @AttributeOverride(name = \"BAR\")})", cu);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        AttributeOverridesTests.assertEquals((String)"BAZ", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertEquals((String)"FOO", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertEquals((String)"BAR", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        AttributeOverridesTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testRemoveAttributeOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),@AttributeOverride(name = \"BAR\")})", cu);
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceContains("@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1))", cu);
    }
}

