/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.EmbeddedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EmbeddedTests
extends JavaResourceModelTestCase {
    public EmbeddedTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEmbedded() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
            }
        });
    }

    public void testEmbedded() throws Exception {
        ICompilationUnit cu = this.createTestEmbedded();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        Annotation mappingAnnotation = attributeResource.getAnnotation("javax.persistence.Embedded");
        EmbeddedTests.assertTrue((boolean)(mappingAnnotation instanceof EmbeddedAnnotation));
    }
}

