/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.utility.jdt;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;

public class ASTToolsTests
extends AnnotationTestCase {
    public ASTToolsTests(String name) {
        super(name);
    }

    private void createEnumAndMembers(String enumName, String enumBody) throws Exception {
        this.javaProject.createCompilationUnit("enums", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createCompilationUnit("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    public void testResolveEnum1() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("@annot.TestAnnotation(foo=enums.TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum2() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.BAZ", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum3() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.*", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum4() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("enums.TestEnum", "@annot.TestAnnotation(foo=TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }
}

