/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.utility.jdt;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationTestCase
extends TestCase {
    protected TestJavaProject javaProject;
    public static final String CR = System.getProperty("line.separator");
    public static final String SEP = File.separator;
    public static final String PROJECT_NAME = "AnnotationTestProject";
    public static final String PACKAGE_NAME = "test";
    public static final String TYPE_NAME = "AnnotationTestType";
    public static final String FULLY_QUALIFIED_TYPE_NAME = "test.AnnotationTestType";
    public static final String FILE_NAME = "AnnotationTestType.java";
    public static final IPath FILE_PATH = new Path("src" + SEP + "test" + SEP + "AnnotationTestType.java");
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected AnnotationTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaProject = this.buildJavaProject(false);
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJavaProject(PROJECT_NAME, autoBuild);
    }

    protected TestJavaProject buildJavaProject(String projectName, boolean autoBuild) throws Exception {
        return new TestJavaProject(projectName, autoBuild);
    }

    protected void tearDown() throws Exception {
        this.deleteProject();
        TestTools.clear((TestCase)this);
        super.tearDown();
    }

    protected void deleteProject() throws Exception {
        int i = 1;
        boolean deleted = false;
        while (!deleted) {
            try {
                this.javaProject.getProject().delete(true, true, null);
                deleted = true;
            }
            catch (CoreException ex) {
                if (i == 4) {
                    throw new RuntimeException(String.valueOf(this.getName()) + " - unable to delete project", ex);
                }
                Thread.sleep(1000L);
                ++i;
            }
        }
    }

    protected void dumpSource(ICompilationUnit cu) throws Exception {
        System.out.println("*** " + this.getName() + " ****");
        System.out.println(this.getSource(cu));
        System.out.println();
    }

    protected ICompilationUnit createTestType() throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter());
    }

    protected ICompilationUnit createTestType(final String annotationImport, final String idFieldAnnotation) throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return annotationImport == null ? EmptyIterator.instance() : new SingleElementIterator((Object)annotationImport);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(idFieldAnnotation);
            }
        });
    }

    protected ICompilationUnit createTestType(String idFieldAnnotation) throws CoreException {
        return this.createTestType(null, idFieldAnnotation);
    }

    protected ICompilationUnit createTestType(AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProject.createCompilationUnit(PACKAGE_NAME, FILE_NAME, this.createSourceWriter(annotationWriter));
    }

    protected ICompilationUnit createTestType(String packageName, String fileName, String typeName, AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProject.createCompilationUnit(packageName, fileName, this.createSourceWriter(annotationWriter, typeName));
    }

    protected TestJavaProject.SourceWriter createSourceWriter(AnnotationWriter annotationWriter) {
        return new AnnotatedSourceWriter(annotationWriter);
    }

    protected TestJavaProject.SourceWriter createSourceWriter(AnnotationWriter annotationWriter, String typeName) {
        return new AnnotatedSourceWriter(annotationWriter, typeName);
    }

    protected void appendSourceTo(StringBuilder sb, AnnotationWriter annotationWriter, String typeName) {
        sb.append(CR);
        Iterator<String> stream = annotationWriter.imports();
        while (stream.hasNext()) {
            sb.append("import ");
            sb.append(stream.next());
            sb.append(";");
            sb.append(CR);
        }
        sb.append(CR);
        annotationWriter.appendTypeAnnotationTo(sb);
        sb.append(CR);
        sb.append("public class ").append(typeName).append(" ");
        annotationWriter.appendExtendsImplementsTo(sb);
        sb.append("{").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendIdFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private int id;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendNameFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private String name;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public int getId() {").append(CR);
        sb.append("        return this.id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setId(int id) {").append(CR);
        sb.append("        this.id = id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public String getName() {").append(CR);
        sb.append("        return this.name;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setTestField(String testField) {").append(CR);
        sb.append("        this.testField = testField;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        annotationWriter.appendMemberTypeTo(sb);
        sb.append(CR);
        sb.append("}").append(CR);
        annotationWriter.appendTopLevelTypesTo(sb);
        sb.append(CR);
    }

    protected TestJavaProject getJavaProject() {
        return this.javaProject;
    }

    protected JDTType testType(ICompilationUnit cu) {
        return this.buildType(TYPE_NAME, cu);
    }

    protected JDTType buildType(String name, ICompilationUnit cu) {
        return this.buildType(name, 1, cu);
    }

    protected JDTType buildType(String name, int occurrence, ICompilationUnit cu) {
        return this.buildType(null, name, occurrence, cu);
    }

    protected JDTType buildType(Type declaringType, String name, int occurrence, ICompilationUnit cu) {
        return new JDTType(declaringType, name, occurrence, cu);
    }

    protected JDTFieldAttribute idField(ICompilationUnit cu) {
        return this.buildField("id", cu);
    }

    protected JDTFieldAttribute nameField(ICompilationUnit cu) {
        return this.buildField("name", cu);
    }

    protected JDTFieldAttribute buildField(String name, ICompilationUnit cu) {
        return this.buildField(name, 1, cu);
    }

    protected JDTFieldAttribute buildField(String name, int occurrence, ICompilationUnit cu) {
        return this.buildField((Type)this.testType(cu), name, occurrence, cu);
    }

    protected JDTFieldAttribute buildField(Type declaringType, String name, int occurrence, ICompilationUnit cu) {
        return new JDTFieldAttribute(declaringType, name, occurrence, cu);
    }

    protected JDTMethodAttribute idGetMethod(ICompilationUnit cu) {
        return this.buildMethod("getId", cu);
    }

    protected JDTMethodAttribute idSetMethod(ICompilationUnit cu) {
        return this.buildMethod("setId", new String[]{"int"}, cu);
    }

    protected JDTMethodAttribute nameGetMethod(ICompilationUnit cu) {
        return this.buildMethod("getName", cu);
    }

    protected JDTMethodAttribute buildMethod(String name, ICompilationUnit cu) {
        return this.buildMethod(name, EMPTY_STRING_ARRAY, cu);
    }

    protected JDTMethodAttribute buildMethod(String name, String[] parameterTypeNames, ICompilationUnit cu) {
        return this.buildMethod(name, parameterTypeNames, 1, cu);
    }

    protected JDTMethodAttribute buildMethod(String name, String[] parameterTypeNames, int occurrence, ICompilationUnit cu) {
        return new JDTMethodAttribute((Type)this.testType(cu), name, parameterTypeNames, occurrence, cu);
    }

    protected JDTMethodAttribute buildMethod(Type declaringType, String name, String[] parameterTypeNames, int occurrence, ICompilationUnit cu) {
        return new JDTMethodAttribute(declaringType, name, parameterTypeNames, occurrence, cu);
    }

    protected String getSource(ICompilationUnit cu) throws JavaModelException {
        return cu.getBuffer().getContents();
    }

    protected CompilationUnit buildASTRoot(ICompilationUnit cu) {
        return ASTTools.buildASTRoot((ICompilationUnit)cu);
    }

    protected void assertSourceContains(String s, ICompilationUnit cu) throws JavaModelException {
        boolean found;
        String source = this.getSource(cu);
        boolean bl = found = source.indexOf(s) > -1;
        if (!found) {
            String msg = "source does not contain the expected string: " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(source);
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected void assertSourceDoesNotContain(String s, ICompilationUnit cu) throws JavaModelException {
        String source = this.getSource(cu);
        int pos = source.indexOf(s);
        if (pos != -1) {
            String msg = "unexpected string in source (position: " + pos + "): " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(source);
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected MemberValuePair memberValuePair(NormalAnnotation annotation, String elementName) {
        for (MemberValuePair pair : this.values(annotation)) {
            if (!pair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return pair;
        }
        return null;
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }

    protected Expression value_(MemberValuePair pair) {
        return pair == null ? null : pair.getValue();
    }

    protected Expression annotationElementValue(NormalAnnotation annotation, String elementName) {
        return this.value_(this.memberValuePair(annotation, elementName));
    }

    protected Expression annotationElementValue(SingleMemberAnnotation annotation, String elementName) {
        return elementName.equals("value") ? annotation.getValue() : null;
    }

    protected Expression annotationElementValue(Annotation annotation, String elementName) {
        if (annotation.isNormalAnnotation()) {
            return this.annotationElementValue((NormalAnnotation)annotation, elementName);
        }
        if (annotation.isSingleMemberAnnotation()) {
            return this.annotationElementValue((SingleMemberAnnotation)annotation, elementName);
        }
        return null;
    }

    protected NumberLiteral newNumberLiteral(AST ast, int value) {
        return ast.newNumberLiteral(Integer.toString(value));
    }

    protected StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(value);
        return stringLiteral;
    }

    protected MemberValuePair newMemberValuePair(AST ast, SimpleName name, Expression value) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(name);
        pair.setValue(value);
        return pair;
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, Expression value) {
        return this.newMemberValuePair(ast, ast.newSimpleName(name), value);
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, String value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newStringLiteral(ast, value));
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, int value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newNumberLiteral(ast, value));
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, MemberValuePair pair) {
        this.values(annotation).add(pair);
        return annotation;
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, int value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, String value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    public class AnnotatedSourceWriter
    implements TestJavaProject.SourceWriter {
        private AnnotationWriter annotationWriter;
        private String typeName;

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter) {
            this(annotationWriter, AnnotationTestCase.TYPE_NAME);
        }

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter, String typeName) {
            this.annotationWriter = annotationWriter;
            this.typeName = typeName;
        }

        public void appendSourceTo(StringBuilder sb) {
            AnnotationTestCase.this.appendSourceTo(sb, this.annotationWriter, this.typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AnnotationWriter {
        public Iterator<String> imports();

        public void appendTypeAnnotationTo(StringBuilder var1);

        public void appendExtendsImplementsTo(StringBuilder var1);

        public void appendIdFieldAnnotationTo(StringBuilder var1);

        public void appendNameFieldAnnotationTo(StringBuilder var1);

        public void appendGetIdMethodAnnotationTo(StringBuilder var1);

        public void appendSetIdMethodAnnotationTo(StringBuilder var1);

        public void appendGetNameMethodAnnotationTo(StringBuilder var1);

        public void appendSetNameMethodAnnotationTo(StringBuilder var1);

        public void appendMemberTypeTo(StringBuilder var1);

        public void appendTopLevelTypesTo(StringBuilder var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationWriterWrapper
    implements AnnotationWriter {
        private final AnnotationWriter aw;

        public AnnotationWriterWrapper(AnnotationWriter aw) {
            this.aw = aw;
        }

        @Override
        public Iterator<String> imports() {
            return this.aw.imports();
        }

        @Override
        public void appendTypeAnnotationTo(StringBuilder sb) {
            this.aw.appendTypeAnnotationTo(sb);
        }

        @Override
        public void appendExtendsImplementsTo(StringBuilder sb) {
            this.aw.appendExtendsImplementsTo(sb);
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuilder sb) {
            this.aw.appendIdFieldAnnotationTo(sb);
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuilder sb) {
            this.aw.appendNameFieldAnnotationTo(sb);
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendGetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendSetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendGetNameMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendSetNameMethodAnnotationTo(sb);
        }

        @Override
        public void appendMemberTypeTo(StringBuilder sb) {
            this.aw.appendMemberTypeTo(sb);
        }

        @Override
        public void appendTopLevelTypesTo(StringBuilder sb) {
            this.aw.appendTopLevelTypesTo(sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAnnotationWriter
    implements AnnotationWriter {
        @Override
        public Iterator<String> imports() {
            return EmptyIterator.instance();
        }

        @Override
        public void appendTypeAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendExtendsImplementsTo(StringBuilder sb) {
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendMemberTypeTo(StringBuilder sb) {
        }

        @Override
        public void appendTopLevelTypesTo(StringBuilder sb) {
        }
    }
}

