/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.wst.jsdt.web.ui.StructuredTextViewerConfigurationJSDT;
import org.eclipse.wst.jsdt.web.ui.tests.internal.ProjectUtil;
import org.eclipse.wst.jsdt.web.ui.tests.internal.StringUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class FormattingTests
extends TestCase {
    private static final String UTF_8 = "UTF-8";
    private static final String PROJECT_NAME = "FormattingTests";
    private static final String PROJECT_FILES = "/testFiles/formatting";
    private static IProject fProject;
    static /* synthetic */ Class class$0;

    public FormattingTests() {
        super("Formatting Tests");
    }

    public FormattingTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.ui.tests.format.FormattingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Formatting Tests");
        return new FormattingTestsSetup((Test)ts);
    }

    public void testFormatHTMLScriptEvent() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test0.html", "test0.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath, SourceViewerConfiguration configuration) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block4: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                IStructuredDocument document = beforeModel.getStructuredDocument();
                String normalizedContents = document.get();
                normalizedContents = StringUtils.replace(normalizedContents, "\r\n", "\n");
                normalizedContents = StringUtils.replace(normalizedContents, "\r", "\n");
                document.set(normalizedContents);
                IContentFormatterExtension formatter = (IContentFormatterExtension)configuration.getContentFormatter(null);
                FormattingContext fContext = new FormattingContext();
                Region region = new Region(0, document.getLength());
                fContext.setProperty((Object)"formatting.context.document", (Object)true);
                fContext.setProperty((Object)"formatting.context.region", (Object)region);
                formatter.format((IDocument)document, (IFormattingContext)fContext);
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
                String actualContents = new String(formattedBytes.toByteArray(), UTF_8);
                expectedContents = StringUtils.replace(expectedContents, "\r\n", "\n");
                expectedContents = StringUtils.replace(expectedContents, "\r", "\n");
                actualContents = StringUtils.replace(actualContents, "\r\n", "\n");
                actualContents = StringUtils.replace(actualContents, "\r", "\n");
                FormattingTests.assertTrue((String)("Formatted document differs from the expected.\nExpected Contents:\n" + expectedContents + "\nActual Contents:\n" + actualContents), (boolean)StringUtils.equalsIgnoreLineSeperator(expectedContents, actualContents));
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var15_17 = null;
                if (beforeModel == null) break block4;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        FormattingTests.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private IStructuredModel getModelForEdit(String path) {
        IFile file = FormattingTests.getFile(path);
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit(file);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return model;
    }

    private static class FormattingTestsSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public FormattingTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ProjectUtil.createProject(FormattingTests.PROJECT_NAME, null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace(FormattingTests.PROJECT_FILES, FormattingTests.PROJECT_NAME);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

