/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.customizer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ResolverUtil;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.ICustomizableCommand;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFactoryRegistry;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.IDropCustomizer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public final class DropCustomizationController {
    private final ICustomizableCommand _command;
    private final IDropSourceData _dropSourceData;
    private final IDOMDocument _domDocument;
    private final IDOMPosition _domPosition;

    public DropCustomizationController(ICustomizableCommand command, IDropSourceData dropSourceData, IDOMDocument domDocument, IDOMPosition domPosition) {
        this._command = command;
        this._dropSourceData = dropSourceData;
        this._domDocument = domDocument;
        this._domPosition = domPosition;
    }

    public IStatus performCustomization() {
        IDropCustomizer customizer;
        String tagName = this._dropSourceData.getId();
        if (this._dropSourceData instanceof ITagDropSourceData) {
            tagName = ((ITagDropSourceData)this._dropSourceData).getTagName();
        }
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)this._dropSourceData.getNamespace(), (String)tagName);
        IElementEdit elementEdit = ElementEditFactoryRegistry.getInstance().createElementEdit(tagId);
        IStatus status = Status.OK_STATUS;
        if (elementEdit != null && (customizer = elementEdit.getDropCustomizer(this._dropSourceData)) != null) {
            IFile file = DropCustomizationController.getFile(this._domDocument);
            if (file != null) {
                status = customizer.runCustomizer(file, this._domPosition);
            } else {
                PDPlugin.log("Could not find file.", new Exception("Not a real exception"));
                status = Status.CANCEL_STATUS;
            }
            if (status.getSeverity() == 0) {
                this._command.setCustomizationData(customizer.getDropCustomizationData());
            }
        }
        return status;
    }

    private static IFile getFile(IDOMDocument domDoc) {
        IStructuredDocument sdoc = domDoc.getStructuredDocument();
        if (sdoc != null) {
            return ResolverUtil.getFileForDocument((IDocument)sdoc);
        }
        return null;
    }
}

