/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.common;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.ui.common.TreeViewerSelectionDialog;
import org.eclipse.jst.pagedesigner.utils.JavaUtil;
import org.eclipse.swt.widgets.Shell;

public class ResourceOnClasspathDialog
extends TreeViewerSelectionDialog {
    private static final String STATUS_MESSAGE = PageDesignerResources.getInstance().getString("ResourcesOnClasspathDialog.statusMessage");
    private IJavaProject _javaProject;
    private String[] _suffixs;
    private ResourceOnClasspathFilter _filter;

    public void setSuffixs(String[] suffixs) {
        this._suffixs = suffixs;
        this._filter.setSuffixs(suffixs);
    }

    public ResourceOnClasspathDialog(Shell parentShell, IJavaProject project) {
        super(parentShell, STATUS_MESSAGE);
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
        this.setContentProvider((ITreeContentProvider)contentProvider);
        this.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this._filter = new ResourceOnClasspathFilter(contentProvider);
        this.setFilter(this._filter);
        this._javaProject = project;
    }

    public Object[] getResult() {
        Object[] objects = super.getResult();
        if (objects == null || objects.length == 0) {
            return null;
        }
        IPath path = JavaUtil.getPathOnClasspath(this._javaProject, objects[0]);
        String result = null;
        if (path.segmentCount() == 0) {
            return new Object[]{""};
        }
        path = path.removeFileExtension();
        result = path.toOSString();
        result = result.replace(File.separatorChar, '.');
        return new Object[]{result};
    }

    protected boolean isValidSelection(Object selection) {
        String extension = JavaUtil.getPathOnClasspath(this._javaProject, selection).getFileExtension();
        return extension != null && Arrays.asList(this._suffixs).contains(extension);
    }

    protected Object findInputElement() {
        IWorkspace input = ResourcesPlugin.getWorkspace();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)input.getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    class ResourceOnClasspathFilter
    extends ViewerFilter {
        StandardJavaElementContentProvider _javaContentProvider;

        public ResourceOnClasspathFilter(StandardJavaElementContentProvider contentProvider) {
            this._javaContentProvider = contentProvider;
        }

        public void setSuffixs(String[] suffixs) {
            ResourceOnClasspathDialog.this._suffixs = suffixs;
        }

        public void setJavaContentProvider(StandardJavaElementContentProvider contentProvider) {
            this._javaContentProvider = contentProvider;
        }

        public void setJavaProject(IJavaProject project) {
            ResourceOnClasspathDialog.this._javaProject = project;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IJavaProject) {
                String currentProjectName = ((IJavaProject)element).getProject().getFullPath().toString().trim();
                String projectName = ResourceOnClasspathDialog.this._javaProject.getProject().getFullPath().toString().trim();
                return projectName.equalsIgnoreCase(currentProjectName);
            }
            if (element instanceof IResource) {
                if (ResourceOnClasspathDialog.this._javaProject != null && !ResourceOnClasspathDialog.this._javaProject.isOnClasspath((IResource)element)) {
                    return false;
                }
                return element instanceof IFile && Arrays.asList(ResourceOnClasspathDialog.this._suffixs).contains(((IFile)element).getFileExtension());
            }
            if (element instanceof IJarEntryResource) {
                String ext = ((IJarEntryResource)element).getFullPath().getFileExtension();
                return ext != null && Arrays.asList(ResourceOnClasspathDialog.this._suffixs).contains(ext);
            }
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            if (ResourceOnClasspathDialog.this._javaProject != null && !ResourceOnClasspathDialog.this._javaProject.isOnClasspath((IJavaElement)element)) {
                return false;
            }
            IJavaElement javaElement = (IJavaElement)element;
            Object[] children = null;
            switch (javaElement.getElementType()) {
                case 3: {
                    children = this._javaContentProvider.getChildren((Object)javaElement);
                    break;
                }
                case 12: {
                    return true;
                }
                case 4: {
                    children = this._javaContentProvider.getChildren((Object)javaElement);
                    break;
                }
                case 6: {
                    return Arrays.asList(ResourceOnClasspathDialog.this._suffixs).contains("class");
                }
                case 5: {
                    String ext = javaElement.getPath().getFileExtension();
                    return ext != null && Arrays.asList(ResourceOnClasspathDialog.this._suffixs).contains(ext);
                }
                default: {
                    return false;
                }
            }
            int i = 0;
            while (i < children.length) {
                if (this.select(viewer, javaElement, children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

