/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ProjectAddingTests
extends TestCase {
    private JaxWsWorkspaceResource target;
    private IJavaModel javaModel;
    private DomUtil util;
    private TestProject testPrj3;

    public void setUp() throws IOException {
        this.util = new DomUtil();
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = new JaxWsWorkspaceResource(this.javaModel);
        this.target.load(null);
        this.target.startSynchronizing();
    }

    public void tearDown() throws CoreException {
        this.target.stopSynchronizing();
    }

    public void test_newNonWsProjectNotAdded() throws Exception {
        this.testPrj3 = new TestProject("TestProject3");
        IWebServiceProject wsPrj3 = this.util.findProjectByName(this.target.getDOM(), this.testPrj3.getProject().getName());
        ProjectAddingTests.assertNull((String)"Newly added project in dom", (Object)wsPrj3);
    }

    public void test_NonWsProjectIgnorredWhenClosedOrRemoved() throws CoreException {
        this.testPrj3 = new TestProject("TestProject3");
        this.testPrj3.createSourceFolder("src");
        IPackageFragment pf = this.testPrj3.createPackage("com.sap.test.nonwsproject");
        IType type = this.testPrj3.createType(pf, "SomeClass.java", "public class SomeClass {}");
        IFile file = this.testPrj3.getJavaProject().getJavaModel().getWorkspace().getRoot().getFile(type.getPath());
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.testPrj3.getProject().close(null);
    }

    public void test_openedNonWsProjectNotAdded() throws Exception {
        this.testPrj3 = new TestProject("TestEJBProject3");
        this.testPrj3.getProject().close(null);
        this.testPrj3.getProject().open(null);
        IWebServiceProject wsPrj3 = this.util.findProjectByName(this.target.getDOM(), this.testPrj3.getProject().getName());
        ProjectAddingTests.assertNull((String)"Newly added project not in dom", (Object)wsPrj3);
    }
}

