/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.ParameterSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer.SerializerAdapterTestFixture;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

public class ParameterSerializerAdapterTest
extends SerializerAdapterTestFixture {
    private MyParameterSerializerAdapter adapter;
    private IMethod method;
    private IWebMethod wsMethod;
    private IWebParam webParam;
    private IAnnotationInspector inspector;

    public void setUp() throws Exception {
        super.setUp();
        this.resource.startSynchronizing();
        this.adapter = new MyParameterSerializerAdapter(this.resource);
        this.method = this.seiType.createMethod("public void method(int param1);", null, false, null);
        this.wsMethod = this.domUtil.findWebMethodByImpl(this.sei, this.domUtil.calcImplementation(this.method));
        this.webParam = (IWebParam)this.wsMethod.getParameters().get(0);
        this.adapter.setTarget((Notifier)this.webParam);
        this.resource.disableSaving();
        this.inspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
    }

    public void testGetAnnotationKind() throws Exception {
        this.webParam.setKind(WebParamKind.IN);
        IAnnotation<? extends IJavaElement> annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        this.webParam.setKind(WebParamKind.INOUT);
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        IParamValuePair paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"mode", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertTrue((boolean)"javax.jws.WebParam.Mode.INOUT".endsWith(paramValue.getValue().toString()));
        this.webParam.setKind(WebParamKind.OUT);
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"mode", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertTrue((boolean)"javax.jws.WebParam.Mode.OUT".endsWith(paramValue.getValue().toString()));
    }

    public void testGetAnnotationHeader() throws Exception {
        this.webParam.setHeader(false);
        IAnnotation<? extends IJavaElement> annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        this.webParam.setHeader(true);
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        IParamValuePair paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"header", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertEquals((String)"true", (String)paramValue.getValue().toString());
    }

    public void testGetAnnotationName() throws Exception {
        this.webParam.setName("arg0");
        IAnnotation<? extends IJavaElement> annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        this.webParam.setName("changed");
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        IParamValuePair paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"name", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertEquals((String)"changed", (String)paramValue.getValue().toString());
    }

    public void testGetAnnotationPartName() throws Exception {
        this.wsMethod.setSoapBindingStyle(SOAPBindingStyle.RPC);
        this.webParam.setPartName("arg0");
        IAnnotation<? extends IJavaElement> annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        this.webParam.setPartName("changed");
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        IParamValuePair paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"partName", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertEquals((String)"changed", (String)paramValue.getValue().toString());
    }

    public void testChangeNameChangesPartName() throws Exception {
        this.resource.enableSaving();
        this.webParam.setName("changed");
        IAnnotation annotation = this.inspector.inspectParam(this.method.getTypeParameter(this.webParam.getImplementation()), "javax.jws.WebParam");
        ParameterSerializerAdapterTest.assertNotNull((Object)annotation);
        ParameterSerializerAdapterTest.assertEquals((String)"changed", (String)annotation.getPropertyValue("name"));
        ParameterSerializerAdapterTest.assertEquals(null, (String)annotation.getPropertyValue("partName"));
    }

    public void testChangeNameDoesNotChangePartNameIfPartNameInAnnotation() throws Exception {
        this.method = this.seiType.createMethod("public void method1(@javax.jws.WebParam(name=\"param1\", partName=\"param1Part\") int param1);", null, false, null);
        this.wsMethod = this.testUtil.findWebMethodByName(this.sei, "method1");
        this.webParam = this.testUtil.findParam(this.wsMethod, "param1");
        this.wsMethod.setSoapBindingStyle(SOAPBindingStyle.RPC);
        this.resource.enableSaving();
        this.webParam.setName("test");
        IAnnotation annotation = this.inspector.inspectParam(this.method.getTypeParameter(this.webParam.getImplementation()), "javax.jws.WebParam");
        ParameterSerializerAdapterTest.assertNotNull((Object)annotation);
        ParameterSerializerAdapterTest.assertEquals((String)"param1Part", (String)annotation.getPropertyValue("partName"));
    }

    public void testGetAnnotationTargetNS() throws Exception {
        this.wsMethod.setSoapBindingStyle(SOAPBindingStyle.RPC);
        this.webParam.setTargetNamespace("http://com.sap/test");
        IAnnotation<? extends IJavaElement> annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        this.webParam.setTargetNamespace("http://changed");
        annotation = this.adapter.getAnnotation();
        ParameterSerializerAdapterTest.assertEquals((String)"javax.jws.WebParam", (String)annotation.getAnnotationName());
        ParameterSerializerAdapterTest.assertEquals((int)1, (int)annotation.getParamValuePairs().size());
        IParamValuePair paramValue = (IParamValuePair)annotation.getParamValuePairs().iterator().next();
        ParameterSerializerAdapterTest.assertEquals((String)"targetNamespace", (String)paramValue.getParam());
        ParameterSerializerAdapterTest.assertEquals((String)"http://changed", (String)paramValue.getValue().toString());
    }

    public void testSaveAnnotation() throws Exception {
        this.wsMethod.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        this.webParam.setName("changed");
        this.webParam.setKind(WebParamKind.INOUT);
        this.webParam.setPartName("different");
        this.webParam.setHeader(true);
        this.resource.enableSaving();
        this.webParam.setTargetNamespace("http://changed/terget/ns");
        IAnnotation annotation = this.inspector.inspectParam(this.method.getTypeParameter(this.webParam.getImplementation()), "javax.jws.WebParam");
        ParameterSerializerAdapterTest.assertNotNull((Object)annotation);
        ParameterSerializerAdapterTest.assertEquals((int)4, (int)annotation.getParamValuePairs().size());
        ParameterSerializerAdapterTest.assertEquals((String)"changed", (String)annotation.getPropertyValue("name"));
        ParameterSerializerAdapterTest.assertTrue((boolean)"javax.jws.WebParam.Mode.INOUT".endsWith(annotation.getPropertyValue("mode")));
        ParameterSerializerAdapterTest.assertEquals((String)"http://changed/terget/ns", (String)annotation.getPropertyValue("targetNamespace"));
        this.wsMethod.setSoapBindingStyle(SOAPBindingStyle.RPC);
        this.webParam.setPartName("different");
        this.inspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
        annotation = this.inspector.inspectParam(this.method.getTypeParameter(this.webParam.getImplementation()), "javax.jws.WebParam");
        ParameterSerializerAdapterTest.assertEquals((int)5, (int)annotation.getParamValuePairs().size());
        ParameterSerializerAdapterTest.assertEquals((String)"different", (String)annotation.getPropertyValue("partName"));
    }

    public void testEmptyAnnotationRemoved() throws JavaModelException {
        this.method = this.seiType.createMethod("public void method1(@javax.jws.WebParam(name=\"param1\") int param1);", null, false, null);
        this.wsMethod = this.testUtil.findWebMethodByName(this.sei, "method1");
        this.webParam = this.testUtil.findParam(this.wsMethod, "param1");
        this.resource.enableSaving();
        this.webParam.setName("arg0");
        IAnnotation annotation = this.inspector.inspectParam(this.method.getTypeParameter(this.webParam.getImplementation()), "javax.jws.WebParam");
        ParameterSerializerAdapterTest.assertNull((String)"Empty annotation has not been removed", (Object)annotation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyParameterSerializerAdapter
    extends ParameterSerializerAdapter {
        public MyParameterSerializerAdapter(JaxWsWorkspaceResource resource) {
            super(resource);
        }

        public IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
            return super.getAnnotation();
        }
    }
}

