/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.DomTestUtils;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;

public class SeiMethodSyncronizationTest
extends TestCase {
    private TestProject testPrj1;
    private JaxWsWorkspaceResource target;
    private IJavaModel javaModel;
    private ICompilationUnit sei1CU;
    private ICompilationUnit someIntfCU;
    private IWebServiceProject wsPrj1;
    private IWebService ws1;
    private IServiceEndpointInterface sei1;
    private DomTestUtils testUtil = new DomTestUtils();
    private DomUtil domUtil = new DomUtil();
    private static final String ws1ImplName = "com.sap.test.modelsync1.WS1";
    private static final String sei1ImplName = "com.sap.test.modelsync1.Sei1";

    public void setUp() throws Exception {
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = new JaxWsWorkspaceResource(this.javaModel){

            public boolean approveProject(IJavaProject prj) {
                return prj.getElementName().equals(SeiMethodSyncronizationTest.this.testPrj1.getJavaProject().getElementName());
            }
        };
        this.testPrj1 = new TestProject("TestProject1");
        this.testPrj1.createSourceFolder("src");
        IPackageFragment modelSync1 = this.testPrj1.createPackage("com.sap.test.modelsync1");
        this.someIntfCU = this.testPrj1.createType(modelSync1, "SomeIntf.java", "public interface SomeIntf{\npublic void voidMethodWithNoArgsNoAnnotationInParent();\n}").getCompilationUnit();
        this.testPrj1.createType(modelSync1, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 extends SomeIntf {\npublic void voidMethodWithNoArgsNoAnnotation();\n@javax.jws.WebMethod(operationName=\"webName\", exclude=true) public void voidMethodWithNoArgsWithAnnotation();\n}");
        this.testPrj1.createType(modelSync1, "WS1.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS1 {}");
        JobUtils.waitForJobs();
        this.target.load(null);
        SeiMethodSyncronizationTest.assertEquals((String)"One projects were defined but a different number were found in the DOM", (int)1, (int)this.target.getDOM().getWebServiceProjects().size());
        SeiMethodSyncronizationTest.assertEquals((int)1, (int)((IWebServiceProject)this.target.getDOM().getWebServiceProjects().get(0)).getServiceEndpointInterfaces().size());
        SeiMethodSyncronizationTest.assertEquals((int)1, (int)((IWebServiceProject)this.target.getDOM().getWebServiceProjects().get(0)).getWebServices().size());
        this.wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        SeiMethodSyncronizationTest.assertNotNull((Object)this.wsPrj1);
        this.ws1 = this.domUtil.findWsByImplName(this.wsPrj1, ws1ImplName);
        SeiMethodSyncronizationTest.assertNotNull((Object)this.ws1);
        this.sei1 = this.domUtil.findSeiByImplName(this.wsPrj1, sei1ImplName);
        SeiMethodSyncronizationTest.assertNotNull((Object)this.sei1);
        this.sei1CU = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getCompilationUnit();
    }

    public void test_voidMethodWithNoArgsNoAnnotationSynched() throws JavaModelException {
        IMethod methodElem = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getMethod("voidMethodWithNoArgsNoAnnotation", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(methodElem));
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)methodElem.getElementName(), (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertFalse((boolean)wm.isExcluded());
    }

    public void test_voidMethodWithNoArgsWithAnnotationSynched() throws JavaModelException {
        IMethod methodElem = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getMethod("voidMethodWithNoArgsWithAnnotation", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(methodElem));
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)"webName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
    }

    public void test_webNameChangedSynched() throws JavaModelException {
        IMethod methodElem = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getMethod("voidMethodWithNoArgsWithAnnotation", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(methodElem));
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)"webName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
        this.target.startSynchronizing();
        FileUtils.getInstance().setCompilationUnitContent(this.sei1CU, "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 {\n@javax.jws.WebMethod(operationName=\"webNameNew\", exclude=true) public void voidMethodWithNoArgsWithAnnotation();\n}", false, null);
        JobUtils.waitForJobs();
        SeiMethodSyncronizationTest.assertEquals((String)"webNameNew", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
    }

    public void test_excludedChangedSynched() throws JavaModelException {
        IMethod methodElem = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getMethod("voidMethodWithNoArgsWithAnnotation", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(methodElem));
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)"webName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
        this.target.startSynchronizing();
        FileUtils.getInstance().setCompilationUnitContent(this.sei1CU, "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 {\n@javax.jws.WebMethod(operationName=\"webName\", exclude=false) public void voidMethodWithNoArgsWithAnnotation();\n}", false, null);
        JobUtils.waitForJobs();
        SeiMethodSyncronizationTest.assertEquals((String)"webName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.getParameters().isEmpty());
        SeiMethodSyncronizationTest.assertEquals((String)this.domUtil.calcImplementation(methodElem), (String)wm.getImplementation());
        SeiMethodSyncronizationTest.assertFalse((boolean)wm.isExcluded());
    }

    public void test_deletedMethodSynced() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod methodToDelete = this.testPrj1.getJavaProject().findType(this.sei1.getImplementation()).getMethod("voidMethodWithNoArgsNoAnnotation", new String[0]);
        String methodToDeleteImpl = this.domUtil.calcImplementation(methodToDelete);
        FileUtils.getInstance().setCompilationUnitContent(this.sei1CU, "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 {\n@javax.jws.WebMethod(operationName=\"webName\", exclude=true) public void voidMethodWithNoArgsWithAnnotation();\n}", false, null);
        JobUtils.waitForJobs();
        SeiMethodSyncronizationTest.assertNull((Object)this.domUtil.findWebMethodByImpl(this.sei1, methodToDeleteImpl));
    }

    public void test_overloadedMethodLoadedProperly() throws JavaModelException {
        this.target.startSynchronizing();
        IMethod newMethod = this.sei1CU.findPrimaryType().createMethod("@javax.jws.WebMethod(operationName=\"webName\", exclude=true) public void voidMethodWithNoArgsWithAnnotation(int i);", null, false, null);
        JobUtils.waitForJobs();
        IWebMethod newWebMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(newMethod));
        SeiMethodSyncronizationTest.assertNotNull((Object)newWebMethod);
        IMethod oldMethod = this.sei1CU.findPrimaryType().getMethod("voidMethodWithNoArgsWithAnnotation", new String[0]);
        SeiMethodSyncronizationTest.assertNotSame((Object)newWebMethod, (Object)this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(oldMethod)));
    }

    public void test_MethodsFromSuperTypeLoaded() throws JavaModelException {
        IMethod parentMethod = this.someIntfCU.findPrimaryType().getMethod("voidMethodWithNoArgsNoAnnotationInParent", new String[0]);
        SeiMethodSyncronizationTest.assertNotNull((Object)this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(parentMethod)));
    }

    public void test_OverrideMethodsLoadedProperly() throws JavaModelException {
        this.target.startSynchronizing();
        this.sei1CU.findPrimaryType().createMethod("@javax.jws.WebMethod(operationName=\"webName\", exclude=true) public void voidMethodWithNoArgsNoAnnotationInParent();", null, false, null);
        JobUtils.waitForJobs();
        IMethod overridenMethod = this.sei1CU.findPrimaryType().getMethod("voidMethodWithNoArgsNoAnnotationInParent", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(overridenMethod));
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)"webName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
    }

    public void test_ChangedMethodInParentInterfaceSynched() throws JavaModelException {
        this.target.startSynchronizing();
        this.someIntfCU.getBuffer().save(null, false);
        JobUtils.waitForJobs();
        IMethod parentMethod = this.someIntfCU.findPrimaryType().getMethod("voidMethodWithNoArgsNoAnnotationInParent", new String[0]);
        IWebMethod wm = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(parentMethod));
        SeiMethodSyncronizationTest.assertEquals((String)"voidMethodWithNoArgsNoAnnotationInParent", (String)wm.getName());
        SeiMethodSyncronizationTest.assertFalse((boolean)wm.isExcluded());
        FileUtils.getInstance().setCompilationUnitContent(this.someIntfCU, "public interface SomeIntf{\n@javax.jws.WebMethod(operationName=\"MethodInParentClassWithNewName\", exclude=true) public void voidMethodWithNoArgsNoAnnotationInParent();\n}", false, null);
        JobUtils.waitForJobs();
        SeiMethodSyncronizationTest.assertNotNull((Object)wm);
        SeiMethodSyncronizationTest.assertEquals((String)"MethodInParentClassWithNewName", (String)wm.getName());
        SeiMethodSyncronizationTest.assertTrue((boolean)wm.isExcluded());
    }

    public void test_ChangedSoapBindingSynched() throws Exception {
        this.target.startSynchronizing();
        this.testUtil.setContents(this.sei1CU, "@javax.jws.WebService() public interface Sei1 { public void soapBindingMethod(); }");
        JobUtils.waitForJobs();
        IMethod newMethod = this.sei1CU.findPrimaryType().getMethod("soapBindingMethod", new String[0]);
        IWebMethod newWebMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(newMethod));
        SeiMethodSyncronizationTest.assertNotNull((Object)newWebMethod);
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)newWebMethod.getSoapBindingStyle());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)newWebMethod.getSoapBindingUse());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)newWebMethod.getSoapBindingParameterStyle());
        this.testUtil.setContents(this.sei1CU, "@javax.jws.WebService() public interface Sei1 { \n@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)\npublic void soapBindingMethod(); }");
        JobUtils.waitForJobs();
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)newWebMethod.getSoapBindingStyle());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)newWebMethod.getSoapBindingUse());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)newWebMethod.getSoapBindingParameterStyle());
    }

    public void test_SoapBindingOnSeiSynched() throws Exception {
        this.target.startSynchronizing();
        this.testUtil.setContents(this.sei1CU, "@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)\n@javax.jws.WebService() public interface Sei1 { public void soapBindingMethod(); }");
        JobUtils.waitForJobs();
        IMethod newMethod = this.sei1CU.findPrimaryType().getMethod("soapBindingMethod", new String[0]);
        IWebMethod newWebMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(newMethod));
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)newWebMethod.getSoapBindingStyle());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)newWebMethod.getSoapBindingUse());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)newWebMethod.getSoapBindingParameterStyle());
    }

    public void test_SoapBindingOnSeiOverlappingAnnotationOnMethodSynched() throws Exception {
        this.target.startSynchronizing();
        this.testUtil.setContents(this.sei1CU, "@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)\n@javax.jws.WebService() public interface Sei1 { @javax.jws.soap.SOAPBinding(style=Style.DOCUMENT, use=Use.LITERAL, parameterStyle=ParameterStyle.WRAPPED)public void soapBindingMethod();}");
        JobUtils.waitForJobs();
        IMethod newMethod = this.sei1CU.findPrimaryType().getMethod("soapBindingMethod", new String[0]);
        IWebMethod newWebMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(newMethod));
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)newWebMethod.getSoapBindingStyle());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)newWebMethod.getSoapBindingUse());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)newWebMethod.getSoapBindingParameterStyle());
    }

    public void test_SoapBindingOnSeiWrongOverlappingAnnotationOnMethodSynched() throws Exception {
        this.target.startSynchronizing();
        this.testUtil.setContents(this.sei1CU, "@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)\n@javax.jws.WebService() public interface Sei1 { @javax.jws.soap.SOAPBinding(style=Style.DOCUMENT1, use=Use.LITERAL1, parameterStyle=ParameterStyle.WRAPPED1)public void soapBindingMethod();}");
        JobUtils.waitForJobs();
        IMethod newMethod = this.sei1CU.findPrimaryType().getMethod("soapBindingMethod", new String[0]);
        IWebMethod newWebMethod = this.domUtil.findWebMethodByImpl(this.sei1, this.domUtil.calcImplementation(newMethod));
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)newWebMethod.getSoapBindingStyle());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)newWebMethod.getSoapBindingUse());
        SeiMethodSyncronizationTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)newWebMethod.getSoapBindingParameterStyle());
    }
}

