/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

final class FacetModuleCoreSupportDelegate {
    private static final String SLASH = "/";
    private static final String JST_WEB_MODULE = "jst.web";

    FacetModuleCoreSupportDelegate() {
    }

    static float getDynamicWebProjectVersion(IProject project) {
        if (project == null) {
            return 3.0f;
        }
        float version = 3.0f;
        try {
            IProjectFacet webModuleFacet;
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null && ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_MODULE) && faceted.hasProjectFacet(webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_MODULE))) {
                version = Float.parseFloat(faceted.getInstalledVersion(webModuleFacet).getVersionString());
            }
        }
        catch (NumberFormatException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return version;
    }

    static IPath getRuntimePath(IPath path) {
        if (path == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        if (virtualResources != null && virtualResources.length > 0) {
            return virtualResources[0].getRuntimePath();
        }
        return null;
    }

    static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    static boolean isDynamicWebProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            if (ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_MODULE)) {
                IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
                IProjectFacet webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_MODULE);
                if (faceted != null && faceted.hasProjectFacet(webModuleFacet)) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    static IPath resolve(IPath basePath, String reference) {
        if (reference == null || basePath == null || basePath.segmentCount() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        if (basePath.segmentCount() > 1) {
            IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(basePath);
            IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)baseFile);
            int i = 0;
            while (i < virtualResources.length) {
                IPath baseRuntimePath = virtualResources[i].getRuntimePath();
                Object referenceRuntimePath = null;
                referenceRuntimePath = reference.startsWith(SLASH) ? new Path(reference) : baseRuntimePath.removeLastSegments(1).append(reference);
                IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)referenceRuntimePath);
                if (virtualFile != null && virtualFile.exists()) {
                    IFile[] underlyingFiles = virtualFile.getUnderlyingFiles();
                    int j = 0;
                    while (j < underlyingFiles.length) {
                        if (underlyingFiles[j].getProject().equals((Object)project) && underlyingFiles[j].exists()) {
                            return underlyingFiles[j].getFullPath();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)new Path(reference));
            if (virtualFile != null && virtualFile.exists()) {
                return virtualFile.getUnderlyingFile().getFullPath();
            }
        }
        return null;
    }
}

