/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmConverterTests
extends EclipseLinkOrmContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @Converter");
            }
        });
    }

    public EclipseLinkOrmConverterTests(String name) {
        super(name);
    }

    public void testUpdateConverterClass() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter("eclipseLinkConverter");
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter("customConverter");
        OrmEclipseLinkCustomConverter ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
        converterResource.setClassName("myConvert");
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)converterResource.getClassName());
        converterResource.setClassName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        EclipseLinkCustomConverter javaConverter = (EclipseLinkCustomConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setConverterClass("bar");
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
    }

    public void testModifyConverterClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter("eclipseLinkConverter");
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter("customConverter");
        OrmEclipseLinkCustomConverter ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverter();
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
        ormConverter.setConverterClass("foo");
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)converterResource.getClassName());
        ormConverter.setConverterClass(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter("eclipseLinkConverter");
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter("customConverter");
        OrmEclipseLinkCustomConverter ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        EclipseLinkCustomConverter javaConverter = (EclipseLinkCustomConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter("eclipseLinkConverter");
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter("customConverter");
        OrmEclipseLinkCustomConverter ormConverter = (OrmEclipseLinkCustomConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverter();
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

