/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.eclipselink.core.internal.v2_0.context.orm.OrmEclipseLinkOneToOneMapping2_0;
import org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm.EclipseLink2_0OrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLink2_0OrmOneToOneMappingTests
extends EclipseLink2_0OrmContextModelTestCase {
    public EclipseLink2_0OrmOneToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private void createTestEntityWithOneToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    @PrivateOwned)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("bar");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        resourceOneToOne.setMapsId("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("manyToOne");
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceManyToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("oneToOne");
        resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToOneMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        OrmJoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        OrmJoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.specifiedJoinColumnsSize());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        ormJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormJoinTable.getSpecifiedName());
        javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName(null);
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormJoinTable);
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setPrimaryKeyJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getPrimaryKeyJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEclipseLinkOneToOneMapping2_0 ormOneToOneMapping = (OrmEclipseLinkOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"Address", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)ormOneToOneMapping.getJoinFetch().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormOneToOneMapping.getPrivateOwned().isPrivateOwned());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormOneToOneMapping.getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        OrmEclipseLinkOneToOneMapping2_0 ormOneToOneMapping = (OrmEclipseLinkOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)ormOneToOneMapping.getJoinFetch().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getPrivateOwned().isPrivateOwned());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getOrphanRemoval().isOrphanRemoval());
    }
}

