/* The following code was generated by JFlex 1.4.2 on 10/2/09 2:47 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.css.core.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.css.core.internal.parser.regions.CSSTextRegionFactory;
import org.eclipse.wst.css.core.internal.parserz.CSSRegionContexts;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.2
 * on 10/2/09 2:47 PM from the specification file
 * <tt>D:/dev/workspaces/wtp/org.eclipse.wst.sse.core/DevTimeSupport/SedModel/CSSTokenizer/devel/CSSTokenizer.jflex</tt>
 */
public class CSSTokenizer implements CSSRegionContexts, ICSSTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_SELECTOR_ATTRIBUTE_NAME = 26;
  public static final int ST_IMPORT_DELIMITER = 10;
  public static final int ST_DECLARATION_PRE_VALUE = 38;
  public static final int ST_SELECTOR = 22;
  public static final int ST_CHARSET_DELIMITER = 4;
  public static final int ST_DECLARATION_VALUE = 40;
  public static final int ST_PAGE_PSEUDO_PAGE = 16;
  public static final int ST_IMPORT_URI = 6;
  public static final int ST_SELECTOR_ATTRIBUTE_END = 32;
  public static final int ST_SELECTOR_ATTRIBUTE_OPERATOR = 28;
  public static final int ST_DECLARATION = 34;
  public static final int ST_PAGE_DELIMITER = 18;
  public static final int ST_SELECTOR_ATTRIBUTE_VALUE = 30;
  public static final int ST_MEDIA_MEDIUM = 12;
  public static final int ST_CHARSET_NAME = 2;
  public static final int ST_IMPORT_MEDIUM = 8;
  public static final int ST_DECLARATION_SEPARATOR = 36;
  public static final int ST_FONT_FACE_DELIMITER = 20;
  public static final int ST_MEDIA_DELIMITER = 14;
  public static final int ST_SELECTOR_MODIFIER = 24;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9,  9,  9,  0,  0, 10, 10, 11, 11, 12, 12, 13, 13, 
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\17\1\0\1\4\1\20\22\0\1\6\1\31\1\11"+
    "\1\21\1\16\1\72\1\16\1\5\1\25\1\13\1\35\1\15\1\55"+
    "\1\10\1\14\1\34\12\1\1\62\1\50\1\30\1\67\1\32\1\27"+
    "\1\36\1\43\1\26\1\40\1\57\1\46\1\64\1\61\1\41\1\51"+
    "\2\2\1\24\1\52\1\65\1\54\1\53\1\2\1\23\1\44\1\47"+
    "\1\22\5\2\1\66\1\3\1\71\1\16\1\2\1\16\1\42\1\7"+
    "\1\37\1\56\1\45\1\63\1\61\1\41\1\51\2\2\1\24\1\52"+
    "\1\65\1\54\1\53\1\2\1\23\1\44\1\47\1\22\5\2\1\60"+
    "\1\70\1\33\1\70\1\0\uff80\2";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\1\1\1\2\1\1\1\3\4\1\1\4\1\1"+
    "\1\5\1\1\1\6\1\7\3\1\1\10\3\1\1\11"+
    "\2\1\1\12\1\13\2\1\1\14\1\15\1\16\2\1"+
    "\1\17\1\1\1\3\1\20\1\21\1\22\2\1\1\23"+
    "\1\1\1\24\1\25\4\1\1\26\3\1\1\27\1\30"+
    "\1\31\1\32\4\1\1\33\3\1\1\32\1\1\2\34"+
    "\1\3\1\0\1\2\1\0\1\35\1\0\1\36\10\0"+
    "\1\6\4\0\1\37\4\0\1\40\4\0\1\11\1\0"+
    "\1\13\1\0\1\16\1\0\1\41\1\0\1\22\1\0"+
    "\1\25\2\0\1\25\3\0\1\26\1\0\1\42\3\0"+
    "\1\43\1\0\1\32\1\44\1\32\2\0\1\45\2\0"+
    "\1\31\1\46\2\0\1\32\2\0\1\47\1\2\1\50"+
    "\1\35\1\36\10\0\1\6\1\0\1\37\2\0\1\37"+
    "\2\0\1\40\2\0\1\40\2\0\1\11\1\13\1\16"+
    "\1\22\1\25\1\0\1\25\2\0\1\25\1\0\1\26"+
    "\1\42\1\32\1\0\1\32\1\0\1\45\2\0\1\45"+
    "\1\0\1\46\1\51\1\32\1\0\1\2\1\35\1\36"+
    "\1\52\1\53\10\0\1\6\5\0\1\11\1\13\1\16"+
    "\1\22\1\25\2\0\1\26\1\42\2\32\2\0\1\46"+
    "\1\51\1\0\1\44\1\0\1\2\1\35\1\36\3\0"+
    "\1\54\2\0\1\6\1\0\1\6\10\0\1\55\1\11"+
    "\1\13\1\16\1\22\1\25\2\0\1\26\1\42\2\32"+
    "\2\0\1\46\2\51\5\0\1\56\1\0\1\2\1\35"+
    "\1\36\2\0\1\57\2\0\1\6\6\0\1\55\2\0"+
    "\1\11\1\13\1\16\1\22\1\25\2\0\1\26\1\42"+
    "\2\32\2\0\1\46\2\51\2\0\1\56\3\0\1\2"+
    "\1\35\1\36\1\0\1\60\2\0\1\6\13\0\1\11"+
    "\1\13\1\16\1\22\1\25\2\0\1\26\1\42\2\32"+
    "\2\0\1\46\2\51\10\0\1\35\1\36\1\61\2\0"+
    "\1\6\6\0\1\55\1\0\1\55\2\0\1\42\1\32"+
    "\2\0\1\46\2\51\2\0\1\56\1\0\1\56\6\0"+
    "\1\32\1\51\4\0\1\62\4\0\1\51\3\0\1\63"+
    "\12\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[436];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\73\0\166\0\261\0\354\0\u0127\0\u0162\0\u019d"+
    "\0\u01d8\0\u0213\0\u024e\0\u0289\0\u02c4\0\u02ff\0\u033a\0\u0375"+
    "\0\u03b0\0\u03eb\0\u0426\0\u0461\0\u049c\0\u04d7\0\u0512\0\u054d"+
    "\0\u0588\0\u05c3\0\u05fe\0\u0461\0\u0639\0\u0461\0\u0674\0\u06af"+
    "\0\u0461\0\u06ea\0\u0725\0\u0760\0\u0461\0\u079b\0\u07d6\0\u0811"+
    "\0\u084c\0\u0887\0\u08c2\0\u0461\0\u08fd\0\u0938\0\u0973\0\u0461"+
    "\0\u0461\0\u09ae\0\u09e9\0\u0a24\0\u0461\0\u0a5f\0\u0a9a\0\u0461"+
    "\0\u0461\0\u0ad5\0\u0b10\0\u0b4b\0\u0461\0\u0b86\0\u0461\0\u0bc1"+
    "\0\u0bfc\0\u0c37\0\u0c72\0\u0cad\0\u0ce8\0\u0d23\0\u0d5e\0\u0d99"+
    "\0\u0461\0\u0461\0\u0dd4\0\u0e0f\0\u0e4a\0\u0e85\0\u0ec0\0\u0efb"+
    "\0\u0461\0\u0f36\0\u0f71\0\u0fac\0\u0fe7\0\u1022\0\u0639\0\u0461"+
    "\0\u105d\0\u04d7\0\u1098\0\u10d3\0\u0588\0\u110e\0\u05c3\0\u1149"+
    "\0\u1184\0\u11bf\0\u11fa\0\u1235\0\u1270\0\u12ab\0\u12e6\0\u1321"+
    "\0\u135c\0\u1397\0\u06ea\0\u13d2\0\u0461\0\u0760\0\u140d\0\u079b"+
    "\0\u1448\0\u0461\0\u07d6\0\u1483\0\u14be\0\u0887\0\u14f9\0\u0938"+
    "\0\u1534\0\u09e9\0\u156f\0\u15aa\0\u0461\0\u0b10\0\u15e5\0\u0bfc"+
    "\0\u1620\0\u0c37\0\u165b\0\u0461\0\u0cad\0\u1696\0\u0d23\0\u16d1"+
    "\0\u170c\0\u1747\0\u1782\0\u17bd\0\u0f36\0\u0461\0\u0e4a\0\u17f8"+
    "\0\u0461\0\u1833\0\u0e85\0\u186e\0\u0461\0\u0efb\0\u18a9\0\u18e4"+
    "\0\u0fac\0\u191f\0\u195a\0\u1995\0\u1022\0\u19d0\0\u0461\0\u1a0b"+
    "\0\u0461\0\u1a46\0\u1a81\0\u1abc\0\u1af7\0\u1b32\0\u1b6d\0\u1ba8"+
    "\0\u1be3\0\u1c1e\0\u1c59\0\u1c94\0\u1ccf\0\u06ea\0\u1d0a\0\u1d45"+
    "\0\u0760\0\u1d80\0\u1dbb\0\u079b\0\u1df6\0\u1e31\0\u07d6\0\u1e6c"+
    "\0\u1ea7\0\u1ee2\0\u1f1d\0\u1f58\0\u1f93\0\u1fce\0\u2009\0\u0c37"+
    "\0\u2044\0\u207f\0\u0cad\0\u20ba\0\u20f5\0\u2130\0\u216b\0\u21a6"+
    "\0\u21e1\0\u221c\0\u0e85\0\u2257\0\u2292\0\u0efb\0\u22cd\0\u2308"+
    "\0\u2343\0\u237e\0\u23b9\0\u23f4\0\u242f\0\u246a\0\u0461\0\u0461"+
    "\0\u24a5\0\u24e0\0\u251b\0\u2556\0\u2591\0\u25cc\0\u2607\0\u2642"+
    "\0\u267d\0\u26b8\0\u26f3\0\u272e\0\u2769\0\u27a4\0\u27df\0\u281a"+
    "\0\u2855\0\u2890\0\u28cb\0\u2906\0\u2941\0\u297c\0\u29b7\0\u29f2"+
    "\0\u2a2d\0\u2a68\0\u2aa3\0\u2ade\0\u2b19\0\u2b54\0\u2b8f\0\u2bca"+
    "\0\u2c05\0\u2c40\0\u2c7b\0\u2cb6\0\u2cf1\0\u2d2c\0\u0461\0\u2d67"+
    "\0\u2da2\0\u0461\0\u2ddd\0\u2e18\0\u2e53\0\u2e8e\0\u2ec9\0\u2f04"+
    "\0\u2f3f\0\u2f7a\0\u2fb5\0\u2ff0\0\u0461\0\u302b\0\u3066\0\u30a1"+
    "\0\u30dc\0\u3117\0\u3152\0\u318d\0\u31c8\0\u3203\0\u323e\0\u3279"+
    "\0\u32b4\0\u32ef\0\u332a\0\u3365\0\u33a0\0\u33db\0\u3416\0\u2b8f"+
    "\0\u3451\0\u348c\0\u0461\0\u34c7\0\u3502\0\u353d\0\u3578\0\u35b3"+
    "\0\u35ee\0\u0461\0\u3629\0\u3664\0\u369f\0\u36da\0\u3715\0\u3750"+
    "\0\u378b\0\u37c6\0\u3801\0\u2f3f\0\u383c\0\u3877\0\u38b2\0\u38ed"+
    "\0\u3928\0\u3963\0\u399e\0\u39d9\0\u3a14\0\u3a4f\0\u3a8a\0\u3ac5"+
    "\0\u3b00\0\u3b3b\0\u3b76\0\u3bb1\0\u3bec\0\u3c27\0\u3c62\0\u3c9d"+
    "\0\u33db\0\u3cd8\0\u3d13\0\u3d4e\0\u3d89\0\u3dc4\0\u3dff\0\u3e3a"+
    "\0\u0461\0\u3e75\0\u3eb0\0\u3eeb\0\u3f26\0\u3f61\0\u3f9c\0\u3fd7"+
    "\0\u4012\0\u404d\0\u4088\0\u40c3\0\u40fe\0\u4139\0\u4174\0\u41af"+
    "\0\u41ea\0\u4225\0\u4260\0\u429b\0\u42d6\0\u4311\0\u434c\0\u4387"+
    "\0\u43c2\0\u43fd\0\u4438\0\u4473\0\u44ae\0\u44e9\0\u4524\0\u455f"+
    "\0\u459a\0\u45d5\0\u4610\0\u464b\0\u4686\0\u46c1\0\u46fc\0\u4737"+
    "\0\u4772\0\u0461\0\u47ad\0\u47e8\0\u4823\0\u485e\0\u4899\0\u48d4"+
    "\0\u490f\0\u494a\0\u4985\0\u2fb5\0\u49c0\0\u2ff0\0\u49fb\0\u4a36"+
    "\0\u4a71\0\u4aac\0\u4ae7\0\u4b22\0\u4b5d\0\u4b98\0\u4bd3\0\u4c0e"+
    "\0\u4c49\0\u3451\0\u4c84\0\u348c\0\u4cbf\0\u4cfa\0\u4d35\0\u4d70"+
    "\0\u4dab\0\u4de6\0\u4e21\0\u4e5c\0\u4e97\0\u4ed2\0\u4f0d\0\u4f48"+
    "\0\u0461\0\u4f83\0\u4fbe\0\u4ff9\0\u5034\0\u0461\0\u506f\0\u50aa"+
    "\0\u50e5\0\u0461\0\u5120\0\u515b\0\u5196\0\u51d1\0\u520c\0\u5247"+
    "\0\u5282\0\u52bd\0\u52f8\0\u5333";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[436];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\24\1\25\1\26\1\27\1\24\1\27\1\25\1\30"+
    "\1\24\1\27\1\24\1\31\2\24\2\27\1\32\3\25"+
    "\1\24\1\25\1\24\1\33\2\24\1\34\1\35\1\36"+
    "\1\37\11\25\1\24\4\25\1\24\2\25\1\24\1\25"+
    "\1\40\3\25\1\41\10\24\1\27\1\42\1\27\1\24"+
    "\1\43\1\44\1\27\4\24\2\27\7\24\1\33\2\24"+
    "\1\34\1\35\1\24\1\37\40\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\26\24"+
    "\1\27\1\46\1\27\1\24\1\43\1\47\1\27\4\24"+
    "\2\27\1\24\1\50\5\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\11\24\1\45\24\24\1\51\1\52\1\27"+
    "\1\24\1\27\1\51\1\53\1\24\1\27\4\24\2\27"+
    "\1\24\3\51\1\24\1\51\1\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\51\1\45\4\51\1\24\2\51"+
    "\1\24\1\51\1\24\3\51\11\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\4\24"+
    "\1\54\17\24\1\55\1\56\1\27\1\24\1\27\1\55"+
    "\1\57\1\24\1\27\4\24\2\27\1\24\3\55\1\24"+
    "\1\55\1\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\55\1\24\4\55\1\24\2\55\1\60\1\55\1\24"+
    "\3\55\11\24\1\27\1\24\1\27\1\24\1\43\1\24"+
    "\1\27\4\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\16\24\1\61\2\24\1\60\14\24\1\62"+
    "\1\63\1\27\1\24\1\27\1\62\1\64\1\24\1\27"+
    "\4\24\2\27\1\24\3\62\1\24\1\62\1\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\62\1\24\4\62"+
    "\1\24\2\62\1\65\1\62\1\66\3\62\11\24\1\27"+
    "\1\24\1\27\1\24\1\43\1\24\1\27\4\24\2\27"+
    "\7\24\1\33\2\24\1\34\1\35\1\24\1\37\21\24"+
    "\1\65\16\24\1\67\1\24\1\67\1\24\1\43\1\24"+
    "\1\67\1\24\1\31\1\70\1\24\2\67\1\32\6\24"+
    "\1\33\1\24\1\70\1\34\1\35\1\36\1\37\16\24"+
    "\1\71\2\24\1\65\1\24\1\40\3\24\1\41\6\24"+
    "\1\72\1\73\1\27\1\24\1\27\1\72\1\74\1\24"+
    "\1\27\4\24\2\27\1\24\3\72\1\24\1\72\1\24"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\72\1\24"+
    "\4\72\1\24\2\72\1\24\1\72\1\24\3\72\11\24"+
    "\1\27\1\24\1\27\1\24\1\43\1\24\1\27\4\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\30\24\1\75\1\76\1\77\3\24\1\100\1\101\1\27"+
    "\1\102\1\27\1\100\1\103\1\104\1\27\4\24\2\27"+
    "\1\24\3\100\1\24\1\100\1\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\100\1\24\4\100\1\24\2\100"+
    "\1\24\1\100\1\24\3\100\11\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\32\24\1\77\3\24"+
    "\1\105\1\106\1\27\1\24\1\27\1\105\1\107\1\24"+
    "\1\27\4\24\2\27\1\24\3\105\1\24\1\105\1\24"+
    "\1\33\2\24\1\34\1\35\1\110\1\37\11\105\1\111"+
    "\4\105\1\24\2\105\1\24\1\105\1\24\3\105\11\24"+
    "\1\27\1\24\1\27\1\24\1\43\1\24\1\27\4\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\24\1\111\11\24\1\112\11\24\1\113\1\114\1\115"+
    "\1\27\1\116\1\27\1\114\1\117\1\120\1\27\1\121"+
    "\1\122\1\123\1\24\2\27\1\124\1\125\2\114\1\24"+
    "\1\114\1\24\1\33\1\126\1\24\1\34\1\127\1\24"+
    "\1\37\11\114\1\111\4\114\1\130\2\114\1\24\1\114"+
    "\1\24\3\114\6\24\1\113\1\114\1\115\1\131\1\116"+
    "\1\131\1\114\1\117\1\120\1\131\1\121\1\122\1\123"+
    "\1\24\2\131\1\124\1\125\2\114\1\24\1\114\1\24"+
    "\1\33\1\126\1\24\1\34\1\127\1\24\1\37\11\114"+
    "\1\111\4\114\1\130\2\114\1\24\1\114\1\24\3\114"+
    "\5\24\74\0\2\25\1\132\3\0\2\25\11\0\3\25"+
    "\1\0\1\25\10\0\11\25\1\0\4\25\1\0\2\25"+
    "\1\0\1\25\1\0\3\25\6\0\1\133\2\25\1\0"+
    "\2\25\1\133\2\25\1\0\4\25\2\0\16\25\1\133"+
    "\2\25\1\133\2\25\1\133\10\25\1\133\4\25\1\133"+
    "\7\25\4\0\1\27\1\0\1\27\3\0\1\27\4\0"+
    "\2\27\54\0\1\25\1\132\3\0\1\25\1\134\11\0"+
    "\3\25\1\0\1\25\10\0\11\25\1\0\4\25\1\0"+
    "\2\25\1\0\1\25\1\0\3\25\6\0\2\135\1\136"+
    "\3\0\2\135\11\0\3\135\1\0\1\135\10\0\11\135"+
    "\1\0\4\135\1\0\2\135\1\0\1\135\1\0\3\135"+
    "\6\0\2\137\1\140\3\0\2\137\11\0\3\137\1\0"+
    "\1\137\10\0\11\137\1\0\4\137\1\0\2\137\1\0"+
    "\1\137\1\0\3\137\36\0\1\141\76\0\1\142\74\0"+
    "\2\143\10\0\1\144\1\145\1\146\7\0\2\147\10\0"+
    "\1\150\1\151\3\0\1\150\1\152\11\0\3\150\1\0"+
    "\1\150\10\0\11\150\1\0\4\150\1\0\2\150\1\0"+
    "\1\150\1\0\3\150\6\0\2\153\1\154\1\0\1\155"+
    "\11\153\2\0\52\153\10\0\1\134\63\0\2\156\1\157"+
    "\1\0\4\156\1\155\5\156\2\0\52\156\1\0\2\160"+
    "\1\161\1\0\1\162\11\160\2\0\52\160\1\0\2\163"+
    "\1\164\1\0\4\163\1\162\5\163\2\0\52\163\23\0"+
    "\1\165\50\0\2\51\1\166\3\0\2\51\11\0\3\51"+
    "\1\0\1\51\10\0\11\51\1\0\4\51\1\0\2\51"+
    "\1\0\1\51\1\0\3\51\6\0\1\167\2\51\1\0"+
    "\2\51\1\167\2\51\1\0\4\51\2\0\16\51\1\167"+
    "\2\51\1\167\2\51\1\167\10\51\1\167\4\51\1\167"+
    "\7\51\2\0\1\51\1\166\3\0\1\51\1\134\11\0"+
    "\3\51\1\0\1\51\10\0\11\51\1\0\4\51\1\0"+
    "\2\51\1\0\1\51\1\0\3\51\6\0\2\55\1\170"+
    "\3\0\2\55\11\0\3\55\1\0\1\55\10\0\11\55"+
    "\1\0\4\55\1\0\2\55\1\0\1\55\1\0\3\55"+
    "\6\0\1\171\2\55\1\0\2\55\1\171\2\55\1\0"+
    "\4\55\2\0\16\55\1\171\2\55\1\171\2\55\1\171"+
    "\10\55\1\171\4\55\1\171\7\55\2\0\1\55\1\170"+
    "\3\0\1\55\1\134\11\0\3\55\1\0\1\55\10\0"+
    "\11\55\1\0\4\55\1\0\2\55\1\0\1\55\1\0"+
    "\3\55\6\0\2\62\1\172\3\0\2\62\11\0\3\62"+
    "\1\0\1\62\10\0\11\62\1\0\4\62\1\0\2\62"+
    "\1\0\1\62\1\0\3\62\6\0\1\173\2\62\1\0"+
    "\2\62\1\173\2\62\1\0\4\62\2\0\16\62\1\173"+
    "\2\62\1\173\2\62\1\173\10\62\1\173\4\62\1\173"+
    "\7\62\2\0\1\62\1\172\3\0\1\62\1\134\11\0"+
    "\3\62\1\0\1\62\10\0\11\62\1\0\4\62\1\0"+
    "\2\62\1\0\1\62\1\0\3\62\7\0\1\62\1\172"+
    "\3\0\1\62\1\174\11\0\3\62\1\0\1\62\10\0"+
    "\11\62\1\0\4\62\1\0\2\62\1\0\1\62\1\0"+
    "\3\62\5\0\4\175\1\67\1\175\1\67\3\175\1\67"+
    "\2\175\1\0\1\175\2\67\11\175\1\0\1\175\1\0"+
    "\20\175\1\0\2\175\1\0\12\175\1\0\2\72\1\176"+
    "\3\0\2\72\11\0\3\72\1\0\1\72\10\0\11\72"+
    "\1\0\4\72\1\0\2\72\1\0\1\72\1\0\3\72"+
    "\6\0\1\177\2\72\1\0\2\72\1\177\2\72\1\0"+
    "\4\72\2\0\16\72\1\177\2\72\1\177\2\72\1\177"+
    "\10\72\1\177\4\72\1\177\7\72\2\0\1\72\1\176"+
    "\3\0\1\72\1\134\11\0\3\72\1\0\1\72\10\0"+
    "\11\72\1\0\4\72\1\0\2\72\1\0\1\72\1\0"+
    "\3\72\74\0\1\75\4\0\2\100\1\200\3\0\2\100"+
    "\11\0\3\100\1\0\1\100\10\0\11\100\1\0\4\100"+
    "\1\0\2\100\1\0\1\100\1\0\3\100\6\0\1\201"+
    "\2\100\1\0\2\100\1\201\2\100\1\0\4\100\2\0"+
    "\16\100\1\201\2\100\1\201\2\100\1\201\10\100\1\201"+
    "\4\100\1\201\7\100\1\0\2\202\1\203\1\0\1\204"+
    "\11\202\2\0\52\202\2\0\1\100\1\200\3\0\1\100"+
    "\1\134\11\0\3\100\1\0\1\100\10\0\11\100\1\0"+
    "\4\100\1\0\2\100\1\0\1\100\1\0\3\100\6\0"+
    "\2\205\1\206\1\0\4\205\1\204\5\205\2\0\52\205"+
    "\1\0\2\105\1\207\3\0\2\105\11\0\3\105\1\0"+
    "\1\105\10\0\11\105\1\0\4\105\1\0\2\105\1\0"+
    "\1\105\1\0\3\105\6\0\1\210\2\105\1\0\2\105"+
    "\1\210\2\105\1\0\4\105\2\0\16\105\1\210\2\105"+
    "\1\210\2\105\1\210\10\105\1\210\4\105\1\210\7\105"+
    "\2\0\1\105\1\207\3\0\1\105\1\134\11\0\3\105"+
    "\1\0\1\105\10\0\11\105\1\0\4\105\1\0\2\105"+
    "\1\0\1\105\1\0\3\105\7\0\1\105\1\207\3\0"+
    "\1\105\1\211\11\0\3\105\1\0\1\105\10\0\11\105"+
    "\1\0\4\105\1\0\2\105\1\0\1\105\1\0\3\105"+
    "\6\0\1\113\1\212\1\213\3\0\1\212\1\214\3\0"+
    "\1\215\5\0\3\212\1\0\1\212\10\0\11\212\1\0"+
    "\4\212\1\0\2\212\1\0\1\212\1\0\3\212\4\0"+
    "\1\216\1\0\2\114\1\217\3\0\2\114\3\0\1\220"+
    "\5\0\3\114\1\221\1\114\10\0\11\114\1\0\4\114"+
    "\1\0\2\114\1\0\1\114\1\0\3\114\6\0\1\222"+
    "\2\114\1\0\2\114\1\222\2\114\1\0\4\114\2\0"+
    "\16\114\1\222\2\114\1\222\2\114\1\222\10\114\1\222"+
    "\4\114\1\222\7\114\1\0\2\223\1\224\1\0\1\225"+
    "\11\223\2\0\52\223\1\0\1\113\1\114\1\217\3\0"+
    "\1\114\1\134\3\0\1\215\5\0\3\114\1\0\1\114"+
    "\10\0\11\114\1\0\4\114\1\0\2\114\1\0\1\114"+
    "\1\0\3\114\6\0\2\226\1\227\1\0\4\226\1\225"+
    "\5\226\2\0\52\226\1\0\1\230\72\0\1\113\12\0"+
    "\1\215\57\0\2\231\1\232\3\0\2\231\11\0\3\231"+
    "\1\0\1\231\10\0\11\231\1\0\4\231\1\0\2\231"+
    "\1\0\1\231\1\0\3\231\6\0\2\114\1\217\3\0"+
    "\2\114\3\0\1\220\1\233\4\0\1\114\1\234\1\114"+
    "\1\221\1\114\10\0\11\114\1\0\4\114\1\0\2\114"+
    "\1\0\1\114\1\0\3\114\11\0\1\235\1\0\1\235"+
    "\3\0\1\235\4\0\2\235\30\0\1\236\21\0\4\237"+
    "\1\131\1\237\1\131\3\237\1\131\4\237\2\131\12\237"+
    "\1\0\14\237\1\0\22\237\1\0\1\240\1\25\1\132"+
    "\1\25\1\0\1\25\1\240\1\25\1\0\1\25\4\0"+
    "\2\25\1\0\3\25\1\0\1\25\10\0\1\240\2\25"+
    "\1\240\2\25\1\240\2\25\1\0\4\25\1\0\1\240"+
    "\1\25\1\0\1\25\1\0\1\240\2\25\37\0\1\241"+
    "\41\0\1\242\2\135\1\0\2\135\1\242\2\135\1\0"+
    "\4\135\2\0\16\135\1\242\2\135\1\242\2\135\1\242"+
    "\10\135\1\242\4\135\1\242\7\135\1\0\1\243\2\137"+
    "\1\0\2\137\1\243\2\137\1\0\4\137\2\0\16\137"+
    "\1\243\2\137\1\243\2\137\1\243\10\137\1\243\4\137"+
    "\1\243\7\137\10\0\1\244\62\0\35\142\1\245\35\142"+
    "\41\0\1\246\103\0\1\247\65\0\2\250\66\0\2\251"+
    "\103\0\1\252\17\0\2\150\1\151\3\0\2\150\11\0"+
    "\3\150\1\253\1\150\10\0\11\150\1\0\4\150\1\0"+
    "\2\150\1\0\1\150\1\0\3\150\6\0\1\254\2\150"+
    "\1\0\2\150\1\254\2\150\1\0\4\150\2\0\16\150"+
    "\1\254\2\150\1\254\2\150\1\254\10\150\1\254\4\150"+
    "\1\254\7\150\2\0\1\150\1\151\3\0\1\150\12\0"+
    "\3\150\1\0\1\150\10\0\11\150\1\0\4\150\1\0"+
    "\2\150\1\0\1\150\1\0\3\150\6\0\1\255\1\153"+
    "\1\154\1\153\1\256\1\153\1\255\10\153\1\257\16\153"+
    "\1\255\2\153\1\255\2\153\1\255\10\153\1\255\4\153"+
    "\1\255\7\153\1\0\1\260\1\156\1\157\3\156\1\260"+
    "\1\156\1\261\6\156\1\262\16\156\1\260\2\156\1\260"+
    "\2\156\1\260\10\156\1\260\4\156\1\260\7\156\1\0"+
    "\1\263\1\160\1\161\1\160\1\264\1\160\1\263\10\160"+
    "\1\265\16\160\1\263\2\160\1\263\2\160\1\263\10\160"+
    "\1\263\4\160\1\263\7\160\1\0\1\266\1\163\1\164"+
    "\3\163\1\266\1\163\1\267\6\163\1\270\16\163\1\266"+
    "\2\163\1\266\2\163\1\266\10\163\1\266\4\163\1\266"+
    "\7\163\24\0\1\271\47\0\1\272\1\51\1\166\1\51"+
    "\1\0\1\51\1\272\1\51\1\0\1\51\4\0\2\51"+
    "\1\0\3\51\1\0\1\51\10\0\1\272\2\51\1\272"+
    "\2\51\1\272\2\51\1\0\4\51\1\0\1\272\1\51"+
    "\1\0\1\51\1\0\1\272\2\51\6\0\1\273\1\55"+
    "\1\170\1\55\1\0\1\55\1\273\1\55\1\0\1\55"+
    "\4\0\2\55\1\0\3\55\1\0\1\55\10\0\1\273"+
    "\2\55\1\273\2\55\1\273\2\55\1\0\4\55\1\0"+
    "\1\273\1\55\1\0\1\55\1\0\1\273\2\55\6\0"+
    "\1\274\1\62\1\172\1\62\1\0\1\62\1\274\1\62"+
    "\1\0\1\62\4\0\2\62\1\0\3\62\1\0\1\62"+
    "\10\0\1\274\2\62\1\274\2\62\1\274\2\62\1\0"+
    "\4\62\1\0\1\274\1\62\1\0\1\62\1\0\1\274"+
    "\2\62\7\0\1\62\1\172\3\0\1\62\12\0\3\62"+
    "\1\0\1\62\10\0\11\62\1\0\4\62\1\0\2\62"+
    "\1\0\1\62\1\0\3\62\6\0\1\275\1\72\1\176"+
    "\1\72\1\0\1\72\1\275\1\72\1\0\1\72\4\0"+
    "\2\72\1\0\3\72\1\0\1\72\10\0\1\275\2\72"+
    "\1\275\2\72\1\275\2\72\1\0\4\72\1\0\1\275"+
    "\1\72\1\0\1\72\1\0\1\275\2\72\6\0\1\276"+
    "\1\100\1\200\1\100\1\0\1\100\1\276\1\100\1\0"+
    "\1\100\4\0\2\100\1\0\3\100\1\0\1\100\10\0"+
    "\1\276\2\100\1\276\2\100\1\276\2\100\1\0\4\100"+
    "\1\0\1\276\1\100\1\0\1\100\1\0\1\276\2\100"+
    "\6\0\1\277\1\202\1\203\1\202\1\300\1\202\1\277"+
    "\10\202\1\301\16\202\1\277\2\202\1\277\2\202\1\277"+
    "\10\202\1\277\4\202\1\277\7\202\1\0\1\302\1\205"+
    "\1\206\3\205\1\302\1\205\1\303\6\205\1\304\16\205"+
    "\1\302\2\205\1\302\2\205\1\302\10\205\1\302\4\205"+
    "\1\302\7\205\1\0\1\305\1\105\1\207\1\105\1\0"+
    "\1\105\1\305\1\105\1\0\1\105\4\0\2\105\1\0"+
    "\3\105\1\0\1\105\10\0\1\305\2\105\1\305\2\105"+
    "\1\305\2\105\1\0\4\105\1\0\1\305\1\105\1\0"+
    "\1\105\1\0\1\305\2\105\7\0\1\105\1\207\3\0"+
    "\1\105\12\0\3\105\1\0\1\105\10\0\11\105\1\0"+
    "\4\105\1\0\2\105\1\0\1\105\1\0\3\105\6\0"+
    "\2\212\1\213\3\0\2\212\11\0\3\212\1\0\1\212"+
    "\10\0\11\212\1\0\4\212\1\0\2\212\1\0\1\212"+
    "\1\0\3\212\6\0\1\306\2\212\1\0\2\212\1\306"+
    "\2\212\1\0\4\212\2\0\16\212\1\306\2\212\1\306"+
    "\2\212\1\306\10\212\1\306\4\212\1\306\7\212\2\0"+
    "\1\212\1\213\3\0\1\212\12\0\3\212\1\0\1\212"+
    "\10\0\11\212\1\0\4\212\1\0\2\212\1\0\1\212"+
    "\1\0\3\212\6\0\2\307\1\310\3\0\2\307\11\0"+
    "\3\307\1\0\1\307\10\0\11\307\1\0\4\307\1\0"+
    "\2\307\1\0\1\307\1\0\3\307\6\0\1\311\1\114"+
    "\1\217\1\114\1\0\1\114\1\311\1\114\1\0\1\114"+
    "\1\0\1\220\2\0\2\114\1\0\3\114\1\221\1\114"+
    "\10\0\1\311\2\114\1\311\2\114\1\311\2\114\1\0"+
    "\4\114\1\0\1\311\1\114\1\0\1\114\1\0\1\311"+
    "\2\114\6\0\1\312\1\223\1\224\1\223\1\313\1\223"+
    "\1\312\10\223\1\314\16\223\1\312\2\223\1\312\2\223"+
    "\1\312\10\223\1\312\4\223\1\312\7\223\1\0\1\315"+
    "\1\226\1\227\3\226\1\315\1\226\1\316\6\226\1\317"+
    "\16\226\1\315\2\226\1\315\2\226\1\315\10\226\1\315"+
    "\4\226\1\315\7\226\1\0\1\230\1\212\1\213\3\0"+
    "\1\212\1\214\11\0\3\212\1\0\1\212\10\0\11\212"+
    "\1\0\4\212\1\0\2\212\1\0\1\212\1\0\3\212"+
    "\4\0\1\216\1\0\1\320\2\231\1\0\2\231\1\320"+
    "\2\231\1\0\4\231\2\0\16\231\1\320\2\231\1\320"+
    "\2\231\1\320\10\231\1\320\4\231\1\320\7\231\1\0"+
    "\1\321\5\0\1\321\16\0\2\321\7\0\2\321\1\0"+
    "\2\321\1\0\2\321\7\0\2\321\3\0\2\321\7\0"+
    "\2\114\1\217\3\0\2\114\3\0\1\220\5\0\2\114"+
    "\1\322\1\221\1\114\10\0\11\114\1\0\4\114\1\0"+
    "\2\114\1\0\1\114\1\0\3\114\57\0\1\323\21\0"+
    "\1\324\1\25\1\132\1\25\1\0\1\25\1\324\1\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\1\324\2\25\1\324\2\25\1\324\2\25\1\0"+
    "\4\25\1\0\1\324\1\25\1\0\1\25\1\0\1\324"+
    "\2\25\6\0\1\325\1\135\1\136\1\135\1\0\1\135"+
    "\1\325\1\135\1\0\1\135\4\0\2\135\1\0\3\135"+
    "\1\0\1\135\10\0\1\325\2\135\1\325\2\135\1\325"+
    "\2\135\1\0\4\135\1\0\1\325\1\135\1\0\1\135"+
    "\1\0\1\325\2\135\6\0\1\326\1\137\1\140\1\137"+
    "\1\0\1\137\1\326\1\137\1\0\1\137\4\0\2\137"+
    "\1\0\3\137\1\0\1\137\10\0\1\326\2\137\1\326"+
    "\2\137\1\326\2\137\1\0\4\137\1\0\1\326\1\137"+
    "\1\0\1\137\1\0\1\326\2\137\15\0\1\327\62\0"+
    "\34\142\1\330\1\245\35\142\42\0\2\331\102\0\1\332"+
    "\75\0\2\333\74\0\1\334\76\0\1\335\7\0\1\336"+
    "\1\337\1\253\1\0\1\253\1\336\1\340\1\0\1\253"+
    "\4\0\2\253\1\0\3\336\1\0\1\336\10\0\11\336"+
    "\1\0\4\336\1\0\2\336\1\0\1\336\1\0\3\336"+
    "\6\0\1\341\1\150\1\151\1\150\1\0\1\150\1\341"+
    "\1\150\1\0\1\150\4\0\2\150\1\0\3\150\1\253"+
    "\1\150\10\0\1\341\2\150\1\341\2\150\1\341\2\150"+
    "\1\0\4\150\1\0\1\341\1\150\1\0\1\150\1\0"+
    "\1\341\2\150\6\0\1\342\1\153\1\154\1\153\1\155"+
    "\1\153\1\342\27\153\1\342\2\153\1\342\2\153\1\342"+
    "\10\153\1\342\4\153\1\342\7\153\1\0\2\153\1\154"+
    "\1\0\1\155\12\153\1\0\52\153\1\0\1\343\1\156"+
    "\1\157\3\156\1\343\1\156\1\155\25\156\1\343\2\156"+
    "\1\343\2\156\1\343\10\156\1\343\4\156\1\343\7\156"+
    "\1\0\2\156\1\157\1\0\4\156\1\155\6\156\1\0"+
    "\52\156\1\0\1\344\1\160\1\161\1\160\1\162\1\160"+
    "\1\344\27\160\1\344\2\160\1\344\2\160\1\344\10\160"+
    "\1\344\4\160\1\344\7\160\1\0\2\160\1\161\1\0"+
    "\1\162\12\160\1\0\52\160\1\0\1\345\1\163\1\164"+
    "\3\163\1\345\1\163\1\162\25\163\1\345\2\163\1\345"+
    "\2\163\1\345\10\163\1\345\4\163\1\345\7\163\1\0"+
    "\2\163\1\164\1\0\4\163\1\162\6\163\1\0\52\163"+
    "\25\0\1\346\46\0\1\347\1\51\1\166\1\51\1\0"+
    "\1\51\1\347\1\51\1\0\1\51\4\0\2\51\1\0"+
    "\3\51\1\0\1\51\10\0\1\347\2\51\1\347\2\51"+
    "\1\347\2\51\1\0\4\51\1\0\1\347\1\51\1\0"+
    "\1\51\1\0\1\347\2\51\6\0\1\350\1\55\1\170"+
    "\1\55\1\0\1\55\1\350\1\55\1\0\1\55\4\0"+
    "\2\55\1\0\3\55\1\0\1\55\10\0\1\350\2\55"+
    "\1\350\2\55\1\350\2\55\1\0\4\55\1\0\1\350"+
    "\1\55\1\0\1\55\1\0\1\350\2\55\6\0\1\351"+
    "\1\62\1\172\1\62\1\0\1\62\1\351\1\62\1\0"+
    "\1\62\4\0\2\62\1\0\3\62\1\0\1\62\10\0"+
    "\1\351\2\62\1\351\2\62\1\351\2\62\1\0\4\62"+
    "\1\0\1\351\1\62\1\0\1\62\1\0\1\351\2\62"+
    "\6\0\1\352\1\72\1\176\1\72\1\0\1\72\1\352"+
    "\1\72\1\0\1\72\4\0\2\72\1\0\3\72\1\0"+
    "\1\72\10\0\1\352\2\72\1\352\2\72\1\352\2\72"+
    "\1\0\4\72\1\0\1\352\1\72\1\0\1\72\1\0"+
    "\1\352\2\72\6\0\1\353\1\100\1\200\1\100\1\0"+
    "\1\100\1\353\1\100\1\0\1\100\4\0\2\100\1\0"+
    "\3\100\1\0\1\100\10\0\1\353\2\100\1\353\2\100"+
    "\1\353\2\100\1\0\4\100\1\0\1\353\1\100\1\0"+
    "\1\100\1\0\1\353\2\100\6\0\1\354\1\202\1\203"+
    "\1\202\1\204\1\202\1\354\27\202\1\354\2\202\1\354"+
    "\2\202\1\354\10\202\1\354\4\202\1\354\7\202\1\0"+
    "\2\202\1\203\1\0\1\204\12\202\1\0\52\202\1\0"+
    "\1\355\1\205\1\206\3\205\1\355\1\205\1\204\25\205"+
    "\1\355\2\205\1\355\2\205\1\355\10\205\1\355\4\205"+
    "\1\355\7\205\1\0\2\205\1\206\1\0\4\205\1\204"+
    "\6\205\1\0\52\205\1\0\1\356\1\105\1\207\1\105"+
    "\1\0\1\105\1\356\1\105\1\0\1\105\4\0\2\105"+
    "\1\0\3\105\1\0\1\105\10\0\1\356\2\105\1\356"+
    "\2\105\1\356\2\105\1\0\4\105\1\0\1\356\1\105"+
    "\1\0\1\105\1\0\1\356\2\105\6\0\1\357\1\212"+
    "\1\213\1\212\1\0\1\212\1\357\1\212\1\0\1\212"+
    "\4\0\2\212\1\0\3\212\1\0\1\212\10\0\1\357"+
    "\2\212\1\357\2\212\1\357\2\212\1\0\4\212\1\0"+
    "\1\357\1\212\1\0\1\212\1\0\1\357\2\212\6\0"+
    "\2\307\1\310\3\0\2\307\3\0\1\220\5\0\3\307"+
    "\1\0\1\307\10\0\11\307\1\0\4\307\1\0\2\307"+
    "\1\0\1\307\1\0\3\307\6\0\1\360\2\307\1\0"+
    "\2\307\1\360\2\307\1\0\4\307\2\0\16\307\1\360"+
    "\2\307\1\360\2\307\1\360\10\307\1\360\4\307\1\360"+
    "\7\307\1\0\1\361\1\114\1\217\1\114\1\0\1\114"+
    "\1\361\1\114\1\0\1\114\1\0\1\220\2\0\2\114"+
    "\1\0\3\114\1\221\1\114\10\0\1\361\2\114\1\361"+
    "\2\114\1\361\2\114\1\0\4\114\1\0\1\361\1\114"+
    "\1\0\1\114\1\0\1\361\2\114\6\0\1\362\1\223"+
    "\1\224\1\223\1\225\1\223\1\362\27\223\1\362\2\223"+
    "\1\362\2\223\1\362\10\223\1\362\4\223\1\362\7\223"+
    "\1\0\2\223\1\224\1\0\1\225\12\223\1\0\52\223"+
    "\1\0\1\363\1\226\1\227\3\226\1\363\1\226\1\225"+
    "\25\226\1\363\2\226\1\363\2\226\1\363\10\226\1\363"+
    "\4\226\1\363\7\226\1\0\2\226\1\227\1\0\4\226"+
    "\1\225\6\226\1\0\52\226\1\0\1\364\1\231\1\232"+
    "\1\231\1\0\1\231\1\364\1\231\1\0\1\231\4\0"+
    "\2\231\1\0\3\231\1\0\1\231\10\0\1\364\2\231"+
    "\1\364\2\231\1\364\2\231\1\0\4\231\1\0\1\364"+
    "\1\231\1\0\1\231\1\0\1\364\2\231\6\0\1\365"+
    "\5\0\1\365\1\366\15\0\2\365\7\0\2\365\1\0"+
    "\2\365\1\0\2\365\7\0\2\365\3\0\2\365\7\0"+
    "\2\114\1\217\3\0\2\114\3\0\1\220\5\0\3\114"+
    "\1\367\1\114\10\0\11\114\1\0\4\114\1\0\2\114"+
    "\1\0\1\114\1\0\3\114\60\0\1\370\20\0\1\371"+
    "\1\25\1\132\1\25\1\0\1\25\1\371\1\25\1\0"+
    "\1\25\4\0\2\25\1\0\3\25\1\0\1\25\10\0"+
    "\1\371\2\25\1\371\2\25\1\371\2\25\1\0\4\25"+
    "\1\0\1\371\1\25\1\0\1\25\1\0\1\371\2\25"+
    "\6\0\1\372\1\135\1\136\1\135\1\0\1\135\1\372"+
    "\1\135\1\0\1\135\4\0\2\135\1\0\3\135\1\0"+
    "\1\135\10\0\1\372\2\135\1\372\2\135\1\372\2\135"+
    "\1\0\4\135\1\0\1\372\1\135\1\0\1\135\1\0"+
    "\1\372\2\135\6\0\1\373\1\137\1\140\1\137\1\0"+
    "\1\137\1\373\1\137\1\0\1\137\4\0\2\137\1\0"+
    "\3\137\1\0\1\137\10\0\1\373\2\137\1\373\2\137"+
    "\1\373\2\137\1\0\4\137\1\0\1\373\1\137\1\0"+
    "\1\137\1\0\1\373\2\137\30\0\1\374\123\0\1\375"+
    "\67\0\1\376\66\0\2\377\73\0\1\u0100\24\0\2\336"+
    "\1\337\1\u0101\1\0\1\u0101\2\336\1\0\1\u0101\1\u0102"+
    "\3\0\2\u0101\1\0\3\336\1\0\1\336\10\0\11\336"+
    "\1\0\4\336\1\0\2\336\1\0\1\336\1\0\3\336"+
    "\6\0\1\u0103\2\336\1\0\2\336\1\u0103\2\336\1\0"+
    "\4\336\2\0\16\336\1\u0103\2\336\1\u0103\2\336\1\u0103"+
    "\10\336\1\u0103\4\336\1\u0103\7\336\2\0\1\336\1\337"+
    "\3\0\1\336\12\0\3\336\1\0\1\336\10\0\11\336"+
    "\1\0\4\336\1\0\2\336\1\0\1\336\1\0\3\336"+
    "\6\0\1\u0104\1\150\1\151\1\150\1\0\1\150\1\u0104"+
    "\1\150\1\0\1\150\4\0\2\150\1\0\3\150\1\253"+
    "\1\150\10\0\1\u0104\2\150\1\u0104\2\150\1\u0104\2\150"+
    "\1\0\4\150\1\0\1\u0104\1\150\1\0\1\150\1\0"+
    "\1\u0104\2\150\6\0\1\u0105\1\153\1\154\1\153\1\155"+
    "\1\153\1\u0105\27\153\1\u0105\2\153\1\u0105\2\153\1\u0105"+
    "\10\153\1\u0105\4\153\1\u0105\7\153\1\0\1\u0106\1\156"+
    "\1\157\3\156\1\u0106\1\156\1\155\25\156\1\u0106\2\156"+
    "\1\u0106\2\156\1\u0106\10\156\1\u0106\4\156\1\u0106\7\156"+
    "\1\0\1\u0107\1\160\1\161\1\160\1\162\1\160\1\u0107"+
    "\27\160\1\u0107\2\160\1\u0107\2\160\1\u0107\10\160\1\u0107"+
    "\4\160\1\u0107\7\160\1\0\1\u0108\1\163\1\164\3\163"+
    "\1\u0108\1\163\1\162\25\163\1\u0108\2\163\1\u0108\2\163"+
    "\1\u0108\10\163\1\u0108\4\163\1\u0108\7\163\1\0\2\u0109"+
    "\1\u010a\1\346\1\u010b\1\346\2\u0109\1\u010c\1\346\1\u010d"+
    "\3\u0109\2\346\4\u0109\1\0\45\u0109\1\0\1\u010e\1\51"+
    "\1\166\1\51\1\0\1\51\1\u010e\1\51\1\0\1\51"+
    "\4\0\2\51\1\0\3\51\1\0\1\51\10\0\1\u010e"+
    "\2\51\1\u010e\2\51\1\u010e\2\51\1\0\4\51\1\0"+
    "\1\u010e\1\51\1\0\1\51\1\0\1\u010e\2\51\6\0"+
    "\1\u010f\1\55\1\170\1\55\1\0\1\55\1\u010f\1\55"+
    "\1\0\1\55\4\0\2\55\1\0\3\55\1\0\1\55"+
    "\10\0\1\u010f\2\55\1\u010f\2\55\1\u010f\2\55\1\0"+
    "\4\55\1\0\1\u010f\1\55\1\0\1\55\1\0\1\u010f"+
    "\2\55\6\0\1\u0110\1\62\1\172\1\62\1\0\1\62"+
    "\1\u0110\1\62\1\0\1\62\4\0\2\62\1\0\3\62"+
    "\1\0\1\62\10\0\1\u0110\2\62\1\u0110\2\62\1\u0110"+
    "\2\62\1\0\4\62\1\0\1\u0110\1\62\1\0\1\62"+
    "\1\0\1\u0110\2\62\6\0\1\u0111\1\72\1\176\1\72"+
    "\1\0\1\72\1\u0111\1\72\1\0\1\72\4\0\2\72"+
    "\1\0\3\72\1\0\1\72\10\0\1\u0111\2\72\1\u0111"+
    "\2\72\1\u0111\2\72\1\0\4\72\1\0\1\u0111\1\72"+
    "\1\0\1\72\1\0\1\u0111\2\72\6\0\1\u0112\1\100"+
    "\1\200\1\100\1\0\1\100\1\u0112\1\100\1\0\1\100"+
    "\4\0\2\100\1\0\3\100\1\0\1\100\10\0\1\u0112"+
    "\2\100\1\u0112\2\100\1\u0112\2\100\1\0\4\100\1\0"+
    "\1\u0112\1\100\1\0\1\100\1\0\1\u0112\2\100\6\0"+
    "\1\u0113\1\202\1\203\1\202\1\204\1\202\1\u0113\27\202"+
    "\1\u0113\2\202\1\u0113\2\202\1\u0113\10\202\1\u0113\4\202"+
    "\1\u0113\7\202\1\0\1\u0114\1\205\1\206\3\205\1\u0114"+
    "\1\205\1\204\25\205\1\u0114\2\205\1\u0114\2\205\1\u0114"+
    "\10\205\1\u0114\4\205\1\u0114\7\205\1\0\1\u0115\1\105"+
    "\1\207\1\105\1\0\1\105\1\u0115\1\105\1\0\1\105"+
    "\4\0\2\105\1\0\3\105\1\0\1\105\10\0\1\u0115"+
    "\2\105\1\u0115\2\105\1\u0115\2\105\1\0\4\105\1\0"+
    "\1\u0115\1\105\1\0\1\105\1\0\1\u0115\2\105\6\0"+
    "\1\u0116\1\212\1\213\1\212\1\0\1\212\1\u0116\1\212"+
    "\1\0\1\212\4\0\2\212\1\0\3\212\1\0\1\212"+
    "\10\0\1\u0116\2\212\1\u0116\2\212\1\u0116\2\212\1\0"+
    "\4\212\1\0\1\u0116\1\212\1\0\1\212\1\0\1\u0116"+
    "\2\212\6\0\1\u0117\1\307\1\310\1\307\1\0\1\307"+
    "\1\u0117\1\307\1\0\1\307\1\0\1\220\2\0\2\307"+
    "\1\0\3\307\1\0\1\307\10\0\1\u0117\2\307\1\u0117"+
    "\2\307\1\u0117\2\307\1\0\4\307\1\0\1\u0117\1\307"+
    "\1\0\1\307\1\0\1\u0117\2\307\6\0\1\u0118\1\114"+
    "\1\217\1\114\1\0\1\114\1\u0118\1\114\1\0\1\114"+
    "\1\0\1\220\2\0\2\114\1\0\3\114\1\221\1\114"+
    "\10\0\1\u0118\2\114\1\u0118\2\114\1\u0118\2\114\1\0"+
    "\4\114\1\0\1\u0118\1\114\1\0\1\114\1\0\1\u0118"+
    "\2\114\6\0\1\u0119\1\223\1\224\1\223\1\225\1\223"+
    "\1\u0119\27\223\1\u0119\2\223\1\u0119\2\223\1\u0119\10\223"+
    "\1\u0119\4\223\1\u0119\7\223\1\0\1\u011a\1\226\1\227"+
    "\3\226\1\u011a\1\226\1\225\25\226\1\u011a\2\226\1\u011a"+
    "\2\226\1\u011a\10\226\1\u011a\4\226\1\u011a\7\226\1\0"+
    "\1\u011b\1\231\1\232\1\231\1\0\1\231\1\u011b\1\231"+
    "\1\0\1\231\4\0\2\231\1\0\3\231\1\0\1\231"+
    "\10\0\1\u011b\2\231\1\u011b\2\231\1\u011b\2\231\1\0"+
    "\4\231\1\0\1\u011b\1\231\1\0\1\231\1\0\1\u011b"+
    "\2\231\6\0\1\u011c\5\0\1\u011c\1\366\15\0\2\u011c"+
    "\7\0\2\u011c\1\0\2\u011c\1\0\2\u011c\7\0\2\u011c"+
    "\3\0\2\u011c\7\0\1\u011d\5\0\1\u011d\16\0\2\u011d"+
    "\7\0\2\u011d\1\0\2\u011d\1\0\2\u011d\7\0\2\u011d"+
    "\3\0\2\u011d\7\0\2\u011e\1\u011f\1\u0120\1\u0121\1\u0120"+
    "\2\u011e\1\u0122\1\u0120\1\u0123\3\u011e\2\u0120\4\u011e\1\0"+
    "\45\u011e\54\0\1\u0124\17\0\1\u0125\1\25\1\132\1\25"+
    "\1\0\1\25\1\u0125\1\25\1\0\1\25\4\0\2\25"+
    "\1\0\3\25\1\0\1\25\10\0\1\u0125\2\25\1\u0125"+
    "\2\25\1\u0125\2\25\1\0\4\25\1\0\1\u0125\1\25"+
    "\1\0\1\25\1\0\1\u0125\2\25\6\0\1\u0126\1\135"+
    "\1\136\1\135\1\0\1\135\1\u0126\1\135\1\0\1\135"+
    "\4\0\2\135\1\0\3\135\1\0\1\135\10\0\1\u0126"+
    "\2\135\1\u0126\2\135\1\u0126\2\135\1\0\4\135\1\0"+
    "\1\u0126\1\135\1\0\1\135\1\0\1\u0126\2\135\6\0"+
    "\1\u0127\1\137\1\140\1\137\1\0\1\137\1\u0127\1\137"+
    "\1\0\1\137\4\0\2\137\1\0\3\137\1\0\1\137"+
    "\10\0\1\u0127\2\137\1\u0127\2\137\1\u0127\2\137\1\0"+
    "\4\137\1\0\1\u0127\1\137\1\0\1\137\1\0\1\u0127"+
    "\2\137\51\0\1\u0128\51\0\1\u0129\111\0\2\u012a\37\0"+
    "\1\u012b\66\0\1\u0101\1\0\1\u0101\3\0\1\u0101\1\u0102"+
    "\3\0\2\u0101\53\0\1\u012c\1\336\1\337\1\336\1\0"+
    "\1\336\1\u012c\1\336\1\0\1\336\1\u0102\3\0\2\336"+
    "\1\0\3\336\1\0\1\336\10\0\1\u012c\2\336\1\u012c"+
    "\2\336\1\u012c\2\336\1\0\4\336\1\0\1\u012c\1\336"+
    "\1\0\1\336\1\0\1\u012c\2\336\6\0\1\u012d\1\150"+
    "\1\151\1\150\1\0\1\150\1\u012d\1\150\1\0\1\150"+
    "\4\0\2\150\1\0\3\150\1\253\1\150\10\0\1\u012d"+
    "\2\150\1\u012d\2\150\1\u012d\2\150\1\0\4\150\1\0"+
    "\1\u012d\1\150\1\0\1\150\1\0\1\u012d\2\150\6\0"+
    "\1\u012e\1\153\1\154\1\153\1\155\1\153\1\u012e\27\153"+
    "\1\u012e\2\153\1\u012e\2\153\1\u012e\10\153\1\u012e\4\153"+
    "\1\u012e\7\153\1\0\1\u012f\1\156\1\157\3\156\1\u012f"+
    "\1\156\1\155\25\156\1\u012f\2\156\1\u012f\2\156\1\u012f"+
    "\10\156\1\u012f\4\156\1\u012f\7\156\1\0\1\u0130\1\160"+
    "\1\161\1\160\1\162\1\160\1\u0130\27\160\1\u0130\2\160"+
    "\1\u0130\2\160\1\u0130\10\160\1\u0130\4\160\1\u0130\7\160"+
    "\1\0\1\u0131\1\163\1\164\3\163\1\u0131\1\163\1\162"+
    "\25\163\1\u0131\2\163\1\u0131\2\163\1\u0131\10\163\1\u0131"+
    "\4\163\1\u0131\7\163\1\0\2\u0109\1\u010a\1\u0132\1\0"+
    "\3\u0109\1\0\1\u0132\1\u010d\3\u0109\2\u0132\4\u0109\1\0"+
    "\45\u0109\1\0\1\u0133\1\u0109\1\u010a\1\u0132\2\u0109\1\u0133"+
    "\2\u0109\1\u0132\1\u0134\3\u0109\2\u0132\16\u0109\1\u0133\2\u0109"+
    "\1\u0133\2\u0109\1\u0133\10\u0109\1\u0133\4\u0109\1\u0133\7\u0109"+
    "\1\0\2\u010b\1\u0135\1\0\1\u0132\11\u010b\2\0\52\u010b"+
    "\1\0\2\u010c\1\u0136\1\0\4\u010c\1\u0132\5\u010c\2\0"+
    "\52\u010c\1\0\1\u0137\1\51\1\166\1\51\1\0\1\51"+
    "\1\u0137\1\51\1\0\1\51\4\0\2\51\1\0\3\51"+
    "\1\0\1\51\10\0\1\u0137\2\51\1\u0137\2\51\1\u0137"+
    "\2\51\1\0\4\51\1\0\1\u0137\1\51\1\0\1\51"+
    "\1\0\1\u0137\2\51\6\0\1\u0138\1\55\1\170\1\55"+
    "\1\0\1\55\1\u0138\1\55\1\0\1\55\4\0\2\55"+
    "\1\0\3\55\1\0\1\55\10\0\1\u0138\2\55\1\u0138"+
    "\2\55\1\u0138\2\55\1\0\4\55\1\0\1\u0138\1\55"+
    "\1\0\1\55\1\0\1\u0138\2\55\6\0\1\u0139\1\62"+
    "\1\172\1\62\1\0\1\62\1\u0139\1\62\1\0\1\62"+
    "\4\0\2\62\1\0\3\62\1\0\1\62\10\0\1\u0139"+
    "\2\62\1\u0139\2\62\1\u0139\2\62\1\0\4\62\1\0"+
    "\1\u0139\1\62\1\0\1\62\1\0\1\u0139\2\62\6\0"+
    "\1\u013a\1\72\1\176\1\72\1\0\1\72\1\u013a\1\72"+
    "\1\0\1\72\4\0\2\72\1\0\3\72\1\0\1\72"+
    "\10\0\1\u013a\2\72\1\u013a\2\72\1\u013a\2\72\1\0"+
    "\4\72\1\0\1\u013a\1\72\1\0\1\72\1\0\1\u013a"+
    "\2\72\6\0\1\u013b\1\100\1\200\1\100\1\0\1\100"+
    "\1\u013b\1\100\1\0\1\100\4\0\2\100\1\0\3\100"+
    "\1\0\1\100\10\0\1\u013b\2\100\1\u013b\2\100\1\u013b"+
    "\2\100\1\0\4\100\1\0\1\u013b\1\100\1\0\1\100"+
    "\1\0\1\u013b\2\100\6\0\1\u013c\1\202\1\203\1\202"+
    "\1\204\1\202\1\u013c\27\202\1\u013c\2\202\1\u013c\2\202"+
    "\1\u013c\10\202\1\u013c\4\202\1\u013c\7\202\1\0\1\u013d"+
    "\1\205\1\206\3\205\1\u013d\1\205\1\204\25\205\1\u013d"+
    "\2\205\1\u013d\2\205\1\u013d\10\205\1\u013d\4\205\1\u013d"+
    "\7\205\1\0\1\u013e\1\105\1\207\1\105\1\0\1\105"+
    "\1\u013e\1\105\1\0\1\105\4\0\2\105\1\0\3\105"+
    "\1\0\1\105\10\0\1\u013e\2\105\1\u013e\2\105\1\u013e"+
    "\2\105\1\0\4\105\1\0\1\u013e\1\105\1\0\1\105"+
    "\1\0\1\u013e\2\105\6\0\1\u013f\1\212\1\213\1\212"+
    "\1\0\1\212\1\u013f\1\212\1\0\1\212\4\0\2\212"+
    "\1\0\3\212\1\0\1\212\10\0\1\u013f\2\212\1\u013f"+
    "\2\212\1\u013f\2\212\1\0\4\212\1\0\1\u013f\1\212"+
    "\1\0\1\212\1\0\1\u013f\2\212\6\0\1\u0140\1\307"+
    "\1\310\1\307\1\0\1\307\1\u0140\1\307\1\0\1\307"+
    "\1\0\1\220\2\0\2\307\1\0\3\307\1\0\1\307"+
    "\10\0\1\u0140\2\307\1\u0140\2\307\1\u0140\2\307\1\0"+
    "\4\307\1\0\1\u0140\1\307\1\0\1\307\1\0\1\u0140"+
    "\2\307\6\0\1\u0141\1\114\1\217\1\114\1\0\1\114"+
    "\1\u0141\1\114\1\0\1\114\1\0\1\220\2\0\2\114"+
    "\1\0\3\114\1\221\1\114\10\0\1\u0141\2\114\1\u0141"+
    "\2\114\1\u0141\2\114\1\0\4\114\1\0\1\u0141\1\114"+
    "\1\0\1\114\1\0\1\u0141\2\114\6\0\1\u0142\1\223"+
    "\1\224\1\223\1\225\1\223\1\u0142\27\223\1\u0142\2\223"+
    "\1\u0142\2\223\1\u0142\10\223\1\u0142\4\223\1\u0142\7\223"+
    "\1\0\1\u0143\1\226\1\227\3\226\1\u0143\1\226\1\225"+
    "\25\226\1\u0143\2\226\1\u0143\2\226\1\u0143\10\226\1\u0143"+
    "\4\226\1\u0143\7\226\1\0\1\u0144\1\231\1\232\1\231"+
    "\1\0\1\231\1\u0144\1\231\1\0\1\231\4\0\2\231"+
    "\1\0\3\231\1\0\1\231\10\0\1\u0144\2\231\1\u0144"+
    "\2\231\1\u0144\2\231\1\0\4\231\1\0\1\u0144\1\231"+
    "\1\0\1\231\1\0\1\u0144\2\231\6\0\1\u0145\5\0"+
    "\1\u0145\1\366\15\0\2\u0145\7\0\2\u0145\1\0\2\u0145"+
    "\1\0\2\u0145\7\0\2\u0145\3\0\2\u0145\7\0\1\u0146"+
    "\5\0\1\u0146\16\0\2\u0146\7\0\2\u0146\1\0\2\u0146"+
    "\1\0\2\u0146\7\0\2\u0146\3\0\2\u0146\7\0\2\u011e"+
    "\1\u011f\1\u0147\1\0\3\u011e\1\0\1\u0147\1\u0123\3\u011e"+
    "\2\u0147\4\u011e\1\0\45\u011e\1\0\1\u0148\1\u011e\1\u011f"+
    "\1\u0147\2\u011e\1\u0148\2\u011e\1\u0147\1\u0149\3\u011e\2\u0147"+
    "\16\u011e\1\u0148\2\u011e\1\u0148\2\u011e\1\u0148\10\u011e\1\u0148"+
    "\4\u011e\1\u0148\7\u011e\1\0\2\u0121\1\u014a\1\0\1\u0147"+
    "\11\u0121\2\0\52\u0121\1\0\2\u0122\1\u014b\1\0\4\u0122"+
    "\1\u0147\5\u0122\2\0\52\u0122\23\0\1\u014c\50\0\1\u014d"+
    "\1\25\1\132\1\25\1\0\1\25\1\u014d\1\25\1\0"+
    "\1\25\4\0\2\25\1\0\3\25\1\0\1\25\10\0"+
    "\1\u014d\2\25\1\u014d\2\25\1\u014d\2\25\1\0\4\25"+
    "\1\0\1\u014d\1\25\1\0\1\25\1\0\1\u014d\2\25"+
    "\6\0\1\u014e\1\135\1\136\1\135\1\0\1\135\1\u014e"+
    "\1\135\1\0\1\135\4\0\2\135\1\0\3\135\1\0"+
    "\1\135\10\0\1\u014e\2\135\1\u014e\2\135\1\u014e\2\135"+
    "\1\0\4\135\1\0\1\u014e\1\135\1\0\1\135\1\0"+
    "\1\u014e\2\135\6\0\1\u014f\1\137\1\140\1\137\1\0"+
    "\1\137\1\u014f\1\137\1\0\1\137\4\0\2\137\1\0"+
    "\3\137\1\0\1\137\10\0\1\u014f\2\137\1\u014f\2\137"+
    "\1\u014f\2\137\1\0\4\137\1\0\1\u014f\1\137\1\0"+
    "\1\137\1\0\1\u014f\2\137\52\0\2\u0150\73\0\1\u0151"+
    "\106\0\2\u0152\7\0\1\u0153\1\336\1\337\1\336\1\0"+
    "\1\336\1\u0153\1\336\1\0\1\336\1\u0102\3\0\2\336"+
    "\1\0\3\336\1\0\1\336\10\0\1\u0153\2\336\1\u0153"+
    "\2\336\1\u0153\2\336\1\0\4\336\1\0\1\u0153\1\336"+
    "\1\0\1\336\1\0\1\u0153\2\336\6\0\1\u0154\1\150"+
    "\1\151\1\150\1\0\1\150\1\u0154\1\150\1\0\1\150"+
    "\4\0\2\150\1\0\3\150\1\253\1\150\10\0\1\u0154"+
    "\2\150\1\u0154\2\150\1\u0154\2\150\1\0\4\150\1\0"+
    "\1\u0154\1\150\1\0\1\150\1\0\1\u0154\2\150\6\0"+
    "\1\u0155\1\153\1\154\1\153\1\155\1\153\1\u0155\27\153"+
    "\1\u0155\2\153\1\u0155\2\153\1\u0155\10\153\1\u0155\4\153"+
    "\1\u0155\7\153\1\0\1\u0156\1\156\1\157\3\156\1\u0156"+
    "\1\156\1\155\25\156\1\u0156\2\156\1\u0156\2\156\1\u0156"+
    "\10\156\1\u0156\4\156\1\u0156\7\156\1\0\1\u0157\1\160"+
    "\1\161\1\160\1\162\1\160\1\u0157\27\160\1\u0157\2\160"+
    "\1\u0157\2\160\1\u0157\10\160\1\u0157\4\160\1\u0157\7\160"+
    "\1\0\1\u0158\1\163\1\164\3\163\1\u0158\1\163\1\162"+
    "\25\163\1\u0158\2\163\1\u0158\2\163\1\u0158\10\163\1\u0158"+
    "\4\163\1\u0158\7\163\4\0\1\u0132\1\0\1\u0132\3\0"+
    "\1\u0132\1\u010d\3\0\2\u0132\53\0\1\u0159\1\u0109\1\u010a"+
    "\1\u0109\1\0\1\u0109\1\u0159\1\u0109\1\0\1\u0109\1\u010d"+
    "\11\u0109\1\0\11\u0109\1\u0159\2\u0109\1\u0159\2\u0109\1\u0159"+
    "\10\u0109\1\u0159\4\u0109\1\u0159\7\u0109\1\0\1\u015a\1\u010b"+
    "\1\u0135\1\u010b\1\u015b\1\u010b\1\u015a\10\u010b\1\u015c\16\u010b"+
    "\1\u015a\2\u010b\1\u015a\2\u010b\1\u015a\10\u010b\1\u015a\4\u010b"+
    "\1\u015a\7\u010b\1\0\1\u015d\1\u010c\1\u0136\3\u010c\1\u015d"+
    "\1\u010c\1\u015e\6\u010c\1\u015f\16\u010c\1\u015d\2\u010c\1\u015d"+
    "\2\u010c\1\u015d\10\u010c\1\u015d\4\u010c\1\u015d\7\u010c\1\0"+
    "\1\u0160\1\51\1\166\1\51\1\0\1\51\1\u0160\1\51"+
    "\1\0\1\51\4\0\2\51\1\0\3\51\1\0\1\51"+
    "\10\0\1\u0160\2\51\1\u0160\2\51\1\u0160\2\51\1\0"+
    "\4\51\1\0\1\u0160\1\51\1\0\1\51\1\0\1\u0160"+
    "\2\51\6\0\1\u0161\1\55\1\170\1\55\1\0\1\55"+
    "\1\u0161\1\55\1\0\1\55\4\0\2\55\1\0\3\55"+
    "\1\0\1\55\10\0\1\u0161\2\55\1\u0161\2\55\1\u0161"+
    "\2\55\1\0\4\55\1\0\1\u0161\1\55\1\0\1\55"+
    "\1\0\1\u0161\2\55\6\0\1\u0162\1\62\1\172\1\62"+
    "\1\0\1\62\1\u0162\1\62\1\0\1\62\4\0\2\62"+
    "\1\0\3\62\1\0\1\62\10\0\1\u0162\2\62\1\u0162"+
    "\2\62\1\u0162\2\62\1\0\4\62\1\0\1\u0162\1\62"+
    "\1\0\1\62\1\0\1\u0162\2\62\6\0\1\u0163\1\72"+
    "\1\176\1\72\1\0\1\72\1\u0163\1\72\1\0\1\72"+
    "\4\0\2\72\1\0\3\72\1\0\1\72\10\0\1\u0163"+
    "\2\72\1\u0163\2\72\1\u0163\2\72\1\0\4\72\1\0"+
    "\1\u0163\1\72\1\0\1\72\1\0\1\u0163\2\72\6\0"+
    "\1\u0164\1\100\1\200\1\100\1\0\1\100\1\u0164\1\100"+
    "\1\0\1\100\4\0\2\100\1\0\3\100\1\0\1\100"+
    "\10\0\1\u0164\2\100\1\u0164\2\100\1\u0164\2\100\1\0"+
    "\4\100\1\0\1\u0164\1\100\1\0\1\100\1\0\1\u0164"+
    "\2\100\6\0\1\u0165\1\202\1\203\1\202\1\204\1\202"+
    "\1\u0165\27\202\1\u0165\2\202\1\u0165\2\202\1\u0165\10\202"+
    "\1\u0165\4\202\1\u0165\7\202\1\0\1\u0166\1\205\1\206"+
    "\3\205\1\u0166\1\205\1\204\25\205\1\u0166\2\205\1\u0166"+
    "\2\205\1\u0166\10\205\1\u0166\4\205\1\u0166\7\205\1\0"+
    "\1\u0167\1\105\1\207\1\105\1\0\1\105\1\u0167\1\105"+
    "\1\0\1\105\4\0\2\105\1\0\3\105\1\0\1\105"+
    "\10\0\1\u0167\2\105\1\u0167\2\105\1\u0167\2\105\1\0"+
    "\4\105\1\0\1\u0167\1\105\1\0\1\105\1\0\1\u0167"+
    "\2\105\6\0\1\u0168\1\212\1\213\1\212\1\0\1\212"+
    "\1\u0168\1\212\1\0\1\212\4\0\2\212\1\0\3\212"+
    "\1\0\1\212\10\0\1\u0168\2\212\1\u0168\2\212\1\u0168"+
    "\2\212\1\0\4\212\1\0\1\u0168\1\212\1\0\1\212"+
    "\1\0\1\u0168\2\212\6\0\1\u0169\1\307\1\310\1\307"+
    "\1\0\1\307\1\u0169\1\307\1\0\1\307\1\0\1\220"+
    "\2\0\2\307\1\0\3\307\1\0\1\307\10\0\1\u0169"+
    "\2\307\1\u0169\2\307\1\u0169\2\307\1\0\4\307\1\0"+
    "\1\u0169\1\307\1\0\1\307\1\0\1\u0169\2\307\6\0"+
    "\1\u016a\1\114\1\217\1\114\1\0\1\114\1\u016a\1\114"+
    "\1\0\1\114\1\0\1\220\2\0\2\114\1\0\3\114"+
    "\1\221\1\114\10\0\1\u016a\2\114\1\u016a\2\114\1\u016a"+
    "\2\114\1\0\4\114\1\0\1\u016a\1\114\1\0\1\114"+
    "\1\0\1\u016a\2\114\6\0\1\u016b\1\223\1\224\1\223"+
    "\1\225\1\223\1\u016b\27\223\1\u016b\2\223\1\u016b\2\223"+
    "\1\u016b\10\223\1\u016b\4\223\1\u016b\7\223\1\0\1\u016c"+
    "\1\226\1\227\3\226\1\u016c\1\226\1\225\25\226\1\u016c"+
    "\2\226\1\u016c\2\226\1\u016c\10\226\1\u016c\4\226\1\u016c"+
    "\7\226\1\0\1\u016d\1\231\1\232\1\231\1\0\1\231"+
    "\1\u016d\1\231\1\0\1\231\4\0\2\231\1\0\3\231"+
    "\1\0\1\231\10\0\1\u016d\2\231\1\u016d\2\231\1\u016d"+
    "\2\231\1\0\4\231\1\0\1\u016d\1\231\1\0\1\231"+
    "\1\0\1\u016d\2\231\6\0\1\u016e\5\0\1\u016e\1\366"+
    "\15\0\2\u016e\7\0\2\u016e\1\0\2\u016e\1\0\2\u016e"+
    "\7\0\2\u016e\3\0\2\u016e\7\0\1\u016f\5\0\1\u016f"+
    "\16\0\2\u016f\7\0\2\u016f\1\0\2\u016f\1\0\2\u016f"+
    "\7\0\2\u016f\3\0\2\u016f\12\0\1\u0147\1\0\1\u0147"+
    "\3\0\1\u0147\1\u0123\3\0\2\u0147\53\0\1\u0170\1\u011e"+
    "\1\u011f\1\u011e\1\0\1\u011e\1\u0170\1\u011e\1\0\1\u011e"+
    "\1\u0123\11\u011e\1\0\11\u011e\1\u0170\2\u011e\1\u0170\2\u011e"+
    "\1\u0170\10\u011e\1\u0170\4\u011e\1\u0170\7\u011e\1\0\1\u0171"+
    "\1\u0121\1\u014a\1\u0121\1\u0172\1\u0121\1\u0171\10\u0121\1\u0173"+
    "\16\u0121\1\u0171\2\u0121\1\u0171\2\u0121\1\u0171\10\u0121\1\u0171"+
    "\4\u0121\1\u0171\7\u0121\1\0\1\u0174\1\u0122\1\u014b\3\u0122"+
    "\1\u0174\1\u0122\1\u0175\6\u0122\1\u0176\16\u0122\1\u0174\2\u0122"+
    "\1\u0174\2\u0122\1\u0174\10\u0122\1\u0174\4\u0122\1\u0174\7\u0122"+
    "\47\0\1\u0177\24\0\2\25\1\132\1\25\1\0\3\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\11\25\1\0\4\25\1\0\2\25\1\0\1\25"+
    "\1\0\3\25\6\0\1\u0178\1\135\1\136\1\135\1\0"+
    "\1\135\1\u0178\1\135\1\0\1\135\4\0\2\135\1\0"+
    "\3\135\1\0\1\135\10\0\1\u0178\2\135\1\u0178\2\135"+
    "\1\u0178\2\135\1\0\4\135\1\0\1\u0178\1\135\1\0"+
    "\1\135\1\0\1\u0178\2\135\6\0\1\u0179\1\137\1\140"+
    "\1\137\1\0\1\137\1\u0179\1\137\1\0\1\137\4\0"+
    "\2\137\1\0\3\137\1\0\1\137\10\0\1\u0179\2\137"+
    "\1\u0179\2\137\1\u0179\2\137\1\0\4\137\1\0\1\u0179"+
    "\1\137\1\0\1\137\1\0\1\u0179\2\137\54\0\1\u017a"+
    "\65\0\2\u017b\30\0\1\u017c\1\336\1\337\1\336\1\0"+
    "\1\336\1\u017c\1\336\1\0\1\336\1\u0102\3\0\2\336"+
    "\1\0\3\336\1\0\1\336\10\0\1\u017c\2\336\1\u017c"+
    "\2\336\1\u017c\2\336\1\0\4\336\1\0\1\u017c\1\336"+
    "\1\0\1\336\1\0\1\u017c\2\336\6\0\1\u017d\1\150"+
    "\1\151\1\150\1\0\1\150\1\u017d\1\150\1\0\1\150"+
    "\4\0\2\150\1\0\3\150\1\253\1\150\10\0\1\u017d"+
    "\2\150\1\u017d\2\150\1\u017d\2\150\1\0\4\150\1\0"+
    "\1\u017d\1\150\1\0\1\150\1\0\1\u017d\2\150\6\0"+
    "\1\u017e\1\153\1\154\1\153\1\155\1\153\1\u017e\27\153"+
    "\1\u017e\2\153\1\u017e\2\153\1\u017e\10\153\1\u017e\4\153"+
    "\1\u017e\7\153\1\0\1\u017f\1\156\1\157\3\156\1\u017f"+
    "\1\156\1\155\25\156\1\u017f\2\156\1\u017f\2\156\1\u017f"+
    "\10\156\1\u017f\4\156\1\u017f\7\156\1\0\1\u0180\1\160"+
    "\1\161\1\160\1\162\1\160\1\u0180\27\160\1\u0180\2\160"+
    "\1\u0180\2\160\1\u0180\10\160\1\u0180\4\160\1\u0180\7\160"+
    "\1\0\1\u0181\1\163\1\164\3\163\1\u0181\1\163\1\162"+
    "\25\163\1\u0181\2\163\1\u0181\2\163\1\u0181\10\163\1\u0181"+
    "\4\163\1\u0181\7\163\1\0\1\u0182\1\u0109\1\u010a\1\u0109"+
    "\1\0\1\u0109\1\u0182\1\u0109\1\0\1\u0109\1\u010d\11\u0109"+
    "\1\0\11\u0109\1\u0182\2\u0109\1\u0182\2\u0109\1\u0182\10\u0109"+
    "\1\u0182\4\u0109\1\u0182\7\u0109\1\0\1\u0183\1\u010b\1\u0135"+
    "\1\u010b\1\u0132\1\u010b\1\u0183\27\u010b\1\u0183\2\u010b\1\u0183"+
    "\2\u010b\1\u0183\10\u010b\1\u0183\4\u010b\1\u0183\7\u010b\1\0"+
    "\2\u010b\1\u0135\2\u0132\1\u015b\3\u010b\1\u015b\1\u0184\3\u010b"+
    "\2\u0132\52\u010b\1\0\2\u010b\1\u0135\1\0\1\u0132\12\u010b"+
    "\1\0\52\u010b\1\0\1\u0185\1\u010c\1\u0136\3\u010c\1\u0185"+
    "\1\u010c\1\u0132\25\u010c\1\u0185\2\u010c\1\u0185\2\u010c\1\u0185"+
    "\10\u010c\1\u0185\4\u010c\1\u0185\7\u010c\1\0\2\u010c\1\u0136"+
    "\1\u0132\1\u010c\1\u015e\2\u010c\1\u0132\1\u015e\1\u0186\3\u010c"+
    "\2\u0132\52\u010c\1\0\2\u010c\1\u0136\1\0\4\u010c\1\u0132"+
    "\6\u010c\1\0\52\u010c\1\0\2\51\1\166\1\51\1\0"+
    "\3\51\1\0\1\51\4\0\2\51\1\0\3\51\1\0"+
    "\1\51\10\0\11\51\1\0\4\51\1\0\2\51\1\0"+
    "\1\51\1\0\3\51\6\0\2\55\1\170\1\55\1\0"+
    "\3\55\1\0\1\55\4\0\2\55\1\0\3\55\1\0"+
    "\1\55\10\0\11\55\1\0\4\55\1\0\2\55\1\0"+
    "\1\55\1\0\3\55\6\0\2\62\1\172\1\62\1\0"+
    "\3\62\1\0\1\62\4\0\2\62\1\0\3\62\1\0"+
    "\1\62\10\0\11\62\1\0\4\62\1\0\2\62\1\0"+
    "\1\62\1\0\3\62\6\0\2\72\1\176\1\72\1\0"+
    "\3\72\1\0\1\72\4\0\2\72\1\0\3\72\1\0"+
    "\1\72\10\0\11\72\1\0\4\72\1\0\2\72\1\0"+
    "\1\72\1\0\3\72\6\0\2\100\1\200\1\100\1\0"+
    "\3\100\1\0\1\100\4\0\2\100\1\0\3\100\1\0"+
    "\1\100\10\0\11\100\1\0\4\100\1\0\2\100\1\0"+
    "\1\100\1\0\3\100\6\0\1\u0187\1\202\1\203\1\202"+
    "\1\204\1\202\1\u0187\27\202\1\u0187\2\202\1\u0187\2\202"+
    "\1\u0187\10\202\1\u0187\4\202\1\u0187\7\202\1\0\1\u0188"+
    "\1\205\1\206\3\205\1\u0188\1\205\1\204\25\205\1\u0188"+
    "\2\205\1\u0188\2\205\1\u0188\10\205\1\u0188\4\205\1\u0188"+
    "\7\205\1\0\2\105\1\207\1\105\1\0\3\105\1\0"+
    "\1\105\4\0\2\105\1\0\3\105\1\0\1\105\10\0"+
    "\11\105\1\0\4\105\1\0\2\105\1\0\1\105\1\0"+
    "\3\105\6\0\1\u0189\1\212\1\213\1\212\1\0\1\212"+
    "\1\u0189\1\212\1\0\1\212\4\0\2\212\1\0\3\212"+
    "\1\0\1\212\10\0\1\u0189\2\212\1\u0189\2\212\1\u0189"+
    "\2\212\1\0\4\212\1\0\1\u0189\1\212\1\0\1\212"+
    "\1\0\1\u0189\2\212\6\0\1\u018a\1\307\1\310\1\307"+
    "\1\0\1\307\1\u018a\1\307\1\0\1\307\1\0\1\220"+
    "\2\0\2\307\1\0\3\307\1\0\1\307\10\0\1\u018a"+
    "\2\307\1\u018a\2\307\1\u018a\2\307\1\0\4\307\1\0"+
    "\1\u018a\1\307\1\0\1\307\1\0\1\u018a\2\307\6\0"+
    "\2\114\1\217\1\114\1\0\3\114\1\0\1\114\1\0"+
    "\1\220\2\0\2\114\1\0\3\114\1\221\1\114\10\0"+
    "\11\114\1\0\4\114\1\0\2\114\1\0\1\114\1\0"+
    "\3\114\6\0\1\u018b\1\223\1\224\1\223\1\225\1\223"+
    "\1\u018b\27\223\1\u018b\2\223\1\u018b\2\223\1\u018b\10\223"+
    "\1\u018b\4\223\1\u018b\7\223\1\0\1\u018c\1\226\1\227"+
    "\3\226\1\u018c\1\226\1\225\25\226\1\u018c\2\226\1\u018c"+
    "\2\226\1\u018c\10\226\1\u018c\4\226\1\u018c\7\226\1\0"+
    "\1\u018d\1\231\1\232\1\231\1\0\1\231\1\u018d\1\231"+
    "\1\0\1\231\4\0\2\231\1\0\3\231\1\0\1\231"+
    "\10\0\1\u018d\2\231\1\u018d\2\231\1\u018d\2\231\1\0"+
    "\4\231\1\0\1\u018d\1\231\1\0\1\231\1\0\1\u018d"+
    "\2\231\6\0\1\u018e\5\0\1\u018e\1\366\15\0\2\u018e"+
    "\7\0\2\u018e\1\0\2\u018e\1\0\2\u018e\7\0\2\u018e"+
    "\3\0\2\u018e\7\0\1\u018f\5\0\1\u018f\16\0\2\u018f"+
    "\7\0\2\u018f\1\0\2\u018f\1\0\2\u018f\7\0\2\u018f"+
    "\3\0\2\u018f\7\0\1\u0190\1\u011e\1\u011f\1\u011e\1\0"+
    "\1\u011e\1\u0190\1\u011e\1\0\1\u011e\1\u0123\11\u011e\1\0"+
    "\11\u011e\1\u0190\2\u011e\1\u0190\2\u011e\1\u0190\10\u011e\1\u0190"+
    "\4\u011e\1\u0190\7\u011e\1\0\1\u0191\1\u0121\1\u014a\1\u0121"+
    "\1\u0147\1\u0121\1\u0191\27\u0121\1\u0191\2\u0121\1\u0191\2\u0121"+
    "\1\u0191\10\u0121\1\u0191\4\u0121\1\u0191\7\u0121\1\0\2\u0121"+
    "\1\u014a\2\u0147\1\u0172\3\u0121\1\u0172\1\u0192\3\u0121\2\u0147"+
    "\52\u0121\1\0\2\u0121\1\u014a\1\0\1\u0147\12\u0121\1\0"+
    "\52\u0121\1\0\1\u0193\1\u0122\1\u014b\3\u0122\1\u0193\1\u0122"+
    "\1\u0147\25\u0122\1\u0193\2\u0122\1\u0193\2\u0122\1\u0193\10\u0122"+
    "\1\u0193\4\u0122\1\u0193\7\u0122\1\0\2\u0122\1\u014b\1\u0147"+
    "\1\u0122\1\u0175\2\u0122\1\u0147\1\u0175\1\u0194\3\u0122\2\u0147"+
    "\52\u0122\1\0\2\u0122\1\u014b\1\0\4\u0122\1\u0147\6\u0122"+
    "\1\0\52\u0122\42\0\2\u0195\30\0\2\135\1\136\1\135"+
    "\1\0\3\135\1\0\1\135\4\0\2\135\1\0\3\135"+
    "\1\0\1\135\10\0\11\135\1\0\4\135\1\0\2\135"+
    "\1\0\1\135\1\0\3\135\6\0\2\137\1\140\1\137"+
    "\1\0\3\137\1\0\1\137\4\0\2\137\1\0\3\137"+
    "\1\0\1\137\10\0\11\137\1\0\4\137\1\0\2\137"+
    "\1\0\1\137\1\0\3\137\44\0\2\u0196\33\0\1\u0197"+
    "\1\336\1\337\1\336\1\0\1\336\1\u0197\1\336\1\0"+
    "\1\336\1\u0102\3\0\2\336\1\0\3\336\1\0\1\336"+
    "\10\0\1\u0197\2\336\1\u0197\2\336\1\u0197\2\336\1\0"+
    "\4\336\1\0\1\u0197\1\336\1\0\1\336\1\0\1\u0197"+
    "\2\336\6\0\2\150\1\151\1\150\1\0\3\150\1\0"+
    "\1\150\4\0\2\150\1\0\3\150\1\253\1\150\10\0"+
    "\11\150\1\0\4\150\1\0\2\150\1\0\1\150\1\0"+
    "\3\150\6\0\2\153\1\154\1\153\1\155\65\153\1\0"+
    "\2\156\1\157\5\156\1\155\61\156\1\0\2\160\1\161"+
    "\1\160\1\162\65\160\1\0\2\163\1\164\5\163\1\162"+
    "\61\163\1\0\1\u0198\1\u0109\1\u010a\1\u0109\1\0\1\u0109"+
    "\1\u0198\1\u0109\1\0\1\u0109\1\u010d\11\u0109\1\0\11\u0109"+
    "\1\u0198\2\u0109\1\u0198\2\u0109\1\u0198\10\u0109\1\u0198\4\u0109"+
    "\1\u0198\7\u0109\1\0\1\u0199\1\u010b\1\u0135\1\u010b\1\u0132"+
    "\1\u010b\1\u0199\27\u010b\1\u0199\2\u010b\1\u0199\2\u010b\1\u0199"+
    "\10\u010b\1\u0199\4\u010b\1\u0199\7\u010b\1\0\1\u019a\1\u010c"+
    "\1\u0136\3\u010c\1\u019a\1\u010c\1\u0132\25\u010c\1\u019a\2\u010c"+
    "\1\u019a\2\u010c\1\u019a\10\u010c\1\u019a\4\u010c\1\u019a\7\u010c"+
    "\1\0\2\202\1\203\1\202\1\204\65\202\1\0\2\205"+
    "\1\206\5\205\1\204\61\205\1\0\2\212\1\213\1\212"+
    "\1\0\3\212\1\0\1\212\4\0\2\212\1\0\3\212"+
    "\1\0\1\212\10\0\11\212\1\0\4\212\1\0\2\212"+
    "\1\0\1\212\1\0\3\212\6\0\1\u019b\1\307\1\310"+
    "\1\307\1\0\1\307\1\u019b\1\307\1\0\1\307\1\0"+
    "\1\220\2\0\2\307\1\0\3\307\1\0\1\307\10\0"+
    "\1\u019b\2\307\1\u019b\2\307\1\u019b\2\307\1\0\4\307"+
    "\1\0\1\u019b\1\307\1\0\1\307\1\0\1\u019b\2\307"+
    "\6\0\2\223\1\224\1\223\1\225\65\223\1\0\2\226"+
    "\1\227\5\226\1\225\61\226\1\0\2\231\1\232\1\231"+
    "\1\0\3\231\1\0\1\231\4\0\2\231\1\0\3\231"+
    "\1\0\1\231\10\0\11\231\1\0\4\231\1\0\2\231"+
    "\1\0\1\231\1\0\3\231\15\0\1\366\63\0\1\u019c"+
    "\5\0\1\u019c\16\0\2\u019c\7\0\2\u019c\1\0\2\u019c"+
    "\1\0\2\u019c\7\0\2\u019c\3\0\2\u019c\7\0\1\u019d"+
    "\1\u011e\1\u011f\1\u011e\1\0\1\u011e\1\u019d\1\u011e\1\0"+
    "\1\u011e\1\u0123\11\u011e\1\0\11\u011e\1\u019d\2\u011e\1\u019d"+
    "\2\u011e\1\u019d\10\u011e\1\u019d\4\u011e\1\u019d\7\u011e\1\0"+
    "\1\u019e\1\u0121\1\u014a\1\u0121\1\u0147\1\u0121\1\u019e\27\u0121"+
    "\1\u019e\2\u0121\1\u019e\2\u0121\1\u019e\10\u0121\1\u019e\4\u0121"+
    "\1\u019e\7\u0121\1\0\1\u019f\1\u0122\1\u014b\3\u0122\1\u019f"+
    "\1\u0122\1\u0147\25\u0122\1\u019f\2\u0122\1\u019f\2\u0122\1\u019f"+
    "\10\u0122\1\u019f\4\u0122\1\u019f\7\u0122\65\0\1\u01a0\52\0"+
    "\2\u01a1\25\0\1\u01a2\1\336\1\337\1\336\1\0\1\336"+
    "\1\u01a2\1\336\1\0\1\336\1\u0102\3\0\2\336\1\0"+
    "\3\336\1\0\1\336\10\0\1\u01a2\2\336\1\u01a2\2\336"+
    "\1\u01a2\2\336\1\0\4\336\1\0\1\u01a2\1\336\1\0"+
    "\1\336\1\0\1\u01a2\2\336\6\0\1\u01a3\1\u0109\1\u010a"+
    "\1\u0109\1\0\1\u0109\1\u01a3\1\u0109\1\0\1\u0109\1\u010d"+
    "\11\u0109\1\0\11\u0109\1\u01a3\2\u0109\1\u01a3\2\u0109\1\u01a3"+
    "\10\u0109\1\u01a3\4\u0109\1\u01a3\7\u0109\1\0\1\u01a4\1\u010b"+
    "\1\u0135\1\u010b\1\u0132\1\u010b\1\u01a4\27\u010b\1\u01a4\2\u010b"+
    "\1\u01a4\2\u010b\1\u01a4\10\u010b\1\u01a4\4\u010b\1\u01a4\7\u010b"+
    "\1\0\1\u01a5\1\u010c\1\u0136\3\u010c\1\u01a5\1\u010c\1\u0132"+
    "\25\u010c\1\u01a5\2\u010c\1\u01a5\2\u010c\1\u01a5\10\u010c\1\u01a5"+
    "\4\u010c\1\u01a5\7\u010c\1\0\2\307\1\310\1\307\1\0"+
    "\3\307\1\0\1\307\1\0\1\220\2\0\2\307\1\0"+
    "\3\307\1\0\1\307\10\0\11\307\1\0\4\307\1\0"+
    "\2\307\1\0\1\307\1\0\3\307\6\0\1\u01a6\5\0"+
    "\1\u01a6\16\0\2\u01a6\7\0\2\u01a6\1\0\2\u01a6\1\0"+
    "\2\u01a6\7\0\2\u01a6\3\0\2\u01a6\7\0\1\u01a7\1\u011e"+
    "\1\u011f\1\u011e\1\0\1\u011e\1\u01a7\1\u011e\1\0\1\u011e"+
    "\1\u0123\11\u011e\1\0\11\u011e\1\u01a7\2\u011e\1\u01a7\2\u011e"+
    "\1\u01a7\10\u011e\1\u01a7\4\u011e\1\u01a7\7\u011e\1\0\1\u01a8"+
    "\1\u0121\1\u014a\1\u0121\1\u0147\1\u0121\1\u01a8\27\u0121\1\u01a8"+
    "\2\u0121\1\u01a8\2\u0121\1\u01a8\10\u0121\1\u01a8\4\u0121\1\u01a8"+
    "\7\u0121\1\0\1\u01a9\1\u0122\1\u014b\3\u0122\1\u01a9\1\u0122"+
    "\1\u0147\25\u0122\1\u01a9\2\u0122\1\u01a9\2\u0122\1\u01a9\10\u0122"+
    "\1\u01a9\4\u0122\1\u01a9\7\u0122\47\0\1\u01aa\24\0\2\336"+
    "\1\337\1\336\1\0\3\336\1\0\1\336\1\u0102\3\0"+
    "\2\336\1\0\3\336\1\0\1\336\10\0\11\336\1\0"+
    "\4\336\1\0\2\336\1\0\1\336\1\0\3\336\6\0"+
    "\1\u01ab\1\u0109\1\u010a\1\u0109\1\0\1\u0109\1\u01ab\1\u0109"+
    "\1\0\1\u0109\1\u010d\11\u0109\1\0\11\u0109\1\u01ab\2\u0109"+
    "\1\u01ab\2\u0109\1\u01ab\10\u0109\1\u01ab\4\u0109\1\u01ab\7\u0109"+
    "\1\0\1\u01ac\1\u010b\1\u0135\1\u010b\1\u0132\1\u010b\1\u01ac"+
    "\27\u010b\1\u01ac\2\u010b\1\u01ac\2\u010b\1\u01ac\10\u010b\1\u01ac"+
    "\4\u010b\1\u01ac\7\u010b\1\0\1\u01ad\1\u010c\1\u0136\3\u010c"+
    "\1\u01ad\1\u010c\1\u0132\25\u010c\1\u01ad\2\u010c\1\u01ad\2\u010c"+
    "\1\u01ad\10\u010c\1\u01ad\4\u010c\1\u01ad\7\u010c\1\0\1\u01ae"+
    "\1\u011e\1\u011f\1\u011e\1\0\1\u011e\1\u01ae\1\u011e\1\0"+
    "\1\u011e\1\u0123\11\u011e\1\0\11\u011e\1\u01ae\2\u011e\1\u01ae"+
    "\2\u011e\1\u01ae\10\u011e\1\u01ae\4\u011e\1\u01ae\7\u011e\1\0"+
    "\1\u01af\1\u0121\1\u014a\1\u0121\1\u0147\1\u0121\1\u01af\27\u0121"+
    "\1\u01af\2\u0121\1\u01af\2\u0121\1\u01af\10\u0121\1\u01af\4\u0121"+
    "\1\u01af\7\u0121\1\0\1\u01b0\1\u0122\1\u014b\3\u0122\1\u01b0"+
    "\1\u0122\1\u0147\25\u0122\1\u01b0\2\u0122\1\u01b0\2\u0122\1\u01b0"+
    "\10\u0122\1\u01b0\4\u0122\1\u01b0\7\u0122\1\0\2\u0109\1\u010a"+
    "\1\u0109\1\0\3\u0109\1\0\1\u0109\1\u010d\11\u0109\1\0"+
    "\45\u0109\1\0\1\u01b1\1\u010b\1\u0135\1\u010b\1\u0132\1\u010b"+
    "\1\u01b1\27\u010b\1\u01b1\2\u010b\1\u01b1\2\u010b\1\u01b1\10\u010b"+
    "\1\u01b1\4\u010b\1\u01b1\7\u010b\1\0\1\u01b2\1\u010c\1\u0136"+
    "\3\u010c\1\u01b2\1\u010c\1\u0132\25\u010c\1\u01b2\2\u010c\1\u01b2"+
    "\2\u010c\1\u01b2\10\u010c\1\u01b2\4\u010c\1\u01b2\7\u010c\1\0"+
    "\2\u011e\1\u011f\1\u011e\1\0\3\u011e\1\0\1\u011e\1\u0123"+
    "\11\u011e\1\0\45\u011e\1\0\1\u01b3\1\u0121\1\u014a\1\u0121"+
    "\1\u0147\1\u0121\1\u01b3\27\u0121\1\u01b3\2\u0121\1\u01b3\2\u0121"+
    "\1\u01b3\10\u0121\1\u01b3\4\u0121\1\u01b3\7\u0121\1\0\1\u01b4"+
    "\1\u0122\1\u014b\3\u0122\1\u01b4\1\u0122\1\u0147\25\u0122\1\u01b4"+
    "\2\u0122\1\u01b4\2\u0122\1\u01b4\10\u0122\1\u01b4\4\u0122\1\u01b4"+
    "\7\u0122\1\0\2\u010b\1\u0135\1\u010b\1\u0132\65\u010b\1\0"+
    "\2\u010c\1\u0136\5\u010c\1\u0132\61\u010c\1\0\2\u0121\1\u014a"+
    "\1\u0121\1\u0147\65\u0121\1\0\2\u0122\1\u014b\5\u0122\1\u0147"+
    "\61\u0122";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21358];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\11\7\1\1\11\1\1\1\11\2\1\1\11"+
    "\3\1\1\11\6\1\1\11\3\1\2\11\3\1\1\11"+
    "\2\1\2\11\3\1\1\11\1\1\1\11\11\1\2\11"+
    "\6\1\1\11\6\1\1\11\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\10\0\1\1\4\0\1\11\4\0"+
    "\1\11\4\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\1\11\1\0\1\1\1\0\1\1\2\0\1\11\3\0"+
    "\1\1\1\0\1\1\3\0\1\11\1\0\1\1\1\11"+
    "\1\1\2\0\1\11\2\0\2\1\2\0\1\1\2\0"+
    "\1\11\1\1\1\11\2\1\10\0\1\1\1\0\1\1"+
    "\2\0\1\1\2\0\1\1\2\0\1\1\2\0\5\1"+
    "\1\0\1\1\2\0\1\1\1\0\3\1\1\0\1\1"+
    "\1\0\1\1\2\0\1\1\1\0\3\1\1\0\3\1"+
    "\2\11\10\0\1\1\5\0\5\1\2\0\4\1\2\0"+
    "\2\1\1\0\1\1\1\0\3\1\3\0\1\11\2\0"+
    "\1\11\1\0\1\1\10\0\1\11\5\1\2\0\4\1"+
    "\2\0\3\1\5\0\1\11\1\0\3\1\2\0\1\11"+
    "\2\0\1\1\6\0\1\1\2\0\5\1\2\0\4\1"+
    "\2\0\3\1\2\0\1\1\3\0\3\1\1\0\1\11"+
    "\2\0\1\1\13\0\5\1\2\0\4\1\2\0\3\1"+
    "\10\0\2\1\1\11\2\0\1\1\6\0\1\1\1\0"+
    "\1\1\2\0\2\1\2\0\3\1\2\0\1\1\1\0"+
    "\1\1\6\0\2\1\4\0\1\11\4\0\1\11\3\0"+
    "\1\11\12\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[436];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	private final static String UNDEFINED = "undefined";
	private String fBufferedContext = null;
	private int fBufferedStart;
//	private int fBufferedTextLength;
	private int fBufferedLength;
//	private StringBuffer fBufferedText = null;
	private CSSTextRegionFactory fRegionFactory = CSSTextRegionFactory.getInstance();
	private int fInitialState = YYINITIAL;
	public final static int BUFFER_SIZE_NORMAL = 16384;
	public final static int BUFFER_SIZE_SMALL = 256;
	private int fInitialBufferSize = BUFFER_SIZE_NORMAL;

	public void setInitialState(int state) {
		fInitialState = state;
	}
	
	public void setInitialBufferSize(int size) {
		fInitialBufferSize = size;
	}

	/* user method */
  	public final ITextRegion getNextToken() throws IOException {
		String context;
		String nextTokenType;
		boolean spaceFollows;
//		StringBuffer text;
		int start;
		int textLength;
		int length;
		if (fBufferedContext != null) {
			context = fBufferedContext;
//			text = fBufferedText;
			start = fBufferedStart;
			textLength = length = fBufferedLength;

			fBufferedContext = null;
		} else {
			context = primGetNextToken();
//			text = new StringBuffer(yytext());
			start = yychar;
			textLength = length = yylength();
		}

		if (context != null) {
			if (context == UNDEFINED) {
				// undef -> concatenate undef's
				nextTokenType = primGetNextToken();
				while (nextTokenType == UNDEFINED) {
//					text.append(yytext());
					textLength += yylength();
					length = textLength;
					nextTokenType = primGetNextToken();
				}
				fBufferedContext = nextTokenType;
//				fBufferedText = new StringBuffer(yytext());
				fBufferedStart = yychar;
				fBufferedLength = yylength();
			} else {
				nextTokenType = null;
				spaceFollows = false;
				if (CSSRegionUtil.isDeclarationValueType(context)) { // declaration value can contain VALUE_S
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_DECLARATION_VALUE_S);
				} else if (canContainSpace(context)) {
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_S);
				}
				if (nextTokenType != null) { // nextToken is retrieved
					if (spaceFollows) {
						// next is space -> append
//						text.append(yytext());
						length += yylength();
					} else {
						// next is NOT space -> push this for next time, return itself
						fBufferedContext = nextTokenType;
//						fBufferedText = new StringBuffer(yytext());
						fBufferedStart = yychar;
						fBufferedLength = yylength();
					}
				}
			}
		}

		if (context != null) {
			if (context == UNDEFINED) {
				context = CSS_UNKNOWN;
			}
			return fRegionFactory.createRegion(context, start, textLength, length);
		} else {
			return null;
		}
  	}

	/* user method */
	/* for standalone use */
  	public final List parseText() throws IOException {
  		List tokens = new ArrayList();

  		CSSTextToken token;
		for (String kind = primGetNextToken(); kind != null; kind = primGetNextToken()) {
			token = new CSSTextToken();
			token.kind = kind;  				
			token.start = yychar;
			token.length = yylength();
			token.image = yytext();
			tokens.add(token);
		}

  		return tokens;
  	}
  	
  	/* user method */
  	private boolean canContainSpace(String type) {
  		if (type == CSS_DELIMITER || type == CSS_RBRACE || type == CSS_DECLARATION_DELIMITER) {
  			return false;
  		} else {
  			return true;
  		}
  	}

	/* user method */
	public final int getOffset() {
		return yychar;
	}
	
	/* user method */
	public final boolean isEOF() {
		return zzAtEOF;
	}

	/* user method */
	public void reset(char[] charArray) {
		reset(new CharArrayReader(charArray), 0);
	}

	/* user method */
	public final void reset(java.io.Reader in, int newOffset) {
		/** the input device */
		zzReader = in;

		/** the current state of the DFA */
		zzState = 0;

		/** the current lexical state */
		zzLexicalState = fInitialState; //YYINITIAL;

		/** this buffer contains the current text to be matched and is
			the source of the yytext() string */
		if (zzBuffer.length != fInitialBufferSize) {
			zzBuffer = new char[fInitialBufferSize];
		}
		java.util.Arrays.fill(zzBuffer, (char)0);

		/** the textposition at the last accepting state */
		zzMarkedPos = 0;

		/** the textposition at the last state to be included in yytext */
//		yy_pushbackPos = 0;

		/** the current text position in the buffer */
		zzCurrentPos = 0;

		/** startRead marks the beginning of the yytext() string in the buffer */
		zzStartRead = 0;

		/** endRead marks the last character in the buffer, that has been read
			from input */
		zzEndRead = 0;

		/** number of newlines encountered up to the start of the matched text */
		yyline = 0;

		/** the number of characters up to the start of the matched text */
		yychar = 0;

		/**
		 * the number of characters from the last newline up to the start of the 
		 * matched text
		 */
//		yycolumn = 0; 

		/** 
		 * yy_atBOL == true <=> the scanner is currently at the beginning of a line
		 */
//		yy_atBOL = false;
		
		/** zzAtEOF == true <=> the scanner has returned a value for EOF */
		zzAtEOF = false;

		/* user variables */
		//		fUndefined.delete(0, fUndefined.length());
	}

	/* user method */
	public CSSTokenizer() {
		super();
	}

	/**
	 * Added to workaround stricter compilation options without creating
	 * an alternate skeleton file
	 */
	void _usePrivates() {
		System.out.print(yycolumn);
		System.out.print(yyline);
		System.out.print(Boolean.toString(zzAtBOL));
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 32: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_STRING;
          }
        case 52: break;
        case 34: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_DIMENSION;
          }
        case 53: break;
        case 39: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return CSS_DECLARATION_VALUE_S;
          }
        case 54: break;
        case 36: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_FUNCTION;
          }
        case 55: break;
        case 20: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ATTRIBUTE_END;
          }
        case 56: break;
        case 1: 
          { return UNDEFINED;
          }
        case 57: break;
        case 9: 
          { yybegin(ST_IMPORT_DELIMITER); return CSS_MEDIUM;
          }
        case 58: break;
        case 37: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_STRING;
          }
        case 59: break;
        case 29: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_CLASS;
          }
        case 60: break;
        case 12: 
          { yybegin(YYINITIAL); return CSS_LBRACE;
          }
        case 61: break;
        case 4: 
          { yybegin(YYINITIAL); return CSS_RBRACE;
          }
        case 62: break;
        case 11: 
          { yybegin(ST_MEDIA_DELIMITER); return CSS_MEDIUM;
          }
        case 63: break;
        case 10: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 64: break;
        case 24: 
          { yybegin(ST_DECLARATION_PRE_VALUE); return CSS_DECLARATION_SEPARATOR;
          }
        case 65: break;
        case 50: 
          { yybegin(ST_FONT_FACE_DELIMITER); return CSS_FONT_FACE;
          }
        case 66: break;
        case 49: 
          { yybegin(ST_CHARSET_NAME); return CSS_CHARSET;
          }
        case 67: break;
        case 45: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_URI;
          }
        case 68: break;
        case 19: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_VALUE); return CSS_SELECTOR_ATTRIBUTE_OPERATOR;
          }
        case 69: break;
        case 40: 
          { return CSS_CDC;
          }
        case 70: break;
        case 15: 
          { yybegin(ST_DECLARATION); return CSS_LBRACE;
          }
        case 71: break;
        case 5: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_UNIVERSAL;
          }
        case 72: break;
        case 7: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_NAME); return CSS_SELECTOR_ATTRIBUTE_START;
          }
        case 73: break;
        case 42: 
          { return CSS_CDO;
          }
        case 74: break;
        case 8: 
          { yybegin(YYINITIAL); return CSS_DELIMITER;
          }
        case 75: break;
        case 18: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_OPERATOR); return CSS_SELECTOR_ATTRIBUTE_NAME;
          }
        case 76: break;
        case 38: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_HASH;
          }
        case 77: break;
        case 44: 
          { yybegin(ST_PAGE_PSEUDO_PAGE); return CSS_PAGE;
          }
        case 78: break;
        case 2: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ELEMENT_NAME;
          }
        case 79: break;
        case 31: 
          { yybegin(ST_CHARSET_DELIMITER); return CSS_STRING;
          }
        case 80: break;
        case 25: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_NUMBER;
          }
        case 81: break;
        case 16: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 82: break;
        case 33: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 83: break;
        case 41: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_UNICODE_RANGE;
          }
        case 84: break;
        case 35: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PERCENTAGE;
          }
        case 85: break;
        case 13: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 86: break;
        case 26: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IDENT;
          }
        case 87: break;
        case 14: 
          { yybegin(ST_PAGE_DELIMITER); return CSS_PAGE_SELECTOR;
          }
        case 88: break;
        case 28: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_OPERATOR;
          }
        case 89: break;
        case 43: 
          { return CSS_COMMENT;
          }
        case 90: break;
        case 51: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IMPORTANT;
          }
        case 91: break;
        case 21: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_END); return CSS_SELECTOR_ATTRIBUTE_VALUE;
          }
        case 92: break;
        case 17: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_SEPARATOR;
          }
        case 93: break;
        case 3: 
          { return CSS_S;
          }
        case 94: break;
        case 30: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ID;
          }
        case 95: break;
        case 48: 
          { yybegin(ST_IMPORT_URI); return CSS_IMPORT;
          }
        case 96: break;
        case 27: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PARENTHESIS_CLOSE;
          }
        case 97: break;
        case 47: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA;
          }
        case 98: break;
        case 23: 
          { yybegin(ST_DECLARATION); return CSS_DECLARATION_DELIMITER;
          }
        case 99: break;
        case 22: 
          { yybegin(ST_DECLARATION_SEPARATOR); return CSS_DECLARATION_PROPERTY;
          }
        case 100: break;
        case 6: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO;
          }
        case 101: break;
        case 46: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_URI;
          }
        case 102: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
