/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object iframe()
  * @type iframe
  * @super Object
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535258.aspx
*/

function iframe(){};
iframe.prototype= new Object();
/**
  * Property align
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533068.aspx
*/

iframe.prototype.align="";
/**
  * Property allowTransparency
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533072.aspx
*/

iframe.prototype.allowTransparency=false;
/**
  * Property border
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533533.aspx
*/

iframe.prototype.border=new Object();
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

iframe.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

iframe.prototype.canHaveHTML=false;
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

iframe.prototype.className="";
/**
  * Property contentWindow
  * @type window
  * @returns {window}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533692.aspx
*/

iframe.prototype.contentWindow=new window();
/**
  * Property window
  * @type window
  * @returns {window}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535873.aspx
*/

iframe.prototype.window= new window();
/**
  * Property frame
  * @type frame
  * @returns {frame}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535250.aspx
*/

iframe.prototype.frame= new frame();
/**
  * Property dataFld
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533703.aspx
*/

iframe.prototype.dataFld="";
/**
  * Property dataSrc
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533709.aspx
*/

iframe.prototype.dataSrc="";
/**
  * Property firstChild
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533755.aspx
*/

iframe.prototype.firstChild=new Object();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

iframe.prototype.childNodes= new childNodes();
/**
  * Property frameBorder
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533770.aspx
*/

iframe.prototype.frameBorder="";
/**
  * Property height
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533781.aspx
*/

iframe.prototype.height=new Object();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

iframe.prototype.hideFocus=false;
/**
  * Property hspace
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533868.aspx
*/

iframe.prototype.hspace=0;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

iframe.prototype.id="";
/**
  * Property innerText
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533899.aspx
*/

iframe.prototype.innerText="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

iframe.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

iframe.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

iframe.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

iframe.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

iframe.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

iframe.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

iframe.prototype.language="";
/**
  * Property lastChild
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533943.aspx
*/

iframe.prototype.lastChild=new Object();
/**
  * Property longDesc
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534132.aspx
*/

iframe.prototype.longDesc="";
/**
  * Property marginHeight
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534145.aspx
*/

iframe.prototype.marginHeight=new Object();
/**
  * Property marginWidth
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534153.aspx
*/

iframe.prototype.marginWidth=new Object();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534182.aspx
*/

iframe.prototype.name="";
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

iframe.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

iframe.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

iframe.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

iframe.prototype.nodeValue=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

iframe.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

iframe.prototype.offsetParent=new Object();
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

iframe.prototype.offsetLeft=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

iframe.prototype.offsetTop=0;
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

iframe.prototype.offsetWidth=0;
/**
  * Property onOffBehavior
  * @type DABoolean
  * @returns {DABoolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533630.aspx
*/

iframe.prototype.onOffBehavior=new DABoolean();
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

iframe.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

iframe.prototype.outerText="";
/**
  * Property ownerDocument
  * @type document
  * @returns {document}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534315.aspx
*/

iframe.prototype.ownerDocument=new document();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

iframe.prototype.document= new document();
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

iframe.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

iframe.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

iframe.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

iframe.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534358.aspx
*/

iframe.prototype.readyState=new Object();
/**
  * Property readyState
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534359.aspx
*/

iframe.prototype.readyState="";
/**
  * Property recordNumber
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534363.aspx
*/

iframe.prototype.recordNumber=new Object();
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

iframe.prototype.scopeName="";
/**
  * Property scrolling
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534616.aspx
*/

iframe.prototype.scrolling="";
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

iframe.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

iframe.prototype.all= new all();
/**
  * Property src
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534643.aspx
*/

iframe.prototype.src="";
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

iframe.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

iframe.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

iframe.prototype.tagUrn="";
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

iframe.prototype.title="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

iframe.prototype.uniqueID="";
/**
  * Property vspace
  * @type Number
  * @returns {Number}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535141.aspx
*/

iframe.prototype.vspace=0;
/**
  * Property width
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535147.aspx
*/

iframe.prototype.width=new Object();
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

iframe.prototype.addBehavior=function(sUrl){};
/**
  * function appendChild(oNode)
  * @param {appendChild} oNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535934.aspx
*/

iframe.prototype.appendChild=function(oNode){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

iframe.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

iframe.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

iframe.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

iframe.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

iframe.prototype.clearAttributes=function(){};
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

iframe.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

iframe.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function contains(oElement)
  * @param {Boolean} oElement
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536377.aspx
*/

iframe.prototype.contains=function(oElement){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

iframe.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function dragDrop()
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536415.aspx
*/

iframe.prototype.dragDrop=function(){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

iframe.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function focus()
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

iframe.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

iframe.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

iframe.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

iframe.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

iframe.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

iframe.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

iframe.prototype.name="";
/**
  * function getElementsByTagName(sTagName)
  * @param {String} sTagName
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536439.aspx
*/

iframe.prototype.getElementsByTagName=function(sTagName){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

iframe.prototype.getExpression=function(sPropertyName){};
/**
  * function hasChildNodes()
  * @type HTML Elements
  * @returns {HTML}
 Elements
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536445.aspx
*/

iframe.prototype.hasChildNodes=function(){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

iframe.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertAdjacentHTML(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536452.aspx
*/

iframe.prototype.insertAdjacentHTML=function(sWhere,sText){};
/**
  * function insertAdjacentText(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536453.aspx
*/

iframe.prototype.insertAdjacentText=function(sWhere,sText){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

iframe.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

iframe.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function normalize()
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

iframe.prototype.normalize=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

iframe.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

iframe.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

iframe.prototype.removeBehavior=function(iID){};
/**
  * function removeChild(oNode)
  * @param {Object} oNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536702.aspx
*/

iframe.prototype.removeChild=function(oNode){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

iframe.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

iframe.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

iframe.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceChild(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536716.aspx
*/

iframe.prototype.replaceChild=function(oNewNode,oChildNode){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

iframe.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

iframe.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

iframe.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

iframe.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

iframe.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

iframe.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

iframe.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

iframe.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

iframe.prototype.activeElement=new Object();
/**
  * Property onafterupdate
  * @type onafterupdate
  * @returns {onafterupdate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536790.aspx
*/

iframe.prototype.onafterupdate= new onafterupdate();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

iframe.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeupdate
  * @type onbeforeupdate
  * @returns {onbeforeupdate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536908.aspx
*/

iframe.prototype.onbeforeupdate= new onbeforeupdate();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

iframe.prototype.onblur= new onblur();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

iframe.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

iframe.prototype.ondeactivate= new ondeactivate();
/**
  * Property onerrorupdate
  * @type onerrorupdate
  * @returns {onerrorupdate}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536931.aspx
*/

iframe.prototype.onerrorupdate= new onerrorupdate();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

iframe.prototype.onfocus= new onfocus();
/**
  * Property onload
  * @type onload
  * @returns {onload}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536942.aspx
*/

iframe.prototype.onload= new onload();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

iframe.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

iframe.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

iframe.prototype.onmovestart= new onmovestart();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

iframe.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

iframe.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

iframe.prototype.onresizestart= new onresizestart();
/**
  * Property ontimeerror
  * @type ontimeerror
  * @returns {ontimeerror}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533588.aspx
*/

iframe.prototype.ontimeerror= new ontimeerror();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

iframe.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

iframe.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

iframe.prototype.behaviorUrns= new behaviorUrns();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

iframe.prototype.childNodes= new childNodes();
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

iframe.prototype.TextNode= new TextNode();
/**
  * Property children
  * @type children
  * @returns {children}
  * @memberOf iframe
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537446.aspx
*/

iframe.prototype.children= new children();
