/*******************************************************************************
 * Copyright (c) 2008, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMappingDefinition;
import org.eclipse.jpt.core.internal.context.java.JavaOneToManyMappingDefinition;

public class JavaEclipseLinkOneToManyMappingDefinition
	extends AbstractJavaAttributeMappingDefinition
{
	// singleton
	private static final JavaEclipseLinkOneToManyMappingDefinition INSTANCE = 
			new JavaEclipseLinkOneToManyMappingDefinition();
	
	
	/**
	 * Return the singleton.
	 */
	public static JavaAttributeMappingDefinition instance() {
		return INSTANCE;
	}
	
	
	/**
	 * Enforce singleton usage
	 */
	private JavaEclipseLinkOneToManyMappingDefinition() {
		super();
	}
	
	
	public String getKey() {
		return JavaOneToManyMappingDefinition.instance().getKey();
	}
	
	public String getAnnotationName() {
		return JavaOneToManyMappingDefinition.instance().getAnnotationName();
	}

	public JavaAttributeMapping buildMapping(JavaPersistentAttribute parent, JpaFactory factory) {
		return JavaOneToManyMappingDefinition.instance().buildMapping(parent, factory);
	}
	
	@Override
	public boolean testDefault(JavaPersistentAttribute persistentAttribute) {
		String targetEntity = persistentAttribute.getMultiReferenceTargetTypeName();
		return (targetEntity != null) 
				&& (persistentAttribute.getPersistenceUnit().getEntity(targetEntity) != null);
	}
}
