/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.util.List;
import org.eclipse.equinox.internal.p2.metadata.expression.All;
import org.eclipse.equinox.internal.p2.metadata.expression.And;
import org.eclipse.equinox.internal.p2.metadata.expression.At;
import org.eclipse.equinox.internal.p2.metadata.expression.Compare;
import org.eclipse.equinox.internal.p2.metadata.expression.Equals;
import org.eclipse.equinox.internal.p2.metadata.expression.EvaluationContext;
import org.eclipse.equinox.internal.p2.metadata.expression.Exists;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.IExpressionConstants;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.internal.p2.metadata.expression.LambdaExpression;
import org.eclipse.equinox.internal.p2.metadata.expression.Literal;
import org.eclipse.equinox.internal.p2.metadata.expression.MatchExpression;
import org.eclipse.equinox.internal.p2.metadata.expression.Matches;
import org.eclipse.equinox.internal.p2.metadata.expression.Member;
import org.eclipse.equinox.internal.p2.metadata.expression.Not;
import org.eclipse.equinox.internal.p2.metadata.expression.Or;
import org.eclipse.equinox.internal.p2.metadata.expression.Parameter;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactory
implements IExpressionFactory,
IExpressionConstants {
    public static final IExpressionFactory INSTANCE = new ExpressionFactory();
    public static final Variable THIS = new Variable("this");

    protected static Expression[] convertArray(IExpression[] operands) {
        Expression[] ops = new Expression[operands.length];
        System.arraycopy(operands, 0, ops, 0, operands.length);
        return ops;
    }

    protected ExpressionFactory() {
    }

    @Override
    public IExpression all(IExpression collection, IExpression lambda) {
        return new All((Expression)collection, (LambdaExpression)lambda);
    }

    @Override
    public IExpression and(IExpression[] operands) {
        if (operands.length == 0) {
            return Literal.TRUE_CONSTANT;
        }
        if (operands.length == 1) {
            return operands[0];
        }
        return new And(ExpressionFactory.convertArray(operands));
    }

    @Override
    public IExpression at(IExpression target, IExpression key) {
        return new At((Expression)target, (Expression)key);
    }

    @Override
    public IExpression normalize(List<? extends IExpression> operands, int expressionType) {
        return Expression.normalize(operands, expressionType);
    }

    @Override
    public IExpression constant(Object value) {
        return Literal.create(value);
    }

    @Override
    public IEvaluationContext createContext(Object[] parameters) {
        return EvaluationContext.create(parameters, null);
    }

    @Override
    public IEvaluationContext createContext(IExpression[] variables, Object[] parameters) {
        return EvaluationContext.create(parameters, variables);
    }

    @Override
    public IFilterExpression filterExpression(IExpression expression) {
        return new LDAPFilter((Expression)expression);
    }

    @Override
    public IExpression equals(IExpression lhs, IExpression rhs) {
        return new Equals((Expression)lhs, (Expression)rhs, false);
    }

    @Override
    public IExpression exists(IExpression collection, IExpression lambda) {
        return new Exists((Expression)collection, (LambdaExpression)lambda);
    }

    @Override
    public IExpression greater(IExpression lhs, IExpression rhs) {
        return new Compare((Expression)lhs, (Expression)rhs, false, false);
    }

    @Override
    public IExpression greaterEqual(IExpression lhs, IExpression rhs) {
        return new Compare((Expression)lhs, (Expression)rhs, false, true);
    }

    @Override
    public IExpression indexedParameter(int index) {
        return new Parameter(index);
    }

    @Override
    public IExpression lambda(IExpression variable, IExpression body) {
        return new LambdaExpression((Variable)variable, (Expression)body);
    }

    @Override
    public IExpression less(IExpression lhs, IExpression rhs) {
        return new Compare((Expression)lhs, (Expression)rhs, true, false);
    }

    @Override
    public IExpression lessEqual(IExpression lhs, IExpression rhs) {
        return new Compare((Expression)lhs, (Expression)rhs, true, true);
    }

    @Override
    public IExpression matches(IExpression lhs, IExpression rhs) {
        return new Matches((Expression)lhs, (Expression)rhs);
    }

    @Override
    public <T> IMatchExpression<T> matchExpression(IExpression expression, Object[] parameters) {
        return new MatchExpression((Expression)expression, parameters);
    }

    @Override
    public IExpression member(IExpression target, String name) {
        return new Member.DynamicMember((Expression)target, name);
    }

    @Override
    public IExpression not(IExpression operand) {
        if (operand instanceof Equals) {
            Equals eq = (Equals)operand;
            return new Equals(eq.lhs, eq.rhs, !eq.negate);
        }
        if (operand instanceof Compare) {
            Compare cmp = (Compare)operand;
            return new Compare(cmp.lhs, cmp.rhs, !cmp.compareLess, !cmp.equalOK);
        }
        if (operand instanceof Not) {
            return ((Not)operand).operand;
        }
        return new Not((Expression)operand);
    }

    @Override
    public IExpression or(IExpression[] operands) {
        if (operands.length == 0) {
            return Literal.TRUE_CONSTANT;
        }
        if (operands.length == 1) {
            return operands[0];
        }
        return new Or(ExpressionFactory.convertArray(operands));
    }

    @Override
    public IExpression thisVariable() {
        return THIS;
    }

    @Override
    public IExpression variable(String name) {
        if ("this".equals(name)) {
            return THIS;
        }
        return new Variable(name);
    }
}

